/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BrkXa_exc_;
import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXXid;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.util.Locale;
import javax.transaction.xa.Xid;

class BrkXaReply {
    private Locale m_locale;
    private LogicalByteArray m_buffer;
    private Header m_header;
    private BrkXa_exc_ m_p1_exception;
    private int m_header_size;
    private int m_reply_size;
    private int m_ReqReplyFlag;
    private int m_ReqCode;
    private int m_BrkGwStatus;
    private int m_last;
    private int m_xarm_retval;
    private SQLMXXid[] m_xids;
    private T4Properties m_t4props;
    private int m_reply_index;
    private int m_exp_index;
    private int m_exp_pointer;
    private int m_reply_pointer;
    private byte[] m_tmfId;
    static final int BRK_XA_COMMIT = 2;
    static final int BRK_XA_FORGET = 3;
    static final int BRK_XA_PREPARE = 5;
    static final int BRK_XA_RECOVER = 6;
    static final int BRK_XA_ROLLBACK = 7;
    static final int BRK_XA_START = 8;
    static final int BRK_XA_END = 10;
    static final int BRK_XA_RECOVER_NEXT = 11;
    static final int BRK_XA_SET_TIMEOUT = 12;
    static final int BRK_XA_GET_TIMEOUT = 13;
    static final int BRK_XA_GET_TRANSACTION_STATE = 14;
    static final int BRK_GW_REPLY = 0;
    final int BRK_GW_OK = 0;
    final int BRK_GW_UNKNOWNREQ = 1;
    final int BRK_GW_MAXCONNECTIONS = 2;
    final int BRK_GW_INCORRECTSIZE = 3;
    final int BRK_GW_NOTOPENED = 4;
    final int BRK_GW_NULLRMNAME = 5;
    final int BRK_GW_NOTSAMERMNAME = 6;
    final int BRK_GW_BADFLAGS = 7;
    final int BRK_GW_INVALIDSESSION = 8;
    final int BRK_GW_NOMEMORY = 9;
    final int BRK_GW_INCORRECTVERSION = 10;

    int getBrkStatus() {
        return this.m_BrkGwStatus;
    }

    int getXARMretval() {
        return this.m_xarm_retval;
    }

    Xid[] getXids() {
        return this.m_xids;
    }

    private void checkXABrokerStatus() throws SQLException {
        switch (this.m_BrkGwStatus) {
            case 0: {
                break;
            }
            case 2: {
                throw SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "ids_max_brk_conn_reached", String.valueOf(this.m_BrkGwStatus));
            }
            case 7: {
                throw SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "ids_invalid_xa_flags", String.valueOf(this.m_BrkGwStatus));
            }
            case 10: {
                throw SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "ids_invalid_xa_version", String.valueOf(this.m_BrkGwStatus));
            }
            default: {
                SQLMXException sqx1 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "internal_error", String.valueOf(this.m_BrkGwStatus));
                SQLMXException sqx2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "contact_hp_error", String.valueOf(this.m_BrkGwStatus));
                sqx1.setNextException(sqx2);
                throw sqx1;
            }
        }
    }

    static void checkReqCode(T4Properties t4props, int p_ReqCode) throws SQLException {
        switch (p_ReqCode) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                SQLMXException sqx1 = SQLMXMessages.createSQLException(t4props, null, "internal_error", String.valueOf(p_ReqCode));
                SQLMXException sqx2 = SQLMXMessages.createSQLException(t4props, null, "contact_hp_error", String.valueOf(p_ReqCode));
                sqx1.setNextException(sqx2);
                throw sqx1;
            }
        }
    }

    private void checkReqReplyFlag() throws SQLException {
        if (this.m_ReqReplyFlag != 0) {
            SQLMXException sqx1 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "internal_error", String.valueOf(this.m_ReqReplyFlag));
            SQLMXException sqx2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "contact_hp_error", String.valueOf(this.m_ReqReplyFlag));
            sqx1.setNextException(sqx2);
            throw sqx1;
        }
    }

    private void extractHeader() {
        this.m_header.extractFromByteArray(this.m_buffer);
        BrkXaReply brkXaReply = this;
        this.m_exp_pointer = this.m_header_size = brkXaReply.m_header.sizeOf();
        this.m_reply_pointer = this.m_header_size + 4;
    }

    private void extractException() throws SQLException {
        this.m_exp_index = this.m_buffer.extractInt() + this.m_header_size;
        this.m_buffer.setLocation(this.m_exp_index);
        this.m_p1_exception = new BrkXa_exc_(this.m_buffer, this.m_exp_index, this.m_header_size, this.m_t4props);
    }

    private void extractReplySize() {
        this.m_buffer.setLocation(this.m_reply_pointer);
        this.m_reply_index = this.m_buffer.extractInt() + this.m_header_size;
        this.m_buffer.setLocation(this.m_reply_index);
        this.m_reply_size = this.m_buffer.extractInt();
        this.m_reply_index += 4;
    }

    private void extractReplyFlag() throws SQLException {
        this.m_ReqReplyFlag = this.m_buffer.extractInt();
        this.checkReqReplyFlag();
        this.m_reply_index += 4;
    }

    private void extractReqCode() throws SQLException {
        this.m_ReqCode = this.m_buffer.extractInt();
        BrkXaReply.checkReqCode(this.m_t4props, this.m_ReqCode);
        this.m_reply_index += 4;
    }

    private void extractGwStatus() throws SQLException {
        this.m_BrkGwStatus = this.m_buffer.extractInt();
        this.checkXABrokerStatus();
        this.m_reply_index += 4;
    }

    private void extractLast() {
        if (this.m_ReqCode == 6) {
            this.m_last = this.m_buffer.extractInt();
            this.m_reply_index += 4;
        }
    }

    private void extractRmRetVal() {
        this.m_xarm_retval = this.m_buffer.extractInt();
        this.m_reply_index += 4;
    }

    private void extractXids() {
        if (this.m_ReqCode == 6) {
            this.m_xids = new SQLMXXid[this.m_xarm_retval];
            int IDL_unsigned_long_length = this.m_buffer.extractInt();
            this.m_reply_index += 4;
            this.m_reply_index += 4;
            this.m_buffer.setLocation(this.m_reply_index);
            int offset_from_start = this.m_buffer.extractInt();
            this.m_reply_index = this.m_header_size + offset_from_start;
            for (int i = 0; i < this.m_xarm_retval; ++i) {
                this.m_xids[i] = new SQLMXXid(this.m_t4props, this.m_buffer, this.m_reply_index);
                this.m_reply_index += this.m_xids[i].sizeof();
            }
        }
    }

    private void extractTmfId() {
        if (this.m_ReqCode == 8) {
            this.m_tmfId = this.m_buffer.extractByteArray(8);
            this.m_reply_index += 8;
        }
    }

    byte[] getTmfId() {
        return this.m_tmfId;
    }

    BrkXaReply(LogicalByteArray buffer1, T4Properties t4props) throws SQLException {
        this.m_buffer = buffer1;
        this.m_t4props = t4props;
        this.m_locale = t4props.getLocale();
        this.m_header = new Header();
        buffer1.setLocation(0);
        this.extractHeader();
        this.extractException();
        this.extractReplySize();
        this.extractReplyFlag();
        this.extractReqCode();
        this.extractGwStatus();
        this.extractLast();
        this.extractRmRetVal();
        this.extractXids();
        this.extractTmfId();
    }
}

