/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BrkXaRequest;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXXid;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.util.Locale;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

class BrkXaTxnRequest
extends BrkXaRequest {
    protected int m_flags;
    protected SQLMXXid m_xid;
    protected T4Properties m_t4props;
    protected Locale m_locale;
    protected int m_rmid = 0;

    BrkXaTxnRequest(T4Properties t4props, int p_ReqCode, int p_rmid, Xid p_xid, int p_flags) throws SQLException, XAException {
        super(t4props, p_ReqCode);
        this.m_t4props = t4props;
        this.m_locale = t4props.getLocale();
        this.checkReqCode(p_ReqCode);
        this.m_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.setRmid(p_rmid);
        this.m_flags = p_flags;
    }

    private void setRmid(int p_rmid) {
        this.m_rmid = p_rmid;
    }

    private void checkReqCode(int p_ReqCode) throws SQLException {
        switch (p_ReqCode) {
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            default: {
                SQLMXException sqx1 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "internal_error", String.valueOf(p_ReqCode));
                SQLMXException sqx2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "contact_hp_error", String.valueOf(p_ReqCode));
                sqx1.setNextException(sqx2);
                throw sqx1;
            }
        }
    }

    int totalSizeOf() {
        int size = 0;
        size = super.totalSizeOf();
        size += this.m_xid.sizeof();
        return size += 8;
    }
}

