/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLValueList_def;
import com.tandem.t4jdbc.SQL_DataValue_def;
import com.tandem.t4jdbc.TRANSPORT;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;

class ExecuteMessage {
    ExecuteMessage() {
    }

    static LogicalByteArray marshal(int dialogueId, int sqlAsyncEnable, int queryTimeout, int inputRowCnt, int maxRowsetSize, int sqlStmtType, int stmtHandle, int stmtType, String sqlString, int sqlStringCharset, String cursorName, int cursorNameCharset, String stmtLabel, int stmtLabelCharset, String stmtExplainLabel, SQL_DataValue_def inputDataValue, SQLValueList_def inputValueList, byte[] txId, boolean isUserBuffer, InterfaceConnection ic, byte[] extTxID) throws CharacterCodingException, UnsupportedCharsetException {
        int wlength = Header.sizeOf();
        byte[] sqlStringBytes = ic.encodeString(sqlString, ic.getTerminalCharset());
        byte[] cursorNameBytes = ic.encodeString(cursorName, 1);
        byte[] stmtLabelBytes = ic.encodeString(stmtLabel, 1);
        byte[] stmtExplainLabelBytes = ic.encodeString(stmtExplainLabel, 1);
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += TRANSPORT.size_bytesWithCharset(sqlStringBytes);
        wlength += TRANSPORT.size_bytesWithCharset(cursorNameBytes);
        wlength += TRANSPORT.size_bytesWithCharset(stmtLabelBytes);
        wlength += TRANSPORT.size_bytes(stmtExplainLabelBytes);
        if (!isUserBuffer) {
            wlength += inputDataValue.sizeof();
            wlength += TRANSPORT.size_bytes(txId);
        }
        wlength = extTxID != null ? (wlength += TRANSPORT.size_bytes(extTxID)) : (wlength += 4);
        LogicalByteArray buf = new LogicalByteArray(wlength, Header.sizeOf(), ic.getByteSwap());
        buf.insertInt(dialogueId);
        buf.insertInt(sqlAsyncEnable);
        buf.insertInt(queryTimeout);
        buf.insertInt(inputRowCnt);
        buf.insertInt(maxRowsetSize);
        buf.insertInt(sqlStmtType);
        buf.insertInt(stmtHandle);
        buf.insertInt(stmtType);
        buf.insertStringWithCharset(sqlStringBytes, sqlStringCharset);
        buf.insertStringWithCharset(cursorNameBytes, cursorNameCharset);
        buf.insertStringWithCharset(stmtLabelBytes, stmtLabelCharset);
        buf.insertString(stmtExplainLabelBytes);
        if (isUserBuffer) {
            buf.setDataBuffer(inputDataValue.userBuffer);
            byte[] trailer = null;
            if (txId == null || txId.length == 0) {
                trailer = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    trailer[i] = 0;
                }
            } else {
                int len = txId.length + 1;
                trailer = new byte[4 + txId.length + 1];
                trailer[0] = (byte)(len >>> 24 & 0xFF);
                trailer[1] = (byte)(len >>> 16 & 0xFF);
                trailer[2] = (byte)(len >>> 8 & 0xFF);
                trailer[3] = (byte)(len & 0xFF);
                System.arraycopy(txId, 0, trailer, 4, txId.length);
                trailer[len + 4 - 1] = 0;
            }
            buf.setTrailer(trailer);
        } else {
            inputDataValue.insertIntoByteArray(buf);
            buf.insertString(txId);
        }
        if (extTxID != null && extTxID.length != 0) {
            buf.insertInt(extTxID.length);
            buf.insertByteArray(extTxID, extTxID.length);
            buf.insertByte((byte)0);
        } else {
            buf.insertInt(0);
        }
        return buf;
    }
}

