/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLWarningOrError;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;

class FetchReply {
    int returnCode;
    int totalErrorLength;
    SQLWarningOrError[] errorList;
    int rowsAffected;
    int outValuesFormat;
    byte[] outValues;

    public FetchReply(LogicalByteArray buf, InterfaceConnection ic) throws CharacterCodingException, UnsupportedCharsetException {
        buf.setLocation(Header.sizeOf());
        this.returnCode = buf.extractInt();
        if (this.returnCode != 0 && this.returnCode != 100) {
            this.totalErrorLength = buf.extractInt();
            if (this.totalErrorLength > 0) {
                this.errorList = new SQLWarningOrError[buf.extractInt()];
                for (int i = 0; i < this.errorList.length; ++i) {
                    this.errorList[i] = new SQLWarningOrError(buf, ic, ic.getISOMapping());
                }
            }
        }
        if (this.errorList == null) {
            this.errorList = new SQLWarningOrError[0];
        }
        this.rowsAffected = buf.extractInt();
        this.outValuesFormat = buf.extractInt();
        if (this.returnCode == 0 || this.returnCode == 1) {
            this.outValues = buf.extractByteArray();
        }
    }
}

