/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Address;
import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Connection;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4TimerThread;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.SocketFactory;

class InputOutput {
    private Address m_addr;
    private Socket m_socket;
    private Locale m_locale;
    private int readHdrLength = Header.sizeOf();
    private int m_dialogueId;
    private int m_timeout;
    private int m_connectionIdleTimeout;
    private Header m_rheader;
    private OutputStream m_os;
    private InputStream m_is;
    private WritableByteChannel m_wbc;
    private T4Connection m_t4conn;
    private int m_sendBufSize;
    private static SocketFactory m_factory = SocketFactory.getDefault();

    public static SocketFactory getSocketFactory() {
        return m_factory;
    }

    public static void setSocketFactory(SocketFactory factory) {
        m_factory = factory;
    }

    InputOutput(Locale locale, Address addr1) {
        this.m_locale = locale;
        this.m_addr = addr1;
        this.m_dialogueId = 0;
        this.m_timeout = 0;
        this.m_connectionIdleTimeout = 0;
        this.m_rheader = new Header(0, this.m_dialogueId, 0, 0, 'N', '\u0000', 3, 12345, 100, 'P', 'T', 'N');
    }

    void setT4Connection(T4Connection t4conn) {
        this.m_t4conn = t4conn;
    }

    void setDialogueId(int dialogueId) {
        this.m_dialogueId = dialogueId;
    }

    void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    void setConnectionIdleTimeout(int timeout) {
        this.m_connectionIdleTimeout = timeout;
    }

    synchronized void openIO() throws SQLException {
        if (this.m_t4conn != null && this.m_t4conn.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.m_t4conn.m_ic.t4props_);
            String temp = "m_socket=" + this.m_socket;
            this.m_t4conn.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "InputOutput", "openIO", temp, p);
        }
        if (this.m_socket == null) {
            String temp;
            Object[] p;
            int numTry;
            boolean found = false;
            int i = 0;
            Vector<Exception> eList = new Vector<Exception>();
            for (numTry = 0; !found && numTry < 3; ++numTry) {
                for (i = 0; !found && i < this.m_addr.m_inetAddrs.length; ++i) {
                    try {
                        this.m_socket = m_factory.createSocket(this.m_addr.m_inetAddrs[i], (int)this.m_addr.m_portNumber);
                        this.m_socket.setSoLinger(false, 0);
                        this.m_socket.setSoTimeout(0);
                        this.m_os = this.m_socket.getOutputStream();
                        this.m_wbc = Channels.newChannel(this.m_os);
                        this.m_is = this.m_socket.getInputStream();
                        this.m_sendBufSize = this.m_socket.getSendBufferSize();
                        found = true;
                        this.startConnectionIdleTimeout();
                        if (this.m_t4conn == null || !this.m_t4conn.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) continue;
                        p = T4LoggingUtilities.makeParams(this.m_t4conn.m_ic.t4props_);
                        temp = "found=" + found + ",numTry=" + numTry + ",i=" + i + ",m_addr.m_inetAddrs.length=" + this.m_addr.m_inetAddrs.length;
                        this.m_t4conn.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "InputOutput", "openIO", temp, p);
                        continue;
                    }
                    catch (Exception e) {
                        eList.addElement(e);
                        found = false;
                    }
                }
                if (found) continue;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!found) {
                if (this.m_t4conn != null && this.m_t4conn.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(this.m_t4conn.m_ic.t4props_);
                    temp = "found=" + found + ",numTry=" + numTry + ",i=" + i + ",m_addr.m_inetAddrs.length=" + this.m_addr.m_inetAddrs.length;
                    this.m_t4conn.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "InputOutput", "openIO", temp, p);
                }
                Exception eFirst = (Exception)eList.firstElement();
                SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_open_error", eFirst.getMessage());
                se.initCause(eFirst);
                throw se;
            }
        }
    }

    synchronized LogicalByteArray doIO(short odbcAPI, LogicalByteArray buffer) throws SQLException {
        SQLMXException se2;
        SQLMXException se;
        int wCount = buffer.getLength();
        ByteBuffer dataBuffer = buffer.getDataBuffer();
        byte[] trailer = buffer.getTrailer();
        if (dataBuffer != null && trailer != null) {
            wCount += dataBuffer.limit();
            wCount += trailer.length;
        }
        if (this.m_t4conn != null && this.m_t4conn.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.m_t4conn.m_ic.t4props_);
            String temp = "MessageBuffer";
            this.m_t4conn.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "InputOutput", "doIO", temp, p);
        }
        Header wheader = new Header(odbcAPI, this.m_dialogueId, wCount - this.readHdrLength, 0, 'N', '\u0000', 1, 12345, 100, 'P', 'T', 'N');
        this.m_rheader.reuseHeader(odbcAPI, this.m_dialogueId);
        int buffer_index = 0;
        if (dataBuffer != null) {
            wCount = buffer.getLength();
        }
        while (wCount > 0) {
            int tcount = wCount > this.m_sendBufSize ? this.m_sendBufSize : wCount;
            this.TCPIPDoWrite(wheader, buffer, buffer_index, tcount);
            wheader.hdr_type_ = 2;
            wCount -= tcount;
            buffer_index += tcount;
        }
        if (dataBuffer != null && trailer != null) {
            this.TCPIPWriteByteBuffer(dataBuffer);
            this.TCPIPWriteByteBuffer(ByteBuffer.wrap(trailer));
        }
        buffer.reset();
        int numRead = 0;
        int totalNumRead = 0;
        this.m_rheader.hdr_type_ = 3;
        this.m_rheader.total_length_ = this.readHdrLength;
        for (int whileCount1 = 0; totalNumRead < this.readHdrLength && whileCount1 < 3; totalNumRead += numRead, ++whileCount1) {
            numRead = this.TCPIPDoRead(this.m_rheader, buffer, totalNumRead);
            if (this.m_t4conn == null || !this.m_t4conn.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) continue;
            Object[] p = T4LoggingUtilities.makeParams(this.m_t4conn.m_ic.t4props_);
            String temp = "MessageBuffer whileCount1=" + whileCount1 + ",numRead=" + numRead + ",totalNumRead=" + totalNumRead;
            this.m_t4conn.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "InputOutput", "doIO", temp, p);
        }
        if (numRead < this.readHdrLength) {
            se = SQLMXMessages.createSQLException(null, this.m_locale, "problem_with_server_read", null);
            se2 = SQLMXMessages.createSQLException(null, this.m_locale, "header_not_long_enough", null);
            se.setNextException(se2);
            throw se;
        }
        buffer.setLocation(0);
        this.m_rheader.extractFromByteArray(buffer);
        if (this.m_rheader.swap_ == 'Y') {
            buffer.setByteSwap(true);
        }
        if (this.m_rheader.signature_ != 12345) {
            se = SQLMXMessages.createSQLException(null, this.m_locale, "problem_with_server_read", null);
            se2 = SQLMXMessages.createSQLException(null, this.m_locale, "wrong_header_signature", String.valueOf(12345), String.valueOf(this.m_rheader.signature_));
            se.setNextException(se2);
            throw se;
        }
        if (this.m_rheader.version_ != 100) {
            se = SQLMXMessages.createSQLException(null, this.m_locale, "problem_with_server_read", null);
            se2 = SQLMXMessages.createSQLException(null, this.m_locale, "wrong_header_version", String.valueOf(100), String.valueOf(this.m_rheader.version_));
            se.setNextException(se2);
            throw se;
        }
        if (this.m_rheader.error_ != 0) {
            se = SQLMXMessages.createSQLException(null, this.m_locale, "driver_err_error_from_server", String.valueOf(this.m_rheader.error_), String.valueOf(this.m_rheader.error_detail_));
            throw se;
        }
        numRead = 0;
        buffer.resize(this.m_rheader.total_length_ + this.readHdrLength);
        while (totalNumRead < this.m_rheader.total_length_ + this.readHdrLength) {
            this.m_rheader.hdr_type_ = 4;
            numRead = this.TCPIPDoRead(this.m_rheader, buffer, totalNumRead);
            totalNumRead += numRead;
        }
        return buffer;
    }

    synchronized void CloseIO(LogicalByteArray buffer) throws SQLException {
        Header hdr = new Header(7, this.m_dialogueId, 0, 0, 'N', '\u0000', 7, 12345, 100, 'P', 'T', 'N');
        this.TCPIPDoWrite(hdr, buffer, 0, hdr.sizeOf());
        try {
            this.m_socket.close();
            this.m_socket = null;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "session_close_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
        finally {
            this.closeTimers();
        }
    }

    void TCPIPWriteByteBuffer(ByteBuffer buffer) throws SQLException {
        if (this.m_socket == null) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_write_error", null);
            SQLMXException se2 = SQLMXMessages.createSQLException(null, this.m_locale, "socket_is_closed_error", null);
            se.setNextException(se2);
            throw se;
        }
        try {
            this.m_wbc.write(buffer);
            this.m_os.flush();
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_write_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
        finally {
            this.resetTimedOutConnection();
        }
    }

    void TCPIPDoWrite(Header hdr, LogicalByteArray buffer, int buffer_index, int bufcount) throws SQLException {
        boolean error = false;
        boolean error_detail = false;
        boolean wcount = false;
        int data_length = 0;
        if (this.m_socket == null) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_write_error", null);
            SQLMXException se2 = SQLMXMessages.createSQLException(null, this.m_locale, "socket_is_closed_error", null);
            se.setNextException(se2);
            throw se;
        }
        switch (hdr.hdr_type_) {
            case 1: 
            case 7: {
                buffer.setLocation(0);
                hdr.insertIntoByteArray(buffer, this.m_locale);
            }
            case 2: {
                this.send_nblk(buffer.getBuffer(), buffer_index, data_length += bufcount);
                break;
            }
            default: {
                SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "unknown_message_type_error", null);
                SQLMXException se2 = SQLMXMessages.createSQLException(null, this.m_locale, "internal_error", null);
                SQLMXException se3 = SQLMXMessages.createSQLException(null, this.m_locale, "cntact_hp_error", null);
                se.setNextException(se2);
                se2.setNextException(se3);
                throw se;
            }
        }
    }

    int TCPIPDoRead(Header hdr, LogicalByteArray buffer, int buffer_index) throws SQLException {
        int numRead = 0;
        if (this.m_socket == null) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_read_error", null);
            SQLMXException se2 = SQLMXMessages.createSQLException(null, this.m_locale, "socket_is_closed_error", null);
            se.setNextException(se2);
            throw se;
        }
        switch (hdr.hdr_type_) {
            case 3: 
            case 4: {
                numRead = this.recv_nblk(buffer.getBuffer(), buffer_index);
                break;
            }
            default: {
                SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "unknown_message_type_error", null);
                SQLMXException se2 = SQLMXMessages.createSQLException(null, this.m_locale, "internal_error", null);
                SQLMXException se3 = SQLMXMessages.createSQLException(null, this.m_locale, "cntact_hp_error", null);
                se.setNextException(se2);
                se2.setNextException(se3);
                throw se;
            }
        }
        return numRead;
    }

    void send_nblk(byte[] buf, int offset, int len) throws SQLException {
        try {
            this.m_os.write(buf, offset, len);
            this.m_os.flush();
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_write_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
        finally {
            this.resetTimedOutConnection();
        }
    }

    int recv_nblk(byte[] buf, int offset) throws SQLException {
        int num_read = 0;
        try {
            this.m_socket.setSoTimeout(this.m_timeout * 1000);
            if (this.m_t4conn != null && this.m_t4conn.m_ic.t4props_.getKeepAlive() != null && !this.m_t4conn.m_ic.t4props_.getCloseConnectionUponQueryTimeout().equalsIgnoreCase("ON") && this.m_t4conn.m_ic.t4props_.getKeepAlive().equalsIgnoreCase("ON")) {
                this.m_socket.setKeepAlive(true);
            }
            if ((num_read = this.m_is.read(buf, offset, buf.length - offset)) < 0) {
                num_read = 0;
            }
            this.m_socket.setSoTimeout(0);
        }
        catch (SocketTimeoutException ste) {
            try {
                this.m_socket.close();
                throw ste;
            }
            catch (Exception e) {
                SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "session_close_error", e.getMessage());
                se.initCause(e);
                throw se;
            }
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(null, this.m_locale, "socket_read_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
        finally {
            this.resetTimedOutConnection();
        }
        return num_read;
    }

    void closeTimers() {
        T4TimerThread t;
        if (this.m_connectionIdleTimeout > 0 && (t = T4TimerThread.getThread(this.m_dialogueId)) != null) {
            T4TimerThread.removeThread(this.m_dialogueId);
        }
    }

    void resetConnectionIdleTimeout() {
        if (this.m_connectionIdleTimeout > 0) {
            T4TimerThread t = T4TimerThread.getThread(this.m_dialogueId);
            if (t != null) {
                t.reset(this.m_connectionIdleTimeout * 1000);
            } else {
                this.startConnectionIdleTimeout();
            }
        }
    }

    private void resetTimedOutConnection() {
        if (this.m_connectionIdleTimeout > 0) {
            boolean timedOut = this.checkConnectionIdleTimeout();
            if (timedOut) {
                this.startConnectionIdleTimeout();
            } else {
                this.resetConnectionIdleTimeout();
            }
        }
    }

    boolean checkConnectionIdleTimeout() {
        T4TimerThread t;
        return this.m_connectionIdleTimeout > 0 && (t = T4TimerThread.getThread(this.m_dialogueId)) != null && t.getTimedOut();
    }

    void startConnectionIdleTimeout() {
        if (this.m_connectionIdleTimeout > 0 && this.m_dialogueId > 0) {
            this.closeTimers();
            T4TimerThread t4TimerThread = new T4TimerThread(this.m_dialogueId, this.m_connectionIdleTimeout * 1000);
        }
    }

    static {
        try {
            String factStr = System.getProperty("t4sqlmx.socketFactoryClass");
            if (factStr != null) {
                Class<?> z = Class.forName(factStr);
                m_factory = SocketFactory.class.isAssignableFrom(z) ? (SocketFactory)z.newInstance() : SocketFactory.getDefault();
            }
        }
        catch (Throwable t) {
            m_factory = SocketFactory.getDefault();
        }
    }
}

