/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BaseRow;
import com.tandem.t4jdbc.SQLMXMessages;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.BitSet;

class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;

    InsertRow(int i) {
        this.origVals = new Object[i];
        this.colsInserted = new BitSet(i);
        this.cols = i;
    }

    protected Object getColumnObject(int i) throws SQLException {
        if (!this.colsInserted.get(i - 1)) {
            throw SQLMXMessages.createSQLException(null, null, "no_column_value_specified", null);
        }
        return this.origVals[i - 1];
    }

    protected void initInsertRow() {
        for (int i = 0; i < this.cols; ++i) {
            this.colsInserted.clear(i);
        }
    }

    protected void markColInserted(int i) {
        this.colsInserted.set(i);
    }

    protected void setColumnObject(int i, Object obj) {
        this.origVals[i - 1] = obj;
        this.markColInserted(i - 1);
    }

    protected void insertRow(PreparedStatement insertStmt, BitSet paramCols) throws SQLException {
        int j = 1;
        for (int i = 0; i < this.cols; ++i) {
            if (!paramCols.get(i)) continue;
            insertStmt.setObject(j++, this.origVals[i]);
        }
        insertStmt.execute();
        this.initInsertRow();
    }
}

