/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CONNECTION_CONTEXT_def;
import com.tandem.t4jdbc.CancelReply;
import com.tandem.t4jdbc.ConnectReply;
import com.tandem.t4jdbc.EndTransactionReply;
import com.tandem.t4jdbc.InitializeDialogueReply;
import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.MXCSAddress;
import com.tandem.t4jdbc.OUT_CONNECTION_CONTEXT_def;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMX_AssociationServer_Cancel;
import com.tandem.t4jdbc.SQLMX_AssociationServer_Connect;
import com.tandem.t4jdbc.SetConnectionOptionReply;
import com.tandem.t4jdbc.T4Connection;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.TerminateDialogueReply;
import com.tandem.t4jdbc.USER_DESC_def;
import com.tandem.t4jdbc.Utility;
import com.tandem.t4jdbc.VERSION_def;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;

class InterfaceConnection {
    private String pwd;
    private int txnIsolationLevel = 2;
    private boolean autoCommit = true;
    private boolean isReadOnly = false;
    private boolean isClosed_;
    private long txid;
    private Locale locale;
    private USER_DESC_def userDesc;
    private CONNECTION_CONTEXT_def inContext;
    private OUT_CONNECTION_CONTEXT_def outContext;
    private boolean useArrayBinding_;
    private short transportBufferSize_;
    Handler t4FileHandler;
    MXCSAddress mxcsAddr_;
    private T4Connection t4connection_;
    private String m_mxcsSrvr_ref;
    private int dialogueId_;
    private String m_sessionName;
    private int isoMapping_ = 1;
    private int termCharset_ = 15;
    private boolean enforceISO = false;
    private boolean wmsMode_ = false;
    private boolean byteSwap = false;
    private String _serverDataSource;
    T4Properties t4props_;
    SQLWarning sqlwarning_;
    Hashtable encoders = new Hashtable(11);
    Hashtable decoders = new Hashtable(11);
    static final int SQL_TXN_READ_UNCOMMITTED = 1;
    static final int SQL_TXN_READ_COMMITTED = 2;
    static final int SQL_TXN_REPEATABLE_READ = 4;
    static final int SQL_TXN_SERIALIZABLE = 8;
    static final short SQL_ATTR_CURRENT_CATALOG = 109;
    static final short SQL_ATTR_ACCESS_MODE = 101;
    static final short SQL_ATTR_AUTOCOMMIT = 102;
    static final short SQL_TXN_ISOLATION = 108;
    static final short SPJ_ENABLE_PROXY = 1040;
    static final int ROWWISE_ROWSET = 0x8000000;
    static final int CHARSET = 0x10000000;
    static final int STREAMING_DELAYEDERROR_MODE = 0x20000000;
    static final short SQL_COMMIT = 0;
    static final short SQL_ROLLBACK = 1;
    static final short JDBC_ATTR_CONN_IDLE_TIMEOUT = 3000;
    static ReferenceQueue refQ_ = new ReferenceQueue();
    static Hashtable refTosrvrCtxHandle_ = new Hashtable();
    private String _roleName = "";
    private boolean _ignoreCancel;

    InterfaceConnection(T4Properties t4props) throws SQLException {
        this.t4props_ = t4props;
        this.gcConnections();
        if (t4props.getSQLException() != null) {
            throw SQLMXMessages.createSQLException(this.t4props_, t4props.getLocale(), "invalid_property", t4props.getSQLException());
        }
        this.m_sessionName = this.t4props_.getSessionName();
        if (this.m_sessionName != null && this.m_sessionName.length() > 0) {
            if (this.m_sessionName.length() > 24) {
                this.m_sessionName = this.m_sessionName.substring(0, 24);
            }
            if (!this.m_sessionName.matches("\\w+")) {
                throw new SQLException("Invalid sessionName.  Session names can only contain alphnumeric characters.");
            }
        }
        this.pwd = t4props.getPassword();
        this.locale = t4props.getLocale();
        this.txid = 0L;
        this.isClosed_ = false;
        this.useArrayBinding_ = t4props.getUseArrayBinding();
        this.transportBufferSize_ = (short)32000;
        this.userDesc = this.getUserDescription(t4props.getUser(), t4props.getPassword());
        this.inContext = this.getInContext(t4props);
        this.m_mxcsSrvr_ref = t4props.getUrl();
        this._ignoreCancel = false;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.t4props_, t4props);
            String temp = "url is = " + t4props.getUrl();
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "", temp, p);
            p = T4LoggingUtilities.makeParams(this.t4props_, t4props);
            temp = "user is = " + this.userDesc.userName;
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "", temp, p);
        }
        this.sqlwarning_ = null;
        this.connect();
    }

    public boolean isClosed() {
        return this.isClosed_;
    }

    String getRoleName() {
        return this._roleName;
    }

    CONNECTION_CONTEXT_def getInContext() {
        return this.inContext;
    }

    private CONNECTION_CONTEXT_def getInContext(T4Properties t4props) {
        this.inContext = new CONNECTION_CONTEXT_def();
        this.inContext.catalog = t4props.getCatalog();
        this.inContext.schema = t4props.getSchema();
        this.inContext.datasource = t4props.getServerDataSource();
        this.inContext.userRole = t4props.getRoleName();
        this.inContext.cpuToUse = t4props.getCpuToUse();
        this.inContext.cpuToUseEnd = (short)-1;
        this.inContext.accessMode = (short)(this.isReadOnly ? 1 : 0);
        this.inContext.autoCommit = (short)(this.autoCommit ? 1 : 0);
        this.inContext.queryTimeoutSec = t4props.getQueryTimeout();
        this.inContext.idleTimeoutSec = (short)t4props.getConnectionTimeout();
        this.inContext.loginTimeoutSec = (short)t4props.getLoginTimeout();
        this.inContext.txnIsolationLevel = (short)2;
        this.inContext.rowSetSize = t4props.getFetchBufferSize();
        this.inContext.diagnosticFlag = 0;
        this.inContext.processId = (int)System.currentTimeMillis() & 0xFFF;
        try {
            this.inContext.computerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uex) {
            this.inContext.computerName = "Unknown Client Host";
        }
        this.inContext.windowText = t4props.getApplicationName();
        this.inContext.ctxDataLang = 15;
        this.inContext.ctxErrorLang = 15;
        this.inContext.ctxACP = 1252;
        this.inContext.ctxCtrlInferNXHAR = (short)-1;
        this.inContext.clientVersionList.list = this.getVersion(this.inContext.processId);
        return this.inContext;
    }

    private VERSION_def[] getVersion(int pid) {
        int majorVersion = 3;
        short minorVersion = 1;
        int buildId = 0;
        VERSION_def[] version = new VERSION_def[2];
        version[0] = new VERSION_def();
        version[0].componentId = (short)20;
        version[0].majorVersion = (short)majorVersion;
        version[0].minorVersion = minorVersion;
        version[0].buildId = buildId | 0x8000000 | 0x10000000;
        if (this.t4props_.getDelayedErrorMode()) {
            version[0].buildId |= 0x20000000;
        }
        version[1] = new VERSION_def();
        version[1].componentId = (short)8;
        version[1].majorVersion = (short)3;
        version[1].minorVersion = 0;
        version[1].buildId = 0;
        return version;
    }

    USER_DESC_def getUserDescription() {
        return this.userDesc;
    }

    private void setISOMapping(int isoMapping) {
        if (InterfaceUtilities.getCharsetName(isoMapping) == "UNKNOWN") {
            isoMapping = InterfaceUtilities.getCharsetValue("ISO8859_1");
        }
        this.isoMapping_ = isoMapping;
    }

    String getServerDataSource() {
        return this._serverDataSource;
    }

    boolean getEnforceISO() {
        return this.enforceISO;
    }

    int getISOMapping() {
        return this.isoMapping_;
    }

    public String getSessionName() {
        return this.m_sessionName;
    }

    private void setTerminalCharset(int termCharset) {
        if (InterfaceUtilities.getCharsetName(termCharset) == "UNKNOWN") {
            termCharset = InterfaceUtilities.getCharsetValue("ISO8859_1");
        }
        this.termCharset_ = termCharset;
    }

    int getTerminalCharset() {
        return this.termCharset_;
    }

    void setWmsMode(boolean value) {
        this.wmsMode_ = value;
    }

    boolean getWmsMode() {
        return this.wmsMode_;
    }

    private USER_DESC_def getUserDescription(String user, String pwd) throws SQLException {
        byte[] authentication;
        this.userDesc = new USER_DESC_def();
        this.userDesc.userDescType = this.t4props_.getSessionToken() ? 3 : 2;
        this.userDesc.userName = user.length() > 128 ? user.substring(0, 128) : user;
        this.userDesc.domainName = "";
        this.userDesc.userSid = null;
        if (pwd.length() > 386) {
            pwd = pwd.substring(0, 386);
        }
        try {
            authentication = pwd.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException uex) {
            throw SQLMXMessages.createSQLException(this.t4props_, this.locale, uex.getMessage(), null);
        }
        if (authentication.length > 0) {
            Utility.Encryption(authentication, authentication, authentication.length);
        }
        this.userDesc.password = authentication;
        return this.userDesc;
    }

    T4Connection getT4Connection() {
        return this.t4connection_;
    }

    int getDialogueId() {
        return this.dialogueId_;
    }

    int getQueryTimeout() {
        return this.inContext.queryTimeoutSec;
    }

    int getLoginTimeout() {
        return this.inContext.loginTimeoutSec;
    }

    int getConnectionTimeout() {
        return this.inContext.idleTimeoutSec;
    }

    String getCatalog() {
        if (this.outContext != null) {
            return this.outContext.catalog;
        }
        return this.inContext.catalog;
    }

    boolean getDateConversion() {
        return (this.outContext.versionList.list[0].buildId & 0x200) > 0;
    }

    int getServerMajorVersion() {
        return this.outContext.versionList.list[0].majorVersion;
    }

    int getServerMinorVersion() {
        return this.outContext.versionList.list[0].minorVersion;
    }

    String getUid() {
        return this.userDesc.userName;
    }

    String getSchema() {
        if (this.outContext != null) {
            return this.outContext.schema;
        }
        return this.inContext.schema;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    boolean getByteSwap() {
        return this.byteSwap;
    }

    MXCSAddress getMXCSAddress() {
        return this.mxcsAddr_;
    }

    void cancel() throws SQLException {
        if (!this._ignoreCancel) {
            String srvrObjRef = "" + this.mxcsAddr_.getPort();
            int srvrType = 2;
            CancelReply cr_ = null;
            if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(this.t4props_);
                String temp = "cancel request received for " + srvrObjRef;
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "connect", temp, p);
            }
            String errorText = null;
            boolean tryNum = false;
            Object errorMsg = null;
            Object errorMsg_detail = null;
            long currentTime = new Date().getTime();
            if (this.inContext.loginTimeoutSec > 0) {
                long endTime = currentTime + (long)(this.inContext.loginTimeoutSec * 1000);
            } else {
                long endTime = Long.MAX_VALUE;
            }
            cr_ = SQLMX_AssociationServer_Cancel.cancel(this.t4props_, this, this.dialogueId_, srvrType, this.mxcsAddr_.m_url + "", 0);
            switch (cr_.m_p1_exception.exception_nr) {
                case 0: {
                    if (!this.t4props_.t4Logger_.isLoggable(Level.FINEST)) break;
                    Object[] p = T4LoggingUtilities.makeParams(this.t4props_);
                    String temp = "Cancel successful";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "connect", temp, p);
                    break;
                }
                default: {
                    if (cr_.m_p1_exception.clientErrorText != null) {
                        errorText = "Client Error text = " + cr_.m_p1_exception.clientErrorText;
                    }
                    errorText = errorText + "  :Exception = " + cr_.m_p1_exception.exception_nr;
                    errorText = errorText + "  :" + "Exception detail = " + cr_.m_p1_exception.exception_detail;
                    errorText = errorText + "  :" + "Error code = " + cr_.m_p1_exception.errorCode;
                    if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                        Object[] p = T4LoggingUtilities.makeParams(this.t4props_);
                        String temp = errorText;
                        this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "cancel", temp, p);
                    }
                    throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "as_cancel_message_error", errorText);
                }
            }
            currentTime = new Date().getTime();
        }
    }

    private void connect() throws SQLException {
        long endTime;
        short retryCount = 32766;
        int srvrType = 2;
        ConnectReply cr_ = null;
        InitializeDialogueReply idr_ = null;
        if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
            String msg = "Association Server URL: " + this.m_mxcsSrvr_ref;
            this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", msg, this.t4props_);
        }
        String errorText = null;
        boolean done = false;
        int tryNum = 0;
        String errorMsg = null;
        String errorMsg_detail = null;
        long currentTime = System.currentTimeMillis();
        long l = endTime = this.inContext.loginTimeoutSec > 0 ? currentTime + (long)(this.inContext.loginTimeoutSec * 1000) : Long.MAX_VALUE;
        do {
            String msg;
            if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                String temp = "Attempting getObjRef.  Try " + (tryNum + 1) + " of " + retryCount;
                this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp, this.t4props_);
            }
            cr_ = SQLMX_AssociationServer_Connect.getConnection(this.t4props_, this, this.inContext, this.userDesc, srvrType, retryCount);
            switch (cr_.m_p1_exception.exception_nr) {
                case 0: {
                    done = true;
                    if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                        msg = "getObjRef Successful.  Server URL: " + cr_.m_p2_srvrObjRef;
                        this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", msg, this.t4props_);
                    }
                    if (cr_.m_p4_dataSource.equals(this.t4props_.getServerDataSource())) break;
                    Object[] messageArguments = new Object[]{cr_.m_p4_dataSource};
                    this.sqlwarning_ = SQLMXMessages.createSQLWarning(this.t4props_, "connected_to_Default_DS", messageArguments);
                    break;
                }
                case 4: {
                    done = false;
                    ++tryNum;
                    errorMsg = "as_connect_message_error";
                    errorMsg_detail = "try again request";
                    break;
                }
                case 5: {
                    done = false;
                    ++tryNum;
                    errorMsg = "as_connect_message_error";
                    errorMsg_detail = "association server not available";
                    break;
                }
                case 6: {
                    done = false;
                    ++tryNum;
                    errorMsg = "as_connect_message_error";
                    errorMsg_detail = "data source not available";
                    break;
                }
                case 7: {
                    done = false;
                    ++tryNum;
                    errorMsg = "as_connect_message_error";
                    errorMsg_detail = "port not available";
                    break;
                }
                case 3: {
                    done = false;
                    ++tryNum;
                    errorMsg = "as_connect_message_error";
                    errorMsg_detail = "server handle not available";
                    break;
                }
                default: {
                    if (cr_.m_p1_exception.clientErrorText != null) {
                        errorText = "Client Error text = " + cr_.m_p1_exception.clientErrorText;
                    }
                    errorText = errorText + "  :Exception = " + cr_.m_p1_exception.exception_nr;
                    errorText = errorText + "  :" + "Exception detail = " + cr_.m_p1_exception.exception_detail;
                    errorText = errorText + "  :" + "Error code = " + cr_.m_p1_exception.errorCode;
                    if (cr_.m_p1_exception.ErrorText != null) {
                        errorText = errorText + "  :" + "Error text = " + cr_.m_p1_exception.ErrorText;
                    }
                    throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "as_connect_message_error", errorText);
                }
            }
            if (!done && this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                msg = "getObjRef Failed. Message from Association Server: " + errorMsg_detail;
                this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", msg, this.t4props_);
            }
            currentTime = System.currentTimeMillis();
        } while (!done && endTime > currentTime && tryNum < retryCount);
        if (!done) {
            SQLMXException se1;
            if (currentTime >= endTime) {
                se1 = SQLMXMessages.createSQLException(this.t4props_, this.locale, "ids_s1_t00", null);
                SQLMXException se2 = SQLMXMessages.createSQLException(this.t4props_, this.locale, errorMsg, errorMsg_detail);
                se1.setNextException(se2);
            } else {
                se1 = SQLMXMessages.createSQLException(this.t4props_, this.locale, errorMsg, errorMsg_detail);
            }
            throw se1;
        }
        this.dialogueId_ = cr_.m_p3_dialogueId;
        this.m_mxcsSrvr_ref = cr_.m_p2_srvrObjRef;
        this.mxcsAddr_ = cr_.getMXCSAddress();
        this.byteSwap = cr_.byteSwap;
        this._serverDataSource = cr_.m_p4_dataSource;
        this.setISOMapping(cr_.isoMapping);
        if (cr_.isoMapping == InterfaceUtilities.getCharsetValue("ISO8859_1")) {
            this.setTerminalCharset(InterfaceUtilities.getCharsetValue("ISO8859_1"));
            this.inContext.ctxDataLang = 0;
            this.inContext.ctxErrorLang = 0;
        } else {
            this.setTerminalCharset(InterfaceUtilities.getCharsetValue("UTF-8"));
        }
        endTime = this.inContext.loginTimeoutSec > 0 ? currentTime + (long)(this.inContext.loginTimeoutSec * 1000) : Long.MAX_VALUE;
        tryNum = 0;
        done = false;
        boolean socketException = false;
        SQLException seSave = null;
        do {
            String temp;
            if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                temp = "Attempting initDiag.  Try " + (tryNum + 1) + " of " + retryCount;
                this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp, this.t4props_);
            }
            socketException = false;
            try {
                this.t4connection_ = new T4Connection(this);
                idr_ = this.t4connection_.InitializeDialogue();
            }
            catch (SQLException se) {
                String temp2;
                int sc = se.getErrorCode();
                int s1 = SQLMXMessages.createSQLException(this.t4props_, this.locale, "socket_open_error", null).getErrorCode();
                int s2 = SQLMXMessages.createSQLException(this.t4props_, this.locale, "socket_write_error", null).getErrorCode();
                int s3 = SQLMXMessages.createSQLException(this.t4props_, this.locale, "socket_read_error", null).getErrorCode();
                if (sc == s1 || sc == s2 || sc == s3) {
                    if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                        temp2 = "A socket exception occured: " + se.getMessage();
                        this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp2, this.t4props_);
                    }
                    socketException = true;
                    seSave = se;
                }
                if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                    temp2 = "A non-socket fatal exception occured: " + se.getMessage();
                    this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp2, this.t4props_);
                }
                try {
                    this.t4connection_.getInputOutput().CloseIO(new LogicalByteArray(1, 0, false));
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw se;
            }
            if (!socketException) {
                if (idr_.m_p1_exception.exception_nr == 0) {
                    done = true;
                    if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                        temp = "initDiag Successful.";
                        this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp, this.t4props_);
                    }
                } else if (idr_.m_p1_exception.exception_nr == 3) {
                    if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
                        temp = "A SQL Warning or Error occured during initDiag: " + idr_.m_p1_exception.SQLError;
                        this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp, this.t4props_);
                    }
                    int ex_nr = idr_.m_p1_exception.exception_nr;
                    int ex_nr_d = idr_.m_p1_exception.exception_detail;
                    if (ex_nr_d == 8857 || ex_nr_d == 8837) {
                        done = true;
                    } else {
                        SQLMXMessages.throwSQLException(this.t4props_, idr_.m_p1_exception.SQLError);
                    }
                }
            }
            currentTime = System.currentTimeMillis();
        } while (!done && endTime > currentTime && ++tryNum < retryCount);
        if (!done) {
            if (socketException) {
                throw seSave;
            }
            SQLMXException se1 = currentTime >= endTime ? SQLMXMessages.createSQLException(this.t4props_, this.locale, "ids_s1_t00", null) : (tryNum >= retryCount ? SQLMXMessages.createSQLException(this.t4props_, this.locale, "as_connect_message_error", "exceeded retry count") : SQLMXMessages.createSQLException(this.t4props_, this.locale, "as_connect_message_error", null));
            throw se1;
        }
        this.outContext = idr_.m_p2_outContext;
        this.enforceISO = this.outContext._enforceISO;
        this._roleName = this.outContext._roleName;
        this._ignoreCancel = this.outContext._ignoreCancel;
        this.t4props_.setDialogueID(Integer.toString(this.dialogueId_));
        this.t4props_.setServerID(this.m_mxcsSrvr_ref);
        this.t4props_.setMxcsMajorVersion(idr_.m_p2_outContext.versionList.list[0].majorVersion);
        this.t4props_.setMxcsMinorVersion(idr_.m_p2_outContext.versionList.list[0].minorVersion);
        this.t4props_.setSqlmxMajorVersion(idr_.m_p2_outContext.versionList.list[1].majorVersion);
        this.t4props_.setSqlmxMinorVersion(idr_.m_p2_outContext.versionList.list[1].minorVersion);
        if (this.t4props_.t4Logger_.isLoggable(Level.INFO)) {
            String temp = "Connection process successful";
            this.t4props_.t4Logger_.logp(Level.INFO, "InterfaceConnection", "connect", temp, this.t4props_);
        }
    }

    void isConnectionClosed() throws SQLException {
        if (!this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "invalid_connection", null);
        }
    }

    void isConnectionOpen() throws SQLException {
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "invalid_connection", null);
        }
    }

    boolean getIsClosed() {
        return this.isClosed_;
    }

    void setIsClosed(boolean isClosed) {
        this.isClosed_ = isClosed;
    }

    String getUrl() {
        return this.m_mxcsSrvr_ref;
    }

    void setCatalog(SQLMXConnection conn, String catalog) throws SQLException {
        String temp;
        Object[] p;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, catalog);
            temp = "Setting connection catalog = " + catalog;
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setCatalog", temp, p);
        }
        if (catalog != null && catalog.length() == 0) {
            catalog = "";
        }
        this.setConnectionAttr(conn, (short)109, 0, catalog);
        this.outContext.catalog = catalog;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, catalog);
            temp = "Setting connection catalog = " + catalog + " is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setCatalog", temp, p);
        }
    }

    void enforceT4ConnectionTimeout(SQLMXConnection conn) throws SQLException {
        String temp;
        Object[] p;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, (short)this.t4props_.getConnectionTimeout());
            temp = "Enforcing connection timeout = " + (short)this.t4props_.getConnectionTimeout();
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "enforceT4ConnectionTimeout", temp, p);
        }
        this.inContext.idleTimeoutSec = (short)this.t4props_.getConnectionTimeout();
        this.setConnectionAttr(conn, (short)3000, this.inContext.idleTimeoutSec, String.valueOf(this.inContext.idleTimeoutSec));
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, (short)this.t4props_.getConnectionTimeout());
            temp = "Enforcing connection timeout = " + (short)this.t4props_.getConnectionTimeout() + " is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "enforceT4ConnectionTimeout", temp, p);
        }
    }

    void disregardT4ConnectionTimeout(SQLMXConnection conn) throws SQLException {
        String temp;
        Object[] p;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, "-1");
            temp = "Setting connection timeout = -1";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "disregardT4ConnectionTimeout", temp, p);
        }
        this.setConnectionAttr(conn, (short)3000, -1, "-1");
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, "-1");
            temp = "Setting connection timeout = -1 is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "disregardT4ConnectionTimeout", temp, p);
        }
    }

    void setConnectionAttr(SQLMXConnection conn, short attr, int valueNum, String valueString) throws SQLException {
        SetConnectionOptionReply scr_;
        this.isConnectionOpen();
        try {
            scr_ = this.t4connection_.SetConnectionOption(attr, valueNum, valueString);
        }
        catch (SQLException tex) {
            if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(conn.props_, (int)attr, valueNum, (Object)valueString);
                String temp = "MXCS or SQLException occured.";
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setConnectionAttr", temp, p);
            }
            throw tex;
        }
        switch (scr_.m_p1.exception_nr) {
            case 0: {
                if (scr_.m_p2.length != 0) {
                    SQLMXMessages.setSQLWarning(conn.props_, (SQLMXHandle)conn, scr_.m_p2);
                }
                if (!this.t4props_.t4Logger_.isLoggable(Level.FINEST)) break;
                Object[] p = T4LoggingUtilities.makeParams(conn.props_, (int)attr, valueNum, (Object)valueString);
                String temp = "Setting connection attribute is done.";
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setConnectionAttr", temp, p);
                break;
            }
            case 3: {
                String temp;
                Object[] p;
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(conn.props_, (int)attr, valueNum, (Object)valueString);
                    temp = "odbc_SQLSvc_SetConnectionOption_SQLError_exn_ occured.";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setConnectionAttr", temp, p);
                }
                SQLMXMessages.throwSQLException(this.t4props_, scr_.m_p1.errorList);
            }
            default: {
                String temp;
                Object[] p;
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(conn.props_, (int)attr, valueNum, (Object)valueString);
                    temp = "UnknownException occured.";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setConnectionAttr", temp, p);
                }
                throw SQLMXMessages.createSQLException(conn.props_, this.locale, "ids_unknown_reply_error", null);
            }
        }
    }

    void setTransactionIsolation(SQLMXConnection conn, int level) throws SQLException {
        String temp;
        Object[] p;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, level);
            temp = "Setting transaction isolation = " + level;
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setTransactionIsolation", temp, p);
        }
        this.isConnectionOpen();
        if (level != 0 && level != 2 && level != 1 && level != 4 && level != 8) {
            throw SQLMXMessages.createSQLException(conn.props_, this.locale, "invalid_transaction_isolation", null);
        }
        this.txnIsolationLevel = level;
        switch (this.txnIsolationLevel) {
            case 0: {
                this.inContext.txnIsolationLevel = (short)2;
                break;
            }
            case 2: {
                this.inContext.txnIsolationLevel = (short)2;
                break;
            }
            case 1: {
                this.inContext.txnIsolationLevel = 1;
                break;
            }
            case 4: {
                this.inContext.txnIsolationLevel = (short)4;
                break;
            }
            case 8: {
                this.inContext.txnIsolationLevel = (short)8;
                break;
            }
            default: {
                this.inContext.txnIsolationLevel = (short)2;
            }
        }
        this.setConnectionAttr(conn, (short)108, this.inContext.txnIsolationLevel, String.valueOf(this.inContext.txnIsolationLevel));
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(conn.props_, level);
            temp = "Setting transaction isolation = " + level + " is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setTransactionIsolation", temp, p);
        }
    }

    int getTransactionIsolation() throws SQLException {
        return this.txnIsolationLevel;
    }

    long getTxid() {
        return this.txid;
    }

    void setTxid(long txid) {
        this.txid = txid;
    }

    boolean getAutoCommit() {
        return this.autoCommit;
    }

    void setAutoCommit(SQLMXConnection conn, boolean autoCommit) throws SQLException {
        this.isConnectionOpen();
        boolean commit = this.autoCommit;
        this.autoCommit = autoCommit;
        this.inContext.autoCommit = !autoCommit ? (short)0 : 1;
        try {
            this.setConnectionAttr(conn, (short)102, this.inContext.autoCommit, String.valueOf(this.inContext.autoCommit));
        }
        catch (SQLException sqle) {
            this.autoCommit = commit;
            throw sqle;
        }
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(conn.props_, autoCommit);
            String temp = "Setting autoCommit = " + autoCommit + " is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "setAutoCommit", temp, p);
        }
    }

    void enableNARSupport(SQLMXConnection conn, boolean NARSupport) throws SQLException {
        int val = NARSupport ? 1 : 0;
        this.setConnectionAttr(conn, (short)2000, val, String.valueOf(val));
    }

    void enableProxySyntax(SQLMXConnection conn) throws SQLException {
        this.setConnectionAttr(conn, (short)1040, 1, "1");
    }

    boolean isReadOnly() {
        return this.isReadOnly;
    }

    void setReadOnly(boolean readOnly) throws SQLException {
        this.isConnectionOpen();
        this.isReadOnly = readOnly;
    }

    void setReadOnly(SQLMXConnection conn, boolean readOnly) throws SQLException {
        if (this.isReadOnly == readOnly) {
            return;
        }
        this.isConnectionOpen();
        this.isReadOnly = readOnly;
        this.inContext.accessMode = !readOnly ? (short)0 : 1;
        this.setConnectionAttr(conn, (short)101, this.inContext.accessMode, String.valueOf(this.inContext.accessMode));
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(conn.props_, readOnly);
            String temp = "Setting readOnly = " + readOnly + " is done.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "readOnly", temp, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws SQLException {
        String temp;
        Object[] p;
        TerminateDialogueReply tdr_ = null;
        if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(this.t4props_);
            temp = "Terminate Dialogue.";
            this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "close", temp, p);
        }
        try {
            tdr_ = this.t4connection_.TerminateDialogue();
        }
        catch (SQLException tex) {
            if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p2 = T4LoggingUtilities.makeParams(this.t4props_);
                String temp2 = "SQLException during TerminateDialogue.";
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "close", temp2, p2);
            }
            throw tex;
        }
        switch (tdr_.m_p1.exception_nr) {
            case 0: {
                break;
            }
            case 3: {
                try {
                    if (this.getAutoCommit()) break;
                    this.rollback();
                    break;
                }
                finally {
                    this.close();
                    SQLMXMessages.throwSQLException(this.t4props_, tdr_.m_p1.SQLError);
                }
            }
        }
        try {
            if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                p = T4LoggingUtilities.makeParams(this.t4props_);
                temp = "Terminate Dialogue successful.";
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "close", temp, p);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void endTransaction(short commitOption) throws SQLException {
        EndTransactionReply etr_ = null;
        if (this.autoCommit && !this.t4props_.getCommitInAutoCommitOn()) {
            throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "invalid_commit_mode", null);
        }
        this.isConnectionOpen();
        try {
            etr_ = this.t4connection_.EndTransaction(commitOption);
        }
        catch (SQLException tex) {
            if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                String temp = "SQLException during EndTransaction." + tex.toString();
                this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
            }
            throw tex;
        }
        switch (etr_.m_p1.exception_nr) {
            case 0: {
                break;
            }
            case 1: {
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    String temp = "odbc_SQLSvc_EndTransaction_ParamError_exn_ :";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                throw SQLMXMessages.createSQLException(this.t4props_, this.locale, "ParamError:" + etr_.m_p1.ParamError, null);
            }
            case 2: {
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    String temp = "odbc_SQLSvc_EndTransaction_InvalidConnection_exn_:";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                throw new SQLException("odbc_SQLSvc_EndTransaction_InvalidConnection_exn", "HY100002", 10001);
            }
            case 3: {
                String temp;
                Object[] p;
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    temp = "odbc_SQLSvc_EndTransaction_SQLError_exn_:" + etr_.m_p1.SQLError;
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                SQLMXMessages.throwSQLException(this.t4props_, etr_.m_p1.SQLError);
            }
            case 4: {
                String temp;
                Object[] p;
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    temp = "odbc_SQLSvc_EndTransaction_SQLInvalidHandle_exn_:";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                throw new SQLException("odbc_SQLSvc_EndTransaction_SQLInvalidHandle_exn", "HY100004", 10001);
            }
            case 5: {
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    String temp = "odbc_SQLSvc_EndTransaction_TransactionError_exn_:";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                throw new SQLException("odbc_SQLSvc_EndTransaction_TransactionError_exn", "HY100005", 10001);
            }
            default: {
                if (this.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.t4props_, commitOption);
                    String temp = "UnknownError:";
                    this.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceConnection", "endTransaction", temp, p);
                }
                throw new SQLException("Unknown Error during EndTransaction", "HY100001", 10001);
            }
        }
    }

    void commit() throws SQLException {
        this.endTransaction((short)0);
    }

    void rollback() throws SQLException {
        this.endTransaction((short)1);
    }

    long beginTransaction() throws SQLException {
        this.isConnectionOpen();
        return this.txid;
    }

    void reuse() {
        this.txnIsolationLevel = 2;
        this.autoCommit = true;
        this.isReadOnly = false;
        this.isClosed_ = false;
        this.txid = 0L;
        this.t4connection_.reuse();
    }

    boolean useArrayBinding() {
        return this.useArrayBinding_;
    }

    short getTransportBufferSize() {
        return this.transportBufferSize_;
    }

    void removeElement(SQLMXConnection conn) {
        refTosrvrCtxHandle_.remove(conn.pRef_);
        conn.pRef_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gcConnections() {
        Reference pRef;
        while ((pRef = refQ_.poll()) != null) {
            InterfaceConnection ic = (InterfaceConnection)refTosrvrCtxHandle_.get(pRef);
            if (ic == null) continue;
            try {
                ic.close();
            }
            catch (SQLException sQLException) {}
            continue;
            finally {
                refTosrvrCtxHandle_.remove(pRef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeString(String str, int charset) throws CharacterCodingException, UnsupportedCharsetException {
        Integer key = new Integer(charset);
        byte[] ret = null;
        if (str != null) {
            if (this.isoMapping_ == 1 && !this.enforceISO) {
                ret = str.getBytes();
            } else {
                CharsetEncoder ce = (CharsetEncoder)this.encoders.get(key);
                if (ce == null) {
                    Charset c = Charset.forName(InterfaceUtilities.getCharsetName(charset));
                    ce = c.newEncoder();
                    ce.onUnmappableCharacter(CodingErrorAction.REPORT);
                    this.encoders.put(key, ce);
                }
                CharsetEncoder charsetEncoder = ce;
                synchronized (charsetEncoder) {
                    ce.reset();
                    ByteBuffer buf = ce.encode(CharBuffer.wrap(str));
                    ret = new byte[buf.remaining()];
                    buf.get(ret, 0, ret.length);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decodeBytes(byte[] data, int charset) throws CharacterCodingException, UnsupportedCharsetException {
        Integer key = new Integer(charset);
        String str = null;
        if (this.isoMapping_ == 1 && !this.enforceISO && charset != 11) {
            str = new String(data);
        } else {
            CharsetDecoder cd;
            boolean fix = false;
            if (charset == 10 && data.length == 1) {
                data = new byte[]{0, data[0]};
                fix = true;
            }
            if ((cd = (CharsetDecoder)this.decoders.get(key)) == null) {
                Charset c = Charset.forName(InterfaceUtilities.getCharsetName(charset));
                cd = c.newDecoder();
                cd.replaceWith(this.t4props_.getReplacementString());
                cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.decoders.put(key, cd);
            }
            CharsetDecoder charsetDecoder = cd;
            synchronized (charsetDecoder) {
                cd.reset();
                str = cd.decode(ByteBuffer.wrap(data)).toString();
            }
            if (fix) {
                str = str.substring(1);
            }
        }
        return str;
    }

    public String getApplicationName() {
        return this.t4props_.getApplicationName();
    }
}

