/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.CloseReply;
import com.tandem.t4jdbc.FetchReply;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.InterfaceStatement;
import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.Row;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDesc;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXResultSet;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4ResultSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Properties;
import java.util.logging.Level;

class InterfaceResultSet {
    InterfaceConnection ic_;
    String stmtLabel_;
    static final int SQLTYPECODE_CHAR = 1;
    static final int SQLTYPECODE_NUMERIC = 2;
    static final int SQLTYPECODE_NUMERIC_UNSIGNED = -201;
    static final int SQLTYPECODE_DECIMAL = 3;
    static final int SQLTYPECODE_DECIMAL_UNSIGNED = -301;
    static final int SQLTYPECODE_DECIMAL_LARGE = -302;
    static final int SQLTYPECODE_DECIMAL_LARGE_UNSIGNED = -303;
    static final int SQLTYPECODE_INTEGER = 4;
    static final int SQLTYPECODE_INTEGER_UNSIGNED = -401;
    static final int SQLTYPECODE_LARGEINT = -402;
    static final int SQLTYPECODE_SMALLINT = 5;
    static final int SQLTYPECODE_SMALLINT_UNSIGNED = -502;
    static final int SQLTYPECODE_BPINT_UNSIGNED = -503;
    static final int SQLTYPECODE_FLOAT = 6;
    static final int SQLTYPECODE_REAL = 7;
    static final int SQLTYPECODE_DOUBLE = 8;
    static final int SQLTYPECODE_DATETIME = 9;
    static final int SQLTYPECODE_INTERVAL = 10;
    static final int SQLTYPECODE_VARCHAR = 12;
    static final int SQLTYPECODE_VARCHAR_WITH_LENGTH = -601;
    static final int SQLTYPECODE_VARCHAR_LONG = -1;
    static final int SQLTYPECODE_BIT = 14;
    static final int SQLTYPECODE_BITVAR = 15;
    static final int SQLTYPECODE_CHAR_DBLBYTE = 16;
    static final int SQLTYPECODE_VARCHAR_DBLBYTE = 17;
    static final int SQLDTCODE_DATE = 1;
    static final int SQLDTCODE_TIME = 2;
    static final int SQLDTCODE_TIMESTAMP = 3;
    static final int SQLDTCODE_MPDATETIME = 4;
    static final int dateLength = 10;
    static final int timeLength = 8;
    static final int timestampLength = 26;
    T4ResultSet t4resultSet_;
    static Properties javaLangToJavaNio = null;
    SQLMXResultSet rs_;

    InterfaceResultSet(SQLMXResultSet rs) throws SQLException {
        this.ic_ = rs.connection_.getServerHandle();
        this.stmtLabel_ = rs.stmtLabel_;
        this.t4resultSet_ = new T4ResultSet(this, rs.connection_.props_.getCloseConnectionUponQueryTimeout());
        this.rs_ = rs;
    }

    static int dataLengthFetchPerf(int SQLDataType, int SQLDateTimeCode, int SQLOctetLength, int maxRowLen, int bufferLen, int ODBCDataType, int ODBCPrecision) {
        int allocLength = 0;
        block0 : switch (SQLDataType) {
            case 10: {
                allocLength = SQLOctetLength;
                break;
            }
            case -601: 
            case -1: 
            case 15: 
            case 17: {
                allocLength = bufferLen + 2;
                break;
            }
            case 1: {
                allocLength = SQLOctetLength;
                if (maxRowLen <= 0) break;
                allocLength = allocLength > maxRowLen ? maxRowLen + 1 : allocLength;
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                allocLength = SQLOctetLength - 1;
                if (maxRowLen <= 0) break;
                allocLength = allocLength > maxRowLen ? maxRowLen + 1 : allocLength;
                break;
            }
            case 9: {
                switch (SQLDateTimeCode) {
                    case 1: {
                        allocLength = 10;
                        break block0;
                    }
                    case 2: {
                        if (ODBCDataType == 1111) {
                            allocLength = SQLOctetLength;
                            break block0;
                        }
                        allocLength = 8;
                        break block0;
                    }
                    case 3: {
                        allocLength = ODBCPrecision;
                        break block0;
                    }
                }
                allocLength = SQLOctetLength;
                break;
            }
            default: {
                allocLength = SQLOctetLength;
            }
        }
        return allocLength;
    }

    Object getFetchString(SQLMXConnection conn, int scale, int SQLDataType, int SQLDatetimeCode, int FSDataType, byte[] ibuffer, int byteIndex, int byteLen, int SQLcharset, int ODBCDataType) throws SQLException {
        Object retObj2;
        block0 : switch (SQLDataType) {
            case 1: {
                byte[] tbuffer = new byte[byteLen];
                System.arraycopy(ibuffer, byteIndex, tbuffer, 0, byteLen);
                retObj2 = tbuffer;
                break;
            }
            case 12: {
                byte[] tbuffer = new byte[byteLen];
                System.arraycopy(ibuffer, byteIndex, tbuffer, 0, byteLen);
                retObj2 = tbuffer;
                break;
            }
            case 10: {
                byte[] tbuffer = new byte[byteLen];
                System.arraycopy(ibuffer, byteIndex, tbuffer, 0, byteLen);
                retObj2 = tbuffer;
                break;
            }
            case -601: 
            case -1: {
                byte[] tbuffer = new byte[byteLen - 2];
                System.arraycopy(ibuffer, byteIndex + 2, tbuffer, 0, byteLen - 2);
                retObj2 = tbuffer;
                break;
            }
            case 9: {
                String tmpStr = new String(Bytes.read_chars(ibuffer, byteIndex, byteLen));
                switch (SQLDatetimeCode) {
                    case 1: {
                        retObj2 = Date.valueOf(tmpStr);
                        break block0;
                    }
                    case 3: {
                        retObj2 = Timestamp.valueOf(tmpStr);
                        break block0;
                    }
                    case 2: {
                        if (ODBCDataType == 1111) break;
                        retObj2 = Time.valueOf(tmpStr);
                        break block0;
                    }
                }
                retObj2 = tmpStr;
                break;
            }
            case 5: {
                short sValue = Bytes.extractShort(ibuffer, byteIndex, this.ic_.getByteSwap());
                retObj2 = new Short(sValue);
                if (scale <= 0) break;
                retObj2 = new BigDecimal(new BigInteger(retObj2.toString()), scale);
                break;
            }
            case -502: {
                retObj2 = new Integer(Bytes.extractUShort(ibuffer, byteIndex, this.ic_.getByteSwap()));
                if (scale <= 0) break;
                retObj2 = new BigDecimal(new BigInteger(retObj2.toString()), scale);
                break;
            }
            case 4: {
                retObj2 = new Integer(Bytes.extractInt(ibuffer, byteIndex, this.ic_.getByteSwap()));
                if (scale <= 0) break;
                retObj2 = new BigDecimal(new BigInteger(retObj2.toString()), scale);
                break;
            }
            case -401: {
                retObj2 = new Long(Bytes.extractUInt(ibuffer, byteIndex, this.ic_.getByteSwap()));
                if (scale <= 0) break;
                retObj2 = new BigDecimal(new BigInteger(retObj2.toString()), scale);
                break;
            }
            case -402: {
                byte[] tbuffer = new byte[byteLen];
                System.arraycopy(ibuffer, byteIndex, tbuffer, 0, byteLen);
                retObj2 = new BigInteger(tbuffer);
                if (scale <= 0) break;
                retObj2 = new BigDecimal((BigInteger)retObj2, scale);
                break;
            }
            case -201: 
            case 2: {
                String tmpStr;
                switch (FSDataType) {
                    case 130: 
                    case 131: {
                        tmpStr = String.valueOf(Bytes.extractShort(ibuffer, byteIndex, this.ic_.getByteSwap()));
                        break;
                    }
                    case 132: 
                    case 133: {
                        tmpStr = String.valueOf(Bytes.extractInt(ibuffer, byteIndex, this.ic_.getByteSwap()));
                        break;
                    }
                    case 134: {
                        tmpStr = String.valueOf(Bytes.extractLong(ibuffer, byteIndex, this.ic_.getByteSwap()));
                        break;
                    }
                    case 2: {
                        byte[] tbuffer = new byte[byteLen];
                        System.arraycopy(ibuffer, byteIndex, tbuffer, 0, byteLen);
                        BigDecimal retObj2 = InterfaceUtilities.convertSQLBigNumToBigDecimal(tbuffer, scale);
                        return retObj2;
                    }
                    default: {
                        throw SQLMXMessages.createSQLException(conn.props_, conn.getLocale(), "restricted_data_type", null);
                    }
                }
                retObj2 = new BigDecimal(new BigInteger(tmpStr), scale);
                break;
            }
            case -303: 
            case -302: 
            case -301: 
            case 3: {
                String retStr;
                byte sign = (byte)(ibuffer[byteIndex] & 0xFFFFFFB0);
                if (sign == -80) {
                    byte firstByte = (byte)(ibuffer[byteIndex] - -80);
                    retStr = "-" + firstByte + String.valueOf(Bytes.read_chars(ibuffer, byteIndex + 1, byteLen - 1));
                } else {
                    retStr = String.valueOf(Bytes.read_chars(ibuffer, byteIndex, byteLen));
                }
                retObj2 = new BigDecimal(new BigInteger(retStr), scale);
                break;
            }
            case 7: {
                retObj2 = new Float(Float.intBitsToFloat(Bytes.extractInt(ibuffer, byteIndex, this.ic_.getByteSwap())));
                break;
            }
            case 6: 
            case 8: {
                retObj2 = new Double(Double.longBitsToDouble(Bytes.extractLong(ibuffer, byteIndex, this.ic_.getByteSwap())));
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(conn.props_, conn.getLocale(), "restricted_data_type", null);
            }
        }
        return retObj2;
    }

    private static String padZero(long i, int len) {
        String s = String.valueOf(i);
        while (s.length() < len) {
            s = '0' + s;
        }
        return s;
    }

    static Object getExecute2FetchString(SQLMXConnection conn, SQLMXDesc desc, byte[] values, int noNullValue, int ODBCDataType, boolean useOldDateFormat, boolean swap) throws SQLException {
        Object retObj;
        block0 : switch (desc.sqlDataType_) {
            case 1: {
                int length = desc.sqlOctetLength_;
                byte[] tbuffer = new byte[length];
                System.arraycopy(values, noNullValue, tbuffer, 0, length);
                retObj = tbuffer;
                break;
            }
            case -601: 
            case -1: 
            case 12: {
                boolean shortLength = (double)desc.precision_ < Math.pow(2.0, 15.0);
                int dataOffset = noNullValue + (shortLength ? 2 : 4);
                int length = shortLength ? Bytes.extractShort(values, noNullValue, swap) : Bytes.extractInt(values, noNullValue, swap);
                byte[] tbuffer = new byte[length];
                int len = values.length - dataOffset;
                System.arraycopy(values, dataOffset, tbuffer, 0, length > len ? len : length);
                retObj = tbuffer;
                break;
            }
            case 10: {
                int length = desc.sqlOctetLength_;
                byte[] tbuffer = new byte[length];
                System.arraycopy(values, noNullValue, tbuffer, 0, length);
                retObj = tbuffer;
                break;
            }
            case 9: {
                switch (desc.sqlDatetimeCode_) {
                    case 1: {
                        if (!useOldDateFormat) {
                            int year = Bytes.extractUShort(values, noNullValue, swap);
                            byte month = values[noNullValue + 2];
                            byte day = values[noNullValue + 3];
                            String dt = SQLMXResultSet.convertDateFormat(String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day));
                            retObj = SQLMXResultSet.valueOf(dt);
                            break block0;
                        }
                        int length = 10;
                        retObj = Date.valueOf(new String(Bytes.read_chars(values, noNullValue, length)));
                        break block0;
                    }
                    case 3: {
                        if (!useOldDateFormat) {
                            String tmpStr;
                            int year = Bytes.extractUShort(values, noNullValue, swap);
                            byte month = values[noNullValue + 2];
                            byte day = values[noNullValue + 3];
                            byte hour = values[noNullValue + 4];
                            byte minute = values[noNullValue + 5];
                            byte second = values[noNullValue + 6];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 7, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                tmpStr = "" + nanoSeconds;
                                int length = tmpStr.length();
                                for (int i = 0; i < desc.sqlPrecision_ - length; ++i) {
                                    tmpStr = "0" + tmpStr;
                                }
                            } else {
                                tmpStr = "0";
                            }
                            retObj = Timestamp.valueOf(InterfaceResultSet.padZero(year, 4) + "-" + InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2) + "." + tmpStr);
                            break block0;
                        }
                        int length = desc.precision_;
                        retObj = Timestamp.valueOf(new String(Bytes.read_chars(values, noNullValue, length)));
                        break block0;
                    }
                    case 2: {
                        if (ODBCDataType == 1111) {
                            int length = desc.sqlOctetLength_;
                            retObj = new String(Bytes.read_chars(values, noNullValue, length));
                            break block0;
                        }
                        int length = 8;
                        if (!useOldDateFormat) {
                            byte hour = values[noNullValue];
                            byte minute = values[noNullValue + 1];
                            byte second = values[noNullValue + 2];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 3, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                String formatStr = "";
                                for (int i = 0; i < desc.sqlPrecision_; ++i) {
                                    formatStr = formatStr + "0";
                                }
                                StringBuffer sb = new StringBuffer();
                                DecimalFormat format = new DecimalFormat("00");
                                format.format((long)hour, sb, new FieldPosition(0));
                                sb.append(':');
                                format.format((long)minute, sb, new FieldPosition(0));
                                sb.append(':');
                                format.format((long)second, sb, new FieldPosition(0));
                                sb.append('.');
                                format = new DecimalFormat(formatStr);
                                format.format(nanoSeconds, sb, new FieldPosition(0));
                                retObj = sb.toString();
                                break block0;
                            }
                            retObj = Time.valueOf(String.valueOf(hour) + ":" + String.valueOf(minute) + ":" + String.valueOf(second));
                            break block0;
                        }
                        retObj = Time.valueOf(new String(Bytes.read_chars(values, noNullValue, length)));
                        break block0;
                    }
                    case 4: {
                        int year = Bytes.extractUShort(values, noNullValue, swap);
                        retObj = String.valueOf(InterfaceResultSet.padZero(year, 4));
                        break block0;
                    }
                    case 5: {
                        int year = Bytes.extractUShort(values, noNullValue, swap);
                        byte month = values[noNullValue + 2];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(year, 4) + "-" + InterfaceResultSet.padZero(month, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 7: {
                        int year = Bytes.extractUShort(values, noNullValue, swap);
                        byte month = values[noNullValue + 2];
                        byte day = values[noNullValue + 3];
                        byte hour = values[noNullValue + 4];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(year, 4) + "-" + InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 8: {
                        int year = Bytes.extractUShort(values, noNullValue, swap);
                        byte month = values[noNullValue + 2];
                        byte day = values[noNullValue + 3];
                        byte hour = values[noNullValue + 4];
                        byte minute = values[noNullValue + 5];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(year, 4) + "-" + InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 10: {
                        byte month = values[noNullValue];
                        retObj = String.valueOf(InterfaceResultSet.padZero(month, 2));
                        break block0;
                    }
                    case 11: {
                        byte month = values[noNullValue];
                        byte day = values[noNullValue + 1];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 12: {
                        byte month = values[noNullValue];
                        byte day = values[noNullValue + 1];
                        byte hour = values[noNullValue + 2];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 13: {
                        byte month = values[noNullValue];
                        byte day = values[noNullValue + 1];
                        byte hour = values[noNullValue + 2];
                        byte minute = values[noNullValue + 3];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 14: {
                        int length = desc.sqlOctetLength_;
                        if (length == 5) {
                            byte month = values[noNullValue];
                            byte day = values[noNullValue + 1];
                            byte hour = values[noNullValue + 2];
                            byte minute = values[noNullValue + 3];
                            byte second = values[noNullValue + 4];
                            String tmpStr = String.valueOf(InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2));
                            retObj = String.valueOf(tmpStr);
                            break block0;
                        }
                        if (length == 9) {
                            String tmpStr;
                            byte month = values[noNullValue];
                            byte day = values[noNullValue + 1];
                            byte hour = values[noNullValue + 2];
                            byte minute = values[noNullValue + 3];
                            byte second = values[noNullValue + 4];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 5, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                tmpStr = "" + nanoSeconds;
                                length = tmpStr.length();
                                for (int i = 0; i < desc.sqlPrecision_ - length; ++i) {
                                    tmpStr = "0" + tmpStr;
                                }
                            } else {
                                tmpStr = "0";
                            }
                            retObj = String.valueOf(InterfaceResultSet.padZero(month, 2) + "-" + InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2) + "." + tmpStr);
                            break block0;
                        }
                        retObj = new String(Bytes.read_chars(values, noNullValue, length));
                        break block0;
                    }
                    case 15: {
                        byte day = values[noNullValue];
                        retObj = String.valueOf(InterfaceResultSet.padZero(day, 2));
                        break block0;
                    }
                    case 16: {
                        byte day = values[noNullValue];
                        byte hour = values[noNullValue + 1];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 17: {
                        byte day = values[noNullValue];
                        byte hour = values[noNullValue + 1];
                        byte minute = values[noNullValue + 2];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 18: {
                        int length = desc.sqlOctetLength_;
                        if (length == 4) {
                            byte day = values[noNullValue];
                            byte hour = values[noNullValue + 1];
                            byte minute = values[noNullValue + 2];
                            byte second = values[noNullValue + 3];
                            String tmpStr = String.valueOf(InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2));
                            retObj = String.valueOf(tmpStr);
                            break block0;
                        }
                        if (length == 8) {
                            String tmpStr;
                            byte day = values[noNullValue];
                            byte hour = values[noNullValue + 1];
                            byte minute = values[noNullValue + 2];
                            byte second = values[noNullValue + 3];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 4, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                tmpStr = "" + nanoSeconds;
                                length = tmpStr.length();
                                for (int i = 0; i < desc.sqlPrecision_ - length; ++i) {
                                    tmpStr = "0" + tmpStr;
                                }
                            } else {
                                tmpStr = "0";
                            }
                            retObj = String.valueOf(InterfaceResultSet.padZero(day, 2) + " " + InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2) + "." + tmpStr);
                            break block0;
                        }
                        retObj = new String(Bytes.read_chars(values, noNullValue, length));
                        break block0;
                    }
                    case 19: {
                        byte hour = values[noNullValue];
                        retObj = String.valueOf(InterfaceResultSet.padZero(hour, 2));
                        break block0;
                    }
                    case 20: {
                        byte hour = values[noNullValue];
                        byte minute = values[noNullValue + 1];
                        String tmpStr = String.valueOf(InterfaceResultSet.padZero(hour, 2) + ":" + InterfaceResultSet.padZero(minute, 2));
                        retObj = String.valueOf(tmpStr);
                        break block0;
                    }
                    case 22: {
                        byte minute = values[noNullValue];
                        retObj = String.valueOf(InterfaceResultSet.padZero(minute, 2));
                        break block0;
                    }
                    case 23: {
                        int length = desc.sqlOctetLength_;
                        if (length == 2) {
                            byte minute = values[noNullValue];
                            byte second = values[noNullValue + 1];
                            String tmpStr = String.valueOf(InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2));
                            retObj = String.valueOf(tmpStr);
                            break block0;
                        }
                        if (length == 6) {
                            String tmpStr;
                            byte minute = values[noNullValue];
                            byte second = values[noNullValue + 1];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 2, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                tmpStr = "" + nanoSeconds;
                                length = tmpStr.length();
                                for (int i = 0; i < desc.sqlPrecision_ - length; ++i) {
                                    tmpStr = "0" + tmpStr;
                                }
                            } else {
                                tmpStr = "0";
                            }
                            retObj = String.valueOf(InterfaceResultSet.padZero(minute, 2) + ":" + InterfaceResultSet.padZero(second, 2) + "." + tmpStr);
                            break block0;
                        }
                        retObj = new String(Bytes.read_chars(values, noNullValue, length));
                        break block0;
                    }
                    case 24: {
                        int length = desc.sqlOctetLength_;
                        if (length == 1) {
                            byte second = values[noNullValue];
                            retObj = String.valueOf(InterfaceResultSet.padZero(second, 2));
                            break block0;
                        }
                        if (length == 5) {
                            String tmpStr;
                            byte second = values[noNullValue];
                            if (desc.sqlPrecision_ > 0) {
                                long nanoSeconds = Bytes.extractUInt(values, noNullValue + 1, swap);
                                if (nanoSeconds > 999999L) {
                                    nanoSeconds = 0L;
                                }
                                tmpStr = "" + nanoSeconds;
                                length = tmpStr.length();
                                for (int i = 0; i < desc.sqlPrecision_ - length; ++i) {
                                    tmpStr = "0" + tmpStr;
                                }
                            } else {
                                tmpStr = "0";
                            }
                            retObj = String.valueOf(InterfaceResultSet.padZero(second, 2) + "." + tmpStr);
                            break block0;
                        }
                        retObj = new String(Bytes.read_chars(values, noNullValue, length));
                        break block0;
                    }
                }
                int length = desc.sqlOctetLength_;
                retObj = new String(Bytes.read_chars(values, noNullValue, length));
                break;
            }
            case 5: {
                short sValue = Bytes.extractShort(values, noNullValue, swap);
                retObj = new Short(sValue);
                if (desc.scale_ <= 0) break;
                retObj = new BigDecimal(new BigInteger(retObj.toString()), desc.scale_);
                break;
            }
            case -502: {
                int signedSValue = Bytes.extractUShort(values, noNullValue, swap);
                BigDecimal tmpbd = desc.scale_ > 0 ? new BigDecimal(new BigInteger(String.valueOf(signedSValue)), desc.scale_) : new BigDecimal(String.valueOf(signedSValue));
                retObj = tmpbd;
                break;
            }
            case 4: {
                retObj = new Integer(Bytes.extractInt(values, noNullValue, swap));
                if (desc.scale_ <= 0) break;
                retObj = new BigDecimal(new BigInteger(retObj.toString()), desc.scale_);
                break;
            }
            case -401: {
                retObj = new Long(Bytes.extractUInt(values, noNullValue, swap));
                if (desc.scale_ <= 0) break;
                retObj = new BigDecimal(new BigInteger(retObj.toString()), desc.scale_);
                break;
            }
            case -402: {
                retObj = new Long(Bytes.extractLong(values, noNullValue, swap));
                if (desc.scale_ <= 0) break;
                retObj = new BigDecimal(new BigInteger(retObj.toString()), desc.scale_);
                break;
            }
            case -201: 
            case 2: {
                byte[] tbuffer = new byte[desc.sqlOctetLength_];
                System.arraycopy(values, noNullValue, tbuffer, 0, desc.sqlOctetLength_);
                retObj = InterfaceUtilities.convertSQLBigNumToBigDecimal(tbuffer, desc.scale_);
                break;
            }
            case -303: 
            case -302: 
            case -301: 
            case 3: {
                String retStr;
                byte sign = (byte)(values[noNullValue] & 0xFFFFFFB0);
                if (sign == -80) {
                    byte firstByte = (byte)(values[noNullValue] - -80);
                    retStr = "-" + firstByte + String.valueOf(Bytes.read_chars(values, noNullValue + 1, desc.sqlOctetLength_ - 1));
                } else {
                    retStr = String.valueOf(Bytes.read_chars(values, noNullValue, desc.sqlOctetLength_));
                }
                retObj = new BigDecimal(new BigInteger(retStr), desc.scale_);
                break;
            }
            case 7: {
                retObj = new Float(Float.intBitsToFloat(Bytes.extractInt(values, noNullValue, swap)));
                break;
            }
            case 6: 
            case 8: {
                retObj = new Double(Double.longBitsToDouble(Bytes.extractLong(values, noNullValue, swap)));
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(conn.props_, conn.getLocale(), "restricted_data_type", null);
            }
        }
        return retObj;
    }

    void setFetchOutputs(SQLMXResultSet rs, int rowsAffected, boolean endOfData, byte[] outputDataValue) throws SQLException {
        int byteIndex = 0;
        short SQLDataInd = 0;
        int byteLen = 0;
        short maxRowLen = rs.connection_.ic_.getTransportBufferSize();
        Row[] rowArray = new Row[rowsAffected];
        int columnCount = rs.getNoOfColumns();
        for (int rowIndex = 0; rowIndex < rowsAffected; ++rowIndex) {
            String temp;
            Object[] p;
            if (rs.connection_.props_.t4Logger_.isLoggable(Level.FINEST)) {
                p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)rs, (Object)outputDataValue, rowsAffected, endOfData, 0);
                temp = "Reading row = " + rowIndex;
                rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "setFetchOutputs", temp, p);
            }
            Object[] objectArray = new Object[columnCount];
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Object columnValue;
                if (rs.connection_.props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)rs, (Object)outputDataValue, rowsAffected, endOfData, 0);
                    temp = "Reading column = " + columnIndex;
                    rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "setFetchOutputs", temp, p);
                }
                SQLDataInd = new Byte(outputDataValue[byteIndex++]).shortValue();
                if (rs.connection_.props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)rs, (Object)outputDataValue, rowsAffected, endOfData, 0);
                    temp = "Row = " + rowIndex + "," + "Column = " + columnIndex + " SQLDataInd is = " + SQLDataInd;
                    rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "setFetchOutputs", temp, p);
                }
                if (SQLDataInd == 0) {
                    short varDataLen = outputDataValue.length > byteIndex + 2 ? Bytes.extractShort(outputDataValue, byteIndex, this.ic_.getByteSwap()) : (short)0;
                    byteLen = InterfaceResultSet.dataLengthFetchPerf(rs.outputDesc_[columnIndex].sqlDataType_, rs.outputDesc_[columnIndex].sqlDatetimeCode_, rs.outputDesc_[columnIndex].sqlOctetLength_, maxRowLen, varDataLen, rs.outputDesc_[columnIndex].dataType_, rs.outputDesc_[columnIndex].precision_);
                    columnValue = this.getFetchString(rs.connection_, rs.outputDesc_[columnIndex].scale_, rs.outputDesc_[columnIndex].sqlDataType_, rs.outputDesc_[columnIndex].sqlDatetimeCode_, rs.outputDesc_[columnIndex].fsDataType_, outputDataValue, byteIndex, byteLen, rs.outputDesc_[columnIndex].sqlCharset_, rs.outputDesc_[columnIndex].dataType_);
                    byteIndex += byteLen;
                    switch (rs.outputDesc_[columnIndex].sqlDataType_) {
                        case -601: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 15: 
                        case 16: 
                        case 17: {
                            ++byteIndex;
                        }
                    }
                    if (columnValue == null) {
                        throw SQLMXMessages.createSQLException(rs.connection_.props_, this.ic_.getLocale(), "null_data", null);
                    }
                } else {
                    columnValue = null;
                }
                objectArray[columnIndex] = columnValue;
            }
            rowArray[rowIndex] = new Row(columnCount, objectArray);
        }
        rs.setFetchOutputs(rowArray, rowsAffected, endOfData);
    }

    void setExecute2FetchOutputs(SQLMXResultSet rs, int rowsAffected, boolean endOfData, byte[] values) throws SQLException {
        if (rs.useOldDateFormat()) {
            this.setFetchOutputs(rs, rowsAffected, endOfData, values);
            return;
        }
        Row[] rowArray = new Row[rowsAffected];
        int columnCount = rs.getNoOfColumns();
        boolean byteIndex = false;
        boolean SQLDataInd = false;
        boolean byteLen = false;
        short maxRowLen = rs.connection_.ic_.getTransportBufferSize();
        Object[] objectArray = new Object[columnCount];
        int dataLength = 0;
        if (rs.outputDesc_ != null && rs.outputDesc_.length > 0) {
            dataLength = rs.outputDesc_[0].rowLength_;
        }
        int rowOffset = 0;
        for (int rowIndex = 0; rowIndex < rowsAffected; ++rowIndex) {
            rowOffset = rowIndex * dataLength;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Object columnValue;
                int noNullValueOffset = rs.outputDesc_[columnIndex].noNullValue_;
                int nullValueOffset = rs.outputDesc_[columnIndex].nullValue_;
                if (nullValueOffset != -1) {
                    nullValueOffset += rowOffset;
                }
                if (noNullValueOffset != -1) {
                    noNullValueOffset += rowOffset;
                }
                if (rs.connection_.props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)rs, endOfData);
                    String temp = "Processing column = " + columnIndex + ":   noNullValueOffset = " + noNullValueOffset + ":   nullValueOffset = " + nullValueOffset;
                    rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "setExecute2FetchOutputs", temp, p);
                }
                if (nullValueOffset != -1 && Bytes.extractShort(values, nullValueOffset, this.ic_.getByteSwap()) == -1) {
                    columnValue = null;
                } else {
                    columnValue = InterfaceStatement.outValuesFormat == 2 ? InterfaceResultSet.getExecute2FetchString(rs.connection_, rs.outputDesc_[columnIndex], values, noNullValueOffset, rs.outputDesc_[columnIndex].dataType_, true, this.ic_.getByteSwap()) : InterfaceResultSet.getExecute2FetchString(rs.connection_, rs.outputDesc_[columnIndex], values, noNullValueOffset, rs.outputDesc_[columnIndex].dataType_, rs.useOldDateFormat(), this.ic_.getByteSwap());
                    if (columnValue == null) {
                        throw SQLMXMessages.createSQLException(rs.connection_.props_, this.ic_.getLocale(), "null_data", null);
                    }
                }
                objectArray[columnIndex] = columnValue;
            }
            rowArray[rowIndex] = new Row(columnCount, objectArray);
        }
        rs.setFetchOutputs(rowArray, rowsAffected, endOfData);
    }

    boolean fetch(String stmtLabel, int maxRowCnt, int queryTimeout, int holdability, SQLMXResultSet rs) throws SQLException {
        String temp;
        Object[] p;
        FetchReply fr;
        int sqlAsyncEnable = 0;
        int stmtHandle = 0;
        int stmtCharset = 1;
        String cursorName = "";
        int cursorCharset = 1;
        String stmtOptions = "";
        boolean endOfData = false;
        boolean dataFound = false;
        String sqlStmt = "";
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p2 = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)stmtLabel, maxRowCnt, queryTimeout, holdability);
            String temp2 = "Entering Fetch";
            rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "fetch", temp2, p2);
        }
        if (this.rs_.stmt_ != null && this.rs_.stmt_.sql_ != null) {
            sqlStmt = this.rs_.stmt_.sql_.startsWith("service:WMS:") ? this.rs_.stmt_.sql_.substring("service:WMS:".length()).toUpperCase() : this.rs_.stmt_.sql_.toUpperCase();
        }
        try {
            fr = this.t4resultSet_.Fetch(sqlAsyncEnable, queryTimeout, stmtHandle, stmtCharset, maxRowCnt, cursorName, cursorCharset, stmtOptions);
        }
        catch (SQLException tex) {
            if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p3 = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)stmtLabel, maxRowCnt, queryTimeout, holdability);
                String temp3 = "SQLException while fetching.";
                rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "fetch", temp3, p3);
            }
            throw tex;
        }
        switch (fr.returnCode) {
            case 0: {
                if (fr.errorList.length != 0) {
                    SQLMXMessages.setSQLWarning(rs.connection_.props_, (SQLMXHandle)rs, fr.errorList);
                }
                boolean bl = endOfData = fr.rowsAffected < maxRowCnt;
                if (fr.rowsAffected <= 0) break;
                if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)stmtLabel, maxRowCnt, queryTimeout, holdability);
                    temp = "Data Found. Setting fetch outputs";
                    rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "fetch", temp, p);
                }
                if (rs.keepRawBuffer_) {
                    rs.rawBuffer_ = fr.outValues;
                }
                if (fr.outValuesFormat == 2) {
                    this.setFetchOutputs(rs, fr.rowsAffected, endOfData, fr.outValues);
                } else {
                    this.setExecute2FetchOutputs(rs, fr.rowsAffected, endOfData, fr.outValues);
                }
                dataFound = true;
                break;
            }
            case 5: 
            case 100: {
                dataFound = false;
                endOfData = true;
                break;
            }
            default: {
                SQLMXMessages.throwSQLException(rs.connection_.props_, fr.errorList);
            }
        }
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            p = T4LoggingUtilities.makeParams(rs.connection_.props_, (Object)stmtLabel, maxRowCnt, queryTimeout, holdability);
            temp = "Exiting Fetch.";
            rs.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "fetch", temp, p);
        }
        return dataFound;
    }

    void close() throws SQLException {
        this.ic_.isConnectionOpen();
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.rs_.connection_.props_);
            String temp = "Closing resultset.";
            this.rs_.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "close", temp, p);
        }
        boolean rval = false;
        CloseReply cry_ = null;
        if (this.rs_ != null && this.rs_.stmt_ != null && this.rs_.stmt_.ist_ != null && this.rs_.stmt_.ist_.sqlQueryType_ != 1) {
            cry_ = this.t4resultSet_.Close();
            switch (cry_.m_p1.exception_nr) {
                case 0: {
                    break;
                }
                case 3: {
                    String temp;
                    Object[] p;
                    if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                        p = T4LoggingUtilities.makeParams(this.rs_.connection_.props_);
                        temp = "odbc_SQLSvc_Close_SQLError_exn_";
                        this.rs_.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "close", temp, p);
                    }
                    SQLMXMessages.throwSQLException(this.rs_.connection_.props_, cry_.m_p1.SQLError);
                }
                default: {
                    String temp;
                    Object[] p;
                    if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                        p = T4LoggingUtilities.makeParams(this.rs_.connection_.props_);
                        temp = "UnknownException occured during close.";
                        this.rs_.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "close", temp, p);
                    }
                    throw SQLMXMessages.createSQLException(this.rs_.connection_.props_, this.ic_.getLocale(), "ids_unknown_reply_error", null);
                }
            }
        }
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.rs_.connection_.props_);
            String temp = "Closed resultset.";
            this.rs_.connection_.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "close", temp, p);
        }
    }

    static Object[] getExecute2Outputs(SQLMXConnection conn, SQLMXDesc[] desc, byte[] values, boolean swap) throws SQLException {
        int columnCount = desc == null ? 0 : desc.length;
        Object[] objectArray = new Object[columnCount];
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            Object columnValue;
            int noNullValueOffset = desc[columnIndex].noNullValue_;
            int nullValueOffset = desc[columnIndex].nullValue_;
            if (conn.props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(conn.props_, (Object)conn, (Object)desc, (Object)values);
                String temp = "Processing column = " + columnIndex + ":   noNullValueOffset = " + noNullValueOffset + ":   nullValueOffset = " + nullValueOffset;
                conn.props_.t4Logger_.logp(Level.FINEST, "InterfaceResultSet", "getExecute2Outputs", temp, p);
            }
            if (nullValueOffset != -1 && Bytes.extractShort(values, nullValueOffset, swap) == -1 || desc[columnIndex].paramMode_ == 1) {
                columnValue = null;
            } else {
                columnValue = InterfaceStatement.outValuesFormat == 2 ? InterfaceResultSet.getExecute2FetchString(conn, desc[columnIndex], values, noNullValueOffset, desc[columnIndex].dataType_, true, swap) : InterfaceResultSet.getExecute2FetchString(conn, desc[columnIndex], values, noNullValueOffset, desc[columnIndex].dataType_, false, swap);
                if (columnValue == null) {
                    throw SQLMXMessages.createSQLException(conn.props_, conn.getLocale(), "null_data", null);
                }
            }
            objectArray[columnIndex] = columnValue;
        }
        return objectArray;
    }
}

