/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.CloseReply;
import com.tandem.t4jdbc.Descriptor2;
import com.tandem.t4jdbc.ExecuteReply;
import com.tandem.t4jdbc.GenericReply;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.InterfaceResultSet;
import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.PrepareReply;
import com.tandem.t4jdbc.SQLItemDescList_def;
import com.tandem.t4jdbc.SQLItemDesc_def;
import com.tandem.t4jdbc.SQLMXCallableStatement;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDesc;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import com.tandem.t4jdbc.SQLMXStatement;
import com.tandem.t4jdbc.SQLValueList_def;
import com.tandem.t4jdbc.SQLWarningOrError;
import com.tandem.t4jdbc.SQL_DataValue_def;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.T4Statement;
import com.tandem.t4jdbc.Utility;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;

class InterfaceStatement {
    InterfaceConnection ic_;
    private long rowCount_;
    static final String CFG_CMD_TAG = "cfgcmd:";
    static final String SERVICEQS_CMD_TAG = "service:WMS:";
    static final short SQL_DROP = 1;
    static short EXTERNAL_STMT = 0;
    int sqlStmtType_ = 0;
    int stmtType_ = 0;
    T4Statement t4statement_;
    int queryTimeout_;
    private String stmtLabel_;
    String cursorName_;
    SQLMXStatement stmt_;
    int sqlQueryType_;
    int stmtHandle_;
    int estimatedCost_;
    boolean prepare2 = false;
    boolean stmtIsLock = false;
    static boolean rowWiseData = false;
    static Class LmUtility_class_ = null;
    static Method LmUtility_getTransactionId_ = null;
    static int outValuesFormat;
    PrepareReply pr_;

    InterfaceStatement(SQLMXStatement stmt) throws SQLException {
        this.ic_ = ((SQLMXConnection)stmt.getConnection()).getServerHandle();
        this.queryTimeout_ = stmt.queryTimeout_;
        this.stmtLabel_ = stmt.stmtLabel_;
        this.cursorName_ = stmt.cursorName_;
        this.t4statement_ = new T4Statement(this, stmt.connection_.props_.getCloseConnectionUponQueryTimeout());
        this.stmt_ = stmt;
    }

    public int getSqlQueryType() {
        return this.sqlQueryType_;
    }

    private String convertDateFormat(String dt) {
        String[] tokens = dt.split("[/]", 3);
        if (tokens.length != 3) {
            return dt;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(tokens[0]).append("-").append(tokens[1]).append("-").append(tokens[2]);
        return sb.toString();
    }

    void convertObjectToSQL2(Locale locale, SQLMXStatement pstmt, Object paramValue, int paramRowCount, int paramNumber, byte[] values, int rowNumber) throws SQLException {
        byte[] tmpBarray = null;
        int precision = pstmt.inputDesc_[paramNumber].precision_;
        short scale = pstmt.inputDesc_[paramNumber].scale_;
        short sqlDatetimeCode = pstmt.inputDesc_[paramNumber].sqlDatetimeCode_;
        int FSDataType = pstmt.inputDesc_[paramNumber].fsDataType_;
        int OdbcDataType = pstmt.inputDesc_[paramNumber].dataType_;
        int maxLength = pstmt.inputDesc_[paramNumber].sqlOctetLength_;
        int dataType = pstmt.inputDesc_[paramNumber].sqlDataType_;
        int dataCharSet = pstmt.inputDesc_[paramNumber].sqlCharset_;
        int noNullValue = pstmt.inputDesc_[paramNumber].noNullValue_;
        int nullValue = pstmt.inputDesc_[paramNumber].nullValue_;
        int dataLength = pstmt.inputDesc_[paramNumber].maxLen_;
        if (dataType == -601 && (dataLength += 2) % 2 != 0) {
            ++dataLength;
        }
        noNullValue = noNullValue * paramRowCount + rowNumber * dataLength;
        if (nullValue != -1) {
            nullValue = nullValue * paramRowCount + rowNumber * 2;
        }
        if (paramValue == null) {
            if (nullValue == -1) {
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "null_parameter_for_not_null_column", new Integer(paramNumber));
            }
            Bytes.insertShort(values, nullValue, (short)-1, this.ic_.getByteSwap());
            return;
        }
        block12 : switch (dataType) {
            case 1: {
                if (paramValue == null) {
                    Bytes.insertShort(values, noNullValue, (short)0, this.ic_.getByteSwap());
                } else if (paramValue instanceof byte[]) {
                    tmpBarray = (byte[])paramValue;
                } else if (paramValue instanceof String) {
                    String charSet = "";
                    try {
                        charSet = this.ic_.getISOMapping() == 1 && !this.ic_.getEnforceISO() && dataCharSet == 1 ? this.ic_.t4props_.getISO88591() : InterfaceUtilities.getEncodingTranslation(pstmt.connection_, dataCharSet);
                        tmpBarray = ((String)paramValue).getBytes(charSet);
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", charSet);
                    }
                } else {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "CHAR data should be either bytes or String for column: " + paramNumber);
                }
                int dataLen = tmpBarray.length;
                if (maxLength >= dataLen) {
                    System.arraycopy(tmpBarray, 0, values, noNullValue, dataLen);
                    if (maxLength <= dataLen) break;
                    if (dataCharSet == 11) {
                        for (int i2 = dataLen; i2 < maxLength; i2 += 2) {
                            values[noNullValue + i2] = 0;
                            values[noNullValue + (i2 + 1)] = 32;
                        }
                        break;
                    }
                    Arrays.fill(values, noNullValue + dataLen, noNullValue + maxLength, (byte)32);
                    break;
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_string_parameter", "CHAR input data is longer than the length for column: " + paramNumber);
            }
            case 12: {
                if (paramValue instanceof byte[]) {
                    tmpBarray = (byte[])paramValue;
                } else if (paramValue instanceof String) {
                    String charSet = "";
                    try {
                        charSet = this.ic_.getISOMapping() == 1 && !this.ic_.getEnforceISO() && dataCharSet == 1 ? this.ic_.t4props_.getISO88591() : InterfaceUtilities.getEncodingTranslation(pstmt.connection_, dataCharSet);
                        tmpBarray = ((String)paramValue).getBytes(charSet);
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", charSet);
                    }
                } else {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "VARCHAR data should be either bytes or String for column: " + paramNumber);
                }
                int dataLen = tmpBarray.length;
                if (maxLength > dataLen) {
                    Bytes.insertShort(values, noNullValue, (short)dataLen, this.ic_.getByteSwap());
                    System.arraycopy(tmpBarray, 0, values, noNullValue + 2, dataLen);
                    break;
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "VARCHAR input data is longer than the length for column: " + paramNumber);
            }
            case 9: {
                switch (sqlDatetimeCode) {
                    case 1: {
                        Date tmpdate;
                        try {
                            tmpdate = Date.valueOf((String)paramValue);
                        }
                        catch (IllegalArgumentException iex) {
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "Date data format is incorrect for column: " + paramNumber + " = " + paramValue);
                        }
                        try {
                            byte[] temp1 = tmpdate.toString().getBytes("ASCII");
                            System.arraycopy(temp1, 0, values, noNullValue, temp1.length);
                            break block12;
                        }
                        catch (UnsupportedEncodingException e) {
                            Object[] messageArguments = new Object[]{e.getMessage()};
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", messageArguments);
                        }
                    }
                    case 3: {
                        Timestamp tmpts;
                        try {
                            tmpts = Timestamp.valueOf((String)paramValue);
                        }
                        catch (IllegalArgumentException iex) {
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "Timestamp data format is incorrect for column: " + paramNumber + " = " + paramValue);
                        }
                        maxLength -= 3;
                        try {
                            tmpBarray = tmpts.toString().getBytes("ASCII");
                        }
                        catch (UnsupportedEncodingException e) {
                            Object[] messageArguments = new Object[]{e.getMessage()};
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", messageArguments);
                        }
                        int dataLen = tmpBarray.length;
                        if (maxLength > dataLen) {
                            System.arraycopy(tmpBarray, 0, values, noNullValue, dataLen);
                            Arrays.fill(values, noNullValue + dataLen, noNullValue + maxLength, (byte)32);
                            break block12;
                        }
                        System.arraycopy(tmpBarray, 0, values, noNullValue, maxLength);
                        break block12;
                    }
                    case 2: {
                        if (OdbcDataType == 1111) break;
                        try {
                            Time tmptime = paramValue instanceof byte[] ? Time.valueOf(new String((byte[])paramValue, "ASCII")) : Time.valueOf(paramValue.toString());
                            byte[] tempb1 = tmptime.toString().getBytes("ASCII");
                            System.arraycopy(tempb1, 0, values, noNullValue, tempb1.length);
                            break block12;
                        }
                        catch (IllegalArgumentException iex) {
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "Time data format is incorrect for column: " + paramNumber + " = " + paramValue);
                        }
                        catch (UnsupportedEncodingException e) {
                            Object[] messageArguments = new Object[]{e.getMessage()};
                            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", messageArguments);
                        }
                    }
                }
                if (paramValue instanceof String) {
                    try {
                        tmpBarray = ((String)paramValue).getBytes("ASCII");
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", "ASCII");
                    }
                } else if (paramValue instanceof byte[]) {
                    tmpBarray = (byte[])paramValue;
                } else {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_cast_specification", "DATETIME data should be either bytes or String for column: " + paramNumber);
                }
                int dataLen = tmpBarray.length;
                if (maxLength == dataLen) {
                    System.arraycopy(tmpBarray, 0, values, noNullValue, maxLength);
                    break;
                }
                if (maxLength > dataLen) {
                    System.arraycopy(tmpBarray, 0, values, noNullValue, dataLen);
                    Arrays.fill(values, noNullValue + dataLen, noNullValue + maxLength, (byte)32);
                    break;
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "DATETIME data longer than column length: " + paramNumber);
            }
            case 10: {
                if (paramValue instanceof byte[]) {
                    tmpBarray = (byte[])paramValue;
                } else if (paramValue instanceof String) {
                    try {
                        tmpBarray = ((String)paramValue).getBytes("ASCII");
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", "ASCII");
                    }
                } else {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_cast_specification", "INTERVAL data should be either bytes or String for column: " + paramNumber);
                }
                int dataLen = tmpBarray.length;
                if (maxLength >= dataLen) {
                    dataLen = tmpBarray.length;
                    if (maxLength == dataLen) {
                        System.arraycopy(tmpBarray, 0, values, noNullValue, maxLength);
                        break;
                    }
                    if (maxLength <= dataLen) break;
                    System.arraycopy(tmpBarray, 0, values, noNullValue, dataLen);
                    Arrays.fill(values, noNullValue + dataLen, noNullValue + maxLength, (byte)32);
                    break;
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "INTERVAL data longer than column length: " + paramNumber);
            }
            case -601: 
            case -1: {
                if (paramValue instanceof byte[]) {
                    tmpBarray = (byte[])paramValue;
                } else if (paramValue instanceof String) {
                    String charSet = "";
                    try {
                        charSet = this.ic_.getISOMapping() == 1 && !this.ic_.getEnforceISO() && dataCharSet == 1 ? this.ic_.t4props_.getISO88591() : InterfaceUtilities.getEncodingTranslation(pstmt.connection_, dataCharSet);
                        tmpBarray = ((String)paramValue).getBytes(charSet);
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", charSet);
                    }
                } else {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_cast_specification", "VARCHAR data should be either bytes or String for column: " + paramNumber);
                }
                int dataLen = tmpBarray.length;
                if (maxLength > dataLen + 2) {
                    maxLength = dataLen + 2;
                    System.arraycopy(Bytes.createShortBytes((short)dataLen, this.ic_.getByteSwap()), 0, values, noNullValue, 2);
                    System.arraycopy(tmpBarray, 0, values, noNullValue + 2, dataLen);
                    break;
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_string_parameter", "VARCHAR data longer than column length: " + paramNumber);
            }
            case 4: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                if (scale > 0) {
                    tmpbd = tmpbd.movePointRight(scale);
                }
                if (pstmt.roundingMode_ == 7) {
                    Utility.checkLongTruncation(paramNumber, tmpbd);
                }
                Utility.checkIntegerBoundary(locale, tmpbd);
                Utility.checkDecimalBoundary(locale, tmpbd, precision);
                Bytes.insertInt(values, noNullValue, tmpbd.intValue(), this.ic_.getByteSwap());
                break;
            }
            case -401: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                if (scale > 0) {
                    tmpbd = tmpbd.movePointRight(scale);
                }
                if (pstmt.roundingMode_ == 7) {
                    Utility.checkLongTruncation(paramNumber, tmpbd);
                }
                Utility.checkUnsignedIntegerBoundary(locale, tmpbd);
                Utility.checkDecimalBoundary(locale, tmpbd, precision);
                Bytes.insertInt(values, noNullValue, tmpbd.intValue(), this.ic_.getByteSwap());
                break;
            }
            case 5: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                if (scale > 0) {
                    tmpbd = tmpbd.movePointRight(scale);
                }
                if (pstmt.roundingMode_ == 7) {
                    Utility.checkLongTruncation(paramNumber, tmpbd);
                }
                Utility.checkShortBoundary(locale, tmpbd);
                Utility.checkDecimalBoundary(locale, tmpbd, precision);
                Bytes.insertShort(values, noNullValue, tmpbd.shortValue(), this.ic_.getByteSwap());
                break;
            }
            case -502: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                if (scale > 0) {
                    tmpbd = tmpbd.movePointRight(scale);
                }
                if (pstmt.roundingMode_ == 7) {
                    Utility.checkLongTruncation(paramNumber, tmpbd);
                }
                Utility.checkSignedShortBoundary(locale, tmpbd);
                Utility.checkDecimalBoundary(locale, tmpbd, precision);
                Bytes.insertShort(values, noNullValue, tmpbd.shortValue(), this.ic_.getByteSwap());
                break;
            }
            case -402: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                if (scale > 0) {
                    tmpbd = tmpbd.movePointRight(scale);
                }
                Utility.checkDecimalBoundary(locale, tmpbd, precision);
                Bytes.insertLong(values, noNullValue, tmpbd.longValue(), this.ic_.getByteSwap());
                break;
            }
            case -301: 
            case 3: {
                int numOfZeros;
                BigDecimal tmpbd;
                try {
                    tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                    if (scale > 0) {
                        tmpbd = tmpbd.movePointRight(scale);
                    }
                    tmpbd = Utility.setScale(tmpbd, scale, pstmt.roundingMode_);
                    if (pstmt.roundingMode_ == 7) {
                        Utility.checkLongTruncation(paramNumber, tmpbd);
                    }
                    try {
                        tmpBarray = String.valueOf(tmpbd.longValue()).getBytes("ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        Object[] messageArguments = new Object[]{e.getMessage()};
                        throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "unsupported_encoding", messageArguments);
                    }
                }
                catch (NumberFormatException nex) {
                    throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "invalid_parameter_value", "DECIMAL data format incorrect for column: " + paramNumber + ". Error is: " + nex.getMessage());
                }
                int dataLen = tmpBarray.length;
                int desPos = 0;
                int srcPos = 0;
                boolean minus = false;
                if (tmpbd.signum() == -1) {
                    minus = true;
                    ++srcPos;
                    --dataLen;
                }
                if ((numOfZeros = maxLength - dataLen) < 0) {
                    throw new DataTruncation(paramNumber, true, false, maxLength, dataLen);
                }
                for (int i = 0; i < numOfZeros; ++i) {
                    values[noNullValue + desPos] = 48;
                    ++desPos;
                }
                System.arraycopy(tmpBarray, srcPos, values, noNullValue + desPos, dataLen);
                if (!minus) break;
                values[noNullValue] = (byte)(0xFFFFFFB0 | values[noNullValue]);
                break;
            }
            case 7: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                Utility.checkFloatBoundary(locale, tmpbd);
                float fvalue = tmpbd.floatValue();
                int bits = Float.floatToIntBits(fvalue);
                Bytes.insertInt(values, noNullValue, bits, this.ic_.getByteSwap());
                break;
            }
            case 6: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                Utility.checkFloatBoundary(locale, tmpbd);
                Bytes.insertLong(values, noNullValue, Double.doubleToLongBits(tmpbd.doubleValue()), this.ic_.getByteSwap());
                break;
            }
            case 8: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                Utility.checkDoubleBoundary(locale, tmpbd);
                Bytes.insertLong(values, noNullValue, Double.doubleToLongBits(tmpbd.doubleValue()), this.ic_.getByteSwap());
                break;
            }
            case -201: 
            case 2: {
                BigDecimal tmpbd = Utility.getBigDecimalValue(locale, paramValue);
                byte[] b = InterfaceUtilities.convertBigDecimalToSQLBigNum(tmpbd, maxLength, scale);
                System.arraycopy(b, 0, values, noNullValue, maxLength);
                break;
            }
            default: {
                if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_, (Object)locale, (Object)pstmt, paramValue, paramNumber);
                    String temp = "Restricted_Datatype_Error";
                    this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "convertObjectToSQL2", temp, p);
                }
                throw SQLMXMessages.createSQLException(pstmt.connection_.props_, locale, "restricted_data_type", null);
            }
        }
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_, (Object)locale, (Object)pstmt, paramValue, paramNumber);
            String temp = "datatype = " + dataType;
            this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "convertObjectToSQL2", temp, p);
        }
    }

    private SQLWarningOrError[] mergeErrors(SQLWarningOrError[] client, SQLWarningOrError[] server) {
        SQLWarningOrError[] target = new SQLWarningOrError[client.length + server.length];
        int si = 0;
        int ci = 0;
        int ti = 0;
        int so = 0;
        while (ci < client.length && si < server.length) {
            int cr = client[ci].rowId;
            int sr = server[si].rowId + so;
            if (cr <= sr || server[si].rowId == 0) {
                ++so;
                target[ti++] = client[ci++];
                continue;
            }
            server[si].rowId += so;
            target[ti++] = server[si++];
        }
        while (ci < client.length) {
            target[ti++] = client[ci++];
        }
        while (si < server.length) {
            if (server[si].rowId != 0) {
                server[si].rowId += so;
            }
            target[ti++] = server[si++];
        }
        return target;
    }

    SQL_DataValue_def fillInSQLValues2(Locale locale, SQLMXStatement stmt, int paramRowCount, int paramCount, Object[] paramValues, ArrayList clientErrors) throws SQLException {
        SQL_DataValue_def dataValue = new SQL_DataValue_def();
        if (paramRowCount == 0 && paramValues != null && paramValues.length > 0) {
            paramRowCount = 1;
        }
        if (stmt.inputParamsLength_ < 0) {
            dataValue.buffer = new byte[0];
            dataValue.length = 0;
        } else {
            int bufLen = stmt.inputParamsLength_ * paramRowCount;
            dataValue.buffer = new byte[bufLen];
            block2: for (int row = 0; row < paramRowCount; ++row) {
                for (int col = 0; col < paramCount; ++col) {
                    try {
                        this.convertObjectToSQL2(locale, stmt, paramValues[row * paramCount + col], paramRowCount, col, dataValue.buffer, row - clientErrors.size());
                        continue;
                    }
                    catch (SQLMXException e) {
                        if (paramRowCount == 1) {
                            throw e;
                        }
                        clientErrors.add(new SQLWarningOrError(row + 1, e.getErrorCode(), e.getMessage(), e.getSQLState()));
                        continue block2;
                    }
                }
            }
            if (rowWiseData) {
                int[] paramPoint = new int[paramCount * paramRowCount];
                int count = 0;
                for (int i = 0; i < paramCount; ++i) {
                    for (int j = 0; j < paramRowCount; ++j) {
                        int noNullValue_ = stmt.inputDesc_[i].noNullValue_;
                        int nullValue_ = stmt.inputDesc_[i].nullValue_;
                        int dataLength_ = stmt.inputDesc_[i].maxLen_;
                        int dataType_ = stmt.inputDesc_[i].sqlDataType_;
                        if (dataType_ == -601 && (dataLength_ += 2) % 2 != 0) {
                            ++dataLength_;
                        }
                        noNullValue_ = noNullValue_ * paramRowCount + j * dataLength_;
                        paramPoint[count++] = noNullValue_;
                    }
                }
                byte[] newByteArray = new byte[bufLen];
                int destPos = 0;
                int noOfBytesToCopy = 0;
                int ptr = 0;
                int noOfBytesToZero = 0;
                for (int j = 0; j < paramRowCount; ++j) {
                    ptr = j;
                    for (int i = 0; i < paramCount; ++i) {
                        noOfBytesToCopy = stmt.inputDesc_[i].maxLen_;
                        if ((stmt.inputDesc_[i].sqlDataType_ == -601 || stmt.inputDesc_[i].sqlDataType_ == -1 || stmt.inputDesc_[i].sqlDataType_ == 12) && (noOfBytesToCopy += 2) % 2 != 0) {
                            ++noOfBytesToCopy;
                        }
                        noOfBytesToZero = i == paramCount - 1 ? stmt.inputParamsLength_ - stmt.inputDesc_[i].noNullValue_ - noOfBytesToCopy : stmt.inputDesc_[i + 1].noNullValue_ - stmt.inputDesc_[i].noNullValue_ - noOfBytesToCopy;
                        System.arraycopy(dataValue.buffer, paramPoint[ptr], newByteArray, destPos, noOfBytesToCopy);
                        destPos += noOfBytesToCopy;
                        if (noOfBytesToZero != 0) {
                            Arrays.fill(newByteArray, destPos, destPos + noOfBytesToZero, (byte)0);
                            destPos += noOfBytesToZero;
                        }
                        ptr += paramRowCount;
                    }
                }
                System.arraycopy(newByteArray, 0, dataValue.buffer, 0, bufLen);
            }
            if (clientErrors.size() > 0) {
                for (int i = 1; i < paramCount; ++i) {
                    int newOffset;
                    int oldOffset;
                    int noNullValue = stmt.inputDesc_[i].noNullValue_;
                    int nullValue = stmt.inputDesc_[i].nullValue_;
                    int colLength = stmt.inputDesc_[i].maxLen_;
                    int dataType = stmt.inputDesc_[i].dataType_;
                    if ((dataType == -601 || dataType == -1 || dataType == 12) && (colLength += 2) % 2 != 0) {
                        ++colLength;
                    }
                    if (nullValue != -1) {
                        oldOffset = nullValue * paramRowCount;
                        newOffset = oldOffset - nullValue * clientErrors.size();
                        System.arraycopy(dataValue.buffer, oldOffset, dataValue.buffer, newOffset, 2 * (paramRowCount - clientErrors.size()));
                    }
                    oldOffset = noNullValue * paramRowCount;
                    newOffset = oldOffset - noNullValue * clientErrors.size();
                    System.arraycopy(dataValue.buffer, oldOffset, dataValue.buffer, newOffset, colLength * (paramRowCount - clientErrors.size()));
                }
            }
            dataValue.length = stmt.inputParamsLength_ * (paramRowCount - clientErrors.size());
        }
        return dataValue;
    }

    boolean hasParameters(String sql) {
        boolean foundParam = false;
        String[] s = sql.split("\"[^\"]*\"|'[^']*'");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].indexOf(63) == -1) continue;
            foundParam = true;
            break;
        }
        return foundParam;
    }

    short getSqlStmtType(String str) {
        this.stmtIsLock = false;
        String[] tokens = str.split("[^a-zA-Z]+", 3);
        int rt1 = 0;
        String str3 = "";
        str3 = tokens[0].length() > 0 ? tokens[0].toUpperCase() : tokens[1].toUpperCase();
        rt1 = str3.equals("SELECT") || str3.equals("SHOWSHAPE") || str3.equals("INVOKE") || str3.equals("SHOWCONTROL") || str3.equals("SHOWDDL") || str3.equals("EXPLAIN") || str3.equals("SHOWPLAN") || str3.equals("REORGANIZE") || str3.equals("MAINTAIN") || str3.equals("SHOWLABEL") || str3.equals("VALUES") || str3.equals("REORG") || str3.equals("SEL") || str3.equals("GET") || str3.equals("SHOWSTATS") || str3.equals("GIVE") ? 1 : (str3.equals("UPDATE") || str3.equals("MERGE") ? 2 : (str3.equals("DELETE") ? 4 : (str3.equals("INSERT") || str3.equals("INS") ? (this.hasParameters(str) ? 256 : 8) : (str3.equals("CREATE") ? 32 : (str3.equals("GRANT") ? 64 : (str3.equals("DROP") ? 128 : (str3.equals("CALL") ? 2048 : (str3.equals("EXPLAIN") ? 16 : (str3.equals("INFOSTATS") ? 4096 : (str.startsWith(CFG_CMD_TAG) ? 8192 : (str.startsWith(SERVICEQS_CMD_TAG) ? 16384 : (str3.equals("WMSOPEN") ? 16385 : (str3.equals("STATUS") || str3.equals("INFO") ? 16384 : (str3.equals("WMSCLOSE") ? 16386 : (str3.equals("CONTROL") ? 9 : 0)))))))))))))));
        return (short)rt1;
    }

    long getRowCount() {
        return this.rowCount_;
    }

    void setRowCount(long rowCount) {
        this.rowCount_ = rowCount < 0L ? -1L : rowCount;
    }

    static SQLMXDesc[] NewDescArray(SQLItemDescList_def desc) {
        if (desc.list == null || desc.list.length == 0) {
            return null;
        }
        SQLMXDesc[] SQLMXDescArray = new SQLMXDesc[desc.list.length];
        for (int index = 0; index < desc.list.length; ++index) {
            SQLItemDesc_def SQLDesc = desc.list[index];
            boolean nullInfo = new Byte(SQLDesc.nullInfo).shortValue() == 1;
            boolean signType = new Byte(SQLDesc.signType).shortValue() == 1;
            SQLMXDescArray[index] = new SQLMXDesc(SQLDesc.dataType, (short)SQLDesc.datetimeCode, SQLDesc.maxLen, SQLDesc.precision, SQLDesc.scale, nullInfo, SQLDesc.colHeadingNm, signType, SQLDesc.ODBCDataType, SQLDesc.ODBCPrecision, SQLDesc.SQLCharset, SQLDesc.ODBCCharset, SQLDesc.CatalogName, SQLDesc.SchemaName, SQLDesc.TableName, SQLDesc.dataType, SQLDesc.intLeadPrec, SQLDesc.paramMode);
            if (desc.list[index].Heading == null) continue;
            SQLMXDescArray[index].columnLabel_ = desc.list[index].Heading;
        }
        return SQLMXDescArray;
    }

    static SQLMXDesc[] NewDescArray(Descriptor2[] descArray) {
        if (descArray == null || descArray.length == 0) {
            return null;
        }
        SQLMXDesc[] SQLMXDescArray = new SQLMXDesc[descArray.length];
        for (int index = 0; index < descArray.length; ++index) {
            Descriptor2 desc = descArray[index];
            boolean nullInfo = false;
            boolean signType = false;
            if (desc.nullInfo_ != 0) {
                nullInfo = true;
            }
            if (desc.signed_ != 0) {
                signType = true;
            }
            SQLMXDescArray[index] = new SQLMXDesc(desc.noNullValue_, desc.nullValue_, desc.version_, desc.dataType_, (short)desc.datetimeCode_, desc.maxLen_, (short)desc.precision_, (short)desc.scale_, nullInfo, signType, desc.odbcDataType_, desc.odbcPrecision_, desc.sqlCharset_, desc.odbcCharset_, desc.colHeadingNm_, desc.tableName_, desc.catalogName_, desc.schemaName_, desc.headingName_, desc.intLeadPrec_, desc.paramMode_, desc.dataType_, desc.getRowLength());
        }
        return SQLMXDescArray;
    }

    void executeDirect(int queryTimeout, SQLMXStatement stmt) throws SQLException {
        short executeAPI = stmt.getOperationID();
        byte[] messageBuffer = stmt.getOperationBuffer();
        GenericReply gr = null;
        gr = this.t4statement_.ExecuteGeneric(executeAPI, messageBuffer);
        stmt.operationReply_ = gr.replyBuffer;
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_, queryTimeout, (Object)stmt);
            String temp = "Exiting ExecDirect.";
            this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "executeDirect", temp, p);
        }
    }

    int close() throws SQLException {
        boolean rval = false;
        CloseReply cry_ = null;
        this.ic_.isConnectionOpen();
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_);
            String temp = "Closing = " + this.stmtLabel_;
            this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "close", temp, p);
        }
        cry_ = this.t4statement_.Close();
        switch (cry_.m_p1.exception_nr) {
            case 0: {
                break;
            }
            case 3: {
                SQLMXMessages.throwSQLException(this.stmt_.connection_.props_, cry_.m_p1.SQLError);
            }
            default: {
                throw SQLMXMessages.createSQLException(this.stmt_.connection_.props_, this.ic_.getLocale(), "ids_unknown_reply_error", null);
            }
        }
        return cry_.m_p2;
    }

    void cancel() throws SQLException {
        this.ic_.cancel();
    }

    void prepare(String sql, int queryTimeout, SQLMXPreparedStatement pstmt) throws SQLException {
        PrepareReply pr;
        int sqlAsyncEnable = 0;
        this.stmtType_ = EXTERNAL_STMT;
        this.sqlStmtType_ = this.getSqlStmtType(sql);
        int stmtLabelCharset = 1;
        String cursorName = pstmt.cursorName_;
        int cursorNameCharset = 1;
        String moduleName = pstmt.moduleName_;
        int moduleNameCharset = 1;
        long moduleTimestamp = pstmt.moduleTimestamp_;
        String sqlString = sql;
        int sqlStringCharset = 1;
        String stmtOptions = "";
        int maxRowsetSize = pstmt.getMaxRows();
        byte[] txId = this.ic_.t4props_.getSPJEnv() ? this.getUDRTransaction(this.ic_.getByteSwap()) : Bytes.createIntBytes(0, false);
        if (this.sqlStmtType_ == 4096) {
            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, this.ic_.getLocale(), "infostats_invalid_error", null);
        }
        if (this.sqlStmtType_ == 8192) {
            throw SQLMXMessages.createSQLException(pstmt.connection_.props_, this.ic_.getLocale(), "config_cmd_invalid_error", null);
        }
        this.pr_ = pr = this.t4statement_.Prepare(sqlAsyncEnable, (short)this.stmtType_, this.sqlStmtType_, pstmt.stmtLabel_, stmtLabelCharset, cursorName, cursorNameCharset, moduleName, moduleNameCharset, moduleTimestamp, sqlString, sqlStringCharset, stmtOptions, maxRowsetSize, txId);
        this.sqlQueryType_ = pr.sqlQueryType;
        switch (pr.returnCode) {
            case 0: 
            case 1: {
                SQLMXDesc[] OutputDesc = InterfaceStatement.NewDescArray(pr.outputDesc);
                SQLMXDesc[] InputDesc = InterfaceStatement.NewDescArray(pr.inputDesc);
                pstmt.setPrepareOutputs2(InputDesc, OutputDesc, pr.inputNumberParams, pr.outputNumberParams, pr.inputParamLength, pr.outputParamLength, pr.inputDescLength, pr.outputDescLength);
                if (pr.errorList != null && pr.errorList.length > 0) {
                    SQLMXMessages.setSQLWarning(this.stmt_.connection_.props_, (SQLMXHandle)pstmt, pr.errorList);
                }
                this.stmtHandle_ = pr.stmtHandle;
                break;
            }
            default: {
                SQLMXMessages.throwSQLException(this.stmt_.connection_.props_, pr.errorList);
            }
        }
        if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_, (Object)sql, queryTimeout, (Object)pstmt);
            String temp = "Exiting prepare...";
            this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "prepare", temp, p);
        }
    }

    byte[] getUDRTransaction(boolean swapBytes) throws SQLException {
        byte[] ret = null;
        try {
            LmUtility_class_ = Class.forName("com.tandem.sqlmx.LmUtility");
            LmUtility_getTransactionId_ = LmUtility_class_.getMethod("getTransactionId", null);
            short[] tId = (short[])LmUtility_getTransactionId_.invoke(null, null);
            ret = new byte[tId.length * 2];
            for (int i = 0; i < tId.length; ++i) {
                Bytes.insertShort(ret, i * 2, tId[i], swapBytes);
            }
        }
        catch (Exception e) {
            this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "getUDRTransaction", "Error calling UDR for transaction id");
            String s = e.toString() + "\r\n";
            StackTraceElement[] st = e.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                s = s + st[i].toString() + "\r\n";
            }
            throw new SQLException(s);
        }
        return ret;
    }

    void execute(short executeAPI, int paramRowCount, int paramCount, Object[] paramValues, int queryTimeout, String sql, SQLMXStatement stmt) throws SQLException {
        long endTime;
        long timeTaken;
        SQL_DataValue_def inputDataValue;
        this.cursorName_ = stmt.cursorName_;
        this.rowCount_ = 0L;
        int sqlAsyncEnable = 0;
        int inputRowCnt = paramRowCount;
        int maxRowsetSize = stmt.getMaxRows();
        String sqlString = sql == null ? stmt.getSQL() : sql;
        int sqlStringCharset = 1;
        int cursorNameCharset = 1;
        int stmtLabelCharset = 1;
        ArrayList clientErrors = new ArrayList();
        this.t4statement_.m_queryTimeout = queryTimeout;
        rowWiseData = executeAPI == 3042;
        byte[] txId = this.ic_.t4props_.getSPJEnv() ? this.getUDRTransaction(this.ic_.getByteSwap()) : (stmt.transactionToJoin != null ? stmt.transactionToJoin : (stmt.connection_.transactionToJoin != null ? stmt.connection_.transactionToJoin : Bytes.createIntBytes(0, false)));
        SQLValueList_def inputValueList = new SQLValueList_def();
        Object inputParams = null;
        if (executeAPI == 3012) {
            this.sqlStmtType_ = this.getSqlStmtType(sql);
            if (this.sqlStmtType_ == 9) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.outputDesc_ = null;
            if (this.sqlStmtType_ == 8192) {
                if (sqlString.startsWith(CFG_CMD_TAG)) {
                    sqlString = sqlString.substring(CFG_CMD_TAG.length());
                }
            } else if (this.sqlStmtType_ == 16384 && sqlString.startsWith(SERVICEQS_CMD_TAG)) {
                if ((sqlString = sqlString.substring(SERVICEQS_CMD_TAG.length())).startsWith("WMSOPEN")) {
                    this.sqlStmtType_ = 16385;
                } else if (sqlString.startsWith("WMSCLOSE")) {
                    this.sqlStmtType_ = 16386;
                }
            }
            if (this.sqlStmtType_ == 16385) {
                this.ic_.setWmsMode(true);
            } else if (this.sqlStmtType_ == 16386) {
                this.ic_.setWmsMode(false);
            }
            if (this.sqlStmtType_ == 16384) {
                this.sqlStmtType_ = sqlString.toUpperCase().startsWith("STATUS") || sqlString.toUpperCase().startsWith("INFO") ? 1 : 0;
            }
        }
        if (stmt.usingRawRowset_) {
            executeAPI = (short)3025;
            inputDataValue = new SQL_DataValue_def();
            inputDataValue.userBuffer = stmt.rowwiseRowsetBuffer_;
            inputDataValue.length = stmt.rowwiseRowsetBuffer_.limit() - 4;
            if (this.sqlQueryType_ == 16) {
                try {
                    inputRowCnt = Integer.parseInt(paramValues[0].toString());
                    maxRowsetSize = Integer.parseInt(paramValues[1].toString());
                }
                catch (Exception e) {
                    throw new SQLException("Error setting inputRowCnt and maxRowsetSize.  Parameters not set or invalid.");
                }
            } else {
                inputRowCnt = paramRowCount - 1;
            }
        } else {
            inputDataValue = this.fillInSQLValues2(this.ic_.getLocale(), stmt, inputRowCnt, paramCount, paramValues, clientErrors);
            if (this.ic_.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(this.stmt_.connection_.props_, paramRowCount, paramCount, paramValues, queryTimeout, (Object)stmt);
                String temp = "invoke ==> Execute2";
                this.ic_.t4props_.t4Logger_.logp(Level.FINEST, "InterfaceStatement", "execute", temp, p);
            }
        }
        long beginTime = 0L;
        if (this.stmt_.connection_.props_.getQueryExecuteTime() > 0L) {
            beginTime = System.currentTimeMillis();
        }
        ExecuteReply er = this.t4statement_.Execute(executeAPI, sqlAsyncEnable, inputRowCnt - clientErrors.size(), maxRowsetSize, this.sqlStmtType_, this.stmtHandle_, sqlString, sqlStringCharset, this.cursorName_, cursorNameCharset, stmt.stmtLabel_, stmtLabelCharset, inputDataValue, inputValueList, txId, stmt.usingRawRowset_);
        if (this.stmt_.connection_.props_.getQueryExecuteTime() > 0L && (timeTaken = (endTime = System.currentTimeMillis()) - beginTime) > this.stmt_.connection_.props_.getQueryExecuteTime() && T4Properties.t4SlowQueryGlobalLogger.isLoggable(Level.INFO)) {
            Object[] p1 = T4LoggingUtilities.makeParams();
            T4Properties.t4SlowQueryGlobalLogger.logp(Level.INFO, this.stmt_.stmtLabel_, this.stmt_.sql_, "TIME TAKEN " + timeTaken + " ms");
        }
        if (executeAPI == 3012) {
            this.sqlQueryType_ = er.queryType;
        }
        if (clientErrors.size() > 0) {
            er.errorList = er.errorList == null ? clientErrors.toArray(new SQLWarningOrError[clientErrors.size()]) : this.mergeErrors(clientErrors.toArray(new SQLWarningOrError[clientErrors.size()]), er.errorList);
        }
        this.stmt_.result_set_offset = 0;
        this.rowCount_ = er.rowsAffected;
        outValuesFormat = er.outValuesFormat_;
        int numStatus = this.stmt_.connection_.props_.getDelayedErrorMode() ? (this.stmt_._lastCount > 0 ? this.stmt_._lastCount : inputRowCnt) : inputRowCnt;
        if (numStatus < 1) {
            numStatus = 1;
        }
        stmt.batchRowCount_ = new int[numStatus];
        if (executeAPI == 3042) {
            if (er.returnCode == 0 || er.returnCode == 1) {
                stmt.batchRowCount_ = er.rowsAffectedArray;
                if (er.errorList != null && er.errorList.length > 0) {
                    SQLMXMessages.setSQLWarning(this.stmt_.connection_.props_, (SQLMXHandle)stmt, er.errorList);
                }
                return;
            }
            if (er.errorList != null) {
                SQLMXMessages.throwSQLException(this.stmt_.connection_.props_, er.errorList);
                return;
            }
        }
        if (this.stmt_.connection_.props_.getDelayedErrorMode() && this.stmt_._lastCount < 1) {
            Arrays.fill(stmt.batchRowCount_, -2);
        } else if (er.returnCode == 0 || er.returnCode == 1 || er.returnCode == 100) {
            Arrays.fill(stmt.batchRowCount_, -2);
            if (er.errorList != null) {
                for (int i = 0; i < er.errorList.length; ++i) {
                    int row = er.errorList[i].rowId - 1;
                    if (row < 0 || row >= stmt.batchRowCount_.length) continue;
                    stmt.batchRowCount_[row] = -3;
                }
            }
            if (er.stmtLabels == null || er.stmtLabels.length == 0) {
                er.stmtLabels = new String[1];
                er.stmtLabels[0] = stmt.stmtLabel_;
            }
            SQLMXDesc[][] desc = null;
            if (er.outputDesc != null && er.outputDesc.length > 0) {
                desc = new SQLMXDesc[er.outputDesc.length][];
                for (int i = 0; i < er.outputDesc.length; ++i) {
                    desc[i] = InterfaceStatement.NewDescArray(er.outputDesc[i]);
                }
            } else if (stmt.outputDesc_ != null && stmt.outputDesc_.length > 0) {
                desc = new SQLMXDesc[][]{stmt.outputDesc_};
            }
            if (this.sqlStmtType_ == 2048) {
                SQLMXCallableStatement cstmt = (SQLMXCallableStatement)stmt;
                Object[] outputValueArray = er.returnCode == 100 ? new Object[cstmt.outputDesc_.length] : InterfaceResultSet.getExecute2Outputs(cstmt.connection_, cstmt.outputDesc_, er.outValues, this.ic_.getByteSwap());
                cstmt.setExecuteCallOutputs(outputValueArray, (short)er.rowsAffected);
                stmt.setMultipleResultSets(er.numResultSets, desc, er.stmtLabels, er.proxySyntax);
            } else {
                if (desc != null && desc.length > 0 && er.numResultSets == 0) {
                    er.numResultSets = 1;
                }
                if (er.outValues != null && er.outValues.length > 0) {
                    stmt.setExecute2Outputs(er.outValues, (short)er.rowsAffected, false, er.proxySyntax, desc[0]);
                } else {
                    stmt.setMultipleResultSets(er.numResultSets, desc, er.stmtLabels, er.proxySyntax);
                }
            }
            if (er.errorList != null) {
                SQLMXMessages.setSQLWarning(this.stmt_.connection_.props_, (SQLMXHandle)stmt, er.errorList);
            }
        } else {
            Arrays.fill(stmt.batchRowCount_, -3);
            SQLMXMessages.throwSQLException(this.stmt_.connection_.props_, er.errorList);
        }
    }

    public synchronized void setStmtLabel_(String stmtLabel_) {
        this.stmtLabel_ = stmtLabel_;
    }

    public String getStmtLabel_() {
        return this.stmtLabel_;
    }

    public void setT4statement_(T4Statement t4statement_) {
        this.t4statement_ = t4statement_;
    }

    public T4Statement getT4statement_() {
        return this.t4statement_;
    }
}

