/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.SQLMXConnection;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;

public class InterfaceUtilities {
    private static Hashtable valueToCharset = new Hashtable(11);
    private static Hashtable charsetToValue;
    static final int SQLCHARSETCODE_UNKNOWN = 0;
    static final String SQLCHARSET_UNKNOWN = "UNKNOWN";
    static final int SQLCHARSETCODE_ISO88591 = 1;
    static final String SQLCHARSET_ISO88591 = "ISO88591";
    static final int SQLCHARSETCODE_UNICODE = 11;
    static final String SQLCHARSET_UNICODE = "UCS2";
    static final int SQLCHARSETCODE_SJIS = 10;
    static final int SQLCHARSETCODE_UTF8 = 15;
    static final int SQLCHARSETCODE_KANJI = -1;
    static final String SQLCHARSET_KANJI = "KANJI";
    static final int SQLCHARSETCODE_KSC5601 = -2;
    static final String SQLCHARSET_KSC5601 = "KSC5601";
    private static final int[] powersOfTen;

    static String getCharsetName(int charset) {
        String ret = (String)valueToCharset.get(new Integer(charset));
        if (ret == null) {
            ret = SQLCHARSET_UNKNOWN;
        }
        return ret;
    }

    static int getCharsetValue(String charset) {
        Integer i = (Integer)charsetToValue.get(charset);
        int ret = i == null ? 0 : i;
        return ret;
    }

    static String getEncodingTranslation(SQLMXConnection conn, int SQLcharset) {
        String rValue = SQLCHARSET_UNKNOWN;
        rValue = SQLcharset == 1 ? conn.props_.getISO88591() : (SQLcharset == -1 ? conn.props_.getKANJI() : (SQLcharset == -2 ? conn.props_.getKSC5601() : (SQLcharset == 11 ? "UnicodeBigUnmarked" : SQLCHARSET_UNKNOWN)));
        return rValue;
    }

    public static byte[] convertBigDecimalToSQLBigNum(BigDecimal bd, int targetLength, int targetScale) {
        int zeros;
        byte[] sourceData = bd.setScale(targetScale, 1).unscaledValue().toString().getBytes();
        byte[] targetData = new byte[targetLength];
        int[] targetInShorts = new int[targetLength / 2];
        int tarPos = 1;
        for (zeros = 0; zeros < sourceData.length && (sourceData[zeros] == 48 || sourceData[zeros] == 45); ++zeros) {
        }
        int i = zeros;
        while (i < sourceData.length) {
            int n = i++;
            sourceData[n] = (byte)(sourceData[n] - 48);
        }
        int length = sourceData.length - zeros;
        for (i = 0; i < length; i += 4) {
            int temp1 = 0;
            int j = 0;
            for (j = 0; j < 4 && i + j < length; ++j) {
                temp1 = temp1 * 10 + sourceData[zeros + i + j];
            }
            int power = powersOfTen[j - 1];
            int temp = targetInShorts[0] * power + temp1;
            targetInShorts[0] = temp & 0xFFFF;
            for (j = 1; j < targetInShorts.length; ++j) {
                int t = (temp & 0xFFFF0000) >> 16;
                temp = targetInShorts[j] * power + t;
                targetInShorts[j] = temp & 0xFFFF;
            }
            int carry = (temp & 0xFFFF0000) >> 16;
            if (carry <= 0) continue;
            targetInShorts[tarPos++] = carry;
        }
        for (i = 0; i < targetInShorts.length; ++i) {
            targetData[i * 2] = (byte)((targetInShorts[i] & 0xFF00) >> 8);
            targetData[i * 2 + 1] = (byte)(targetInShorts[i] & 0xFF);
        }
        if (bd.signum() < 0) {
            int n = targetData.length - 2;
            targetData[n] = (byte)(targetData[n] | 0x80);
        }
        return targetData;
    }

    public static BigDecimal convertSQLBigNumToBigDecimal(byte[] sourceData, int scale) {
        int j;
        int curPos;
        String strVal = "";
        boolean negative = (sourceData[sourceData.length - 2] & 0x80) > 0;
        int n = sourceData.length - 2;
        sourceData[n] = (byte)(sourceData[n] & 0x7F);
        int[] dataInShorts = new int[sourceData.length / 2];
        for (int i = 0; i < dataInShorts.length; ++i) {
            dataInShorts[i] = Bytes.extractUShort(sourceData, i * 2, false);
        }
        for (curPos = dataInShorts.length - 1; curPos >= 0 && dataInShorts[curPos] == 0; --curPos) {
        }
        int remainder = 0;
        while (curPos >= 0 || dataInShorts[0] >= 10000) {
            for (j = curPos; j >= 0; --j) {
                long temp = remainder;
                temp &= 0xFFFFL;
                temp <<= 16;
                dataInShorts[j] = (int)((temp += (long)dataInShorts[j]) / 10000L);
                remainder = (int)(temp % 10000L);
            }
            if (dataInShorts[curPos] == 0) {
                --curPos;
            }
            for (j = 0; j < 4; ++j) {
                strVal = remainder % 10 + strVal;
                remainder /= 10;
            }
        }
        remainder = dataInShorts[0];
        for (j = 0; j < 4; ++j) {
            strVal = remainder % 10 + strVal;
            remainder /= 10;
        }
        BigInteger bi = new BigInteger(strVal);
        if (negative) {
            bi = bi.negate();
        }
        return new BigDecimal(bi, scale);
    }

    static {
        valueToCharset.put(new Integer(1), "ISO8859_1");
        valueToCharset.put(new Integer(10), "MS932");
        valueToCharset.put(new Integer(11), "UTF-16BE");
        valueToCharset.put(new Integer(12), "EUCJP");
        valueToCharset.put(new Integer(13), "MS950");
        valueToCharset.put(new Integer(14), "GB18030");
        valueToCharset.put(new Integer(15), "UTF-8");
        valueToCharset.put(new Integer(16), "MS949");
        valueToCharset.put(new Integer(17), "GB2312");
        valueToCharset.put(new Integer(-1), SQLCHARSET_KANJI);
        valueToCharset.put(new Integer(-2), SQLCHARSET_KSC5601);
        charsetToValue = new Hashtable(11);
        charsetToValue.put("ISO8859_1", new Integer(1));
        charsetToValue.put("MS932", new Integer(10));
        charsetToValue.put("UTF-16BE", new Integer(11));
        charsetToValue.put("EUCJP", new Integer(12));
        charsetToValue.put("MS950", new Integer(13));
        charsetToValue.put("GB18030", new Integer(14));
        charsetToValue.put("UTF-8", new Integer(15));
        charsetToValue.put("MS949", new Integer(16));
        charsetToValue.put("GB2312", new Integer(17));
        charsetToValue.put(SQLCHARSET_KANJI, new Integer(-1));
        charsetToValue.put(SQLCHARSET_KSC5601, new Integer(-2));
        powersOfTen = new int[]{10, 100, 1000, 10000};
    }
}

