/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.toByte;
import java.nio.ByteBuffer;

class LogicalByteArray {
    private static ThreadLocal threadArray = new ThreadLocal();
    private byte[] array;
    private ByteBuffer dataBuffer;
    private byte[] trailer;
    private boolean swap;
    private int loc;
    private int length;

    LogicalByteArray(int size, int startingLoc, boolean byteSwap) {
        this.loc = startingLoc;
        this.length = 0;
        this.swap = byteSwap;
        this.resize(size > 4096 ? size : 4096);
    }

    void resize(int size) {
        byte[] old = (byte[])threadArray.get();
        if (old == null || old.length < size) {
            this.array = new byte[size];
            if (old != null) {
                System.arraycopy(old, 0, this.array, 0, old.length);
            }
            threadArray.set(this.array);
        } else {
            this.array = old;
        }
    }

    void reset() {
        this.length = 0;
        this.loc = 0;
    }

    byte[] getBuffer() {
        return this.array;
    }

    int getTotalAllocated() {
        return this.array.length;
    }

    int getLength() {
        if (this.length < this.loc) {
            this.length = this.loc;
        }
        return this.length;
    }

    int getLocation() {
        return this.loc;
    }

    public void setLocation(int newLoc) {
        if (newLoc > this.length) {
            this.length = newLoc;
        }
        this.loc = newLoc;
    }

    void insertByte(byte value) {
        this.array[this.loc++] = value;
    }

    void insertByteArray(byte[] value, int len) {
        System.arraycopy(value, 0, this.array, this.loc, len);
        this.loc += len;
    }

    void insertChar(char value) {
        this.array[this.loc++] = (byte)value;
    }

    void insertShort(short value) {
        if (this.swap) {
            this.array[this.loc + 1] = (byte)(value >>> 8 & 0xFF);
            this.array[this.loc] = (byte)(value & 0xFF);
        } else {
            this.array[this.loc] = (byte)(value >>> 8 & 0xFF);
            this.array[this.loc + 1] = (byte)(value & 0xFF);
        }
        this.loc += 2;
    }

    void insertInt(int value) {
        if (this.swap) {
            this.array[this.loc + 3] = (byte)(value >>> 24 & 0xFF);
            this.array[this.loc + 2] = (byte)(value >>> 16 & 0xFF);
            this.array[this.loc + 1] = (byte)(value >>> 8 & 0xFF);
            this.array[this.loc] = (byte)(value & 0xFF);
        } else {
            this.array[this.loc] = (byte)(value >>> 24 & 0xFF);
            this.array[this.loc + 1] = (byte)(value >>> 16 & 0xFF);
            this.array[this.loc + 2] = (byte)(value >>> 8 & 0xFF);
            this.array[this.loc + 3] = (byte)(value & 0xFF);
        }
        this.loc += 4;
    }

    void insertLong(long value) {
        if (this.swap) {
            this.array[this.loc + 7] = (byte)(value >>> 56 & 0xFFL);
            this.array[this.loc + 6] = (byte)(value >>> 48 & 0xFFL);
            this.array[this.loc + 5] = (byte)(value >>> 40 & 0xFFL);
            this.array[this.loc + 4] = (byte)(value >>> 32 & 0xFFL);
            this.array[this.loc + 3] = (byte)(value >>> 24 & 0xFFL);
            this.array[this.loc + 2] = (byte)(value >>> 16 & 0xFFL);
            this.array[this.loc + 1] = (byte)(value >>> 8 & 0xFFL);
            this.array[this.loc] = (byte)(value & 0xFFL);
        } else {
            this.array[this.loc] = (byte)(value >>> 56 & 0xFFL);
            this.array[this.loc + 1] = (byte)(value >>> 48 & 0xFFL);
            this.array[this.loc + 2] = (byte)(value >>> 40 & 0xFFL);
            this.array[this.loc + 3] = (byte)(value >>> 32 & 0xFFL);
            this.array[this.loc + 4] = (byte)(value >>> 24 & 0xFFL);
            this.array[this.loc + 5] = (byte)(value >>> 16 & 0xFFL);
            this.array[this.loc + 6] = (byte)(value >>> 8 & 0xFFL);
            this.array[this.loc + 7] = (byte)(value & 0xFFL);
        }
        this.loc += 8;
    }

    void insertStringWithCharset(byte[] str, int charset) {
        if (str != null && str.length > 0) {
            this.insertString(str);
            this.insertInt(charset);
        } else {
            this.insertInt(0);
        }
    }

    void insertFixedString(byte[] buf, int len) {
        int dataLength;
        if (buf != null) {
            dataLength = buf.length > len - 1 ? len - 1 : buf.length;
            this.insertByteArray(buf, dataLength);
        } else {
            dataLength = 0;
        }
        byte[] padding = new byte[len - dataLength];
        this.insertByteArray(padding, padding.length);
    }

    void insertString(byte[] buf) {
        if (buf != null && buf.length > 0) {
            this.insertInt(buf.length + 1);
            this.insertByteArray(buf, buf.length);
            this.insertByte((byte)0);
        } else {
            this.insertInt(0);
        }
    }

    void insertString(byte[] str, boolean fixForServer) {
        if (str != null && str.length > 0) {
            this.insertInt(str.length + 1);
            this.insertByteArray(str, str.length);
            this.insertByte((byte)0);
        } else {
            this.insertInt(1);
            this.insertByte((byte)0);
        }
    }

    boolean extractBoolean() {
        return this.extractByte() != 0;
    }

    byte extractByte() {
        return this.array[this.loc++];
    }

    byte[] extractByteArray(int len) {
        byte[] a = new byte[len];
        System.arraycopy(this.array, this.loc, a, 0, len);
        this.loc += len;
        return a;
    }

    byte[] extractByteArray() {
        return this.extractByteArray(this.extractInt());
    }

    char extractChar() {
        return (char)this.extractByte();
    }

    short extractShort() {
        int value = this.swap ? this.array[this.loc] & 0xFF | this.array[this.loc + 1] << 8 & 0xFF00 : this.array[this.loc + 1] & 0xFF | this.array[this.loc] << 8 & 0xFF00;
        this.loc += 2;
        return (short)value;
    }

    int extractInt() {
        int value = this.swap ? this.array[this.loc] & 0xFF | this.array[this.loc + 1] << 8 & 0xFF00 | this.array[this.loc + 2] << 16 & 0xFF0000 | this.array[this.loc + 3] << 24 & 0xFF000000 : this.array[this.loc + 3] & 0xFF | this.array[this.loc + 2] << 8 & 0xFF00 | this.array[this.loc + 1] << 16 & 0xFF0000 | this.array[this.loc] << 24 & 0xFF000000;
        this.loc += 4;
        return value;
    }

    char[] extractChars(int loc, int index) {
        byte[] temp = this.extractByteArray(index);
        return toByte.read_chars(temp, 0, temp.length);
    }

    long extractUnsignedInt() {
        long value = this.swap ? (long)(this.array[this.loc] & 0xFF | this.array[this.loc + 1] << 8 & 0xFF00 | this.array[this.loc + 2] << 16 & 0xFF0000 | this.array[this.loc + 3] << 24 & 0xFF000000) : (long)(this.array[this.loc + 3] & 0xFF | this.array[this.loc + 2] << 8 & 0xFF00 | this.array[this.loc + 1] << 16 & 0xFF0000 | this.array[this.loc] << 24 & 0xFF000000);
        this.loc += 4;
        return value & 0xFFFFFFFFL;
    }

    byte[] extractString() {
        int len = this.extractInt();
        byte[] str = new byte[]{};
        if (len > 0) {
            str = this.extractByteArray(len - 1);
            this.extractByte();
        }
        return str;
    }

    byte[] extractByteString() {
        int len = this.extractInt();
        byte[] b = new byte[]{};
        if (len > 0) {
            b = this.extractByteArray(len);
            this.extractByte();
        }
        return b;
    }

    void setDataBuffer(ByteBuffer buf) {
        this.dataBuffer = buf;
    }

    void setTrailer(byte[] buf) {
        this.trailer = buf;
    }

    ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    byte[] getTrailer() {
        return this.trailer;
    }

    void setByteSwap(boolean byteSwap) {
        this.swap = byteSwap;
    }

    boolean getByteSwap() {
        return this.swap;
    }
}

