/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Address;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.util.Locale;

final class MXCSAddress
extends Address {
    private static final String ODBCServerPrefix = "TCP:";
    private static final String ODBCServerSuffix = ":NonStopODBC";
    private static final int minODBCServerAddrLen = "TCP:".length() + 7 + ":NonStopODBC".length();
    static final int OS_type = 2;

    MXCSAddress(T4Properties t4props, Locale locale, String addr) throws SQLException {
        super(t4props, locale, addr);
        this.m_locale = locale;
        if (addr == null) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_null_error", null);
            throw se;
        }
        if (MXCSAddress.acceptsURL(addr)) {
            this.m_type = 2;
            if (!addr.endsWith(ODBCServerSuffix)) {
                SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
                SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "odbc_server_suffix_error", ODBCServerSuffix);
                se.setNextException(se2);
                throw se;
            }
            if (addr.length() < minODBCServerAddrLen) {
                SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
                SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "min_address_length_error", null);
                se.setNextException(se2);
                throw se;
            }
            addr = addr.substring(ODBCServerPrefix.length());
            if ((addr = addr.substring(0, addr.length() - ODBCServerSuffix.length())).indexOf(",") > 0) {
                this.interpretMXCSAddress(t4props, locale, addr);
            } else {
                this.interpretAddress(t4props, locale, addr);
            }
            if (this.m_machineName == null && this.m_ipAddress == null || this.m_processName == null || this.m_portNumber == null) {
                SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
                SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_1_error", null);
                se.setNextException(se2);
                throw se;
            }
        }
    }

    void interpretAddress(T4Properties t4props, Locale locale, String addr) throws SQLException {
        int index1 = addr.indexOf("\\");
        int index3 = addr.indexOf("/");
        int index2 = addr.lastIndexOf(".", index3);
        if (!(-1 < index1 && index1 < index2 && index2 < index3 && index3 < addr.length())) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_1_error", null);
            se.setNextException(se2);
            throw se;
        }
        String temp4 = addr.substring(index1 + 1, index2);
        if (Character.isDigit(temp4.charAt(0)) || temp4.substring(0, 1).equals("[")) {
            this.m_ipAddress = temp4;
        } else {
            this.m_machineName = temp4;
        }
        this.m_processName = addr.substring(index2 + 1, index3);
        this.m_portNumber = new Integer(addr.substring(index3 + 1, addr.length()));
    }

    void interpretMXCSAddress(T4Properties t4props, Locale locale, String addr) throws SQLException {
        int index1 = addr.indexOf("\\");
        int index3 = addr.indexOf("/");
        int index4 = addr.indexOf(",");
        int index2 = addr.indexOf(".", 0);
        if (!(-1 < index1 && index1 < index2 && index2 < index4 && index4 < index3 && index3 < addr.length())) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_1_error", null);
            se.setNextException(se2);
            throw se;
        }
        String temp4 = addr.substring(index4 + 1, index3);
        if (Character.isDigit(temp4.charAt(0)) || temp4.substring(0, 1).equals("[")) {
            this.m_ipAddress = temp4;
        } else {
            this.m_machineName = temp4;
        }
        this.m_processName = addr.substring(index2 + 1, index4);
        this.m_portNumber = new Integer(addr.substring(index3 + 1, addr.length()));
    }

    String recreateAddress() {
        String addr = "TCP:\\";
        if (this.m_machineName != null) {
            addr = addr + this.m_machineName;
        }
        addr = addr + ".";
        if (this.m_processName != null) {
            addr = addr + this.m_processName;
        }
        addr = addr + "/";
        if (this.m_portNumber != null) {
            addr = addr + this.m_portNumber;
        }
        addr = addr + ODBCServerSuffix;
        return addr;
    }

    static boolean acceptsURL(String url) throws SQLException {
        try {
            return url.toUpperCase().startsWith(ODBCServerPrefix);
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString());
        }
    }
}

