/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.VERSION_LIST_def;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;

class OUT_CONNECTION_CONTEXT_def {
    static final long OUTCONTEXT_OPT1_ENFORCE_ISO88591 = 1L;
    static final long OUTCONTEXT_OPT1_IGNORE_SQLCANCEL = 0x40000000L;
    static final long OUTCONTEXT_OPT1_EXTRA_OPTIONS = 0x80000000L;
    VERSION_LIST_def versionList;
    short nodeId;
    int processId;
    String computerName;
    String catalog;
    String schema;
    int optionFlags1;
    int optionFlags2;
    String _roleName;
    boolean _enforceISO;
    boolean _ignoreCancel;

    OUT_CONNECTION_CONTEXT_def() {
    }

    void extractFromByteArray(LogicalByteArray buf, InterfaceConnection ic) throws SQLException, UnsupportedCharsetException, CharacterCodingException {
        this.versionList = new VERSION_LIST_def();
        this.versionList.extractFromByteArray(buf);
        this.nodeId = buf.extractShort();
        this.processId = buf.extractInt();
        this.computerName = ic.decodeBytes(buf.extractString(), 1);
        this.catalog = ic.decodeBytes(buf.extractString(), 1);
        this.schema = ic.decodeBytes(buf.extractString(), 1);
        this.optionFlags1 = buf.extractInt();
        this.optionFlags2 = buf.extractInt();
        this._enforceISO = ((long)this.optionFlags1 & 1L) > 0L;
        boolean bl = this._ignoreCancel = ((long)this.optionFlags1 & 0x40000000L) > 0L;
        if (((long)this.optionFlags1 & 0x80000000L) > 0L) {
            try {
                this.decodeExtraOptions(ic.decodeBytes(buf.extractString(), ic.getTerminalCharset()));
            }
            catch (Exception e) {
                ic.t4props_.logger.warning("An error occured parsing OutConnectionContext: " + e.getMessage());
            }
        }
    }

    public void decodeExtraOptions(String options) {
        String[] opts = options.split(";");
        for (int i = 0; i < opts.length; ++i) {
            int index = opts[i].indexOf(61);
            String token = opts[i].substring(0, index).toUpperCase();
            String value = opts[i].substring(index + 1);
            if (!token.equals("RN")) continue;
            this._roleName = value;
        }
    }
}

