/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.TRANSPORT;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;

class PrepareMessage {
    PrepareMessage() {
    }

    static LogicalByteArray marshal(int dialogueId, int sqlAsyncEnable, int queryTimeout, short stmtType, int sqlStmtType, String stmtLabel, int stmtLabelCharset, String cursorName, int cursorNameCharset, String moduleName, int moduleNameCharset, long moduleTimestamp, String sqlString, int sqlStringCharset, String stmtOptions, String stmtExplainLabel, int maxRowsetSize, byte[] txId, InterfaceConnection ic) throws CharacterCodingException, UnsupportedCharsetException {
        int wlength = Header.sizeOf();
        byte[] stmtLabelBytes = ic.encodeString(stmtLabel, 1);
        byte[] cursorNameBytes = ic.encodeString(cursorName, 1);
        byte[] moduleNameBytes = ic.encodeString(moduleName, 1);
        byte[] sqlStringBytes = ic.encodeString(sqlString, ic.getTerminalCharset());
        byte[] stmtOptionsBytes = ic.encodeString(stmtOptions, 1);
        byte[] stmtExplainLabelBytes = ic.encodeString(stmtExplainLabel, 1);
        wlength += 4;
        wlength += 4;
        wlength += 4;
        wlength += 2;
        wlength += 4;
        wlength += TRANSPORT.size_bytesWithCharset(stmtLabelBytes);
        wlength += TRANSPORT.size_bytesWithCharset(cursorNameBytes);
        wlength += TRANSPORT.size_bytesWithCharset(moduleNameBytes);
        if (moduleName != null && moduleName.length() > 0) {
            wlength += 8;
        }
        wlength += TRANSPORT.size_bytesWithCharset(sqlStringBytes);
        wlength += TRANSPORT.size_bytes(stmtOptionsBytes);
        wlength += TRANSPORT.size_bytes(stmtExplainLabelBytes);
        wlength += 4;
        LogicalByteArray buf = new LogicalByteArray(wlength += TRANSPORT.size_bytes(txId), Header.sizeOf(), ic.getByteSwap());
        buf.insertInt(dialogueId);
        buf.insertInt(sqlAsyncEnable);
        buf.insertInt(queryTimeout);
        buf.insertShort(stmtType);
        buf.insertInt(sqlStmtType);
        buf.insertStringWithCharset(stmtLabelBytes, stmtLabelCharset);
        buf.insertStringWithCharset(cursorNameBytes, cursorNameCharset);
        buf.insertStringWithCharset(moduleNameBytes, moduleNameCharset);
        if (moduleName != null && moduleName.length() > 0) {
            buf.insertLong(moduleTimestamp);
        }
        buf.insertStringWithCharset(sqlStringBytes, sqlStringCharset);
        buf.insertString(stmtOptionsBytes);
        buf.insertString(stmtExplainLabelBytes);
        buf.insertInt(maxRowsetSize);
        buf.insertString(txId);
        return buf;
    }
}

