/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXClobReader;
import com.tandem.t4jdbc.SQLMXClobWriter;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import com.tandem.t4jdbc.SQLMXLobOutputStream;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXClob
extends SQLMXLob
implements Clob {
    SQLMXClobReader reader_;
    SQLMXClobWriter writer_;
    Reader ir_;
    int irLength_;
    Clob inputLob_;
    String inputLobStr_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "getAsciiStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("getAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkIfCurrent();
        if (this.reader_ != null) {
            try {
                this.reader_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.reader_ = null;
            }
        }
        return this.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "getCharacterStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("getCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkIfCurrent();
        if (this.reader_ != null) {
            try {
                this.reader_.close();
            }
            catch (IOException e) {
            }
            finally {
                this.reader_ = null;
            }
        }
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inputStream_ = null;
            }
        }
        this.reader_ = new SQLMXClobReader(this.conn_, this);
        return this.reader_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long pos, int length) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, length);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "getSubString", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("getSubString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (pos <= 0L || length < 0) {
            Object[] messageArguments = new Object[]{"Clob.getSubString(long, int)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        int startChunkNo = (int)((pos - 1L) / (long)this.chunkSize_);
        int endChunkNo = (int)((pos - 1L + (long)length) / (long)this.chunkSize_);
        int copyLen = length;
        int offset = (int)((pos - 1L) % (long)this.chunkSize_);
        StringBuffer retString = new StringBuffer(length);
        this.prepareGetLobDataStmt();
        PreparedStatement preparedStatement = this.conn_.LobPreparedStatements[1];
        synchronized (preparedStatement) {
            this.conn_.LobPreparedStatements[1].setString(1, this.tableName_);
            this.conn_.LobPreparedStatements[1].setLong(2, this.dataLocator_);
            this.conn_.LobPreparedStatements[1].setInt(3, startChunkNo);
            this.conn_.LobPreparedStatements[1].setInt(4, endChunkNo);
            ResultSet rs = this.conn_.LobPreparedStatements[1].executeQuery();
            try {
                while (rs.next()) {
                    String data = rs.getString(1);
                    int dataLength = data.length() - offset;
                    if (dataLength >= copyLen) {
                        retString.append(data.substring(offset, offset + copyLen));
                        break;
                    }
                    if (offset == 0) {
                        retString.append(data);
                    } else {
                        retString.append(data.substring(offset));
                    }
                    copyLen -= dataLength;
                    offset = 0;
                }
            }
            finally {
                rs.close();
            }
        }
        return retString.toString();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)searchstr, start);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "position", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)searchstr, start);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("position");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (start <= 0L) {
            Object[] messageArguments = new Object[]{"Clob.position(Clob, long)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        String searchString = searchstr.getSubString(1L, (int)searchstr.length());
        return this.position(searchString, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)searchstr, start);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "position", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)searchstr, start);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("position");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (start <= 0L) {
            Object[] messageArguments = new Object[]{"Clob.position(String, long)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        String clobData = this.getSubString(start, (int)this.length());
        long retValue = clobData.indexOf(searchstr);
        if (retValue != -1L) {
            retValue += start;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "setAsciiStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("setAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkAutoCommitExtTxn();
        this.checkIfCurrent();
        if (this.writer_ != null) {
            try {
                this.writer_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.writer_ = null;
            }
        }
        return this.setOutputStream(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "setCharacterStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("setCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkAutoCommitExtTxn();
        this.checkIfCurrent();
        if (this.writer_ != null) {
            try {
                this.writer_.close();
            }
            catch (IOException e) {
            }
            finally {
                this.writer_ = null;
            }
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.outputStream_ = null;
            }
        }
        this.writer_ = new SQLMXClobWriter(this.conn_, this, pos);
        return this.writer_;
    }

    public int setString(long pos, String str) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)str);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "setString", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)str);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("setString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (str == null) {
            Object[] messageArguments = new Object[]{"Clob.setString(long, String)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        return this.setString(pos, str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)str, offset, len);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "setString", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)str, offset, len);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("setString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (str == null || pos <= 0L || len < 0 || offset < 0) {
            Object[] messageArguments = new Object[]{"Clob.setString(long, String, int, int)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        long lobLen = this.length();
        if (pos > lobLen + 1L) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_position_value", null);
        }
        int copyLen = len;
        long remLen = pos - 1L + (long)len;
        int strOffset = offset;
        int totalRetLen = 0;
        int chunkNo = (int)((pos - 1L) / (long)this.chunkSize_);
        long lobLenForUpd = lobLen % (long)this.chunkSize_ == 0L ? lobLen / (long)this.chunkSize_ * (long)this.chunkSize_ : (lobLen / (long)this.chunkSize_ + 1L) * (long)this.chunkSize_;
        int updLen = remLen <= lobLenForUpd ? len : (int)(lobLenForUpd - (pos - 1L));
        if (updLen > 0) {
            int updOffset = (int)((pos - 1L) % (long)this.chunkSize_);
            this.prepareUpdLobDataStmt();
            preparedStatement = this.conn_.LobPreparedStatements[5];
            synchronized (preparedStatement) {
                this.conn_.LobPreparedStatements[5].setString(4, this.tableName_);
                this.conn_.LobPreparedStatements[5].setLong(5, this.dataLocator_);
                while (true) {
                    this.conn_.LobPreparedStatements[5].setInt(6, chunkNo);
                    this.conn_.LobPreparedStatements[5].setInt(1, updOffset);
                    if (updOffset + updLen <= this.chunkSize_) {
                        this.conn_.LobPreparedStatements[5].setInt(3, updOffset + updLen + 1);
                        this.conn_.LobPreparedStatements[5].setString(2, str.substring(strOffset, strOffset + updLen));
                        this.conn_.LobPreparedStatements[5].executeUpdate();
                        totalRetLen += updLen;
                        strOffset += updLen;
                        ++chunkNo;
                        break;
                    }
                    this.conn_.LobPreparedStatements[5].setInt(3, this.chunkSize_ + 1);
                    this.conn_.LobPreparedStatements[5].setString(2, str.substring(strOffset, strOffset + this.chunkSize_ - updOffset));
                    this.conn_.LobPreparedStatements[5].executeUpdate();
                    totalRetLen += this.chunkSize_ - updOffset;
                    strOffset += this.chunkSize_ - updOffset;
                    updLen -= this.chunkSize_ - updOffset;
                    ++chunkNo;
                    updOffset = 0;
                }
            }
            copyLen = (int)(remLen - lobLenForUpd);
        }
        if (remLen > lobLenForUpd) {
            while (true) {
                this.prepareInsLobDataStmt();
                preparedStatement = this.conn_.LobPreparedStatements[0];
                synchronized (preparedStatement) {
                    this.conn_.LobPreparedStatements[0].setString(1, this.tableName_);
                    this.conn_.LobPreparedStatements[0].setLong(2, this.dataLocator_);
                    this.conn_.LobPreparedStatements[0].setInt(3, chunkNo);
                    if (copyLen <= this.chunkSize_) {
                        this.conn_.LobPreparedStatements[0].setString(4, str.substring(strOffset, strOffset + copyLen));
                        this.conn_.LobPreparedStatements[0].executeUpdate();
                        strOffset += copyLen;
                        totalRetLen += copyLen;
                        break;
                    }
                    this.conn_.LobPreparedStatements[0].setString(4, str.substring(strOffset, strOffset + this.chunkSize_));
                    this.conn_.LobPreparedStatements[0].executeUpdate();
                    strOffset += this.chunkSize_;
                    copyLen -= this.chunkSize_;
                    totalRetLen += this.chunkSize_;
                    ++chunkNo;
                }
            }
        }
        return totalRetLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "close", "", p);
        }
        try {
            if (this.reader_ != null) {
                this.reader_.close();
            }
            if (this.writer_ != null) {
                this.writer_.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.reader_ = null;
            this.writer_ = null;
        }
        super.close();
    }

    void populate() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "populate", "", p);
        }
        if (this.is_ != null) {
            SQLMXLobOutputStream os = (SQLMXLobOutputStream)this.setOutputStream(1L);
            os.populate(this.is_, this.isLength_);
            this.is_ = null;
        } else if (this.ir_ != null) {
            SQLMXClobWriter cw = (SQLMXClobWriter)this.setCharacterStream(1L);
            cw.populate(this.ir_, this.irLength_);
            this.ir_ = null;
        } else if (this.inputLob_ != null) {
            this.populateFromClob();
            this.inputLob_ = null;
        } else if (this.inputLobStr_ != null) {
            this.setString(1L, this.inputLobStr_);
            this.inputLobStr_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateFromClob() throws SQLException {
        String s;
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "populateFromClob", "", p);
        }
        int chunkNo = 0;
        long pos = 1L;
        if (this.inputLob_ instanceof SQLMXClob) {
            SQLMXClob inputClob = (SQLMXClob)this.inputLob_;
            this.prepareGetLobDataStmt();
            this.prepareInsLobDataStmt();
            PreparedStatement preparedStatement = this.conn_.LobPreparedStatements[1];
            synchronized (preparedStatement) {
                this.conn_.LobPreparedStatements[1].setString(1, inputClob.tableName_);
                this.conn_.LobPreparedStatements[1].setLong(2, inputClob.dataLocator_);
                this.conn_.LobPreparedStatements[1].setInt(3, 0);
                this.conn_.LobPreparedStatements[1].setInt(4, Integer.MAX_VALUE);
                ResultSet rs = this.conn_.LobPreparedStatements[1].executeQuery();
                PreparedStatement preparedStatement2 = this.conn_.LobPreparedStatements[0];
                synchronized (preparedStatement2) {
                    try {
                        this.conn_.LobPreparedStatements[0].setString(1, this.tableName_);
                        this.conn_.LobPreparedStatements[0].setLong(2, this.dataLocator_);
                        while (rs.next()) {
                            String s2 = rs.getString(1);
                            this.conn_.LobPreparedStatements[0].setInt(3, chunkNo);
                            this.conn_.LobPreparedStatements[0].setString(4, s2);
                            this.conn_.LobPreparedStatements[0].executeUpdate();
                            ++chunkNo;
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
            }
        }
        while ((s = this.inputLob_.getSubString(pos, this.chunkSize_)).length() != 0) {
            int ret = this.setString(pos, s);
            pos += (long)s.length();
        }
    }

    void prepareGetLobLenStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareGetLobLenStmt", "", p);
        }
        this.conn_.prepareGetLobLenStmt(this.lobTableName_, false);
    }

    void prepareDelLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareDelLobDataStmt", "", p);
        }
        this.conn_.prepareDelLobDataStmt(this.lobTableName_, false);
    }

    void prepareGetLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareGetLobDataStmt", "", p);
        }
        this.conn_.prepareGetLobDataStmt(this.lobTableName_, false);
    }

    void prepareUpdLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareUpdLobDataStmt", "", p);
        }
        this.conn_.prepareUpdLobDataStmt(this.lobTableName_, false);
    }

    void prepareInsLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareInsLobDataStmt", "", p);
        }
        this.conn_.prepareInsLobDataStmt(this.lobTableName_, false);
    }

    void prepareTrunLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "prepareTrunLobDataStmt", "", p);
        }
        this.conn_.prepareTrunLobDataStmt(this.lobTableName_, false);
    }

    void prepareInsSpjLobDataStmt() throws SQLException {
    }

    void prepareInsSpjBaseDataStmt() throws SQLException {
    }

    PreparedStatement getSpjInsLobDataStmt() {
        return null;
    }

    PreparedStatement getSpjInsBaseDataStmt() {
        return null;
    }

    PreparedStatement getGetLobLenStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getGetLobLenStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[2];
    }

    PreparedStatement getDelLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getDelLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[3];
    }

    PreparedStatement getTrunLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getTrunLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[4];
    }

    PreparedStatement getInsLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getInsLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[0];
    }

    PreparedStatement getUpdLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getUpdLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[5];
    }

    PreparedStatement getGetLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "getGetLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[1];
    }

    SQLMXClob(SQLMXConnection connection, String tableName, long dataLocator) throws SQLException {
        super(connection, tableName, dataLocator, connection.clobTableName_, false);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.clobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_clobTableName", null);
        }
    }

    SQLMXClob(SQLMXConnection connection, String tableName, long dataLocator, InputStream x, int length) throws SQLException {
        super(connection, tableName, dataLocator, x, length, connection.clobTableName_, false);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.clobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_clobTableName", null);
        }
    }

    SQLMXClob(SQLMXConnection connection, String tableName, long dataLocator, Reader x, int length) throws SQLException {
        super(connection, tableName, dataLocator, connection.clobTableName_, false);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXClob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.clobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_clobTableName", null);
        }
        this.ir_ = x;
        this.irLength_ = length;
    }

    SQLMXClob(SQLMXConnection connection, String tableName, long dataLocator, Clob inputLob) throws SQLException {
        super(connection, tableName, dataLocator, connection.clobTableName_, false);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)inputLob);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXClob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)inputLob);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXClob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.clobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_clobTableName", null);
        }
        this.inputLob_ = inputLob;
    }

    SQLMXClob(SQLMXConnection connection, String tableName, long dataLocator, String lobStr) throws SQLException {
        super(connection, tableName, dataLocator, connection.clobTableName_, false);
        if (connection.clobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_clobTableName", null);
        }
        this.inputLobStr_ = lobStr;
    }
}

