/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.SQLMXMessages;
import java.sql.SQLException;
import java.util.Locale;

class SQLMXDesc {
    public static final int SQLTYPECODE_CHAR = 1;
    public static final int SQLTYPECODE_VARCHAR = 12;
    public static final int SQLTYPECODE_VARCHAR_LONG = -1;
    public static final int SQLTYPECODE_INTERVAL = 10;
    public static final int SQLTYPECODE_VARCHAR_WITH_LENGTH = -601;
    public static final int SQLTYPECODE_SMALLINT = 5;
    public static final int SQLTYPECODE_INTEGER = 4;
    public static final int SQLDTCODE_YEAR = 4;
    public static final int SQLDTCODE_YEAR_TO_MONTH = 5;
    public static final int SQLDTCODE_YEAR_TO_HOUR = 7;
    public static final int SQLDTCODE_YEAR_TO_MINUTE = 8;
    public static final int SQLDTCODE_MONTH = 10;
    public static final int SQLDTCODE_MONTH_TO_DAY = 11;
    public static final int SQLDTCODE_MONTH_TO_HOUR = 12;
    public static final int SQLDTCODE_MONTH_TO_MINUTE = 13;
    public static final int SQLDTCODE_MONTH_TO_SECOND = 14;
    public static final int SQLDTCODE_MONTH_TO_FRACTION = 14;
    public static final int SQLDTCODE_DAY = 15;
    public static final int SQLDTCODE_DAY_TO_HOUR = 16;
    public static final int SQLDTCODE_DAY_TO_MINUTE = 17;
    public static final int SQLDTCODE_DAY_TO_SECOND = 18;
    public static final int SQLDTCODE_DAY_TO_FRACTION = 18;
    public static final int SQLDTCODE_HOUR = 19;
    public static final int SQLDTCODE_HOUR_TO_MINUTE = 20;
    public static final int SQLDTCODE_HOUR_TO_FRACTION = 2;
    public static final int SQLDTCODE_MINUTE = 22;
    public static final int SQLDTCODE_MINUTE_TO_SECOND = 23;
    public static final int SQLDTCODE_MINUTE_TO_FRACTION = 23;
    public static final int SQLDTCODE_SECOND = 24;
    public static final int SQLDTCODE_SECOND_TO_FRACTION = 24;
    public static final int SQLDTCODE_FRACTION_TO_FRACTION = 29;
    int sqlCharset_;
    int odbcCharset_;
    int sqlDataType_;
    int dataType_;
    short sqlPrecision_;
    short sqlDatetimeCode_;
    int sqlOctetLength_;
    int isNullable_;
    String name_;
    short scale_;
    int precision_;
    boolean isSigned_;
    boolean isCurrency_;
    boolean isCaseSensitive_;
    String catalogName_;
    String schemaName_;
    String tableName_;
    int fsDataType_;
    int intLeadPrec_;
    int paramMode_;
    int paramIndex_;
    int paramPos_;
    String columnClassName_;
    int displaySize_;
    String columnLabel_;
    boolean isAutoIncrement_;
    boolean isSearchable_;
    boolean isValueSet_;
    Object paramValue_;
    int noNullValue_;
    int nullValue_;
    int version_;
    String headingName_;
    int rowLength_;
    int maxLen_;

    String getColumnClassName() throws SQLException {
        switch (this.dataType_) {
            case 5: {
                return "java.lang.Integer";
            }
            case 4: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 1111: {
                return "java.sql.String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 2004: {
                return "java.sql.Blob";
            }
        }
        return null;
    }

    String getColumnTypeName(Locale locale) throws SQLException {
        switch (this.dataType_) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 1111: {
                if (this.sqlDataType_ == 10) {
                    return "INTERVAL";
                }
                if (this.sqlDataType_ == 9) {
                    return "DATETIME";
                }
                return "UNKNOWN";
            }
        }
        return null;
    }

    void checkValidNumericConversion(Locale locale) throws SQLException {
        switch (this.dataType_) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                System.out.println("Data type is " + this.dataType_);
                throw SQLMXMessages.createSQLException(null, locale, "restricted_data_type", null);
            }
        }
    }

    SQLMXDesc(int dataType, short datetimeCode, int maxLen, short precision, short scale, boolean nullInfo, String colName, boolean signType, int odbcDataType, short odbcPrecision, int sqlCharset, int odbcCharset, String catalogName, String schemaName, String tableName, int fsDataType, int intLeadPrec, int paramMode) {
        this.catalogName_ = catalogName;
        this.schemaName_ = schemaName;
        this.tableName_ = tableName;
        this.name_ = colName;
        this.isNullable_ = nullInfo ? 1 : 0;
        this.sqlDataType_ = dataType;
        this.dataType_ = odbcDataType;
        this.sqlDatetimeCode_ = datetimeCode;
        this.sqlCharset_ = sqlCharset;
        this.odbcCharset_ = odbcCharset;
        this.isSigned_ = signType;
        this.sqlOctetLength_ = maxLen;
        this.scale_ = scale;
        this.sqlPrecision_ = precision;
        if (odbcDataType == -8) {
            this.dataType_ = 1;
        } else if (odbcDataType == -9) {
            this.dataType_ = 12;
        } else if (odbcDataType == -10) {
            this.dataType_ = -1;
        }
        if (this.sqlDataType_ == 9) {
            block0 : switch (this.dataType_) {
                case 9: {
                    switch (this.sqlDatetimeCode_) {
                        case 4: 
                        case 5: 
                        case 10: 
                        case 11: 
                        case 15: {
                            this.dataType_ = 1111;
                            this.precision_ = odbcPrecision;
                            this.displaySize_ = maxLen;
                            this.sqlOctetLength_ = maxLen;
                            break block0;
                        }
                    }
                    this.dataType_ = 91;
                    break;
                }
                case 10: {
                    switch (this.sqlDatetimeCode_) {
                        case 19: 
                        case 20: 
                        case 22: 
                        case 23: 
                        case 24: {
                            this.dataType_ = 1111;
                            this.precision_ = odbcPrecision;
                            this.displaySize_ = maxLen;
                            this.sqlOctetLength_ = maxLen;
                            break block0;
                        }
                    }
                    this.dataType_ = 92;
                    break;
                }
                case 11: {
                    switch (this.sqlDatetimeCode_) {
                        case 2: 
                        case 7: 
                        case 8: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 23: 
                        case 24: {
                            this.dataType_ = 1111;
                            this.precision_ = odbcPrecision;
                            this.displaySize_ = maxLen;
                            this.sqlOctetLength_ = maxLen;
                            break block0;
                        }
                    }
                    this.dataType_ = 93;
                    break;
                }
                default: {
                    this.dataType_ = 93;
                }
            }
        }
        switch (this.dataType_) {
            case 2: 
            case 3: {
                this.precision_ = odbcPrecision;
                this.displaySize_ = this.precision_ + 2;
                break;
            }
            case 5: {
                this.precision_ = odbcPrecision;
                if (this.isSigned_) {
                    this.displaySize_ = 6;
                    break;
                }
                this.dataType_ = 4;
                this.displaySize_ = 5;
                break;
            }
            case 4: {
                this.precision_ = odbcPrecision;
                if (this.isSigned_) {
                    this.displaySize_ = 11;
                    break;
                }
                this.dataType_ = -5;
                this.displaySize_ = 10;
                break;
            }
            case -6: {
                this.precision_ = odbcPrecision;
                if (this.isSigned_) {
                    this.displaySize_ = 4;
                    break;
                }
                this.displaySize_ = 3;
                break;
            }
            case -5: {
                this.precision_ = odbcPrecision;
                if (this.isSigned_) {
                    this.displaySize_ = 20;
                    break;
                }
                this.displaySize_ = 19;
                break;
            }
            case 7: {
                this.precision_ = odbcPrecision;
                this.displaySize_ = 14;
                break;
            }
            case 6: 
            case 8: {
                this.precision_ = odbcPrecision;
                this.displaySize_ = 24;
                break;
            }
            case 91: {
                this.sqlOctetLength_ = maxLen + 3;
                this.displaySize_ = 10;
                this.precision_ = 10;
                break;
            }
            case 92: {
                this.sqlOctetLength_ = maxLen + 3;
                this.displaySize_ = precision == 0 ? 8 : precision + 9;
                this.precision_ = 8;
                break;
            }
            case 93: {
                this.sqlOctetLength_ = maxLen + 3;
                this.displaySize_ = this.precision_ = (int)odbcPrecision;
                if (this.sqlDatetimeCode_ <= 3) break;
                this.dataType_ = 1111;
                break;
            }
            case 1: {
                this.sqlOctetLength_ = maxLen;
                this.displaySize_ = maxLen;
                this.precision_ = maxLen;
                break;
            }
            case -1: 
            case 12: {
                this.sqlOctetLength_ = this.sqlDataType_ == 12 ? maxLen + 1 : maxLen + 3;
                this.displaySize_ = maxLen;
                this.precision_ = maxLen;
                break;
            }
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                if (this.sqlDataType_ != 10) break;
                this.dataType_ = 1111;
                this.precision_ = odbcPrecision;
                this.displaySize_ = maxLen;
                this.sqlOctetLength_ = maxLen;
            }
        }
        if (this.sqlDataType_ == 1 || this.sqlDataType_ == 12 || this.sqlDataType_ == -1 || this.sqlDataType_ == -601) {
            this.isCaseSensitive_ = true;
        }
        this.isSearchable_ = true;
        this.fsDataType_ = fsDataType;
        this.intLeadPrec_ = intLeadPrec;
        this.paramMode_ = paramMode;
    }

    SQLMXDesc(int noNullValue, int nullValue, int version, int dataType, short datetimeCode, int maxLen, short precision, short scale, boolean nullInfo, boolean signType, int odbcDataType, int odbcPrecision, int sqlCharset, int odbcCharset, String colName, String tableName, String catalogName, String schemaName, String headingName, int intLeadPrec, int paramMode, int fsDataType, int rowLength) {
        this(dataType, datetimeCode, maxLen, precision, scale, nullInfo, colName, signType, odbcDataType, (short)odbcPrecision, sqlCharset, odbcCharset, catalogName, schemaName, tableName, fsDataType, intLeadPrec, paramMode);
        this.noNullValue_ = noNullValue;
        this.nullValue_ = nullValue;
        this.version_ = version;
        this.headingName_ = headingName;
        this.rowLength_ = rowLength;
        this.columnLabel_ = headingName;
        this.maxLen_ = maxLen;
    }

    String getCharacterSetName() throws SQLException {
        switch (this.dataType_) {
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return InterfaceUtilities.getCharsetName(this.sqlCharset_);
            }
        }
        return null;
    }
}

