/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.sql.SQLWarning;

public abstract class SQLMXHandle {
    SQLWarning sqlWarning_;
    static final String ERROR_IDS_08_S01 = new String("ids_08_s01");
    static final String ERROR_INVALID_CONNECTION = new String("invalid_connection");
    static final String ERROR_SOCKET_WRITE_ERROR = new String("socket_write_error");
    static final String ERROR_SOCKET_READ_ERROR = new String("socket_read_error");
    static final String ERROR_SOCKET_IS_CLOSED_ERROR = new String("socket_is_closed_error");
    static final String IDS_S1_T00 = new String("ids_s1_t00");

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    void setSQLWarning(T4Properties t4props, String messageId, Object[] messageArguments) {
        SQLWarning sqlWarningLeaf = SQLMXMessages.createSQLWarning(t4props, messageId, messageArguments);
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sqlWarningLeaf;
        } else {
            this.sqlWarning_.setNextWarning(sqlWarningLeaf);
        }
    }

    void setSqlWarning(SQLWarning sqlWarning) {
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sqlWarning;
        } else {
            this.sqlWarning_.setNextWarning(sqlWarning);
        }
    }

    void performConnectionErrorChecks(SQLException se) {
        if (se instanceof SQLMXException) {
            SQLMXException sqlmx_e = (SQLMXException)se;
            if (sqlmx_e.messageId.equals(ERROR_SOCKET_WRITE_ERROR) || sqlmx_e.messageId.equals(ERROR_SOCKET_READ_ERROR) || sqlmx_e.messageId.equals(ERROR_SOCKET_IS_CLOSED_ERROR) || sqlmx_e.messageId.equals(ERROR_INVALID_CONNECTION) || sqlmx_e.messageId.equals(ERROR_IDS_08_S01) || sqlmx_e.messageId.equals(IDS_S1_T00) || sqlmx_e.getErrorCode() == -8841) {
                this.closeErroredConnection(sqlmx_e);
            }
        }
    }

    abstract void closeErroredConnection(SQLMXException var1);
}

