/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDataLocator;
import com.tandem.t4jdbc.SQLMXLobInputStream;
import com.tandem.t4jdbc.SQLMXLobOutputStream;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class SQLMXLob {
    SQLMXConnection conn_;
    String tableName_;
    long dataLocator_;
    SQLMXLobInputStream inputStream_;
    SQLMXLobOutputStream outputStream_;
    boolean isCurrent_;
    InputStream is_;
    int isLength_;
    String lobTableName_;
    int chunkSize_;
    public static final int MAX_LOB_BATCHED_ROWS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        long length = 0L;
        this.checkIfCurrent();
        this.prepareGetLobLenStmt();
        PreparedStatement preparedStatement = this.getGetLobLenStmt();
        synchronized (preparedStatement) {
            this.getGetLobLenStmt().setString(1, this.tableName_);
            this.getGetLobLenStmt().setLong(2, this.dataLocator_);
            ResultSet rs = ((SQLMXPreparedStatement)this.getGetLobLenStmt()).executeQuery();
            try {
                if (rs.next()) {
                    length = rs.getLong(1);
                }
            }
            finally {
                rs.close();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long len) throws SQLException {
        if (len < 0L) {
            Object[] messageArguments = new Object[]{"SQLMXLob.truncate(long)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        int chunkNo = (int)(len / (long)this.chunkSize_);
        int offset = (int)(len % (long)this.chunkSize_);
        this.prepareDelLobDataStmt();
        PreparedStatement preparedStatement = this.getDelLobDataStmt();
        synchronized (preparedStatement) {
            this.getDelLobDataStmt().setString(1, this.tableName_);
            this.getDelLobDataStmt().setLong(2, this.dataLocator_);
            this.getDelLobDataStmt().setInt(3, chunkNo + 1);
            this.getDelLobDataStmt().setInt(4, Integer.MAX_VALUE);
            this.getDelLobDataStmt().executeUpdate();
        }
        if (offset != 0) {
            this.prepareTrunLobDataStmt();
            preparedStatement = this.getTrunLobDataStmt();
            synchronized (preparedStatement) {
                this.getTrunLobDataStmt().setInt(1, offset);
                this.getTrunLobDataStmt().setString(2, this.tableName_);
                this.getTrunLobDataStmt().setLong(3, this.dataLocator_);
                this.getTrunLobDataStmt().setInt(4, chunkNo);
                this.getTrunLobDataStmt().executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream() throws SQLException {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inputStream_ = null;
            }
        }
        this.inputStream_ = new SQLMXLobInputStream(this.conn_, this);
        return this.inputStream_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream setOutputStream(long pos) throws SQLException {
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.outputStream_ = null;
            }
        }
        this.outputStream_ = new SQLMXLobOutputStream(this.conn_, this, pos);
        return this.outputStream_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.isCurrent_ = false;
        try {
            if (this.inputStream_ != null) {
                this.inputStream_.close();
            }
            if (this.outputStream_ != null) {
                this.outputStream_.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.inputStream_ = null;
            this.outputStream_ = null;
        }
    }

    static String convSQLExceptionToIO(SQLException e) {
        SQLException e1 = e;
        StringBuffer s = new StringBuffer(1000);
        do {
            s.append("SQLState :");
            s.append(e1.getSQLState());
            s.append(" ErrorCode :");
            s.append(e1.getErrorCode());
            s.append(" Message:");
            s.append(e1.getMessage());
        } while ((e1 = e1.getNextException()) != null);
        return s.toString();
    }

    void checkIfCurrent() throws SQLException {
        if (!this.isCurrent_) {
            Object[] messageArguments = new Object[]{this};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "lob_not_current", messageArguments);
        }
    }

    void checkAutoCommitExtTxn() throws SQLException {
        if (this.conn_.getAutoCommit()) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_lob_commit_state", null);
        }
    }

    abstract void prepareGetLobLenStmt() throws SQLException;

    abstract void prepareDelLobDataStmt() throws SQLException;

    abstract void prepareGetLobDataStmt() throws SQLException;

    abstract void prepareUpdLobDataStmt() throws SQLException;

    abstract void prepareInsLobDataStmt() throws SQLException;

    abstract void prepareTrunLobDataStmt() throws SQLException;

    abstract void prepareInsSpjLobDataStmt() throws SQLException;

    abstract void prepareInsSpjBaseDataStmt() throws SQLException;

    abstract PreparedStatement getSpjInsLobDataStmt();

    abstract PreparedStatement getSpjInsBaseDataStmt();

    abstract PreparedStatement getGetLobLenStmt();

    abstract PreparedStatement getDelLobDataStmt();

    abstract PreparedStatement getTrunLobDataStmt();

    abstract PreparedStatement getInsLobDataStmt();

    abstract PreparedStatement getUpdLobDataStmt();

    abstract PreparedStatement getGetLobDataStmt();

    SQLMXLob(SQLMXConnection connection, String tableName, long dataLocator, String lobTableName, boolean isBlob) throws SQLException {
        this.conn_ = connection;
        this.tableName_ = tableName;
        this.isCurrent_ = true;
        this.dataLocator_ = dataLocator;
        if (lobTableName != null) {
            this.lobTableName_ = lobTableName;
            this.chunkSize_ = this.conn_.getChunkSize(this.lobTableName_, isBlob);
        }
    }

    SQLMXLob(SQLMXConnection connection, String tableName, long dataLocator, InputStream x, int length, String lobTableName, boolean isBlob) throws SQLException {
        this.conn_ = connection;
        this.tableName_ = tableName;
        this.is_ = x;
        this.isLength_ = length;
        this.isCurrent_ = true;
        this.dataLocator_ = dataLocator;
        if (lobTableName != null) {
            if (connection.isCallProc_) {
                lobTableName = connection.spjBlobTableName_;
            }
            this.lobTableName_ = lobTableName;
            SQLMXDataLocator tempLoc = (SQLMXDataLocator)SQLMXConnection.lobTableToDataLoc_.get(lobTableName);
            if (tempLoc == null) {
                dataLocator = this.conn_.getDataLocator(this.lobTableName_, isBlob);
            }
            SQLMXDataLocator dataLoc = (SQLMXDataLocator)SQLMXConnection.lobTableToDataLoc_.get(lobTableName);
            this.chunkSize_ = dataLoc.chunkSize_;
        }
    }
}

