/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLMXLobInputStream
extends InputStream {
    SQLMXLob lob_;
    SQLMXConnection conn_;
    boolean isClosed_;
    byte[] chunk_;
    int currentByte_;
    int currentChunkNo_;
    int bytesRead_;

    public int available() throws IOException {
        if (this.isClosed_) {
            throw new IOException("Input stream is in closed state");
        }
        try {
            long length = this.lob_.length();
            long readLength = this.currentChunkNo_ > 0 ? (long)((this.currentChunkNo_ - 1) * this.lob_.chunkSize_ + this.currentByte_) : (long)this.currentByte_;
            return (int)(length - readLength);
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
    }

    public void close() throws IOException {
        this.isClosed_ = true;
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int retValue = 0;
        if (this.isClosed_) {
            throw new IOException("Input stream is in closed state");
        }
        if (this.currentByte_ == this.bytesRead_) {
            retValue = this.readChunkThrowIO(null, 0, this.lob_.chunkSize_);
        }
        if (retValue != -1) {
            retValue = this.chunk_[this.currentByte_];
            if (retValue < 0) {
                retValue = 256 + retValue;
            }
            if (this.currentByte_ != this.bytesRead_) {
                ++this.currentByte_;
            }
        }
        return retValue;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new IOException("Invalid input value");
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retLen;
        int tempLen = 0;
        if (this.isClosed_) {
            throw new IOException("Input stream is in closed state");
        }
        if (b == null) {
            throw new IOException("Invalid input value");
        }
        int copyLen = len;
        int copyOffset = off;
        int readLen = 0;
        if (this.currentByte_ < this.bytesRead_) {
            if (copyLen + this.currentByte_ <= this.bytesRead_) {
                System.arraycopy(this.chunk_, this.currentByte_, b, copyOffset, copyLen);
                this.currentByte_ += copyLen;
                readLen = copyLen;
                return readLen;
            }
            tempLen = this.bytesRead_ - this.currentByte_;
            System.arraycopy(this.chunk_, this.currentByte_, b, copyOffset, tempLen);
            copyOffset += tempLen;
            copyLen -= tempLen;
            this.currentByte_ += tempLen;
        }
        if ((retLen = (readLen = this.readChunkThrowIO(b, copyOffset, copyLen)) != -1 ? readLen + tempLen : tempLen) == 0) {
            return -1;
        }
        return retLen;
    }

    public void reset() throws IOException {
        if (this.isClosed_) {
            throw new IOException("Input stream is in closed state");
        }
        this.currentByte_ = 0;
        this.currentChunkNo_ = 0;
        this.bytesRead_ = 0;
    }

    public long skip(long n) throws IOException {
        int noOfChunks = 0;
        long retLen = -1L;
        long bytesSkipped = 0L;
        if (this.isClosed_) {
            throw new IOException("Input stream is in closed state");
        }
        if (n <= 0L) {
            throw new IOException("Invalid input Value");
        }
        if ((long)this.currentByte_ + n <= (long)this.bytesRead_) {
            this.currentByte_ = (int)((long)this.currentByte_ + n);
            return n;
        }
        bytesSkipped = this.bytesRead_ - this.currentByte_;
        long bytesToSkip = n - bytesSkipped;
        this.currentByte_ = (int)((long)this.currentByte_ + bytesSkipped);
        int remBytes = bytesToSkip % (long)this.lob_.chunkSize_ == 0L ? this.lob_.chunkSize_ : (int)(bytesToSkip % (long)this.lob_.chunkSize_);
        int oldChunkNo = this.currentChunkNo_;
        this.currentChunkNo_ += (noOfChunks += (int)((bytesToSkip - 1L) / (long)this.lob_.chunkSize_));
        retLen = this.readChunkThrowIO(null, 0, this.lob_.chunkSize_);
        if (retLen != -1L) {
            bytesSkipped += (long)((this.currentChunkNo_ - oldChunkNo - 1) * this.lob_.chunkSize_);
            if (retLen < (long)remBytes) {
                remBytes = (int)retLen;
            }
            this.currentByte_ = remBytes;
            bytesSkipped += (long)remBytes;
        } else {
            remBytes = (int)((bytesSkipped += (long)this.available()) - (long)(this.bytesRead_ - this.currentByte_));
            this.currentChunkNo_ = oldChunkNo + (noOfChunks += (remBytes - 1) / this.lob_.chunkSize_);
            if (remBytes == 0) {
                this.currentByte_ = 0;
                this.bytesRead_ = 0;
            } else {
                this.currentByte_ = remBytes % this.lob_.chunkSize_ == 0 ? this.lob_.chunkSize_ : remBytes % this.lob_.chunkSize_;
                this.bytesRead_ = this.currentByte_;
            }
        }
        return bytesSkipped;
    }

    int readChunkThrowIO(byte[] b, int off, int len) throws IOException {
        int readLen;
        try {
            readLen = this.readChunk(b, off, len);
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
        return readLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readChunk(byte[] b, int off, int len) throws SQLException {
        int readLen = 0;
        int rowsToRead = (len - 1) / this.lob_.chunkSize_;
        this.lob_.prepareGetLobDataStmt();
        PreparedStatement preparedStatement = this.lob_.getGetLobDataStmt();
        synchronized (preparedStatement) {
            this.lob_.getGetLobDataStmt().setString(1, this.lob_.tableName_);
            this.lob_.getGetLobDataStmt().setLong(2, this.lob_.dataLocator_);
            this.lob_.getGetLobDataStmt().setInt(3, this.currentChunkNo_);
            this.lob_.getGetLobDataStmt().setInt(4, this.currentChunkNo_ + rowsToRead);
            int copyLen = len;
            int copyOffset = off;
            ResultSet rs = this.lob_.getGetLobDataStmt().executeQuery();
            try {
                if (rowsToRead > 1) {
                    rs.setFetchSize(rowsToRead >= 8 ? 8 : rowsToRead);
                }
                while (rs.next()) {
                    byte[] data = rs.getBytes(1);
                    ++this.currentChunkNo_;
                    this.bytesRead_ = data.length;
                    if (b == null) {
                        System.arraycopy(data, 0, this.chunk_, 0, data.length);
                        readLen += data.length;
                        this.currentByte_ = 0;
                    } else {
                        if (copyLen >= data.length) {
                            System.arraycopy(data, 0, b, copyOffset, data.length);
                            copyLen -= data.length;
                            readLen += data.length;
                            copyOffset += data.length;
                            this.currentByte_ = data.length;
                            continue;
                        }
                        System.arraycopy(data, 0, b, copyOffset, copyLen);
                        System.arraycopy(data, copyLen, this.chunk_, copyLen, data.length - copyLen);
                        readLen += copyLen;
                        this.currentByte_ = copyLen;
                    }
                    break;
                }
            }
            finally {
                rs.close();
            }
        }
        if (readLen == 0) {
            return -1;
        }
        return readLen;
    }

    SQLMXLobInputStream(SQLMXConnection connection, SQLMXLob lob) {
        this.lob_ = lob;
        this.conn_ = connection;
        this.chunk_ = new byte[this.lob_.chunkSize_];
    }
}

