/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import com.tandem.t4jdbc.SQLMXMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLMXLobOutputStream
extends OutputStream {
    SQLMXLob lob_;
    long startingPos_;
    SQLMXConnection conn_;
    boolean isClosed_;
    byte[] chunk_;
    int currentByte_;
    int currentChunkNo_;
    boolean isFlushed_;
    int updChunkNo_;
    int updOffset_;

    public void close() throws IOException {
        if (!this.isClosed_) {
            this.flush();
            this.isClosed_ = true;
        }
    }

    public void flush() throws IOException {
        if (this.isClosed_) {
            throw new IOException("Output stream is in closed state");
        }
        if (!this.isFlushed_) {
            this.writeChunkThrowIO();
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new IOException("Invalid input value");
        }
        this.write(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed_) {
            throw new IOException("Output stream is in closed state");
        }
        if (b == null) {
            throw new IOException("Invalid input value");
        }
        if (off < 0 || len < 0 || off > b.length) {
            throw new IndexOutOfBoundsException("length or offset is less than 0 or offset is greater than the length of array");
        }
        srcOffset = off;
        copyLen = len;
        writesBatched = false;
        isUpdate = false;
        isInsert = false;
        if (copyLen + this.currentByte_ < 2 * this.lob_.chunkSize_) {
            writesBatched = false;
        } else {
            writesBatched = true;
            try {
                if (this.currentChunkNo_ > this.updChunkNo_) {
                    this.lob_.prepareInsLobDataStmt();
                    isInsert = true;
                } else {
                    this.lob_.prepareUpdLobDataStmt();
                    isUpdate = true;
                }
            }
            catch (SQLException e) {
                throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
            }
        }
        rowsBatched = 0;
        while (true) {
            if (copyLen + this.currentByte_ < this.lob_.chunkSize_) {
                System.arraycopy(b, srcOffset, this.chunk_, this.currentByte_, copyLen);
                this.currentByte_ += copyLen;
                break;
            }
            tempLen = this.lob_.chunkSize_ - this.currentByte_;
            System.arraycopy(b, srcOffset, this.chunk_, this.currentByte_, tempLen);
            this.currentByte_ += tempLen;
            if (writesBatched) {
                if (!isInsert && this.currentChunkNo_ <= this.updChunkNo_) {
                    try {
                        this.lob_.prepareInsLobDataStmt();
                        isInsert = true;
                    }
                    catch (SQLException e) {
                        throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
                    }
                }
                this.writeBatchChunkThrowIO();
                if (++rowsBatched >= 100) {
                    rowsBatched = 0;
                    try {
                        if (isUpdate) {
                            this.lob_.getUpdLobDataStmt().executeBatch();
                            this.lob_.getUpdLobDataStmt().clearBatch();
                        }
                        if (!isInsert) ** GOTO lbl60
                        this.lob_.getInsLobDataStmt().executeBatch();
                        this.lob_.getInsLobDataStmt().clearBatch();
                    }
                    catch (SQLException e) {
                        throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
                    }
                }
            } else {
                this.writeChunkThrowIO();
            }
lbl60:
            // 4 sources

            copyLen -= tempLen;
            srcOffset += tempLen;
            this.currentByte_ = 0;
        }
        this.isFlushed_ = false;
        if (writesBatched && rowsBatched > 0) {
            rowsBatched = 0;
            try {
                if (isUpdate) {
                    this.lob_.getUpdLobDataStmt().executeBatch();
                    this.lob_.getUpdLobDataStmt().clearBatch();
                }
                if (isInsert) {
                    this.lob_.getInsLobDataStmt().executeBatch();
                    this.lob_.getInsLobDataStmt().clearBatch();
                }
            }
            catch (SQLException e) {
                throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
            }
        }
    }

    public void write(int b) throws IOException {
        if (this.isClosed_) {
            throw new IOException("Output stream is in closed state");
        }
        this.chunk_[this.currentByte_] = (byte)b;
        this.isFlushed_ = false;
        ++this.currentByte_;
        if (this.currentByte_ == this.lob_.chunkSize_) {
            this.writeChunkThrowIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChunk() throws SQLException {
        if (this.currentChunkNo_ > this.updChunkNo_) {
            this.lob_.prepareInsLobDataStmt();
            PreparedStatement preparedStatement = this.lob_.getInsLobDataStmt();
            synchronized (preparedStatement) {
                byte[] tempChunk;
                this.lob_.getInsLobDataStmt().setString(1, this.lob_.tableName_);
                this.lob_.getInsLobDataStmt().setLong(2, this.lob_.dataLocator_);
                this.lob_.getInsLobDataStmt().setInt(3, this.currentChunkNo_);
                if (this.currentByte_ != this.lob_.chunkSize_) {
                    tempChunk = new byte[this.currentByte_];
                    System.arraycopy(this.chunk_, 0, tempChunk, 0, this.currentByte_);
                } else {
                    tempChunk = this.chunk_;
                }
                this.lob_.getInsLobDataStmt().setBytes(4, tempChunk);
                this.lob_.getInsLobDataStmt().executeUpdate();
                ++this.currentChunkNo_;
                this.currentByte_ = 0;
            }
        }
        this.lob_.prepareUpdLobDataStmt();
        PreparedStatement preparedStatement = this.lob_.getUpdLobDataStmt();
        synchronized (preparedStatement) {
            byte[] tempChunk;
            this.lob_.getUpdLobDataStmt().setString(4, this.lob_.tableName_);
            this.lob_.getUpdLobDataStmt().setLong(5, this.lob_.dataLocator_);
            this.lob_.getUpdLobDataStmt().setInt(6, this.currentChunkNo_);
            this.lob_.getUpdLobDataStmt().setInt(1, this.updOffset_);
            if (this.updOffset_ != 0 || this.currentByte_ != this.lob_.chunkSize_) {
                tempChunk = new byte[this.currentByte_ - this.updOffset_];
                System.arraycopy(this.chunk_, this.updOffset_, tempChunk, 0, this.currentByte_ - this.updOffset_);
            } else {
                tempChunk = this.chunk_;
            }
            this.lob_.getUpdLobDataStmt().setInt(3, this.currentByte_ + 1);
            this.lob_.getUpdLobDataStmt().setBytes(2, tempChunk);
            this.lob_.getUpdLobDataStmt().executeUpdate();
            ++this.currentChunkNo_;
            this.currentByte_ = 0;
            this.updOffset_ = 0;
        }
        this.isFlushed_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChunk2() throws SQLException {
        this.lob_.prepareInsSpjLobDataStmt();
        String tableName_ = "SPJ_BASE_TABLE";
        PreparedStatement preparedStatement = this.lob_.getSpjInsLobDataStmt();
        synchronized (preparedStatement) {
            byte[] tempChunk;
            this.lob_.getSpjInsLobDataStmt().setString(1, tableName_);
            this.lob_.getSpjInsLobDataStmt().setLong(2, this.lob_.dataLocator_);
            this.lob_.getSpjInsLobDataStmt().setInt(3, this.currentChunkNo_);
            if (this.currentByte_ != this.lob_.chunkSize_) {
                tempChunk = new byte[this.currentByte_];
                System.arraycopy(this.chunk_, 0, tempChunk, 0, this.currentByte_);
            } else {
                tempChunk = this.chunk_;
            }
            this.lob_.getSpjInsLobDataStmt().setBytes(4, tempChunk);
            this.lob_.getSpjInsLobDataStmt().executeUpdate();
            ++this.currentChunkNo_;
            this.currentByte_ = 0;
        }
        this.isFlushed_ = true;
    }

    void writeChunkThrowIO() throws IOException {
        try {
            this.writeChunk();
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
    }

    void writeBatchChunkThrowIO() throws IOException {
        try {
            this.writeBatchChunk();
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
    }

    void writeBatchChunk() throws SQLException {
        if (this.currentChunkNo_ > this.updChunkNo_) {
            byte[] tempChunk;
            this.lob_.getInsLobDataStmt().setString(1, this.lob_.tableName_);
            this.lob_.getInsLobDataStmt().setLong(2, this.lob_.dataLocator_);
            this.lob_.getInsLobDataStmt().setInt(3, this.currentChunkNo_);
            if (this.currentByte_ != this.lob_.chunkSize_) {
                tempChunk = new byte[this.currentByte_];
                System.arraycopy(this.chunk_, 0, tempChunk, 0, this.currentByte_);
            } else {
                tempChunk = this.chunk_;
            }
            this.lob_.getInsLobDataStmt().setBytes(4, tempChunk);
            this.lob_.getInsLobDataStmt().addBatch();
            ++this.currentChunkNo_;
            this.currentByte_ = 0;
        } else {
            byte[] tempChunk;
            this.lob_.getUpdLobDataStmt().setString(4, this.lob_.tableName_);
            this.lob_.getUpdLobDataStmt().setLong(5, this.lob_.dataLocator_);
            this.lob_.getUpdLobDataStmt().setInt(6, this.currentChunkNo_);
            this.lob_.getUpdLobDataStmt().setInt(1, this.updOffset_);
            if (this.updOffset_ != 0 || this.currentByte_ != this.lob_.chunkSize_) {
                tempChunk = new byte[this.currentByte_ - this.updOffset_];
                System.arraycopy(this.chunk_, this.updOffset_, tempChunk, 0, this.currentByte_ - this.updOffset_);
            } else {
                tempChunk = this.chunk_;
            }
            this.lob_.getUpdLobDataStmt().setInt(3, this.currentByte_ + 1);
            this.lob_.getUpdLobDataStmt().setBytes(2, tempChunk);
            this.lob_.getUpdLobDataStmt().addBatch();
            ++this.currentChunkNo_;
            this.currentByte_ = 0;
            this.updOffset_ = 0;
        }
        this.isFlushed_ = true;
    }

    void populate(InputStream is, int length) throws SQLException {
        block21: {
            boolean isInsert = false;
            boolean isUpdate = false;
            int readLen = length;
            try {
                if (readLen <= 0) break block21;
                if (this.currentChunkNo_ > this.updChunkNo_) {
                    this.lob_.prepareInsLobDataStmt();
                    isInsert = true;
                } else {
                    this.lob_.prepareUpdLobDataStmt();
                    isUpdate = true;
                }
                int rowsBatched = 0;
                while (readLen > 0) {
                    int tempLen;
                    int retLen;
                    if (!isInsert && this.currentChunkNo_ <= this.updChunkNo_) {
                        this.lob_.prepareInsLobDataStmt();
                        isInsert = true;
                    }
                    if ((retLen = is.read(this.chunk_, 0, tempLen = readLen <= this.lob_.chunkSize_ ? readLen : this.lob_.chunkSize_)) == -1) break;
                    this.currentByte_ = retLen;
                    try {
                        this.writeBatchChunk();
                        if (++rowsBatched >= 100) {
                            rowsBatched = 0;
                            if (isUpdate) {
                                this.lob_.getUpdLobDataStmt().executeBatch();
                                this.lob_.getUpdLobDataStmt().clearBatch();
                            }
                            if (isInsert) {
                                this.lob_.getInsLobDataStmt().executeBatch();
                                this.lob_.getInsLobDataStmt().clearBatch();
                            }
                        }
                    }
                    catch (SQLException se) {
                        if (isInsert) {
                            this.lob_.getInsLobDataStmt().clearBatch();
                        }
                        if (isUpdate) {
                            this.lob_.getUpdLobDataStmt().clearBatch();
                        }
                        throw se;
                    }
                    readLen -= retLen;
                }
                if (rowsBatched > 0) {
                    rowsBatched = 0;
                    if (isUpdate) {
                        this.lob_.getUpdLobDataStmt().executeBatch();
                        this.lob_.getUpdLobDataStmt().clearBatch();
                    }
                    if (isInsert) {
                        this.lob_.getInsLobDataStmt().executeBatch();
                        this.lob_.getInsLobDataStmt().clearBatch();
                    }
                }
            }
            catch (IOException e) {
                Object[] messageArguments = new Object[]{e.getMessage()};
                throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "io_exception", messageArguments);
            }
            finally {
                if (isInsert) {
                    this.lob_.getInsLobDataStmt().clearBatch();
                }
                if (isUpdate) {
                    this.lob_.getUpdLobDataStmt().clearBatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populate2(InputStream is, int length) throws SQLException {
        block6: {
            boolean isInsert = false;
            boolean isUpdate = false;
            try {
                int tempLen;
                int retLen;
                int readLen;
                if (readLen <= 0) break block6;
                this.lob_.prepareInsSpjBaseDataStmt();
                PreparedStatement preparedStatement = this.lob_.getSpjInsBaseDataStmt();
                synchronized (preparedStatement) {
                    this.lob_.getSpjInsBaseDataStmt().setLong(1, this.lob_.dataLocator_);
                    this.lob_.getSpjInsBaseDataStmt().executeUpdate();
                }
                for (readLen = length; readLen > 0 && (retLen = is.read(this.chunk_, 0, tempLen = readLen <= this.lob_.chunkSize_ ? readLen : this.lob_.chunkSize_)) != -1; readLen -= retLen) {
                    this.currentByte_ = retLen;
                    this.writeChunk2();
                }
            }
            catch (IOException e) {
                Object[] messageArguments = new Object[]{e.getMessage()};
                throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "io_exception", messageArguments);
            }
        }
    }

    SQLMXLobOutputStream(SQLMXConnection connection, SQLMXLob lob, long pos) throws SQLException {
        this.lob_ = lob;
        long length = this.lob_.length();
        this.conn_ = connection;
        if (pos < 1L || pos > length + 1L) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_position_value", null);
        }
        this.startingPos_ = pos;
        this.chunk_ = new byte[this.lob_.chunkSize_];
        this.isFlushed_ = false;
        this.updChunkNo_ = length == 0L ? -1 : (length % (long)this.lob_.chunkSize_ == 0L ? (int)(length / (long)this.lob_.chunkSize_) - 1 : (int)(length / (long)this.lob_.chunkSize_));
        this.currentChunkNo_ = (int)((pos - 1L) / (long)this.lob_.chunkSize_);
        this.currentByte_ = (int)((pos - 1L) % (long)this.lob_.chunkSize_);
        this.updOffset_ = (int)((pos - 1L) % (long)this.lob_.chunkSize_);
    }
}

