/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CachedPreparedStatement;
import com.tandem.t4jdbc.SQLMXBlob;
import com.tandem.t4jdbc.SQLMXClob;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDesc;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXParameterMetaData;
import com.tandem.t4jdbc.SQLMXResultSet;
import com.tandem.t4jdbc.SQLMXResultSetMetaData;
import com.tandem.t4jdbc.SQLMXStatement;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXPreparedStatement
extends SQLMXStatement
implements PreparedStatement {
    ArrayList keyColumns = null;
    int paramRowCount_;
    boolean ExecuteBatchDone_ = false;
    String moduleName_;
    int moduleVersion_;
    long moduleTimestamp_;
    boolean isAnyLob_;
    ArrayList lobObjects_;
    ArrayList rowsValue_;
    Object[] paramsValue_;
    public static final short TYPE_UNKNOWN = 0;
    public static final short TYPE_SELECT = 1;
    public static final short TYPE_UPDATE = 2;
    public static final short TYPE_DELETE = 4;
    public static final short TYPE_INSERT = 8;
    public static final short TYPE_EXPLAIN = 16;
    public static final short TYPE_CREATE = 32;
    public static final short TYPE_GRANT = 64;
    public static final short TYPE_DROP = 128;
    public static final short TYPE_INSERT_PARAM = 256;
    public static final short TYPE_SELECT_CATALOG = 512;
    public static final short TYPE_SMD = 1024;
    public static final short TYPE_CALL = 2048;
    public static final short TYPE_STATS = 4096;
    public static final short TYPE_CONFIG = 8192;
    public static final int SQL_OTHER = -1;
    public static final int SQL_UNKNOWN = 0;
    public static final int SQL_SELECT_UNIQUE = 1;
    public static final int SQL_SELECT_NON_UNIQUE = 2;
    public static final int SQL_INSERT_UNIQUE = 3;
    public static final int SQL_INSERT_NON_UNIQUE = 4;
    public static final int SQL_UPDATE_UNIQUE = 5;
    public static final int SQL_UPDATE_NON_UNIQUE = 6;
    public static final int SQL_DELETE_UNIQUE = 7;
    public static final int SQL_DELETE_NON_UNIQUE = 8;
    public static final int SQL_CONTROL = 9;
    public static final int SQL_SET_TRANSACTION = 10;
    public static final int SQL_SET_CATALOG = 11;
    public static final int SQL_SET_SCHEMA = 12;
    public static final int SQL_CREATE_TABLE = 13;
    public static final int SQL_CREATE_VIEW = 14;
    public static final int SQL_CREATE_INDEX = 15;
    public static final int SQL_CREATE_UNIQUE_INDEX = 16;
    public static final int SQL_CREATE_SYNONYM = 17;
    public static final int SQL_CREATE_VOLATILE_TABLE = 18;
    public static final int SQL_CREATE_MV = 19;
    public static final int SQL_CREATE_MVG = 20;
    public static final int SQL_CREATE_MP_ALIAS = 21;
    public static final int SQL_CREATE_PROCEDURE = 22;
    public static final int SQL_CREATE_TRIGGER = 23;
    public static final int SQL_CREATE_SET_TABLE = 24;
    public static final int SQL_CREATE_MULTISET_TABLE = 25;
    public static final int SQL_DROP_TABLE = 26;
    public static final int SQL_DROP_VIEW = 27;
    public static final int SQL_DROP_INDEX = 28;
    public static final int SQL_DROP_SYNONYM = 29;
    public static final int SQL_DROP_VOLATILE_TABLE = 30;
    public static final int SQL_DROP_MV = 31;
    public static final int SQL_DROP_MVG = 32;
    public static final int SQL_DROP_MP_ALIAS = 33;
    public static final int SQL_DROP_PROCEDURE = 34;
    public static final int SQL_DROP_TRIGGER = 35;
    public static final int SQL_DROP_SET_TABLE = 36;
    public static final int SQL_DROP_MULTISET_TABLE = 37;
    public static final int SQL_ALTER_TABLE = 38;
    public static final int SQL_ALTER_INDEX = 39;
    public static final int SQL_ALTER_TRIGGER = 40;
    public static final int SQL_ALTER_MP_ALIAS = 41;

    public void addBatch() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "addBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("addBatch");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.ExecuteBatchDone_) {
            this.rowsValue_.clear();
            this.paramRowCount_ = 0;
            this.ExecuteBatchDone_ = false;
        }
        if (this.inputDesc_ == null) {
            return;
        }
        this.checkIfAllParamsSet();
        if (this.rowsValue_ == null) {
            this.rowsValue_ = new ArrayList();
        }
        this.rowsValue_.add(this.paramsValue_);
        ++this.paramRowCount_;
        this.paramsValue_ = new Object[this.inputDesc_.length];
        if (this.isAnyLob_ && this.lobObjects_ == null) {
            this.lobObjects_ = new ArrayList();
        }
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            if (this.inputDesc_[i].paramValue_ != null) {
                this.lobObjects_.add(this.inputDesc_[i].paramValue_);
                this.inputDesc_[i].paramValue_ = null;
            }
            this.inputDesc_[i].isValueSet_ = false;
        }
    }

    public void clearBatch() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "clearBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("clearBatch");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.inputDesc_ == null) {
            return;
        }
        if (this.rowsValue_ != null) {
            this.rowsValue_.clear();
        }
        if (this.lobObjects_ != null) {
            this.lobObjects_.clear();
        }
        this.paramRowCount_ = 0;
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            this.inputDesc_[i].isValueSet_ = false;
            this.paramsValue_[i] = null;
            this.inputDesc_[i].paramValue_ = null;
        }
        this.isAnyLob_ = false;
        this.batchRowCount_ = new int[0];
    }

    public void clearParameters() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "clearParameters", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("clearParameters");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.inputDesc_ == null) {
            return;
        }
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            this.inputDesc_[i].isValueSet_ = false;
            this.paramsValue_[i] = null;
            this.inputDesc_[i].paramValue_ = null;
        }
        this.isAnyLob_ = false;
    }

    public synchronized void close() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "close", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            return;
        }
        try {
            if (!this.connection_._isClosed()) {
                if (!this.connection_.isStatementCachingEnabled()) {
                    super.close();
                } else {
                    SQLMXConnection psmgr = this.connection_;
                    Iterator iter = psmgr.prepStmtsInCache_.values().iterator();
                    boolean cached = false;
                    while (iter.hasNext()) {
                        if (this != ((CachedPreparedStatement)iter.next()).getPreparedStatement()) continue;
                        cached = true;
                        break;
                    }
                    if (cached) {
                        this.logicalClose();
                    } else {
                        super.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
        finally {
            this.isClosed_ = true;
            if (!this.connection_.isStatementCachingEnabled()) {
                this.connection_.removeElement(this.pRef_);
            }
        }
    }

    public synchronized boolean execute() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "execute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("execute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        this.validateExecuteInvocation();
        if (this.isAnyLob_ && this.connection_.getAutoCommit()) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_lob_commit_state", null);
        }
        if (this.inputDesc_ != null) {
            if (!this.usingRawRowset_) {
                valueArray = this.getValueArray();
            }
            inDescLength = this.inputDesc_.length;
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.execute(this.paramRowCount_ + 1, inDescLength, valueArray, this.queryTimeout_, this.isAnyLob_);
        if (this.resultSet_ != null && this.resultSet_[this.result_set_offset] != null) {
            return true;
        }
        if (this.isAnyLob_) {
            this.populateLobObjects();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        Object temp;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "executeBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("executeBatch");
            T4LogFormatter lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println((String)temp);
        }
        try {
            int prc;
            SQLMXException se;
            this.clearWarnings();
            Object[] valueArray = null;
            if (this.inputDesc_ == null) {
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "batch_command_failed", null);
                throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
            }
            if (this.sqlStmtType_ == 1) {
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "select_in_batch_not_supported", null);
                throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
            }
            if (this.connection_._isClosed()) {
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_connection", null);
                this.connection_.closeErroredConnection(se);
                throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
            }
            if (this.isAnyLob_ && this.connection_.getAutoCommit()) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_lob_commit_state", null);
            }
            int n = prc = this.usingRawRowset_ ? this.paramRowCount_ + 1 : this.paramRowCount_;
            if (this.paramRowCount_ < 1 && !this.connection_.props_.getDelayedErrorMode()) {
                temp = new int[0];
                return temp;
            }
            if (!this.connection_.getAutoCommit()) {
                this.connection_.isActiveTrans = true;
            }
            try {
                if (!this.usingRawRowset_) {
                    valueArray = this.getValueArray();
                }
                this.execute(prc, this.inputDesc_.length, valueArray, this.queryTimeout_, this.lobObjects_ != null);
                this.populateBatchLobObjects();
            }
            catch (SQLException e) {
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "batch_command_failed", null);
                if (this.batchRowCount_ == null) {
                    this.batchRowCount_ = new int[this.paramRowCount_];
                    Arrays.fill(this.batchRowCount_, -3);
                }
                BatchUpdateException be = new BatchUpdateException(se.getMessage(), se.getSQLState(), this.batchRowCount_);
                be.setNextException(e);
                throw be;
            }
            this.ExecuteBatchDone_ = true;
            int[] nArray = this.batchRowCount_;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "executeQuery", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("executeQuery");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        this.validateExecuteInvocation();
        if (this.sqlStmtType_ != 1) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "non_select_invalid", null);
        }
        if (this.inputDesc_ != null) {
            if (!this.usingRawRowset_) {
                valueArray = this.getValueArray();
            }
            inDescLength = this.inputDesc_.length;
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.execute(this.paramRowCount_ + 1, inDescLength, valueArray, this.queryTimeout_, this.isAnyLob_);
        return this.resultSet_[this.result_set_offset];
    }

    public synchronized int executeUpdate() throws SQLException {
        long count = this.executeUpdate64();
        if (count > Integer.MAX_VALUE) {
            this.setSQLWarning(null, "numeric_out_of_range", null);
        }
        return (int)count;
    }

    public long executeUpdate64() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        this.validateExecuteInvocation();
        if (this.sqlStmtType_ == 1 && !this.ist_.stmtIsLock) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "select_invalid", null);
        }
        if (!this.usingRawRowset_) {
            if (this.inputDesc_ != null) {
                if (!this.usingRawRowset_) {
                    valueArray = this.getValueArray();
                }
                inDescLength = this.inputDesc_.length;
            }
        } else {
            valueArray = this.paramsValue_;
            --this.paramRowCount_;
        }
        if (this.isAnyLob_ && this.connection_.getAutoCommit()) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_lob_commit_state", null);
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.execute(this.paramRowCount_ + 1, inDescLength, valueArray, this.queryTimeout_, this.isAnyLob_);
        if (this.isAnyLob_) {
            this.populateLobObjects();
        }
        return this.ist_.getRowCount();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "getMetaData", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("getMetaData");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.outputDesc_ != null) {
            return new SQLMXResultSetMetaData(this, this.outputDesc_);
        }
        return null;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "getParameterMetaData", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("getParameterMetaData");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.inputDesc_ != null) {
            return new SQLMXParameterMetaData(this, this.inputDesc_);
        }
        return null;
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "setArray()");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                long dataLocator = this.connection_.getDataLocator(this.connection_.clobTableName_, false);
                SQLMXClob clob = new SQLMXClob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, x, length);
                this.inputDesc_[parameterIndex - 1].paramValue_ = clob;
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case 2004: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                byte[] buffer = new byte[length];
                try {
                    x.read(buffer);
                }
                catch (IOException e) {
                    Object[] messageArguments = new Object[]{e.getMessage()};
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
                }
                try {
                    this.addParamValue(parameterIndex, new String(buffer, "ASCII"));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    Object[] messageArguments = new Object[]{e.getMessage()};
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", messageArguments);
                }
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
            }
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        if (x != null) {
            if (this.inputDesc_[parameterIndex - 1].dataType_ == 2 || this.inputDesc_[parameterIndex - 1].dataType_ == 3) {
                x = Utility.setScale(x, this.inputDesc_[parameterIndex - 1].scale_, this.roundingMode_);
            }
            Utility.checkDecimalTruncation(parameterIndex, this.connection_.getLocale(), x, this.inputDesc_[parameterIndex - 1].precision_, this.inputDesc_[parameterIndex - 1].scale_);
            this.addParamValue(parameterIndex, x.toString());
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setBinaryStream", "setBinaryStream", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
            case 2004: {
                SQLMXBlob blob;
                long dataLocator;
                if (this.connection_.isCallProc_) {
                    dataLocator = this.connection_.getDataLocator(this.connection_.spjBlobTableName_, true);
                    blob = new SQLMXBlob(this.connection_, this.connection_.spjBaseTableName_, dataLocator, x, length);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                } else {
                    dataLocator = this.connection_.getDataLocator(this.connection_.blobTableName_, true);
                    blob = new SQLMXBlob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, x, length);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                }
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                byte[] buffer2 = new byte[length];
                try {
                    int temp = x.read(buffer2);
                }
                catch (IOException e) {
                    Object[] messageArguments = new Object[]{e.getMessage()};
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
                }
                this.addParamValue(parameterIndex, buffer2);
                break;
            }
            default: {
                byte[] buffer = new byte[length];
                try {
                    x.read(buffer);
                }
                catch (IOException e) {
                    Object[] messageArguments = new Object[]{e.getMessage()};
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
                }
                this.addParamValue(parameterIndex, buffer);
            }
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2004: {
                SQLMXBlob blob;
                long dataLocator;
                if (this.connection_.isCallProc_) {
                    dataLocator = this.connection_.getDataLocator(this.connection_.spjBlobTableName_, true);
                    blob = new SQLMXBlob(this.connection_, this.connection_.spjBaseTableName_, dataLocator, x);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                } else {
                    dataLocator = this.connection_.getDataLocator(this.connection_.blobTableName_, true);
                    blob = new SQLMXBlob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, x);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                }
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
            }
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        if (x) {
            this.addParamValue(parameterIndex, "1");
        } else {
            this.addParamValue(parameterIndex, "0");
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (int)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setByte", "setByte", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (int)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        this.addParamValue(parameterIndex, Byte.toString(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (x == null) {
            this.setNull(parameterIndex, -4);
            return;
        }
        byte[] tmpArray = new byte[x.length];
        System.arraycopy(x, 0, tmpArray, 0, x.length);
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2004: {
                long dataLocator;
                if (this.connection_.isCallProc_) {
                    dataLocator = this.connection_.getDataLocator(this.connection_.spjBlobTableName_, true);
                    SQLMXBlob blob = new SQLMXBlob(this.connection_, this.connection_.spjBaseTableName_, dataLocator, x);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                } else {
                    dataLocator = this.connection_.getDataLocator(this.connection_.blobTableName_, true);
                    SQLMXBlob blob = new SQLMXBlob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, tmpArray);
                    this.inputDesc_[parameterIndex - 1].paramValue_ = blob;
                }
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                this.addParamValue(parameterIndex, tmpArray);
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)reader, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)reader, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                long dataLocator = this.connection_.getDataLocator(this.connection_.clobTableName_, false);
                SQLMXClob clob = new SQLMXClob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, reader, length);
                this.inputDesc_[parameterIndex - 1].paramValue_ = clob;
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case 2004: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
            }
            default: {
                char[] value = new char[length];
                try {
                    int tempReadLen;
                    int valuePos;
                    if (valuePos < 1) {
                        Object[] messageArguments = new Object[]{"No data to read from the Reader"};
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
                    }
                    for (valuePos = reader.read(value); valuePos < length; valuePos += tempReadLen) {
                        char[] temp = new char[length - valuePos];
                        tempReadLen = reader.read(temp, 0, length - valuePos);
                        System.arraycopy(temp, 0, value, valuePos, tempReadLen);
                    }
                }
                catch (IOException e) {
                    Object[] messageArguments = new Object[]{e.getMessage()};
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
                }
                this.addParamValue(parameterIndex, new String(value));
            }
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (x == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                long dataLocator = this.connection_.getDataLocator(this.connection_.clobTableName_, false);
                SQLMXClob clob = new SQLMXClob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, x);
                this.inputDesc_[parameterIndex - 1].paramValue_ = clob;
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            if (dataType == 93) {
                Timestamp t1 = new Timestamp(x.getTime());
                this.addParamValue(parameterIndex, t1.toString());
            } else {
                this.addParamValue(parameterIndex, x.toString());
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        java.util.Date adjustDate = null;
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            if (cal != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(x);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(x);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                java.util.Date date = adjustDate = timeZoneOffset == 0L || x == null ? x : new Date(x.getTime() + timeZoneOffset);
            }
            if (dataType == 93) {
                Timestamp t1 = new Timestamp(adjustDate.getTime());
                this.addParamValue(parameterIndex, t1.toString());
            } else {
                this.addParamValue(parameterIndex, ((Date)adjustDate).toString());
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        if (this.inputDesc_[parameterIndex - 1].dataType_ == 2 || this.inputDesc_[parameterIndex - 1].dataType_ == 3) {
            x = Utility.setScale(new BigDecimal(x), this.inputDesc_[parameterIndex - 1].scale_, this.roundingMode_).doubleValue();
        }
        this.addParamValue(parameterIndex, Double.toString(x));
        this.inputDesc_[parameterIndex - 1].isValueSet_ = true;
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        if (this.inputDesc_[parameterIndex - 1].dataType_ == 2 || this.inputDesc_[parameterIndex - 1].dataType_ == 3) {
            x = Utility.setScale(new BigDecimal(x), this.inputDesc_[parameterIndex - 1].scale_, this.roundingMode_).floatValue();
        }
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        this.addParamValue(parameterIndex, Float.toString(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        this.addParamValue(parameterIndex, Integer.toString(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        Utility.checkLongBoundary(this.connection_.getLocale(), BigDecimal.valueOf(x));
        this.addParamValue(parameterIndex, Long.toString(x));
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.addParamValue(parameterIndex, null);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, paramIndex, sqlType, (Object)typeName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, paramIndex, sqlType, (Object)typeName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.setNull(paramIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, x.toString());
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof BigInteger) {
            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x));
        } else {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "object_type_not_supported", null);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x, targetSqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x, targetSqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x, targetSqlType, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x, targetSqlType, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Locale locale = this.connection_.getLocale();
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else {
            switch (targetSqlType) {
                case -1: 
                case 1: 
                case 12: {
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(parameterIndex, (byte[])x);
                    break;
                }
                case 93: {
                    if (x instanceof Timestamp) {
                        this.setTimestamp(parameterIndex, (Timestamp)x);
                        break;
                    }
                    if (x instanceof Date) {
                        this.setTimestamp(parameterIndex, Timestamp.valueOf(x.toString() + " 00:00:00.0"));
                        break;
                    }
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case 92: {
                    if (x instanceof Time) {
                        this.setTime(parameterIndex, (Time)x);
                        break;
                    }
                    if (x instanceof Date) {
                        this.setTime(parameterIndex, new Time(((Date)x).getTime()));
                        break;
                    }
                    if (x instanceof Timestamp) {
                        this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                        break;
                    }
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                case 91: {
                    try {
                        if (x instanceof Date) {
                            this.setDate(parameterIndex, (Date)x);
                            break;
                        }
                        if (x instanceof Time) {
                            this.setDate(parameterIndex, new Date(((Time)x).getTime()));
                            break;
                        }
                        if (x instanceof Timestamp) {
                            this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                            break;
                        }
                        this.setDate(parameterIndex, Date.valueOf(x.toString()));
                        break;
                    }
                    catch (IllegalArgumentException iex) {
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_value", x.toString());
                    }
                }
                case -7: {
                    x = x.toString().equalsIgnoreCase("1") || x.toString().equalsIgnoreCase("true") ? "TRUE" : "FALSE";
                    this.setBoolean(parameterIndex, Boolean.valueOf(x.toString()));
                    break;
                }
                case 16: {
                    this.setBoolean(parameterIndex, Boolean.valueOf(x.toString()));
                    break;
                }
                case 5: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    Utility.checkShortBoundary(locale, tmpbd);
                    Utility.checkLongTruncation(parameterIndex, tmpbd);
                    this.setShort(parameterIndex, tmpbd.shortValue());
                    break;
                }
                case 4: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    Utility.checkLongTruncation(parameterIndex, tmpbd);
                    Utility.checkIntegerBoundary(locale, tmpbd);
                    this.setInt(parameterIndex, tmpbd.intValue());
                    break;
                }
                case -5: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    Utility.checkLongBoundary(locale, tmpbd);
                    Utility.checkLongTruncation(parameterIndex, tmpbd);
                    this.setLong(parameterIndex, tmpbd.longValue());
                    break;
                }
                case 3: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    tmpbd = Utility.setScale(tmpbd, scale, 6);
                    this.setBigDecimal(parameterIndex, tmpbd);
                    break;
                }
                case 2: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    tmpbd = Utility.setScale(tmpbd, scale, 6);
                    this.setBigDecimal(parameterIndex, tmpbd);
                    break;
                }
                case -6: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    tmpbd = Utility.setScale(tmpbd, scale, this.roundingMode_);
                    Utility.checkTinyintBoundary(locale, tmpbd);
                    this.setShort(parameterIndex, tmpbd.shortValue());
                    break;
                }
                case 6: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    Utility.checkFloatBoundary(locale, tmpbd);
                    this.setDouble(parameterIndex, tmpbd.doubleValue());
                    break;
                }
                case 8: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    Utility.checkDoubleBoundary(locale, tmpbd);
                    this.setDouble(parameterIndex, tmpbd.doubleValue());
                    break;
                }
                case 7: {
                    BigDecimal tmpbd = Utility.getBigDecimalValue(locale, x);
                    this.setFloat(parameterIndex, tmpbd.floatValue());
                    break;
                }
                case 2005: {
                    if (x instanceof Clob) {
                        this.setClob(parameterIndex, (Clob)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.addParamValue(parameterIndex, (Long)x);
                        break;
                    }
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "conversion_not_allowed", null);
                }
                case 2004: {
                    if (x instanceof Blob) {
                        this.setBlob(parameterIndex, (Blob)x);
                        break;
                    }
                    if (x instanceof Long) {
                        this.addParamValue(parameterIndex, (Long)x);
                        break;
                    }
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "conversion_not_allowed", null);
                }
                case 1111: {
                    if (this.inputDesc_[parameterIndex - 1].fsDataType_ == 10) {
                        if (x instanceof byte[]) {
                            this.addParamValue(parameterIndex, x);
                            break;
                        }
                        if (x instanceof String) {
                            this.addParamValue(parameterIndex, x);
                            break;
                        }
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "conversion_not_allowed", null);
                    }
                    if (this.inputDesc_[parameterIndex - 1].fsDataType_ != 9) break;
                    if (x instanceof byte[]) {
                        this.addParamValue(parameterIndex, x);
                        break;
                    }
                    if (x instanceof String) {
                        this.addParamValue(parameterIndex, x);
                        break;
                    }
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "conversion_not_allowed", null);
                }
                default: {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "object_type_not_supported", null);
                }
            }
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, i, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, i, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(i);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "setRef()");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (int)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (int)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        this.addParamValue(parameterIndex, Short.toString(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 1111: {
                this.addParamValue(parameterIndex, x);
                break;
            }
            case 93: {
                boolean chkValid = this.isValidDate(x);
                if (!chkValid) {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "set_time_stamp_for_prep_stmt_error", null);
                }
                this.addParamValue(parameterIndex, x);
                break;
            }
            case 2005: {
                long dataLocator = this.connection_.getDataLocator(this.connection_.clobTableName_, false);
                SQLMXClob clob = new SQLMXClob(this.connection_, this.inputDesc_[parameterIndex - 1].tableName_, dataLocator, x);
                this.inputDesc_[parameterIndex - 1].paramValue_ = clob;
                this.isAnyLob_ = true;
                this.addParamValue(parameterIndex, new Long(dataLocator));
                break;
            }
            case -2: 
            case 70: 
            case 2000: 
            case 2003: 
            case 2006: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "datatype_not_supported", null);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (x != null) {
                    x = x.trim();
                }
                this.setObject(parameterIndex, (Object)x, dataType);
                break;
            }
            case -7: 
            case -4: 
            case -3: 
            case 0: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 2004: {
                this.setObject(parameterIndex, (Object)x, dataType);
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "fetch_output_inconsistent", null);
            }
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            if (dataType == 93) {
                Timestamp t1 = new Timestamp(x.getTime());
                this.addParamValue(parameterIndex, t1.toString());
            } else {
                this.addParamValue(parameterIndex, x.toString());
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        java.util.Date adjustTime = null;
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            if (cal != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(x);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(x);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                java.util.Date date = adjustTime = timeZoneOffset == 0L || x == null ? x : new Time(x.getTime() + timeZoneOffset);
            }
            if (dataType == 93) {
                Timestamp t1 = new Timestamp(adjustTime.getTime());
                this.addParamValue(parameterIndex, t1.toString());
            } else {
                this.addParamValue(parameterIndex, ((Time)adjustTime).toString());
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            switch (dataType) {
                case 91: {
                    Date d1 = new Date(x.getTime());
                    this.addParamValue(parameterIndex, d1.toString());
                    break;
                }
                case 92: {
                    Time t1 = new Time(x.getTime());
                    this.addParamValue(parameterIndex, t1.toString());
                    break;
                }
                default: {
                    this.addParamValue(parameterIndex, x.toString());
                    break;
                }
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Timestamp adjustedTimestamp = null;
        this.validateSetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        if (x != null) {
            switch (dataType) {
                case 91: {
                    Date d1 = new Date(x.getTime());
                    this.addParamValue(parameterIndex, d1.toString());
                    break;
                }
                case 92: {
                    Time t1 = new Time(x.getTime());
                    this.addParamValue(parameterIndex, t1.toString());
                    break;
                }
                default: {
                    if (cal != null) {
                        Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                        targetCalendar.clear();
                        targetCalendar.setTime(x);
                        Calendar defaultCalendar = Calendar.getInstance();
                        defaultCalendar.clear();
                        defaultCalendar.setTime(x);
                        long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                        Timestamp timestamp = adjustedTimestamp = timeZoneOffset == 0L || x == null ? x : new Timestamp(x.getTime() + timeZoneOffset);
                        if (x != null) {
                            adjustedTimestamp.setNanos(x.getNanos());
                        }
                    }
                    this.addParamValue(parameterIndex, adjustedTimestamp.toString());
                    break;
                }
            }
        } else {
            this.addParamValue(parameterIndex, null);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setUnicodeStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setUnicodeStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        byte[] buffer = new byte[length];
        this.validateSetInvocation(parameterIndex);
        if (x == null) {
            this.addParamValue(parameterIndex, null);
        } else {
            int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
            switch (dataType) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_datatype_for_column", null);
                }
            }
            try {
                x.read(buffer, 0, length);
            }
            catch (IOException e) {
                Object[] messageArguments = new Object[]{e.getMessage()};
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
            }
            try {
                String s = new String(buffer, "UnicodeBig");
                this.addParamValue(parameterIndex, s);
            }
            catch (UnsupportedEncodingException e) {
                Object[] messageArguments = new Object[]{e.getMessage()};
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", messageArguments);
            }
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateSetInvocation(parameterIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "setURL()");
    }

    public void setDataBuffer(int numRows, ByteBuffer buffer) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, numRows, (Object)buffer);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setDataBuffer", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, numRows, (Object)buffer);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setDataBuffer");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.usingRawRowset_ = true;
        this.paramRowCount_ = numRows;
        this.rowwiseRowsetBuffer_ = buffer;
    }

    protected void validateExecuteInvocation() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "validateExecuteInvocation", "", p);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "stmt_closed", null);
        }
        this.connection_.isConnectionOpen();
        for (int i = 0; i < this.num_result_sets_; ++i) {
            if (this.resultSet_[i] == null) continue;
            this.resultSet_[i].close();
        }
        if (this.paramRowCount_ > 0 && !this.usingRawRowset_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "function_sequence_error", null);
        }
        if (!this.usingRawRowset_) {
            this.checkIfAllParamsSet();
        }
    }

    private void checkIfAllParamsSet() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "checkIfAllParamsSet", "", p);
        }
        if (this.inputDesc_ == null) {
            return;
        }
        for (int paramNumber = 0; paramNumber < this.inputDesc_.length; ++paramNumber) {
            if (this.inputDesc_[paramNumber].isValueSet_) continue;
            Object[] messageArguments = new Object[]{new Integer(paramNumber + 1), new Integer(this.paramRowCount_ + 1)};
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "parameter_not_set", messageArguments);
        }
    }

    private void validateSetInvocation(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "validateSetInvocation", "", p);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "stmt_closed", null);
        }
        this.connection_.isConnectionOpen();
        if (this.inputDesc_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_index", null);
        }
        if (parameterIndex < 1 || parameterIndex > this.inputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_index", null);
        }
        if (this.inputDesc_[parameterIndex - 1].paramMode_ == 4) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "is_a_output_parameter", null);
        }
    }

    void addParamValue(int parameterIndex, Object x) {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "addParamValue", "", p);
        }
        this.paramsValue_[parameterIndex - 1] = x;
        this.inputDesc_[parameterIndex - 1].isValueSet_ = true;
    }

    Object[] getValueArray() {
        Object[] valueArray;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "getValueArray", "", p);
        }
        if (this.paramRowCount_ > 0) {
            valueArray = new Object[(this.paramRowCount_ + 1) * this.inputDesc_.length];
            int length = this.rowsValue_.size();
            int index = 0;
            for (int i = 0; i < length; ++i) {
                Object[] rows = (Object[])this.rowsValue_.get(i);
                int j = 0;
                while (j < rows.length) {
                    valueArray[index] = rows[j];
                    ++j;
                    ++index;
                }
            }
        } else {
            valueArray = this.paramsValue_;
        }
        return valueArray;
    }

    void logicalClose() throws SQLException {
        int i;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "logicalClose", "", p);
        }
        this.isClosed_ = true;
        if (this.rowsValue_ != null) {
            this.rowsValue_.clear();
        }
        if (this.lobObjects_ != null) {
            this.lobObjects_.clear();
        }
        this.paramRowCount_ = 0;
        for (i = 0; i < this.num_result_sets_; ++i) {
            if (this.resultSet_[i] == null) continue;
            this.resultSet_[i].close();
        }
        this.result_set_offset = 0;
        this.resultSet_[this.result_set_offset] = null;
        if (this.inputDesc_ != null) {
            for (i = 0; i < this.inputDesc_.length; ++i) {
                this.inputDesc_[i].isValueSet_ = false;
                this.paramsValue_[i] = null;
            }
        }
        this.isAnyLob_ = false;
        if (!this.connection_.closePreparedStatement(this.connection_, this.sql_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_)) {
            this.close(true);
        }
    }

    void setPrepareOutputs(SQLMXDesc[] inputDesc, SQLMXDesc[] outputDesc, int inputParamCount, int outputParamCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)inputDesc, (Object)outputDesc, inputParamCount, outputParamCount);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "setPrepareOutputs", "", p);
        }
        this.inputDesc_ = inputDesc;
        this.outputDesc_ = outputDesc;
        this.paramRowCount_ = 0;
        this.paramsValue_ = this.inputDesc_ != null ? new Object[this.inputDesc_.length] : null;
    }

    void setPrepareOutputs2(SQLMXDesc[] inputDesc, SQLMXDesc[] outputDesc, int inputParamCount, int outputParamCount, int inputParamsLength, int outputParamsLength, int inputDescLength, int outputDescLength) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)inputDesc, (Object)outputDesc, inputParamCount, outputParamCount, inputParamsLength, outputParamsLength, inputDescLength, outputDescLength);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "setPrepareOutputs2", "", p);
        }
        this.inputParamCount_ = inputParamCount;
        this.outputParamCount_ = outputParamCount;
        this.inputParamsLength_ = inputParamsLength;
        this.outputParamsLength_ = outputParamsLength;
        this.inputDescLength_ = inputDescLength;
        this.outputDescLength_ = outputDescLength;
        this.setPrepareOutputs(inputDesc, outputDesc, inputParamCount, outputParamCount);
    }

    void setExecuteOutputs(int rowCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rowCount);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "setExecuteOutputs", "", p);
        }
        this.batchRowCount_ = new int[1];
        this.batchRowCount_[0] = rowCount;
        this.num_result_sets_ = 1;
        this.result_set_offset = 0;
        this.resultSet_[this.result_set_offset] = this.outputDesc_ != null ? new SQLMXResultSet(this, this.outputDesc_) : null;
    }

    void setExecuteBatchOutputs(int[] rowCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rowCount);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "setExecuteBatchOutputs", "", p);
        }
        this.num_result_sets_ = 1;
        this.result_set_offset = 0;
        this.resultSet_[this.result_set_offset] = this.outputDesc_ != null ? new SQLMXResultSet(this, this.outputDesc_) : null;
        this.batchRowCount_ = rowCount;
    }

    void reuse(SQLMXConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "reuse", "", p);
        }
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_type", null);
        }
        if (resultSetType == 1005) {
            this.resultSetType_ = 1004;
            this.setSQLWarning(null, "scrollResultSetChanged", null);
        } else {
            this.resultSetType_ = resultSetType;
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_concurrency", null);
        }
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.queryTimeout_ = this.connection_.getServerHandle().getQueryTimeout();
        this.fetchSize_ = 1;
        this.maxRows_ = 0;
        this.fetchDirection_ = 1000;
        this.isClosed_ = false;
    }

    public void close(boolean hardClose) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, hardClose);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "close", "", p);
        }
        if (this.connection_._isClosed()) {
            return;
        }
        try {
            if (hardClose) {
                this.ist_.close();
            } else {
                this.logicalClose();
            }
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
        finally {
            this.isClosed_ = true;
            if (hardClose) {
                this.connection_.removeElement(this.pRef_);
            }
        }
    }

    void populateLobObjects() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "populateLobObjects", "", p);
        }
        if (this.isAnyLob_) {
            for (int i = 0; i < this.inputDesc_.length; ++i) {
                if (this.inputDesc_[i].paramValue_ == null) continue;
                Object lob = this.inputDesc_[i].paramValue_;
                if (lob instanceof SQLMXClob) {
                    ((SQLMXClob)lob).populate();
                    continue;
                }
                ((SQLMXBlob)lob).populate();
            }
        }
    }

    void populateBatchLobObjects() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "populateBatchLobObjects", "", p);
        }
        if (this.lobObjects_ != null) {
            int len = this.lobObjects_.size();
            for (int i = 0; i < len; ++i) {
                Object lob = this.lobObjects_.get(i);
                if (lob instanceof SQLMXClob) {
                    ((SQLMXClob)lob).populate();
                    continue;
                }
                ((SQLMXBlob)lob).populate();
            }
        }
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String sql, String stmtLabel) throws SQLException {
        this(connection, sql, 1003, 1007, connection.holdability_, stmtLabel);
        connection.ic_.t4props_.setUseArrayBinding(false);
        connection.ic_.t4props_.setBatchRecovery(false);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "Note, this call is before previous constructor call.", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, connection.holdability_);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "Note, this call is before previous constructor call.", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, connection.holdability_);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "Note, this call is before previous constructor call.", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String stmtLabel) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, stmtLabel);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "Note, this call is before previous constructor call.", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.connection_.isConnectionOpen();
        this.sqlStmtType_ = this.ist_.getSqlStmtType(sql);
        if (this.sqlStmtType_ == 4096) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "infostats_invalid_error", null);
        }
        if (this.sqlStmtType_ == 8192) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "config_cmd_invalid_error", null);
        }
        this.sql_ = this.scanSqlStr(sql);
        this.stmtLabel_ = stmtLabel;
        this.usingRawRowset_ = false;
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "Note, this call is before previous constructor call.", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.connection_.isConnectionOpen();
        this.sqlStmtType_ = this.ist_.getSqlStmtType(sql);
        if (this.sqlStmtType_ == 4096) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "infostats_invalid_error", null);
        }
        if (this.sqlStmtType_ == 8192) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "config_cmd_invalid_error", null);
        }
        this.sql_ = this.scanSqlStr(sql);
        this.stmtLabel_ = this.generateStmtLabel();
        this.usingRawRowset_ = false;
    }

    SQLMXPreparedStatement(SQLMXConnection connection, String moduleName, int moduleVersion, long moduleTimestamp, String stmtName, boolean isSelect, int holdability) {
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, connection, moduleName, moduleVersion, moduleTimestamp, stmtName, isSelect, holdability);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "", "", p);
        }
        try {
            if (connection.props_.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(connection.props_, connection, moduleName, moduleVersion, moduleTimestamp, stmtName, isSelect, holdability);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXPreparedStatement");
                lr.setSourceMethodName("");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                connection.props_.getLogWriter().println(temp);
            }
        }
        catch (SQLException se) {
            // empty catch block
        }
        this.connection_ = connection;
        this.moduleName_ = moduleName;
        this.moduleVersion_ = moduleVersion;
        this.moduleTimestamp_ = moduleTimestamp;
        this.stmtLabel_ = stmtName;
        this.sqlStmtType_ = isSelect ? (short)1 : 0;
        this.usingRawRowset_ = false;
        this.fetchSize_ = 1;
        this.maxRows_ = 0;
        this.fetchDirection_ = 1000;
        this.queryTimeout_ = this.connection_.getServerHandle().getQueryTimeout();
        this.resultSetType_ = 1003;
        this.resultSetHoldability_ = holdability;
        this.usingRawRowset_ = false;
    }

    public void prepare(String sql, int queryTimeout, int holdability) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)this.stmtLabel_, queryTimeout, holdability);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "prepare", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, queryTimeout, holdability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("prepare");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        try {
            this.ist_.prepare(sql, queryTimeout, this);
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setFetchSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPreparedStatement");
            lr.setSourceMethodName("setFetchSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (rows < 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_fetchSize_value", null);
        }
        if (rows > 0) {
            this.fetchSize_ = rows;
        }
    }

    private void execute(int paramRowCount, int paramCount, Object[] paramValues, int queryTimeout, boolean isAnyLob) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, paramRowCount, paramCount, (Object)paramValues, queryTimeout, isAnyLob);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXPreparedStatement", "execute", "", p);
        }
        try {
            if ((paramRowCount > 1 || this.rowsValue_ != null && this.rowsValue_.size() > 0) && this.connection_.props_.getExecuteBatchWithRowsAffected().equals("ON")) {
                this.ist_.execute((short)3042, paramRowCount, paramCount, paramValues, queryTimeout, null, this);
            } else {
                this.ist_.execute((short)3025, paramRowCount, paramCount, paramValues, queryTimeout, null, this);
            }
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    public String getStatementType() {
        String stmtType = "";
        switch (this.sqlStmtType_) {
            case 1: {
                stmtType = "SELECT";
                break;
            }
            case 2: {
                stmtType = "UPDATE";
                break;
            }
            case 4: {
                stmtType = "DELETE";
                break;
            }
            case 8: 
            case 256: {
                stmtType = "INSERT";
                break;
            }
            case 32: {
                stmtType = "CREATE";
                break;
            }
            case 64: {
                stmtType = "GRANT";
                break;
            }
            case 128: {
                stmtType = "DROP";
                break;
            }
            case 2048: {
                stmtType = "CALL";
                break;
            }
            case 16: {
                stmtType = "EXPLAIN";
                break;
            }
            case 4096: {
                stmtType = "INFOSTATS";
                break;
            }
            case 8192: {
                stmtType = "CONFIG";
                break;
            }
            default: {
                stmtType = "";
            }
        }
        return stmtType;
    }

    public boolean isValidDate(String dateStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date tempDate = null;
        try {
            tempDate = dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            return false;
        }
        return dateFormat.format(tempDate).equals(dateStr.substring(0, 10));
    }

    public short getStatementTypeShort() {
        return this.sqlStmtType_;
    }

    public int getStatementTypeInt() {
        return this.ist_.getSqlQueryType();
    }

    ArrayList getKeyColumns() {
        return this.keyColumns;
    }

    void setKeyColumns(ArrayList keyColumns) {
        this.keyColumns = keyColumns;
    }
}

