/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXXAResource;
import com.tandem.t4jdbc.SQLMXXid;
import com.tandem.t4jdbc.StateJoin;
import com.tandem.t4jdbc.StateReadOnly;
import com.tandem.t4jdbc.StateRollback;
import com.tandem.t4jdbc.StateStart;
import com.tandem.t4jdbc.XAInputOutputStateParameter;
import com.tandem.t4jdbc.XAResourceState;
import java.util.Hashtable;
import javax.transaction.xa.XAException;

class SQLMXXAConnectionState {
    private Hashtable xid_state_table = new Hashtable();
    private Hashtable resource_state_table = new Hashtable();
    protected static final int xa_no_state_change_ = 0;
    protected static final int xa_send_message_to_broker_ = -1;
    protected static final int xa_state_roll_back_ = 1000;
    protected static final int xa_state_commit_ = 1001;
    protected static final int xa_state_prepare_ = 1002;
    protected static final int xa_state_start_ = 1003;
    protected static final int xa_state_end_ = 1004;
    protected static final int xa_state_forget_ = 1005;
    protected static final int xa_tm_suspend = 0x2000000;
    static final Integer XA_STATE_ROLL_BACK = new Integer(1000);
    static final Integer XA_STATE_COMMIT = new Integer(1001);
    static final Integer XA_STATE_PREPARE = new Integer(1002);
    static final Integer XA_STATE_START = new Integer(1003);
    static final Integer XA_STATE_END = new Integer(1004);
    static final Integer XA_STATE_FORGET = new Integer(1005);
    static final Integer XA_NO_STATE_CHANGE = new Integer(0);
    static final Integer XA_SEND_MESSAGE_TO_BROKER = new Integer(-1);
    static final Integer XAER_PROTOCOL_ERROR = new Integer(-6);
    static final Integer XA_READ_ONLY = new Integer(3);
    static final Integer XA_STATE_SUSPEND = new Integer(0x2000000);

    SQLMXXAConnectionState() {
    }

    private void throwResourceTableError(SQLMXXAResource p_res, XAException xaex) throws XAException {
        this.resource_state_table.remove(this.getKey(p_res));
        XAException xaex1 = new XAException("State error with the resource table entry.");
        xaex1.errorCode = -3;
        xaex1.setStackTrace(xaex.getStackTrace());
        throw xaex1;
    }

    private void throwXidTableError(SQLMXXid p_xid, XAException xaex) throws XAException {
        this.xid_state_table.remove(p_xid);
        XAException xaex1 = new XAException("State error with the xid table entry.");
        xaex1.errorCode = -3;
        xaex1.setStackTrace(xaex.getStackTrace());
        throw xaex1;
    }

    XAResourceState start(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState resNextState = XAResourceState.startState;
        XAResourceState xidNextState = XAResourceState.startState;
        SQLMXXAResource l_res = xa_param.getXAResource();
        XAResourceState l_currentState = null;
        SQLMXXid l_xid = xa_param.getXIDdef();
        XAResourceState l_state = XAResourceState.startState;
        try {
            if (l_res != null && (l_currentState = this.getResStateFromXAParam(l_res)) != null) {
                resNextState = l_currentState.start(null, xa_param.getXAFlags());
            }
        }
        catch (XAException xaex) {
            this.throwResourceTableError(l_res, xaex);
        }
        try {
            if (l_xid != null && (l_currentState = this.getXidStateFromXAParam(l_xid)) != null) {
                xidNextState = l_currentState.start(l_xid, xa_param.getXAFlags());
            }
        }
        catch (XAException xaex) {
            this.throwXidTableError(l_xid, xaex);
        }
        if (resNextState == null) {
            l_state = XAResourceState.startState;
        } else if (resNextState instanceof StateStart && xidNextState instanceof StateJoin) {
            l_state = XAResourceState.joinState;
        } else if (resNextState instanceof StateReadOnly) {
            l_state = XAResourceState.readOnlyState;
        } else if (resNextState != null) {
            l_state = resNextState;
        } else if (xidNextState == null) {
            l_state = xidNextState;
        }
        return l_state;
    }

    synchronized void setStart(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState l_state = this.start(xa_param);
        xa_param.setAction(XAResourceState.startState);
        this.resource_state_table.put(this.getKey(xa_param.getXAResource()), xa_param);
        this.xid_state_table.put(xa_param.getXIDdef(), xa_param);
    }

    XAResourceState end(XAInputOutputStateParameter xa_param) throws XAException {
        SQLMXXAResource l_res = xa_param.getXAResource();
        XAResourceState resNextState = null;
        XAResourceState l_currentState = null;
        try {
            l_currentState = this.getResStateFromXAParam(l_res);
            if (l_currentState == null) {
                throw XAResourceState.noTxException;
            }
            resNextState = l_currentState.end(null);
        }
        catch (XAException xaex) {
            this.throwResourceTableError(l_res, xaex);
        }
        return resNextState;
    }

    synchronized void setEnd(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState l_state = this.end(xa_param);
        this.resource_state_table.remove(this.getKey(xa_param.getXAResource()));
        xa_param.setAction(l_state);
        this.xid_state_table.put(xa_param.getXIDdef(), xa_param);
    }

    XAResourceState prepare(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState resNextState = XAResourceState.prepareState;
        XAResourceState xidNextState = XAResourceState.prepareState;
        SQLMXXAResource l_res = xa_param.getXAResource();
        SQLMXXid l_xid = xa_param.getXIDdef();
        try {
            XAResourceState l_currentState = this.getXidStateFromXAParam(l_xid);
            if (l_currentState != null) {
                xidNextState = l_currentState.prepare(l_xid);
            }
            if ((l_currentState = this.getResStateFromXAParam(l_res)) != null) {
                resNextState = l_currentState.prepare(l_xid);
            }
        }
        catch (XAException xaex) {
            this.throwXidTableError(l_xid, xaex);
        }
        return xidNextState;
    }

    synchronized void setPrepare(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState l_state = this.prepare(xa_param);
        xa_param.setAction(l_state);
        this.resource_state_table.remove(this.getKey(xa_param.getXAResource()));
        this.xid_state_table.put(xa_param.getXIDdef(), xa_param);
    }

    XAResourceState commit(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState resNextState = XAResourceState.commitState;
        XAResourceState xidNextState = XAResourceState.commitState;
        SQLMXXAResource l_res = xa_param.getXAResource();
        SQLMXXid l_xid = xa_param.getXIDdef();
        try {
            XAResourceState l_currentState = this.getXidStateFromXAParam(l_xid);
            if (l_currentState != null) {
                xidNextState = l_currentState.commit(l_xid);
            }
            if ((l_currentState = this.getResStateFromXAParam(l_res)) != null) {
                resNextState = l_currentState.commit(l_xid);
            }
        }
        catch (XAException xaex) {
            this.throwXidTableError(l_xid, xaex);
        }
        return xidNextState;
    }

    synchronized void setCommit(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState l_state = this.commit(xa_param);
        this.resource_state_table.remove(this.getKey(xa_param.getXAResource()));
        this.xid_state_table.put(xa_param.getXIDdef(), xa_param);
    }

    XAResourceState rollback(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState resNextState = XAResourceState.rollbackState;
        SQLMXXid l_xid = xa_param.getXIDdef();
        SQLMXXAResource l_res = xa_param.getXAResource();
        XAResourceState l_currentState = null;
        try {
            l_currentState = this.getXidStateFromXAParam(l_xid);
            if (l_currentState != null) {
                resNextState = l_currentState.rollback(l_xid);
            }
        }
        catch (XAException xaex) {
            this.throwXidTableError(l_xid, xaex);
        }
        try {
            if (resNextState instanceof StateRollback && (l_currentState = this.getResStateFromXAParam(l_res)) != null) {
                resNextState = l_currentState.rollback(null);
            }
        }
        catch (XAException xaex) {
            this.throwResourceTableError(l_res, xaex);
        }
        return resNextState;
    }

    synchronized void setRollback(XAInputOutputStateParameter xa_param) throws XAException {
        XAResourceState l_state = this.rollback(xa_param);
        this.resource_state_table.remove(this.getKey(xa_param.getXAResource()));
        xa_param.setAction(l_state);
        this.xid_state_table.put(xa_param.getXIDdef(), xa_param);
    }

    synchronized void removeState(XAInputOutputStateParameter xa_param) throws XAException {
        this.resource_state_table.remove(this.getKey(xa_param.getXAResource()));
        this.xid_state_table.remove(xa_param.getXIDdef());
    }

    private XAResourceState getResStateFromXAParam(SQLMXXAResource p_res) {
        XAResourceState l_currentState = null;
        XAInputOutputStateParameter l_xa_param = (XAInputOutputStateParameter)this.resource_state_table.get(this.getKey(p_res));
        if (l_xa_param != null) {
            l_currentState = l_xa_param.getState();
        }
        return l_currentState;
    }

    private XAResourceState getXidStateFromXAParam(SQLMXXid p_xid) {
        XAResourceState l_currentState = null;
        XAInputOutputStateParameter l_xa_param = (XAInputOutputStateParameter)this.xid_state_table.get(p_xid);
        if (l_xa_param != null) {
            l_currentState = l_xa_param.getState();
        }
        return l_currentState;
    }

    private Object getKey(SQLMXXAResource p_res) {
        return p_res.m_xaConnection;
    }
}

