/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Address;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class T4Properties {
    private String description_;
    private String dataSourceName_;
    private String serverDataSource_;
    private String catalog_;
    private String schema_;
    private String user_;
    private String url_;
    private String pwd_;
    private Locale locale_;
    private int maxPoolSize_;
    private int minPoolSize_;
    private int initialPoolSize_;
    private int maxStatements_;
    private int loginTimeout_;
    private int networkTimeout_;
    private int connectionTimeout_;
    private int maxIdleTime_;
    private Level t4LogLevel;
    private String T4LogFile_;
    private Properties defaults_;
    private Properties inprops_;
    private PrintWriter logWriter_;
    static long reserveDataLocator_;
    private int roundMode_;
    private boolean commitInAutoCommitOn_;
    private String KANJI_;
    private String KSC5601_;
    private String language_;
    private short fetchBufferSize_;
    private String connectionID_;
    private String dialogueID_;
    private String serverID_;
    private short mxcsMajorVersion_;
    private short mxcsMinorVersion_;
    private short sqlmxMajorVersion_;
    private short sqlmxMinorVersion_;
    String clobTableName_;
    String blobTableName_;
    private boolean useArrayBinding_;
    private boolean batchRecovery_;
    private final String propPrefix_ = "t4sqlmx.";
    static final String DEFAULT_CATALOG = "";
    private short queryTimeout_;
    private String closeConnectionUponQueryTimeout = "DEFAULT";
    private String mfuStatementCache = "YES";
    private String enableMFC = "ON";
    private long queryExecuteTime;
    private String keepAlive = "OFF";
    private String externalCallHandler = "NONE";
    private String externalCallPrefix = "EXT";
    private T4Address t4addr_;
    private String executeBatchWithRowsAffected = "OFF";
    String sqlExceptionMessage_;
    Logger logger;
    Logger t4Logger_;
    FileHandler t4LogFileHandler_;
    private boolean SPJEnv_ = false;
    private boolean keepRawFetchBuffer_ = false;
    private short cpuToUse_ = (short)-1;
    private String sessionName;
    private String replacementString_;
    private String ISO88591_;
    private String _roleName;
    private String _applicationName;
    private boolean _sessionToken;
    private boolean _fetchAhead;
    private boolean _seaquest;
    private boolean _delayedErrorMode;
    private static int DEFAULT_MAX_IDLE_TIMEOUT;
    private String useExternalTransaction = "NO";
    static Level t4GlobalLogLevel;
    static String t4GlobalLogFile;
    static Logger t4GlobalLogger;
    static FileHandler t4GlobalLogFileHandler;
    static String t4SlowQueryGlobalLogFile;
    static Logger t4SlowQueryGlobalLogger;
    static FileHandler t4SlowQueryGlobalLogFileHandler;
    private String t4QueryExecuteLogFile_;
    FileHandler t4SlowQueryLogFileHandler_;
    private String dbMetaDataforDBTools = "OFF";

    void initializeLogging(Properties p) {
        if (t4GlobalLogger != null) {
            return;
        }
        t4GlobalLogger = Logger.getLogger("com.tandem.t4jdbc.logger");
        String ID = T4LoggingUtilities.getUniqueID();
        String name = T4LoggingUtilities.getUniqueLoggerName(ID);
        t4SlowQueryGlobalLogger = Logger.getLogger(name);
        try {
            String temp;
            boolean createGlobalLogFile = false;
            String userSpecifiedLogFile = null;
            boolean createSlowQueryGlobalLogFile = false;
            String userSpecifiedSlowQueryLogFile = null;
            Level userSpecifiedLogLevel = null;
            if (p == null) {
                p = T4Properties.getPropertiesFileValues();
            }
            t4GlobalLogger.setUseParentHandlers(false);
            t4SlowQueryGlobalLogger.setUseParentHandlers(false);
            if (p != null) {
                userSpecifiedLogFile = p.getProperty("T4LogFile");
                temp = p.getProperty("T4LogLevel");
                userSpecifiedSlowQueryLogFile = p.getProperty("T4QueryExecuteLogFile");
                if (temp != null) {
                    userSpecifiedLogLevel = Level.parse(temp);
                }
            }
            if (userSpecifiedLogFile == null) {
                userSpecifiedLogFile = System.getProperty("t4sqlmx.T4LogFile");
            }
            if (userSpecifiedSlowQueryLogFile == null) {
                userSpecifiedSlowQueryLogFile = System.getProperty("t4sqlmx.T4QueryExecuteLogFile");
            }
            if (userSpecifiedLogLevel == null) {
                temp = System.getProperty("t4sqlmx.T4LogLevel");
                userSpecifiedLogLevel = temp != null ? Level.parse(temp) : null;
            }
            if (userSpecifiedLogFile != null || userSpecifiedLogLevel != null && userSpecifiedLogLevel != Level.OFF) {
                createGlobalLogFile = true;
            }
            if (userSpecifiedSlowQueryLogFile != null) {
                createSlowQueryGlobalLogFile = true;
            }
            t4GlobalLogFile = userSpecifiedLogFile == null ? T4LoggingUtilities.getUniqueLogFileName(T4LoggingUtilities.getUniqueID()) : userSpecifiedLogFile;
            t4SlowQueryGlobalLogFile = userSpecifiedSlowQueryLogFile == null ? T4LoggingUtilities.getUniqueLogFileName("QueryExecuteTime") : userSpecifiedSlowQueryLogFile;
            t4GlobalLogLevel = userSpecifiedLogLevel == null ? Level.OFF : userSpecifiedLogLevel;
            t4GlobalLogger.setLevel(t4GlobalLogLevel);
            t4SlowQueryGlobalLogger.setLevel(Level.INFO);
            if (createGlobalLogFile) {
                temp = t4GlobalLogFile;
                if (temp.contains("%u")) {
                    temp = temp.replace("%u", T4LoggingUtilities.getUniqueID());
                }
                t4GlobalLogFileHandler = new FileHandler(temp);
                t4GlobalLogger.addHandler(t4GlobalLogFileHandler);
                T4LogFormatter ff1 = new T4LogFormatter();
                t4GlobalLogFileHandler.setFormatter(ff1);
            }
            if (createSlowQueryGlobalLogFile) {
                t4SlowQueryGlobalLogFileHandler = new FileHandler(t4SlowQueryGlobalLogFile);
                t4SlowQueryGlobalLogger.addHandler(t4SlowQueryGlobalLogFileHandler);
                T4LogFormatter ff2 = new T4LogFormatter();
                t4SlowQueryGlobalLogFileHandler.setFormatter(ff2);
            }
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(null, null, "problem_with_logging", e.getMessage());
            this.sqlExceptionMessage_ = se.getMessage();
        }
    }

    public T4Properties() {
        this.initializeLogging(null);
        this.initialize(null);
    }

    public T4Properties(Properties props) {
        this.initializeLogging(props);
        this.initialize(props);
    }

    void initialize(Properties props) {
        this.sqlExceptionMessage_ = null;
        this.inprops_ = props;
        this.setProperties();
    }

    private Object getHashTableEntry(String token) {
        Object outObj = null;
        if (this.inprops_ != null) {
            outObj = this.inprops_.get(token);
        }
        return outObj;
    }

    private String getProperty(String token) {
        String ret = null;
        if (this.inprops_ != null) {
            ret = this.inprops_.getProperty(token);
        }
        if (ret == null && this.defaults_ != null) {
            ret = this.defaults_.getProperty(token);
        }
        if (ret == null) {
            ret = System.getProperty("t4sqlmx." + token);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperties() {
        this.defaults_ = null;
        String propsFile = this.getProperty("properties");
        if (propsFile != null && (propsFile = propsFile.trim()).length() != 0) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(propsFile));
                this.defaults_ = new Properties();
                this.defaults_.load(fis);
            }
            catch (Exception ex) {
                fis = null;
                this.sqlExceptionMessage_ = "Error while loading t4sqlmx.properties file: " + ex.getMessage();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        this.setDescription(this.getProperty("description"));
        this.setDataSourceName(this.getProperty("dataSourceName"));
        this.setServerDataSource(this.getProperty("serverDataSource"));
        this.setCatalog(this.getProperty("catalog"));
        this.setSchema(this.getProperty("schema"));
        this.setUser(this.getProperty("user"));
        this.setPassword(this.getProperty("password"));
        if (this.url_ == null) {
            this.setUrl(this.getProperty("url"));
        }
        this.setMaxPoolSize(this.getProperty("maxPoolSize"));
        this.setMinPoolSize(this.getProperty("minPoolSize"));
        this.setInitialPoolSize(this.getProperty("initialPoolSize"));
        this.setMaxStatements(this.getProperty("maxStatements"));
        this.setLoginTimeout(this.getProperty("loginTimeout"));
        this.setNetworkTimeout(this.getProperty("networkTimeout"));
        this.setT4LogLevel(this.getProperty("T4LogLevel"));
        this.setT4LogFile(this.getProperty("T4LogFile"));
        this.setT4QueryExecuteLogFile(this.getProperty("T4QueryExecuteLogFile"));
        this.setLogger(this.getHashTableEntry("logger"));
        this.setT4LogFileHandler(this.getHashTableEntry("T4LogFileHandler"));
        this.setT4SlowQueryLogFileHandler(this.getHashTableEntry("T4SlowQueryLogFileHandler"));
        this.setUseArrayBinding(this.getProperty("useArrayBinding"));
        this.setBatchRecovery(this.getProperty("batchRecovery"));
        this.setLanguage(this.getProperty("language"));
        this.setMaxIdleTime(this.getProperty("maxIdleTime"));
        this.setConnectionTimeout(this.getProperty("connectionTimeout"));
        this.setFetchBufferSize(this.getProperty("fetchBufferSize"));
        try {
            this.setClobTableName(this.getProperty("clobTableName"));
        }
        catch (SQLException se) {
            this.sqlExceptionMessage_ = "Error while reading the clobTableName property: " + se.getMessage();
        }
        try {
            this.setBlobTableName(this.getProperty("blobTableName"));
        }
        catch (SQLException se2) {
            this.sqlExceptionMessage_ = "Error while reading the blobTableName property: " + se2.getMessage();
        }
        this.setReserveDataLocator(this.getProperty("reserveDataLocator"));
        this.setQueryTimeout(this.getProperty("queryTimeout"));
        this.setRoundingMode(this.getProperty("roundingMode"));
        this.setCommitInAutoCommitOn(this.getProperty("commitInAutoCommitOn"));
        this.setSPJEnv(this.getProperty("SPJEnv"));
        this.setKeepRawFetchBuffer(this.getProperty("keepRawFetchBuffer"));
        this.setCpuToUse(this.getProperty("cpuToUse"));
        this.setSessionName(this.getProperty("sessionName"));
        this.setReplacementString(this.getProperty("replacementString"));
        this.setISO88591(this.getProperty("ISO88591"));
        this.setKANJI(this.getProperty("KANJI"));
        this.setKSC5601(this.getProperty("KSC5601"));
        this.setRoleName(this.getProperty("roleName"));
        this.setApplicationName(this.getProperty("applicationName"));
        this.setSessionToken(this.getProperty("sessionToken"));
        this.setFetchAhead(this.getProperty("fetchAhead"));
        this.setSeaquest(this.getProperty("seaquest"));
        this.setDelayedErrorMode(this.getProperty("delayedErrorMode"));
        if (this.getProperty("closeConnectionUponQueryTimeout") != null) {
            this.setCloseConnectionUponQueryTimeout(this.getProperty("closeConnectionUponQueryTimeout"));
        }
        if (this.getProperty("enableMFC") != null) {
            this.setEnableMFC(this.getProperty("enableMFC"));
        }
        if (this.getProperty("queryExecuteTime") != null) {
            this.setQueryExecuteTime(this.getProperty("queryExecuteTime"));
        }
        if (this.getProperty("keepAlive") != null) {
            this.setKeepAlive(this.getProperty("keepAlive"));
        }
        if (this.getProperty("executeBatchWithRowsAffected") != null) {
            this.setExecuteBatchWithRowsAffected(this.getProperty("executeBatchWithRowsAffected"));
        }
        if (this.getProperty("mfuStatementCache") != null) {
            this.setMfuStatementCache(this.getProperty("mfuStatementCache"));
        }
        if (this.getProperty("externalCallPrefix") != null) {
            this.setExternalCallPrefix(this.getProperty("externalCallPrefix"));
        }
        if (this.getProperty("externalCallHandler") != null) {
            this.setExternalCallHandler(this.getProperty("externalCallHandler"));
        }
        this.setUseExternalTransaction(this.getProperty("useExternalTransaction"));
        if (this.getProperty("dbMetaDataforDBTools") != null) {
            this.setDbMetaDataforDBTools(this.getProperty("dbMetaDataforDBTools"));
        }
    }

    T4Properties getT4Properties() {
        return this;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.getCatalog() != null) {
            props.setProperty("catalog", this.catalog_);
        }
        if (this.getSchema() != null) {
            props.setProperty("schema", this.schema_);
        }
        if (this.url_ != null) {
            props.setProperty("url", this.url_);
        }
        props.setProperty("user", this.user_);
        props.setProperty("password", this.pwd_);
        props.setProperty("maxPoolSize", String.valueOf(this.maxPoolSize_));
        props.setProperty("minPoolSize", String.valueOf(this.minPoolSize_));
        props.setProperty("initialPoolSize", String.valueOf(this.initialPoolSize_));
        props.setProperty("maxStatements", String.valueOf(this.maxStatements_));
        props.setProperty("T4LogLevel", this.t4LogLevel.toString());
        props.setProperty("fetchBufferSize", String.valueOf(this.fetchBufferSize_));
        if (this.logger != null) {
            props.put("logger", this.logger);
        }
        if (this.t4LogFileHandler_ != null) {
            props.put("T4LogFileHandler", this.t4LogFileHandler_);
        }
        if (this.t4SlowQueryLogFileHandler_ != null) {
            props.put("T4SlowQueryLogFileHandler", this.t4SlowQueryLogFileHandler_);
        }
        props.setProperty("T4LogFile", this.T4LogFile_);
        props.setProperty("loginTimeout", String.valueOf(this.loginTimeout_));
        props.setProperty("networkTimeout", String.valueOf(this.networkTimeout_));
        props.setProperty("connectionTimeout", String.valueOf(this.connectionTimeout_));
        props.setProperty("description", this.description_);
        props.setProperty("dataSourceName", this.dataSourceName_);
        props.setProperty("serverDataSource", this.serverDataSource_);
        props.setProperty("useArrayBinding", String.valueOf(this.useArrayBinding_));
        props.setProperty("batchRecovery", String.valueOf(this.batchRecovery_));
        props.setProperty("maxIdleTime", String.valueOf(this.maxIdleTime_));
        props.setProperty("language", this.language_);
        if (this.getBlobTableName() != null) {
            props.setProperty("blobTableName", this.blobTableName_);
        }
        if (this.getClobTableName() != null) {
            props.setProperty("clobTableName", this.clobTableName_);
        }
        props.setProperty("KANJI", this.KANJI_);
        props.setProperty("KSC5601", this.KSC5601_);
        props.setProperty("queryTimeout", String.valueOf(this.queryTimeout_));
        props.setProperty("roundingMode", String.valueOf(this.roundMode_));
        props.setProperty("commitInAutoCommitOn", String.valueOf(this.commitInAutoCommitOn_));
        props.setProperty("SPJEnv", String.valueOf(this.SPJEnv_));
        props.setProperty("keepRawFetchBuffer", String.valueOf(this.keepRawFetchBuffer_));
        props.setProperty("cpuToUse", String.valueOf(this.cpuToUse_));
        props.setProperty("enableMFC", this.enableMFC);
        props.setProperty("queryExecuteTime", String.valueOf(this.queryExecuteTime));
        props.setProperty("T4QueryExecuteLogFile", this.t4QueryExecuteLogFile_);
        props.setProperty("keepAlive", this.keepAlive);
        props.setProperty("executeBatchWithRowsAffected", this.executeBatchWithRowsAffected);
        props.setProperty("mfuStatementCache", this.getMfuStatementCache());
        props.setProperty("replacementString", String.valueOf(this.replacementString_));
        props.setProperty("ISO88591", String.valueOf(this.ISO88591_));
        if (this._roleName != null) {
            props.setProperty("roleName", this._roleName);
        }
        if (this._applicationName != null) {
            props.setProperty("applicationName", this._applicationName);
        }
        props.setProperty("sessionToken", String.valueOf(this._sessionToken));
        props.setProperty("fetchAhead", String.valueOf(this._fetchAhead));
        props.setProperty("seaquest", String.valueOf(this._seaquest));
        props.setProperty("delayedErrorMode", String.valueOf(this._delayedErrorMode));
        props.setProperty("closeConnectionUponQueryTimeout", this.closeConnectionUponQueryTimeout);
        props.setProperty("externalCallHandler", this.getExternalCallHandler());
        props.setProperty("externalCallPrefix", this.getExternalCallPrefix());
        props.setProperty("useExternalTransaction", this.getUseExternalTransaction());
        props.setProperty("dbMetaDataforDBTools", this.dbMetaDataforDBTools);
        return props;
    }

    void setDescription(String description) {
        this.description_ = description == null ? "NonStop JDBC T4 SQLMX DataSource." : description;
    }

    String getDescription() {
        return this.description_;
    }

    void setDataSourceName(String dataSourceName) {
        this.dataSourceName_ = dataSourceName == null ? DEFAULT_CATALOG : dataSourceName;
    }

    String getDataSourceName() {
        return this.dataSourceName_;
    }

    void setServerDataSource(String serverDataSource) {
        this.serverDataSource_ = serverDataSource == null ? DEFAULT_CATALOG : serverDataSource;
    }

    String getServerDataSource() {
        return this.serverDataSource_;
    }

    void setCatalog(String catalog) {
        this.catalog_ = catalog;
        if (this.catalog_ == null) {
            this.catalog_ = this.getProperty("catalog");
        }
        if (this.catalog_ != null) {
            if (this.catalog_.length() == 0) {
                this.catalog_ = DEFAULT_CATALOG;
            } else if (!this.catalog_.startsWith("\"")) {
                this.catalog_ = this.catalog_.trim().toUpperCase();
            }
        } else {
            this.catalog_ = DEFAULT_CATALOG;
        }
    }

    String getCatalog() {
        return this.catalog_;
    }

    void setSchema(String schema) {
        this.schema_ = schema;
        if (this.schema_ == null) {
            this.schema_ = this.getProperty("schema");
        }
        if (this.schema_ != null) {
            if (!this.schema_.startsWith("\"")) {
                this.schema_ = this.schema_.trim().toUpperCase();
            }
        } else {
            this.schema_ = null;
        }
    }

    String getSchema() {
        return this.schema_;
    }

    Locale getLocale() {
        return this.locale_;
    }

    void setMaxPoolSize(String maxPoolSize) {
        int maxPs = -1;
        if (maxPoolSize != null) {
            try {
                maxPs = Integer.parseInt(maxPoolSize);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect maxPoolSize value set: " + maxPoolSize + ". " + ex.getMessage();
                maxPs = -1;
            }
        }
        this.setMaxPoolSize(maxPs);
    }

    void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize < -1 ? -1 : (maxPoolSize > 0 ? (this.minPoolSize_ != 0 && this.minPoolSize_ > maxPoolSize ? this.minPoolSize_ : maxPoolSize) : maxPoolSize);
    }

    int getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    void setMinPoolSize(String minPoolSize) {
        int minPs = -1;
        if (minPoolSize != null) {
            try {
                minPs = Integer.parseInt(minPoolSize);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for minPoolSize set: " + minPoolSize + ". " + ex.getMessage();
                minPs = -1;
            }
        }
        this.setMinPoolSize(minPs);
    }

    void setMinPoolSize(int minPoolSize) {
        if (this.maxPoolSize_ == -1) {
            this.minPoolSize_ = -1;
            return;
        }
        this.minPoolSize_ = minPoolSize < -1 ? -1 : (minPoolSize == 0 ? 0 : (minPoolSize > 0 ? (this.maxPoolSize_ != 0 && this.maxPoolSize_ < minPoolSize ? this.maxPoolSize_ : minPoolSize) : minPoolSize));
    }

    int getMinPoolSize() {
        return this.minPoolSize_;
    }

    void setInitialPoolSize(String initialPoolSize) {
        int initPs = -1;
        if (initialPoolSize != null) {
            try {
                initPs = Integer.parseInt(initialPoolSize);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect initialPoolSize value set: " + initialPoolSize + ". " + ex.getMessage();
                initPs = -1;
            }
        }
        this.setInitialPoolSize(initPs);
    }

    void setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize <= 0) {
            this.initialPoolSize_ = -1;
            return;
        }
        this.initialPoolSize_ = initialPoolSize > this.maxPoolSize_ ? this.maxPoolSize_ : initialPoolSize;
    }

    int getInitialPoolSize() {
        return this.initialPoolSize_;
    }

    void setMaxStatements(String maxStatements) {
        int maxstmt = 0;
        if (maxStatements != null) {
            try {
                maxstmt = Integer.parseInt(maxStatements);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for maxStatements set: " + maxStatements + ex.getMessage();
                maxstmt = 0;
            }
        }
        this.setMaxStatements(maxstmt);
    }

    void setMaxStatements(int maxStatements) {
        if (maxStatements < 0) {
            this.sqlExceptionMessage_ = "Incorrect value for maxStatements set: " + maxStatements;
            this.maxStatements_ = 0;
        } else {
            this.maxStatements_ = maxStatements;
        }
    }

    int getMaxStatements() {
        return this.maxStatements_;
    }

    String getURL() {
        return this.getUrl();
    }

    public String getUrl() {
        return this.url_;
    }

    void setUrl(String url) {
        this.url_ = url != null ? url : DEFAULT_CATALOG;
    }

    boolean acceptsUrl(String url) {
        try {
            new T4Address(this, this.locale_, url);
        }
        catch (SQLException sqlex) {
            return false;
        }
        return true;
    }

    Properties setURL(String url) throws SQLException {
        Object host = null;
        Object port = null;
        Properties props = null;
        this.t4addr_ = new T4Address(this, this.locale_, url);
        props = this.t4addr_.getProps();
        this.initialize(props);
        this.setUrl(this.t4addr_.getUrl());
        return props;
    }

    T4Address getAddress() {
        return this.t4addr_;
    }

    void setUser(String user) {
        this.user_ = user == null ? DEFAULT_CATALOG : user;
    }

    String getUser() {
        return this.user_;
    }

    void setPassword(String pwd) {
        this.pwd_ = pwd == null ? DEFAULT_CATALOG : pwd;
    }

    String getPassword() {
        return this.pwd_;
    }

    void setLoginTimeout(String loginTimeout) {
        int loginTo = 60;
        if (loginTimeout != null) {
            try {
                loginTo = Short.parseShort(loginTimeout);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Provided LoginTimeout property value " + loginTimeout + " is invalid and should be less than Short.MAX_VALUE(32767)";
                loginTo = 60;
            }
        }
        this.setLoginTimeout(loginTo);
    }

    void setLoginTimeout(int loginTimeout) {
        if (loginTimeout < 0) {
            this.sqlExceptionMessage_ = "Incorrect value for loginTimeout set: " + loginTimeout + ".";
            this.loginTimeout_ = 60;
        } else {
            this.loginTimeout_ = loginTimeout;
        }
    }

    int getLoginTimeout() {
        return this.loginTimeout_;
    }

    void setNetworkTimeout(String networkTimeout) {
        int networkTo = 0;
        if (networkTimeout != null) {
            try {
                networkTo = Integer.parseInt(networkTimeout);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for networkTimeout set: " + networkTimeout + ex.getMessage();
                networkTo = 0;
            }
        }
        this.setNetworkTimeout(networkTo);
    }

    void setNetworkTimeout(int networkTimeout) {
        if (networkTimeout < 0) {
            this.sqlExceptionMessage_ = "Incorrect value for networkTimeout set: " + networkTimeout + ".";
            this.networkTimeout_ = 0;
        } else {
            this.networkTimeout_ = networkTimeout;
        }
    }

    int getNetworkTimeout() {
        return this.networkTimeout_;
    }

    void setConnectionTimeout(String connectionTimeout) {
        int tmpTimeout = -1;
        if (connectionTimeout != null) {
            try {
                tmpTimeout = Integer.parseInt(connectionTimeout);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for connectionTimeout set: " + connectionTimeout + ". " + ex.getMessage();
                tmpTimeout = -1;
            }
        }
        this.setConnectionTimeout(tmpTimeout);
    }

    void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout_ = connectionTimeout < 0 ? -1 : connectionTimeout;
    }

    void setMaxIdleTime(String maxIdleTime) {
        int tmpTimeout = DEFAULT_MAX_IDLE_TIMEOUT;
        if (maxIdleTime != null) {
            try {
                tmpTimeout = Integer.parseInt(maxIdleTime);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for maxIdleTime set: " + maxIdleTime + ". " + ex.getMessage();
                tmpTimeout = DEFAULT_MAX_IDLE_TIMEOUT;
            }
        }
        this.setMaxIdleTime(tmpTimeout);
    }

    void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime_ = maxIdleTime < 0 ? DEFAULT_MAX_IDLE_TIMEOUT : maxIdleTime;
    }

    int getConnectionTimeout() {
        return this.connectionTimeout_;
    }

    int getMaxIdleTime() {
        return this.maxIdleTime_;
    }

    void setT4LogLevel(String level) {
        this.t4LogLevel = Level.parse("OFF");
        if (level != null) {
            try {
                this.t4LogLevel = Level.parse(level);
            }
            catch (Exception ex) {
                SQLMXException se = SQLMXMessages.createSQLException(null, null, "problem_with_logging", ex.getMessage());
                this.sqlExceptionMessage_ = se.getMessage();
            }
        }
    }

    String getT4LogLevel() {
        return this.t4LogLevel.toString();
    }

    void setT4LogFile(String t4LogFile) {
        this.T4LogFile_ = t4LogFile != null ? t4LogFile : t4GlobalLogFile;
    }

    String getT4LogFile() {
        return this.T4LogFile_;
    }

    void setT4QueryExecuteLogFile(String t4QueryExecuteLogFile) {
        this.t4QueryExecuteLogFile_ = t4QueryExecuteLogFile != null ? t4QueryExecuteLogFile : t4SlowQueryGlobalLogFile;
    }

    String getT4QueryExecuteLogFile() {
        return this.t4QueryExecuteLogFile_;
    }

    String getT4GlobalLogFile() {
        return t4GlobalLogFile;
    }

    void setT4GlobalLogFile(String lgf) {
        t4GlobalLogFile = lgf;
    }

    String getT4SlowQueryGlobalLogFile() {
        return t4SlowQueryGlobalLogFile;
    }

    void setT4SlowQueryGlobalLogFile(String lgf) {
        t4SlowQueryGlobalLogFile = lgf;
    }

    FileHandler getT4GlobalLogFileHandler() {
        return t4GlobalLogFileHandler;
    }

    void setT4GlobalLogFileHandler(Object fh) {
        t4GlobalLogFileHandler = (FileHandler)fh;
    }

    FileHandler getT4SlowQueryGlobalLogFileHandler() {
        return t4SlowQueryGlobalLogFileHandler;
    }

    void setT4SlowQueryGlobalLogFileHandler(Object fh) {
        t4SlowQueryGlobalLogFileHandler = (FileHandler)fh;
    }

    Logger getLogger() {
        return this.logger;
    }

    void setLogger(Object log) {
        this.t4Logger_ = log != null ? (this.logger = (Logger)log) : (this.logger = t4GlobalLogger);
    }

    FileHandler getT4LogFileHandler() {
        try {
            if (this.t4LogFileHandler_ == null) {
                if (this.T4LogFile_.equals(t4GlobalLogFile)) {
                    this.t4LogFileHandler_ = t4GlobalLogFileHandler;
                } else {
                    String temp = this.getT4LogFile();
                    if (temp.contains("%u")) {
                        temp = temp.replace("%u", T4LoggingUtilities.getUniqueID());
                    }
                    this.t4LogFileHandler_ = new FileHandler(temp);
                    this.t4LogFileHandler_.setFormatter(new T4LogFormatter());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.t4LogFileHandler_;
    }

    void setT4LogFileHandler(Object fh) {
        this.t4LogFileHandler_ = (FileHandler)fh;
    }

    FileHandler getT4SlowQueryLogFileHandler() {
        try {
            if (this.t4SlowQueryLogFileHandler_ == null) {
                if (this.t4QueryExecuteLogFile_.equals(t4SlowQueryGlobalLogFile)) {
                    this.t4SlowQueryLogFileHandler_ = t4SlowQueryGlobalLogFileHandler;
                } else {
                    this.t4SlowQueryLogFileHandler_ = new FileHandler(this.t4QueryExecuteLogFile_);
                    this.t4SlowQueryLogFileHandler_.setFormatter(new T4LogFormatter());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.t4SlowQueryLogFileHandler_;
    }

    void setT4SlowQueryLogFileHandler(Object fh) {
        this.t4SlowQueryLogFileHandler_ = (FileHandler)fh;
    }

    void setKANJI(String lang) {
        this.KANJI_ = lang == null ? "SJIS" : lang;
    }

    String getKANJI() {
        return this.KANJI_;
    }

    void setKSC5601(String lang) {
        this.KSC5601_ = lang == null ? "EUC_KR" : lang;
    }

    String getKSC5601() {
        return this.KSC5601_;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter_;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter_ = printWriter;
    }

    void setQueryTimeout(String queryTimeout) {
        short tmpQTimeOut = 0;
        if (queryTimeout != null) {
            try {
                tmpQTimeOut = Short.parseShort(queryTimeout);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for queryTimeout set: " + queryTimeout + ex.getMessage();
                tmpQTimeOut = 0;
            }
        }
        this.setQueryTimeout(tmpQTimeOut);
    }

    void setQueryTimeout(short queryTimeout) {
        this.queryTimeout_ = queryTimeout;
    }

    short getQueryTimeout() {
        return this.queryTimeout_;
    }

    void setFetchBufferSize(short fetchBufferSize) {
        this.fetchBufferSize_ = (short)512;
        if (fetchBufferSize > 512) {
            this.fetchBufferSize_ = fetchBufferSize;
        }
    }

    void setFetchBufferSize(String fetchBufferSize) {
        short setFetchSizeVal = 4;
        if (fetchBufferSize != null) {
            try {
                setFetchSizeVal = Short.parseShort(fetchBufferSize);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect fetchBufferSize value set: " + setFetchSizeVal + ". " + ex.getMessage();
                setFetchSizeVal = 1;
            }
        }
        this.setFetchBufferSize(setFetchSizeVal);
    }

    short getFetchBufferSize() {
        return this.fetchBufferSize_;
    }

    void setUseArrayBinding(String useArrayBinding) {
        boolean boolUseArrayBinding = false;
        if (useArrayBinding != null && useArrayBinding.equalsIgnoreCase("true")) {
            boolUseArrayBinding = true;
        }
        this.setUseArrayBinding(boolUseArrayBinding);
    }

    void setUseArrayBinding(boolean useArrayBinding) {
        this.useArrayBinding_ = useArrayBinding;
    }

    boolean getUseArrayBinding() {
        return this.useArrayBinding_;
    }

    void setBatchRecovery(String batchRecovery) {
        boolean boolBatchRecovery = true;
        if (batchRecovery != null && batchRecovery.equalsIgnoreCase("false")) {
            boolBatchRecovery = false;
        }
        this.setBatchRecovery(boolBatchRecovery);
    }

    void setBatchRecovery(boolean batchRecovery) {
        this.batchRecovery_ = batchRecovery;
    }

    boolean getBatchRecovery() {
        return this.batchRecovery_;
    }

    void setClobTableName(String clobTableName) throws SQLException {
        int fromIndex = -1;
        if (clobTableName != null) {
            int count;
            for (count = 0; (fromIndex = clobTableName.indexOf(46, fromIndex + 1)) != -1 && count < 2; ++count) {
            }
            if (count < 2) {
                SQLMXException se = SQLMXMessages.createSQLException(null, null, "no_clobTableName", null);
                this.sqlExceptionMessage_ = se.getMessage();
            }
            this.clobTableName_ = clobTableName;
        } else {
            this.clobTableName_ = null;
        }
    }

    String getClobTableName() {
        return this.clobTableName_;
    }

    String getSQLException() {
        return this.sqlExceptionMessage_;
    }

    void setBlobTableName(String blobTableName) throws SQLException {
        int fromIndex = -1;
        if (blobTableName != null) {
            int count;
            for (count = 0; (fromIndex = blobTableName.indexOf(46, fromIndex + 1)) != -1 && count < 2; ++count) {
            }
            if (count < 2) {
                SQLMXException se = SQLMXMessages.createSQLException(null, null, "no_blobTableName", null);
                this.sqlExceptionMessage_ = se.getMessage();
            }
            this.blobTableName_ = blobTableName;
        } else {
            this.blobTableName_ = null;
        }
    }

    String getBlobTableName() {
        return this.blobTableName_;
    }

    void setReserveDataLocator(String reserveDataLocator) {
        long reserveDataLocatorLen = 100L;
        if (reserveDataLocator != null) {
            try {
                reserveDataLocatorLen = Long.parseLong(reserveDataLocator);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for setReserveDataLocator set: " + reserveDataLocator + ex.getMessage();
                reserveDataLocatorLen = 100L;
            }
        }
        this.setReserveDataLocator(reserveDataLocatorLen);
    }

    void setReserveDataLocator(long reserveDataLocatorLen) {
        if (reserveDataLocatorLen < 0L) {
            this.sqlExceptionMessage_ = "Incorrect value for reserveDataLocator set: " + reserveDataLocatorLen + ".";
            reserveDataLocator_ = 100L;
        } else {
            reserveDataLocator_ = reserveDataLocatorLen;
        }
    }

    long getReserveDataLocator() {
        return reserveDataLocator_;
    }

    int getRoundingMode() {
        return this.roundMode_;
    }

    void setRoundingMode(String roundMode) {
        this.roundMode_ = Utility.getRoundingMode(roundMode);
    }

    void setRoundingMode(int roundMode) {
        this.roundMode_ = Utility.getRoundingMode(roundMode);
    }

    void setCommitInAutoCommitOn(String p_commitInAutoCommitOn) {
        if (p_commitInAutoCommitOn != null && p_commitInAutoCommitOn.toUpperCase().equals("TRUE")) {
            this.setCommitInAutoCommitOn(true);
        } else {
            this.setCommitInAutoCommitOn(false);
        }
    }

    void setCommitInAutoCommitOn(boolean p_commitInAutoCommitOn) {
        this.commitInAutoCommitOn_ = p_commitInAutoCommitOn;
    }

    boolean getCommitInAutoCommitOn() {
        return this.commitInAutoCommitOn_;
    }

    void setConnectionID(String connID) {
        this.connectionID_ = connID;
    }

    String getConnectionID() {
        return this.connectionID_;
    }

    void setDialogueID(String diaID) {
        this.dialogueID_ = diaID;
    }

    String getDialogueID() {
        return this.dialogueID_;
    }

    void setMxcsMajorVersion(short majorVer) {
        this.mxcsMajorVersion_ = majorVer;
    }

    void setMxcsMajorVersion(String majorVer) {
        short mv = 0;
        if (majorVer != null) {
            try {
                mv = Short.parseShort(majorVer);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for MXCS major version set: " + majorVer + ex.getMessage();
                mv = 0;
            }
        }
        this.setMxcsMajorVersion(mv);
        this.mxcsMajorVersion_ = mv;
    }

    short getMxcsMajorVersion() {
        return this.mxcsMajorVersion_;
    }

    void setMxcsMinorVersion(short minorVer) {
        this.mxcsMinorVersion_ = minorVer;
    }

    void setMxcsMinorVersion(String minorVer) {
        short mv = 0;
        if (minorVer != null) {
            try {
                mv = Short.parseShort(minorVer);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for MXCS minor version set: " + minorVer + ex.getMessage();
                mv = 0;
            }
        }
        this.setMxcsMinorVersion(mv);
        this.mxcsMinorVersion_ = mv;
    }

    short getMxcsMinorVersion() {
        return this.mxcsMinorVersion_;
    }

    void setSqlmxMajorVersion(short majorVer) {
        this.sqlmxMajorVersion_ = majorVer;
    }

    void setSqlmxMajorVersion(String majorVer) {
        short mv = 0;
        if (majorVer != null) {
            try {
                mv = Short.parseShort(majorVer);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for SQL/MX major version set: " + majorVer + ex.getMessage();
                mv = 0;
            }
        }
        this.setSqlmxMajorVersion(mv);
    }

    public void setSPJEnv(String SPJEnv) {
        this.SPJEnv_ = SPJEnv == null ? false : SPJEnv.equalsIgnoreCase("true");
    }

    public void setSPJEnv(boolean SPJEnv) {
        this.SPJEnv_ = SPJEnv;
    }

    public boolean getSPJEnv() {
        return this.SPJEnv_;
    }

    public void setKeepRawFetchBuffer(String keep) {
        this.keepRawFetchBuffer_ = keep == null ? false : keep.equalsIgnoreCase("true");
    }

    public void setKeepRawFetchBuffer(boolean keep) {
        this.keepRawFetchBuffer_ = keep;
    }

    public boolean getKeepRawFetchBuffer() {
        return this.keepRawFetchBuffer_;
    }

    short getSqlmxMajorVersion() {
        return this.sqlmxMajorVersion_;
    }

    public void setCpuToUse(String cpu) {
        this.cpuToUse_ = cpu == null ? (short)-1 : Short.parseShort(cpu);
    }

    public void setCpuToUse(short cpu) {
        this.cpuToUse_ = cpu;
    }

    public short getCpuToUse() {
        return this.cpuToUse_;
    }

    public void setSessionName(String name) {
        this.sessionName = name == null ? DEFAULT_CATALOG : name;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setReplacementString(String str) {
        this.replacementString_ = str == null ? "?" : str;
    }

    public String getReplacementString() {
        return this.replacementString_;
    }

    void setISO88591(String lang) {
        this.ISO88591_ = lang == null ? InterfaceUtilities.getCharsetName(1) : lang;
    }

    String getISO88591() {
        return this.ISO88591_;
    }

    String getRoleName() {
        return this._roleName;
    }

    void setRoleName(String roleName) {
        if (roleName != null && roleName.length() > 0 && roleName.length() > 128) {
            this.sqlExceptionMessage_ = "Invalid RoleName.  Max length: 128";
        }
        this._roleName = roleName;
    }

    String getApplicationName() {
        return this._applicationName;
    }

    void setApplicationName(String applicationName) {
        this._applicationName = applicationName == null || applicationName.length() == 0 ? "FASTJDBC" : applicationName;
    }

    public void setDelayedErrorMode(String mode) {
        this._delayedErrorMode = Boolean.valueOf(mode);
    }

    public void setDelayedErrorMode(boolean mode) {
        this._delayedErrorMode = mode;
    }

    public boolean getDelayedErrorMode() {
        return this._delayedErrorMode;
    }

    boolean getSessionToken() {
        return this._sessionToken;
    }

    void setSessionToken(boolean sessionToken) {
        this._sessionToken = sessionToken;
    }

    void setSessionToken(String sessionToken) {
        this.setSessionToken(Boolean.valueOf(sessionToken));
    }

    boolean getFetchAhead() {
        return this._fetchAhead;
    }

    void setFetchAhead(boolean fetchAhead) {
        this._fetchAhead = fetchAhead;
    }

    void setFetchAhead(String fetchAhead) {
        this.setFetchAhead(Boolean.valueOf(fetchAhead));
    }

    boolean getSeaquest() {
        return this._seaquest;
    }

    void setSeaquest(boolean seaquest) {
        this._seaquest = seaquest;
    }

    void setSeaquest(String seaquest) {
        this.setSeaquest(Boolean.valueOf(seaquest));
    }

    void setSqlmxMinorVersion(short minorVer) {
        this.sqlmxMinorVersion_ = minorVer;
    }

    void setSqlmxMinorVersion(String minorVer) {
        short mv = 0;
        if (minorVer != null) {
            try {
                mv = Short.parseShort(minorVer);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for SQL/MX minor version set: " + minorVer + ex.getMessage();
                mv = 0;
            }
        }
        this.setSqlmxMinorVersion(mv);
    }

    short getSqlmxMinorVersion() {
        return this.sqlmxMinorVersion_;
    }

    BigDecimal getMxcsVersion() {
        String minor = new Short(this.getMxcsMinorVersion()).toString();
        String major = new Short(this.getMxcsMajorVersion()).toString();
        BigDecimal bigD = new BigDecimal(major + "." + minor);
        return bigD;
    }

    void setServerID(String serID) {
        this.serverID_ = serID;
    }

    String getServerID() {
        return this.serverID_;
    }

    void setLanguage(String language) {
        this.locale_ = language == null ? Locale.getDefault() : new Locale(language, DEFAULT_CATALOG, DEFAULT_CATALOG);
        this.language_ = this.locale_.getLanguage();
    }

    String getLanguage() {
        return this.language_;
    }

    Reference addReferences(Reference ref) {
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("serverDataSource", this.getServerDataSource()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        String val = this.getCatalog();
        if (val != null) {
            ref.add(new StringRefAddr("catalog", val));
        }
        if ((val = this.getSchema()) != null) {
            ref.add(new StringRefAddr("schema", val));
        }
        ref.add(new StringRefAddr("language", this.getLanguage()));
        ref.add(new StringRefAddr("maxPoolSize", Integer.toString(this.getMaxPoolSize())));
        ref.add(new StringRefAddr("minPoolSize", Integer.toString(this.getMinPoolSize())));
        ref.add(new StringRefAddr("initialPoolSize", Integer.toString(this.getInitialPoolSize())));
        ref.add(new StringRefAddr("maxStatements", Integer.toString(this.getMaxStatements())));
        ref.add(new StringRefAddr("connectionTimeout", Integer.toString(this.getConnectionTimeout())));
        ref.add(new StringRefAddr("maxIdleTime", Integer.toString(this.getMaxIdleTime())));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.getLoginTimeout())));
        ref.add(new StringRefAddr("networkTimeout", Integer.toString(this.getNetworkTimeout())));
        ref.add(new StringRefAddr("T4LogLevel", this.getT4LogLevel().toString()));
        ref.add(new StringRefAddr("T4LogFile", this.getT4LogFile()));
        ref.add(new StringRefAddr("T4QueryExecuteLogFile", this.getT4QueryExecuteLogFile()));
        ref.add(new StringRefAddr("queryExecuteTime", Long.toString(this.getQueryExecuteTime())));
        ref.add(new StringRefAddr("KANJI", this.getKANJI()));
        ref.add(new StringRefAddr("KSC5601", this.getKSC5601()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        val = this.getClobTableName();
        if (val != null) {
            ref.add(new StringRefAddr("clobTableName", val));
        }
        if ((val = this.getBlobTableName()) != null) {
            ref.add(new StringRefAddr("blobTableName", val));
        }
        ref.add(new StringRefAddr("reserveDataLocator", Long.toString(reserveDataLocator_)));
        ref.add(new StringRefAddr("roundingMode", Integer.toString(this.getRoundingMode())));
        ref.add(new StringRefAddr("queryTimeout", Integer.toString(this.getQueryTimeout())));
        ref.add(new StringRefAddr("fetchBufferSize", Short.toString(this.getFetchBufferSize())));
        ref.add(new StringRefAddr("batchRecovery", Boolean.toString(this.getBatchRecovery())));
        return ref;
    }

    DriverPropertyInfo[] getPropertyInfo(String url, Properties defaults) throws SQLException {
        String[] level = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST"};
        String[] roundingMode = new String[]{"ROUND_CEILING", "ROUND_DOWN", "ROUND_UP", "ROUND_FLOOR", "ROUND_HALF_UP", "ROUND_UNNECESSARY", "ROUND_HALF_EVEN", "ROUND_HALF_DOWN", "ROUND_DOWN"};
        String[] closeConnectionUponQueryTimeoutValues = new String[]{"DEFAULT", "IGNORE"};
        String[] enableMFC = new String[]{"ON", "OFF"};
        String[] keepAlive = new String[]{"ON", "OFF"};
        String[] dbMetaDataforDBTools = new String[]{"OFF", "ON"};
        String[] executeBatchWithRowsAffected = new String[]{"ON", "OFF"};
        String[] mfuStatementCache = new String[]{"YES", "NO"};
        String[] useExternalTransaction = new String[]{"YES", "NO"};
        Properties props = new Properties(defaults);
        props.setProperty("url", url);
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{this.setPropertyInfo("catalog", props, true, "SQL/MX2.0 catalog name", null), this.setPropertyInfo("schema", props, true, "SQL/MX2.0 schema name", null), this.setPropertyInfo("url", props, false, "jdbc:t4sqlmx://<host>:<port>/:", null), this.setPropertyInfo("user", props, true, "NSK safeguard user name", null), this.setPropertyInfo("password", props, true, "NSK safeguard user password", null), this.setPropertyInfo("maxPoolSize", props, false, "Maximum connection pool size", null), this.setPropertyInfo("minPoolSize", props, false, "Minimum connection pool size", null), this.setPropertyInfo("initialPoolSize", props, false, "Initial connection pool size", null), this.setPropertyInfo("maxStatements", props, false, "Maximum statement pool size", null), this.setPropertyInfo("T4LogLevel", props, false, "Logging Level", level), this.setPropertyInfo("T4LogFile", props, false, "Logging file location", null), this.setPropertyInfo("loginTimeout", props, false, "Login time out in secs", null), this.setPropertyInfo("networkTimeout", props, false, "Network time out in secs", null), this.setPropertyInfo("connectionTimeout", props, false, "Connection time out in secs", null), this.setPropertyInfo("maxIdleTime", props, false, "Max idle time for a free pool connection in secs", null), this.setPropertyInfo("language", props, false, "Locale language to use", null), this.setPropertyInfo("serverDataSource", props, false, "MXCS data source name", null), this.setPropertyInfo("roundingMode", props, false, "Data rounding mode", roundingMode), this.setPropertyInfo("KANJI", props, false, "KANJI column character set translation", null), this.setPropertyInfo("KSC5601", props, false, "KSC5601 column character set translation", null), this.setPropertyInfo("blobTableName", props, false, "Table name to store and retrieve BLOB column data", null), this.setPropertyInfo("clobTableName", props, false, "Table name to store and retrieve CLOB column data", null), this.setPropertyInfo("reserveDataLocator", props, false, "Number of data locators (for LOB) to be reserved by the connection", null), this.setPropertyInfo("closeConnectionUponQueryTimeout", props, false, "Doesnt throw unsupported feature exception when the value is IGNORE", closeConnectionUponQueryTimeoutValues), this.setPropertyInfo("fetchBufferSize", props, false, "Value (in KB) for the size of the fetch buffer to be used when rows are fetched", null), this.setPropertyInfo("enableMFC", props, false, "Use MFC for Statement Cache enable", enableMFC), this.setPropertyInfo("queryExecuteTime", props, false, "Used to Idenfify queries exectution time", null), this.setPropertyInfo("T4QueryExecuteLogFile", props, false, " Log file for execute queries", null), this.setPropertyInfo("keepAlive", props, false, "Use to keep connection alive", keepAlive), this.setPropertyInfo("executeBatchWithRowsAffected", props, false, "To Return valid rowsaffected result for executebatch", executeBatchWithRowsAffected), this.setPropertyInfo("mfuStatementCache", props, false, "Changes the Driver Side Statement Caching Strategy to Most Frequently used, the default is Most Recently used", mfuStatementCache), this.setPropertyInfo("batchRecovery", props, false, "Continue batch processing of next commands even after errors", null), this.setPropertyInfo("useExternalTransaction", props, false, "Inherits the transaction started by application, to use for DB operations ", useExternalTransaction), this.setPropertyInfo("dbMetaDataforDBTools", props, false, "Property for changing the behaviour of DatabaseMetaData.getSchemas()and getCatalog() to assist DB tools", dbMetaDataforDBTools)};
        return propertyInfo;
    }

    private DriverPropertyInfo setPropertyInfo(String name, Properties props, boolean required, String description, String[] choices) {
        String value = props.getProperty(name);
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(name, value);
        propertyInfo.required = required;
        propertyInfo.description = description;
        propertyInfo.choices = choices;
        return propertyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFileValues() {
        Properties values = null;
        String propsFile = System.getProperty("t4sqlmx.properties");
        if (propsFile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(propsFile));
                values = new Properties();
                values.load(fis);
            }
            catch (Exception ex) {
                fis = null;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return values;
    }

    public String getCloseConnectionUponQueryTimeout() {
        return this.closeConnectionUponQueryTimeout;
    }

    public void setCloseConnectionUponQueryTimeout(String closeConnectionUponQueryTimeout) {
        this.closeConnectionUponQueryTimeout = closeConnectionUponQueryTimeout.equals("DEFAULT") ? "DEFAULT" : (closeConnectionUponQueryTimeout.equals("IGNORE") ? "IGNORE" : (closeConnectionUponQueryTimeout.equals("ON") ? "ON" : "DEFAULT"));
    }

    public void setMfuStatementCache(String mfuStatementCache) {
        if (mfuStatementCache.toUpperCase().equals("NO")) {
            this.mfuStatementCache = "NO";
        }
    }

    public String getMfuStatementCache() {
        return this.mfuStatementCache;
    }

    public String getEnableMFC() {
        return this.enableMFC;
    }

    public void setEnableMFC(String enableMFC) {
        if (enableMFC.equalsIgnoreCase("ON") || enableMFC.equalsIgnoreCase("OFF")) {
            this.enableMFC = enableMFC.toUpperCase();
        }
    }

    public void setKeepAlive(String keepAlive) {
        if (keepAlive.equalsIgnoreCase("ON") || keepAlive.equalsIgnoreCase("OFF")) {
            this.keepAlive = keepAlive;
        }
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public void setQueryExecuteTime(long queryExecuteTime) {
        if (queryExecuteTime > 0L) {
            this.queryExecuteTime = queryExecuteTime;
        }
    }

    public long getQueryExecuteTime() {
        return this.queryExecuteTime;
    }

    void setQueryExecuteTime(String queryExecuteTime) {
        long tmpQueryExecuteTime = 0L;
        if (queryExecuteTime != null) {
            try {
                tmpQueryExecuteTime = Long.parseLong(queryExecuteTime);
            }
            catch (NumberFormatException ex) {
                this.sqlExceptionMessage_ = "Incorrect value for queryExecuteTime set: " + queryExecuteTime + ex.getMessage();
                tmpQueryExecuteTime = 0L;
            }
        }
        this.setQueryExecuteTime(tmpQueryExecuteTime);
    }

    public String getExecuteBatchWithRowsAffected() {
        return this.executeBatchWithRowsAffected;
    }

    public void setExecuteBatchWithRowsAffected(String executeBatchWithRowsAffected) {
        if (executeBatchWithRowsAffected.equalsIgnoreCase("ON") || executeBatchWithRowsAffected.equalsIgnoreCase("OFF")) {
            this.executeBatchWithRowsAffected = executeBatchWithRowsAffected.toUpperCase();
        }
    }

    public void setExternalCallHandler(String externalCallHandler) {
        this.externalCallHandler = externalCallHandler;
    }

    public String getExternalCallHandler() {
        return this.externalCallHandler;
    }

    public void setExternalCallPrefix(String externalCallPrefix) {
        this.externalCallPrefix = externalCallPrefix;
    }

    public String getExternalCallPrefix() {
        return this.externalCallPrefix;
    }

    public String getUseExternalTransaction() {
        return this.useExternalTransaction;
    }

    public void setUseExternalTransaction(String useExternalTransaction) {
        this.useExternalTransaction = useExternalTransaction == null ? "NO" : useExternalTransaction;
    }

    public String getDbMetaDataforDBTools() {
        return this.dbMetaDataforDBTools;
    }

    public void setDbMetaDataforDBTools(String dbMetaDataforDBTools) {
        if (dbMetaDataforDBTools.equalsIgnoreCase("ON")) {
            this.dbMetaDataforDBTools = "ON";
        }
    }

    static {
        DEFAULT_MAX_IDLE_TIMEOUT = 0;
        t4GlobalLogLevel = null;
        t4GlobalLogFile = null;
        t4GlobalLogger = null;
        t4GlobalLogFileHandler = null;
        t4SlowQueryGlobalLogFile = null;
        t4SlowQueryGlobalLogger = null;
        t4SlowQueryGlobalLogFileHandler = null;
    }
}

