/*
#
# COPYRIGHT INFORMATION
#
# Copyright (C) 2013 Indian Institute of Science
# Bangalore 560012, INDIA
#
# This program is part of the CODD Metadata Processor
# software distribution invented at the Database Systems Lab,
# Indian Institute of Science. The use of the software is governed
# by the licensing agreement set up between the copyright owner,
# Indian Institute of Science, and the licensee.
#
# This program is distributed WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# The public URL of the CODD project is
# http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
#
# For any issues, contact
# Prof. Jayant R. Haritsa
# SERC
# Indian Institute of Science
# Bangalore 560012, India.
# 

# Email: haritsa@dsl.serc.iisc.ernet.in
# 
#
 */
package iisc.dsl.codd.client;
import iisc.dsl.codd.db.ColumnStatistics;
import iisc.dsl.codd.db.DBConstants;
import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.db.IndexStatistics;
import iisc.dsl.codd.db.RelationStatistics;
import iisc.dsl.codd.db.db2.DB2ColumnStatistics;
import iisc.dsl.codd.db.db2.DB2ConstructModeGUI;
import iisc.dsl.codd.db.db2.DB2IndexStatistics;
import iisc.dsl.codd.db.db2.DB2RelationStatistics;
import iisc.dsl.codd.db.nonstopsql.NonStopSQLColumnStatistics;
import iisc.dsl.codd.db.nonstopsql.NonStopSQLConstructModeGUI;
import iisc.dsl.codd.db.nonstopsql.NonStopSQLIndexStatistics;
import iisc.dsl.codd.db.nonstopsql.NonStopSQLRelationStatistics;
import iisc.dsl.codd.db.oracle.OracleColumnStatistics;
import iisc.dsl.codd.db.oracle.OracleConstructModeGUI;
import iisc.dsl.codd.db.oracle.OracleIndexStatistics;
import iisc.dsl.codd.db.oracle.OracleRelationStatistics;
import iisc.dsl.codd.db.postgres.PostgresColumnStatistics;
import iisc.dsl.codd.db.postgres.PostgresConstructModeGUI;
import iisc.dsl.codd.db.postgres.PostgresIndexStatistics;
import iisc.dsl.codd.db.postgres.PostgresRelationStatistics;
import iisc.dsl.codd.ds.Constants;
import iisc.dsl.codd.ds.Statistics;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import iisc.dsl.codd.client.gui.BaseJPanel;
import javax.swing.GroupLayout.Alignment;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;
import java.awt.Component;
/**
 * Construct mode allows the user to construct metadata from scratch or from CODD transfered metadata file.
 * ConstructMode Frame allows the user to choose any one of the following operations:
 *  1) Construct from Scratch
 *  2) Construct from CODD transfered metadata
 * @author dsladmin
 */
public class ConstructMode extends javax.swing.JFrame {
	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 3244331955831364035L;
	private String type;  // DB Engine type
	private String[] relations; // Set of relations to construct
	private Database database; // Database object
	private File selectedFile; // Metadata file selected

	/**
	 * Constructor for ConstructMode
	 * @param Type Database Vendor Name
	 * @param relations Set of relations to construct
	 * @param database Connected Database object
	 */
	public ConstructMode(String Type, String [] relations, Database database) {
		type= Type;
		this.relations = relations;
		this.database = database;
		this.selectedFile = null;
		initComponents();
		setLocationRelativeTo(null);
		setTitle("ConstructMode - " +type);
		// Disable all the components except the three radio buttons.
		//-jLabel3.setEnabled(false);   // Enter File Path
		jTextField2.setEnabled(false);   // File Path
		jTextField2.setText("");   // File Path
		jButton2.setEnabled(false);   // Browse
		jCheckBox1.setEnabled(false); // Modify and Update
		/*if(type.equals(DBConstants.NONSTOPSQL)) {
			jRadioButton2.setEnabled(false);
		}*/
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		buttonGroup1 = new javax.swing.ButtonGroup();
		jPanel1 = new BaseJPanel("img/bg_net.png");
		jPanel2 = new javax.swing.JPanel();
		jRadioButton1 = new javax.swing.JRadioButton();
		jRadioButton2 = new javax.swing.JRadioButton();
		jSeparator2 = new javax.swing.JSeparator();
		jLabel3 = new javax.swing.JLabel();
		jTextField2 = new javax.swing.JTextField();
		jButton2 = new javax.swing.JButton();
		jCheckBox1 = new javax.swing.JCheckBox();
		jButton3 = new javax.swing.JButton();
		jButton5 = new javax.swing.JButton();
		jSeparator3 = new javax.swing.JSeparator();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Choose Option", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Cambria", 0, 12), new java.awt.Color(51, 0, 153))); // NOI18N
		jPanel2.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jPanel2.setOpaque(false);

		buttonGroup1.add(jRadioButton1);
		jRadioButton1.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jRadioButton1.setText("Construct from scratch");
		jRadioButton1.setOpaque(false);
		jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jRadioButton1ActionPerformed(evt);
			}
		});

		buttonGroup1.add(jRadioButton2);
		jRadioButton2.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jRadioButton2.setText("Construct from baseline configuration");
		jRadioButton2.setToolTipText("");
		jRadioButton2.setOpaque(false);
		jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jRadioButton2ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
		jPanel2.setLayout(jPanel2Layout);
		jPanel2Layout.setHorizontalGroup(
				jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel2Layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jRadioButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 258, javax.swing.GroupLayout.PREFERRED_SIZE)
						.addGap(10, 10, 10)
						.addComponent(jRadioButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addContainerGap())
				);
		jPanel2Layout.setVerticalGroup(
				jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel2Layout.createSequentialGroup()
						.addContainerGap(8, Short.MAX_VALUE)
						.addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
								.addComponent(jRadioButton1)
								.addComponent(jRadioButton2))
								.addGap(0, 0, 0))
				);

		jLabel3.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel3.setText("Enter the directory path to the CODD Transferred files:");
		jLabel3.setToolTipText("");

		jButton2.setText("Browse");
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton2ActionPerformed(evt);
			}
		});

		jCheckBox1.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jCheckBox1.setText("Modify and Update");
		jCheckBox1.setToolTipText("Modifiy the read metadata and update");
		jCheckBox1.setOpaque(false);

		jButton3.setText("<< Back");
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton3ActionPerformed(evt);
			}
		});

		jButton5.setText("Continue >>");
		jButton5.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton5ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1Layout.setHorizontalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addContainerGap()
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
						.addComponent(jSeparator3, GroupLayout.DEFAULT_SIZE, 557, Short.MAX_VALUE)
						.addComponent(jSeparator2, GroupLayout.DEFAULT_SIZE, 557, Short.MAX_VALUE)
						.addComponent(jPanel2, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
								.addComponent(jLabel3)
								.addComponent(jTextField2, GroupLayout.PREFERRED_SIZE, 424, GroupLayout.PREFERRED_SIZE))
							.addPreferredGap(ComponentPlacement.RELATED)
							.addComponent(jButton2, GroupLayout.DEFAULT_SIZE, 127, Short.MAX_VALUE))
						.addGroup(Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
							.addComponent(jButton3)
							.addPreferredGap(ComponentPlacement.RELATED, 367, Short.MAX_VALUE)
							.addComponent(jButton5))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(jCheckBox1)
							.addGap(0, 414, Short.MAX_VALUE)))
					.addContainerGap())
		);
		jPanel1Layout.setVerticalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addContainerGap()
					.addComponent(jPanel2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(jLabel3)
							.addPreferredGap(ComponentPlacement.UNRELATED)
							.addComponent(jTextField2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addComponent(jButton2, GroupLayout.PREFERRED_SIZE, 48, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(jSeparator2, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(jCheckBox1)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(jSeparator3, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(jButton3, GroupLayout.PREFERRED_SIZE, 38, GroupLayout.PREFERRED_SIZE)
						.addComponent(jButton5, GroupLayout.PREFERRED_SIZE, 39, GroupLayout.PREFERRED_SIZE))
					.addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
		);
		jPanel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {jButton3, jButton5});
		jPanel1.setLayout(jPanel1Layout);

		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
		// Back Button
		new ModeSelection(database, relations).setVisible(true);
		this.dispose();
	}//GEN-LAST:event_jButton3ActionPerformed

	/**
	 * Initializes the Statistics for all the relations to construct from the CODD transfered metadata file (in case of Construct from transfered file)
	 * or with the default initial values. Engine specific Construct Mode window is shown with the initialized metadata.
	 * if the transfered metadata vendor and connected database vendor is same
	 *  Use the initial statistics as such
	 * else
	 *  transform the statistics for the destination database (Super class metadata, Histogram adjustment)
	 * @param readType - Database Vendor name of the transfered metadata
	 * @param allStats - Initial Statistics for the selected relations
	 */
	private void initializeStatisticsAndCallConstructWindow(String readType, Statistics[] allStats)
	{
		Statistics[] newStats;
		try
		{
			if(readType != null && readType.equals(this.type))
			{
				newStats = allStats;
			}
			else
			{
				if (readType != null && (type.equals(DBConstants.ORACLE) || type.equals(DBConstants.POSTGRES))) {
					Constants.status = -1; // Mapping warning
				}
				newStats = new Statistics[relations.length];
				for (int i = 0; i < relations.length; i++) {
					/** Relation Statistics. **/
					String relationName = relations[i];
					Statistics stat = new Statistics(relationName, this.type);
					RelationStatistics relStat = null;

					if (type.equals(DBConstants.MSSQL)) {
						//relStat = new MSSQLRelationStatistics(); // No Construct mode
					}
					else if (type.equals(DBConstants.ORACLE)) {
						relStat = new OracleRelationStatistics(relationName, database.getSchema());
					}
					else if (type.equals(DBConstants.DB2)) {
						relStat = new DB2RelationStatistics(relationName, database.getSchema());
					}
					else if (type.equals(DBConstants.SYBASE)) {

					}
					else if (type.equals(DBConstants.POSTGRES)) {
						relStat = new PostgresRelationStatistics(relationName, database.getSchema());
					}
					else if (type.equals(DBConstants.NONSTOPSQL)) {
						relStat = new NonStopSQLRelationStatistics(relationName, database.getSchema(), database.getCatalog());
					}
					// Initialize super class metadata if read allStats are read from another database
					if(readType != null) {
						relStat.mapForPorting(allStats[i].getRelationStatistics());
					}
					stat.setRelationStatistics(relStat);

					/** Columns Statistics. **/
					String[] attribs;
					if(type.equals(DBConstants.NONSTOPSQL)){
						attribs = database.getMultiColumnAttributes(relationName);
					}else{
						attribs = database.getAttributes(relationName);
					}
					for(int j=0;j<attribs.length;j++)
					{
						String colName = attribs[j];
						String colType = database.getType(relationName, attribs[j]);
						ColumnStatistics colStat = null;
						if (type.equals(DBConstants.MSSQL)) {
							//colStat = new MSSQLColumnStatistics(); No ConstructMode for MSSQL
						} else if (type.equals(DBConstants.ORACLE)) {
							OracleColumnStatistics OrclColStat = new OracleColumnStatistics(relationName, colName, colType, database.getConstraint(relationName, colName));
							if (readType == null) {
								// Construct Mode from Scratch. Set UserInput boolean variable.
								OrclColStat.setUserInput(true);
							}
							colStat = OrclColStat;
						} else if (type.equals(DBConstants.DB2)) {
							colStat = new DB2ColumnStatistics(relationName, colName, colType, database.getConstraint(relationName, colName));
						} else if (type.equals(DBConstants.SYBASE)) {
						} else if (type.equals(DBConstants.POSTGRES)) {
							colStat = new PostgresColumnStatistics(relationName, colName, colType, database.getConstraint(relationName, colName));
						} else if (type.equals(DBConstants.NONSTOPSQL)) {
							colStat = new NonStopSQLColumnStatistics(relationName, colName, colType, database.getConstraint(relationName, colName));
						}
						// Initialize global Variables if read from another Histogram
						if (readType != null) {
							colStat.mapForPorting(allStats[i].getColumnStatistics(colName), relStat.getCardinality());
						}
						stat.addColumnStatistics(colName, colStat);
					}

					/** Index Statistics. **/
					Map<String,String> map = database.getIndexedColumns(relationName);
					Iterator<String> iterator = map.keySet().iterator();

					while (iterator.hasNext()) {
						String indName = iterator.next();
						String colNames = map.get(indName);
						ArrayList<String> cols = new ArrayList<String>();
						if (colNames.contains("+")) {
							String[] col = colNames.split(Pattern.quote("+"));
							for (int c = 0; c < col.length; c++) {
								cols.add(col[c]);
							}
						} else {
							cols.add(colNames);
						}
						IndexStatistics indStat = null;
						if (type.equals(DBConstants.MSSQL)) {
							//indStat = new MSSQLIndexStatistics();
						} else if (type.equals(DBConstants.ORACLE)) {
							indStat = new OracleIndexStatistics(relationName, cols);
						} else if (type.equals(DBConstants.DB2)) {
							indStat = new DB2IndexStatistics(relationName, cols);
						} else if (type.equals(DBConstants.SYBASE)) {
						} else if (type.equals(DBConstants.POSTGRES)) {
							indStat = new PostgresIndexStatistics(relationName, cols);
						} else if (type.equals(DBConstants.NONSTOPSQL)) {
							indStat = new NonStopSQLIndexStatistics(relationName, cols);
						}
						// Initialize global Variables if read from another Histogram
						if (readType != null) {
							indStat.mapForPorting(allStats[i].getIndexStatistics(colNames));
						}
						stat.addIndexStatistics(colNames, indStat);
					}
					newStats[i] = stat;
				} // End for
				if (readType != null && (type.equals(DBConstants.ORACLE) || type.equals(DBConstants.POSTGRES))) {
					Constants.status = 0; // Reset Mapping warning
				}
			}
			// Use newStats[] for the construct mode GUI initializer
			if (type.equals(DBConstants.MSSQL)) {
				//new mssqlConstructMode(database, newStats).setVisible();
			} else if (type.equals(DBConstants.ORACLE)) {
				new OracleConstructModeGUI(database, newStats).setVisible(true);
			} else if (type.equals(DBConstants.DB2)) {
				new DB2ConstructModeGUI(database, newStats).setVisible(true);
			} else if (type.equals(DBConstants.SYBASE)) {
			} else if (type.equals(DBConstants.POSTGRES)) {
				new PostgresConstructModeGUI(database, newStats).setVisible(true);
			} else if (type.equals(DBConstants.NONSTOPSQL)) {
				new NonStopSQLConstructModeGUI(database, newStats).setVisible(true);
			}
		}
		catch(Exception e)
		{
			Constants.CPrintErrToConsole(e);
			JOptionPane.showMessageDialog(null, "Exception Caught: Could not initialize metadata.", "CODD - Exception", JOptionPane.ERROR_MESSAGE);
		}
	}

	private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed

		// Continue Button
		/**
		 * Determine the option chosen.
		 *  Construct from Scratch
		 *      call constructMode window with null
		 *  Construct from file
		 *      If Modify
		 *          call constructMode window with read data
		 *      Else
		 *          Construct with read data
		 */

		if(jRadioButton1.isSelected()){
			// Construct from Scratch
			initializeStatisticsAndCallConstructWindow(null, null);
			this.dispose();
		}
		else if (jRadioButton2.isSelected()) {

			if(selectedFile != null)
			{
				// Construct from CODD transferred file
				Statistics[] allStats = new Statistics[relations.length];
				boolean readFailure = false;
				// Read File Type
				String readType = null;
				try {
					String fileName = selectedFile.getAbsolutePath() + Constants.PathSeparator + "dbType";;
					FileInputStream fis = new FileInputStream(fileName);
					ObjectInputStream ois = new ObjectInputStream(fis);
					readType = (String) ois.readObject();
					ois.close();
				} catch (Exception e) {
					readFailure = true;
					Constants.CPrintErrToConsole(e);
					JOptionPane.showMessageDialog(null, "Exception: Could not read metadata object dbType file.", "CODD - Exception", JOptionPane.ERROR_MESSAGE);
				}
				for(int i=0; i<relations.length && !readFailure; i++)
				{
					String relationName = relations[i];
					String fileName = selectedFile.getAbsolutePath()+Constants.PathSeparator+relationName;
					Constants.CPrintToConsole(" Reading statistics from file "+fileName, Constants.DEBUG_FIRST_LEVEL_Information);
					Statistics stats = null;
					try {
						FileInputStream fis = new FileInputStream(fileName);
						ObjectInputStream ois = new ObjectInputStream(fis);
						stats = (Statistics) ois.readObject();
						ois.close();
						allStats[i] = stats;
						/**
						 * 1) Validate Relations in terms of the schema i.e. validate schema in source and destination are same
						 *      Current implementation assumes same schema is exists i.e same relation, attribute name and indexed columns in source and destination databases.
						 * 2) Provide option to map source relation or attributes to destination database, in case schema differs in naming
						 *      For example, the relation name could be different for source and destination database PART and PART1 and similarly for attributes.
						 */
					} catch (Exception e) {
						readFailure = true;
						Constants.CPrintErrToConsole(e);
						JOptionPane.showMessageDialog(null, "Exception: Could not read metadata object from the file "+relationName+".", "CODD - Exception", JOptionPane.ERROR_MESSAGE);
					}
				}
				if(readFailure)
				{
					try {
						new GetRelationFrame(database).setVisible(true);
						this.dispose();
					} catch (Exception ex) {
						Constants.CPrintErrToConsole(ex);
						JOptionPane.showMessageDialog(this, "Exception Thrown :" + ex.getMessage(), "Fatal Error", JOptionPane.ERROR_MESSAGE);
					}
				}
				else
				{
					boolean success = true;
					if (jCheckBox1.isSelected()) {
						// Construct and modify the read data
						initializeStatisticsAndCallConstructWindow(readType, allStats);
						this.dispose();
					} else {
						// Construct with read data
						if (readType != null && (type.equals(DBConstants.ORACLE) || type.equals(DBConstants.POSTGRES))) {
							Constants.status = -1; //Mapping warning
						}
						for (int i = 0; i < allStats.length; i++) {
							if (allStats[i] != null) {
								// Validation is not required. Assuming the CODD transfered metadata is valid.
								success = success & allStats[i].updateStatisticsToDatabase(database);
							}
						}
						if (readType != null && (type.equals(DBConstants.ORACLE) || type.equals(DBConstants.POSTGRES))) {
							Constants.status = 0; // Reset Mapping warning
						}
						if(success) {
							JOptionPane.showMessageDialog(null, "Statistics Construct is Successful.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
						} else {
							JOptionPane.showMessageDialog(null, "Statistics Construct is Failed.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
						}
						try{
							new GetRelationFrame(database).setVisible(true);
							this.dispose();							
						}catch(Exception e){
				            Constants.CPrintErrToConsole(e);
				            JOptionPane.showMessageDialog(null,e.getMessage(), "CODD - Exception",JOptionPane.ERROR_MESSAGE);
						}
					}
				}
			}
			else
			{
				JOptionPane.showMessageDialog(null, "Path to the file is incorrect.", "CODD Error Message", 0);
			}
		} else {
			JOptionPane.showMessageDialog(null, "You are required to select one of the two option to move ahead. To abort construct mode press Exit.", "CODD Error Message", 0);
		}
	}//GEN-LAST:event_jButton5ActionPerformed

	private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
		// Construt From Scratch
		jLabel3.setEnabled(false);   // Enter File Path
		jTextField2.setEnabled(false);   // File Path
		jTextField2.setText("");   // File Path
		jButton2.setEnabled(false);   // Browse
		jCheckBox1.setEnabled(false); // Modify and Update
	}//GEN-LAST:event_jRadioButton1ActionPerformed

	private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
		// Construct from CODD transferred file
		jLabel3.setEnabled(true);   // Enter File Path
		jTextField2.setEnabled(true);   // File Path
		jTextField2.setText("");   // File Path
		jButton2.setEnabled(true);   // Browse
		//if (type.equals(DBConstants.ORACLE)) {
		//    jCheckBox1.setEnabled(false); // Modify and Update
		//} else {
		jCheckBox1.setEnabled(true); // Modify and Update
		//}
	}//GEN-LAST:event_jRadioButton2ActionPerformed

	private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
		// Get the directory which has the transferred metadata

		JFileChooser filechooser = new JFileChooser();
		filechooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		String currDir = Constants.getWorkingDirectory();
		filechooser.setCurrentDirectory(new File(currDir));
		int returnvalue = filechooser.showOpenDialog(this);
		if (returnvalue == JFileChooser.APPROVE_OPTION) {
			selectedFile = filechooser.getSelectedFile();
			jTextField2.setText(selectedFile.getAbsolutePath());
			Constants.CPrintToConsole("Read Metadata files from this directory.: "+selectedFile.getAbsolutePath(), Constants.DEBUG_FIRST_LEVEL_Information);
		}
	}//GEN-LAST:event_jButton2ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.ButtonGroup buttonGroup1;
	private javax.swing.JButton jButton2;
	private javax.swing.JButton jButton3;
	private javax.swing.JButton jButton5;
	private javax.swing.JCheckBox jCheckBox1;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JRadioButton jRadioButton1;
	private javax.swing.JRadioButton jRadioButton2;
	private javax.swing.JSeparator jSeparator2;
	private javax.swing.JSeparator jSeparator3;
	private javax.swing.JTextField jTextField2;
	// End of variables declaration//GEN-END:variables

}