/*
#
# COPYRIGHT INFORMATION
#
# Copyright (C) 2013 Indian Institute of Science
# Bangalore 560012, INDIA
#
# This program is part of the CODD Metadata Processor
# software distribution invented at the Database Systems Lab,
# Indian Institute of Science. The use of the software is governed
# by the licensing agreement set up between the copyright owner,
# Indian Institute of Science, and the licensee.
#
# This program is distributed WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# The public URL of the CODD project is
# http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
#
# For any issues, contact
# Prof. Jayant R. Haritsa
# SERC
# Indian Institute of Science
# Bangalore 560012, India.
# 

# Email: haritsa@dsl.serc.iisc.ernet.in
# 
#
 */
package iisc.dsl.codd.client;
import iisc.dsl.codd.DatalessException;
import iisc.dsl.codd.db.DBConstants;
import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.ds.Constants;
import java.awt.Color;
import javax.swing.JOptionPane;
import javax.swing.DefaultListModel;
import java.util.ArrayList;
import javax.swing.GroupLayout.Alignment;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle.ComponentPlacement;
import java.awt.Font;

/**
 * GetRelationFrame lets user to choose relations to perform CODD dataless operations on them.
 * GetRelationFrame lists all the relations of the database user. The user can select the
 * relations on which he/she wants to perform the CODD Dataless modes.
 * @author dsladmin
 */
public class GetRelationFrame extends javax.swing.JFrame {
	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = -4657853005410822820L;
	String type; // Database Vendor name
	DefaultListModel model = new DefaultListModel(); // Lists the not Selected Relations
	DefaultListModel model1 = new DefaultListModel(); // Lists the Selected Relations
	Database database;

	/**
	 * Constructor for GetRelationFrame.
	 * @param database - Database object.
	 */
	public GetRelationFrame(Database database) throws DatalessException {
		setTitle("Relation Frame");
		setResizable(false);
		this.database = database;
		initComponents();
		setLocationRelativeTo(null);
		jList1.setModel(model);
		jList2.setModel(model1);
		type = database.getSettings().getDbVendor();
		try
		{
			ArrayList<String> relations = database.getRelations();
			int j = 0;
			String vendor = database.getSettings().getDbVendor();
			for (int i = 0; i < relations.size(); i++) {
				String relation = relations.get(i);
				if (!DBConstants.isSystemCreatedRelationToIgnore(vendor, relation)) {
					model.addElement(relation);
					j++;
				}
			}
		}
		catch(Exception e)
		{
			throw new DatalessException(e.getMessage());
		}
	}



	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jPanel1 = new iisc.dsl.codd.client.gui.BaseJPanel("img/bg_net.png");
		jLabel4 = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		jScrollPane1 = new javax.swing.JScrollPane();
		jList1 = new javax.swing.JList();
		jLabel2 = new javax.swing.JLabel();
		jSeparator2 = new javax.swing.JSeparator();
		jSeparator3 = new javax.swing.JSeparator();
		jScrollPane2 = new javax.swing.JScrollPane();
		jList2 = new javax.swing.JList();
		jList2.setFont(new Font("Courier New", Font.PLAIN, 14));
		jButton2 = new javax.swing.JButton();
		jButton3 = new javax.swing.JButton();
		jButton4 = new javax.swing.JButton();
		jButton5 = new javax.swing.JButton();
		jLabel3 = new javax.swing.JLabel();
		jSeparator4 = new javax.swing.JSeparator();
		jButton7 = new javax.swing.JButton();
		jButton1 = new javax.swing.JButton();
		jLabel5 = new javax.swing.JLabel();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

		jLabel4.setFont(new java.awt.Font("Cambria", 0, 14));
		jLabel4.setText("Database Name:");

		jList1.setBackground(Color.WHITE);
		jList1.setFont(new Font("Courier New", Font.PLAIN, 14));
		jList1.setSelectionBackground(new java.awt.Color(204, 255, 204));
		jScrollPane1.setViewportView(jList1);

		jLabel2.setFont(new java.awt.Font("Cambria", 0, 14));
		jLabel2.setText("Available Relations:");
		jLabel2.setToolTipText("<html> This box contains the relations that are available in the selected schema.<br />  Users can select the required relations to perform further operations. </html> >");

		jScrollPane2.setViewportView(jList2);

		jButton2.setText(">");
		jButton2.setToolTipText("Move selected to right side");
		jButton2.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton2ActionPerformed(evt);
			}
		});

		jButton3.setText("<");
		jButton3.setToolTipText("Move selected to left side");
		jButton3.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton3ActionPerformed(evt);
			}
		});

		jButton4.setText(">>");
		jButton4.setToolTipText("Move All to right side");
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton4ActionPerformed(evt);
			}
		});

		jButton5.setText("<<");
		jButton5.setToolTipText("Move all to left side");
		jButton5.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton5ActionPerformed(evt);
			}
		});

		jLabel3.setFont(new java.awt.Font("Cambria", 0, 14));
		jLabel3.setText("Selected Relations:");
		jLabel3.setToolTipText("<html> This box shows the relations selected by the user.<br /> The selected relations will be used by CODD for various<br /> operations. </html>");

		jButton7.setText("<< Back");
		jButton7.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton7ActionPerformed(evt);
			}
		});

		jButton1.setText("Continue >>");
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		jLabel5.setFont(new java.awt.Font("Tahoma", 1, 12));
		jLabel5.setText(database.getSettings().getDbName());
		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1Layout.setHorizontalGroup(
				jPanel1Layout.createParallelGroup(Alignment.TRAILING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
								.addComponent(jSeparator4, GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
								.addComponent(jSeparator1, GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
								.addGroup(jPanel1Layout.createSequentialGroup()
										.addComponent(jLabel4)
										.addPreferredGap(ComponentPlacement.UNRELATED)
										.addComponent(jLabel5, GroupLayout.DEFAULT_SIZE, 357, Short.MAX_VALUE))
										.addGroup(jPanel1Layout.createSequentialGroup()
												.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
														.addGroup(jPanel1Layout.createSequentialGroup()
																.addComponent(jScrollPane1, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE)
																.addPreferredGap(ComponentPlacement.RELATED)
																.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
																		.addComponent(jSeparator2, GroupLayout.PREFERRED_SIZE, 50, GroupLayout.PREFERRED_SIZE)
																		.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING, false)
																				.addComponent(jSeparator3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
																				.addComponent(jButton2, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																				.addComponent(jButton3, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																				.addComponent(jButton4, GroupLayout.PREFERRED_SIZE, 50, Short.MAX_VALUE)
																				.addComponent(jButton5, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
																				.addComponent(jLabel2))
																				.addPreferredGap(ComponentPlacement.UNRELATED)
																				.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
																						.addComponent(jLabel3)
																						.addComponent(jScrollPane2, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE)))
																						.addGroup(jPanel1Layout.createSequentialGroup()
																								.addComponent(jButton7, GroupLayout.PREFERRED_SIZE, 120, GroupLayout.PREFERRED_SIZE)
																								.addPreferredGap(ComponentPlacement.RELATED, 242, Short.MAX_VALUE)
																								.addComponent(jButton1)))
																								.addContainerGap())
				);
		jPanel1Layout.setVerticalGroup(
				jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING, false)
								.addComponent(jLabel4, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addComponent(jLabel5, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
								.addPreferredGap(ComponentPlacement.RELATED)
								.addComponent(jSeparator1, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE)
								.addPreferredGap(ComponentPlacement.RELATED)
								.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
										.addComponent(jLabel2)
										.addComponent(jLabel3))
										.addPreferredGap(ComponentPlacement.RELATED)
										.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
												.addGroup(jPanel1Layout.createSequentialGroup()
														.addComponent(jSeparator3, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.RELATED)
														.addComponent(jButton2, GroupLayout.PREFERRED_SIZE, 35, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.RELATED)
														.addComponent(jButton3, GroupLayout.PREFERRED_SIZE, 35, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.RELATED)
														.addComponent(jButton4, GroupLayout.PREFERRED_SIZE, 37, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.RELATED)
														.addComponent(jButton5, GroupLayout.PREFERRED_SIZE, 35, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.RELATED, 124, Short.MAX_VALUE)
														.addComponent(jSeparator2, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE))
														.addComponent(jScrollPane1, GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
														.addComponent(jScrollPane2, GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE))
														.addPreferredGap(ComponentPlacement.RELATED, 11, GroupLayout.PREFERRED_SIZE)
														.addComponent(jSeparator4, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(ComponentPlacement.UNRELATED)
														.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
																.addComponent(jButton7, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
																.addComponent(jButton1, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE))
																.addContainerGap())
				);
		jPanel1.setLayout(jPanel1Layout);

		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		int selectedcnt = model1.getSize();
		if (selectedcnt == 0) {
			JOptionPane.showMessageDialog(null, "You are required to select atleast one relation to move ahead.", "CODD Error Message - Action Required", 0);
		} else {
			String[] selectedRelation = new String[selectedcnt];
			for (int j = 0; j < selectedcnt; j++) {
				selectedRelation[j] = model1.getElementAt(j).toString();
				Constants.CPrintToConsole(selectedRelation[j], Constants.DEBUG_SECOND_LEVEL_Information);
			}
			try {
				new ModeSelection(database, selectedRelation).setVisible(true);
				this.dispose();
			} catch (Exception e) {
				JOptionPane.showMessageDialog(this, "Exception Thrown :" + e.getMessage(), "Fatal Error", JOptionPane.ERROR_MESSAGE);
			}
		}
	}//GEN-LAST:event_jButton1ActionPerformed

	private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
		for(int i = 0; i < model.size(); i++)
		{
			model1.addElement(model.getElementAt(i));
		}
		model.removeAllElements();
	}//GEN-LAST:event_jButton4ActionPerformed

	private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
		for(int i = 0; i < model1.size(); i++)
		{
			model.addElement(model1.getElementAt(i));
		}
		model1.removeAllElements();
	}//GEN-LAST:event_jButton5ActionPerformed

	private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
		Object[] selection = jList1.getSelectedValues();
		int len = selection.length;
		for (int k = 0; k < len; k++) {
			String selectedrelation = selection[k].toString();
			model.removeElement(selectedrelation);
			model1.addElement(selectedrelation);
		}
	}//GEN-LAST:event_jButton2ActionPerformed

	private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
		Object[] selection = jList2.getSelectedValues();
		int len = selection.length;
		for (int k = 0; k < len; k++) {
			String selectedrelation = selection[k].toString();
			model1.removeElement(selectedrelation);
			model.addElement(selectedrelation);
		}
	}//GEN-LAST:event_jButton3ActionPerformed

	private void jButton7ActionPerformed(java.awt.event.ActionEvent evt){//GEN-FIRST:event_jButton7ActionPerformed
		String dbServerName, dbType, dbServerPort, dbName, dbCatalog, dbSchema, dbUserName, dbPassword, serverInstance, dbVersion;
		try{
			//if(database.getSettings().getDbVendor().equals(DBConstants.DB2)){
			//	new ConfigurationTypeSelection(database).setVisible(true);
			//}else{
				dbServerName = database.getSettings().getServerName();
				dbType = database.getSettings().getDbVendor();
				dbServerPort = database.getSettings().getServerPort();
				dbName = database.getSettings().getDbName();
				dbCatalog = database.getSettings().getCatalog();
				dbSchema = database.getSettings().getSchema();
				dbUserName = database.getSettings().getUserName();
				dbPassword = database.getSettings().getPassword();
				serverInstance = database.getSettings().getSqlServerInstanceName();
				dbVersion = database.getSettings().getVersion();
				database.close();        		
				new ConnectDBFrame(dbServerName, dbType, dbServerPort, dbName, dbCatalog, dbSchema, dbUserName, dbPassword, serverInstance, dbVersion).setVisible(true);
			//}
		}catch(Exception e){
			JOptionPane.showMessageDialog(this, "Exception Thrown :" + e.getMessage(), "Fatal Error", JOptionPane.ERROR_MESSAGE);
		} finally {
			this.dispose();
		}
	}//GEN-LAST:event_jButton7ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButton1;
	private javax.swing.JButton jButton2;
	private javax.swing.JButton jButton3;
	private javax.swing.JButton jButton4;
	private javax.swing.JButton jButton5;
	private javax.swing.JButton jButton7;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JLabel jLabel4;
	private javax.swing.JLabel jLabel5;
	private javax.swing.JList jList1;
	private javax.swing.JList jList2;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JScrollPane jScrollPane2;
	private javax.swing.JSeparator jSeparator1;
	private javax.swing.JSeparator jSeparator2;
	private javax.swing.JSeparator jSeparator3;
	private javax.swing.JSeparator jSeparator4;
	// End of variables declaration//GEN-END:variables
}
