/*
#
# COPYRIGHT INFORMATION
#
# Copyright (C) 2013 Indian Institute of Science
# Bangalore 560012, INDIA
#
# This program is part of the CODD Metadata Processor
# software distribution invented at the Database Systems Lab,
# Indian Institute of Science. The use of the software is governed
# by the licensing agreement set up between the copyright owner,
# Indian Institute of Science, and the licensee.
#
# This program is distributed WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# The public URL of the CODD project is
# http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
#
# For any issues, contact
# Prof. Jayant R. Haritsa
# SERC
# Indian Institute of Science
# Bangalore 560012, India.
# 

# Email: haritsa@dsl.serc.iisc.ernet.in
# 
#
 */
package iisc.dsl.codd.client;

import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.ds.Constants;
import javax.swing.JOptionPane;
import javax.swing.DefaultListModel;

/**
 * This class implements the TPC-H Style Size Scaling.
 * It scales the selected relation by the scaling factor.
 * @author dsladmin
 */
public class SizeScaling extends javax.swing.JFrame {
	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 5174458817727387559L;
	String[] selectedRelation; // List of selected relations
	DefaultListModel model1 = new DefaultListModel(); //selected relations
	boolean runStats; // Indicates whether statistics on the selected relations must be collected before scaling or not
	Database database; // Database object

	/**
	 * Constructor for SizeScaling
	 * @param relations - Array of relations to scale
	 * @param sf - scale factor
	 * @param runStats - boolean, which determines the statistics collection on the selected relations before scaling
	 * @param database - Database object
	 */
	public SizeScaling(String[] relations, String sf, boolean runStats, Database database) {
		System.out.println("Size scaling.");
		this.database = database;
		selectedRelation = relations;
		this.runStats = runStats;
		initComponents();
		setLocationRelativeTo(null);
		setTitle("Metadata Size Scaling (TPC-H Style)");
		getContentPane().setBackground(new java.awt.Color(255, 255, 204));
		jList1.setModel(model1);
		jLabel8.setText(sf);
		for (int i = 0; i < relations.length; i++) {
			model1.addElement(relations[i]);
		}
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jPanel1 = new iisc.dsl.codd.client.gui.BaseJPanel("img/bg_net.png");
		jLabel2 = new javax.swing.JLabel();
		jLabel5 = new javax.swing.JLabel();
		jScrollPane1 = new javax.swing.JScrollPane();
		jList1 = new javax.swing.JList();
		jButton3 = new javax.swing.JButton();
		jLabel7 = new javax.swing.JLabel();
		jLabel8 = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		jButton4 = new javax.swing.JButton();
		jButton1 = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		jLabel2.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel2.setText("Following relations have been selected for size scaling by the user:");

		jLabel5.setText("(To avoid scaling in any of the above relations select and press remove button)");

		jList1.setFont(new java.awt.Font("Courier New", 0, 14)); // NOI18N
		jScrollPane1.setViewportView(jList1);

		jButton3.setText("Remove");
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton3ActionPerformed(evt);
			}
		});

		jLabel7.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel7.setForeground(new java.awt.Color(255, 0, 51));
		jLabel7.setText("Scale Factor:");

		jLabel8.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel8.setForeground(new java.awt.Color(255, 0, 51));
		jLabel8.setText("0.0");

		jButton4.setText("<< Back");
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton4ActionPerformed(evt);
			}
		});

		jButton1.setText("Scale");
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1.setLayout(jPanel1Layout);
		jPanel1Layout.setHorizontalGroup(
				jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jSeparator1)
								.addGroup(jPanel1Layout.createSequentialGroup()
										.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
												.addComponent(jLabel2)
												.addComponent(jLabel5)
												.addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 423, Short.MAX_VALUE))
												.addGap(10, 10, 10)
												.addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE))
												.addGroup(jPanel1Layout.createSequentialGroup()
														.addComponent(jLabel7)
														.addGap(10, 10, 10)
														.addComponent(jLabel8)
														.addGap(0, 0, Short.MAX_VALUE))
														.addGroup(jPanel1Layout.createSequentialGroup()
																.addComponent(jButton4, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
																.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
																.addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)))
																.addContainerGap())
				);

		jPanel1Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButton1, jButton4});

		jPanel1Layout.setVerticalGroup(
				jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jLabel2)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
								.addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
								.addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 40, javax.swing.GroupLayout.PREFERRED_SIZE))
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addComponent(jLabel5)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
										.addComponent(jLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addComponent(jLabel7))
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
										.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
												.addComponent(jButton1)
												.addComponent(jButton4, javax.swing.GroupLayout.PREFERRED_SIZE, 40, javax.swing.GroupLayout.PREFERRED_SIZE))
												.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
				);

		jPanel1Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jButton1, jButton4});

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
				);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
				);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		if(model1.getSize() == 0)
		{
			JOptionPane.showMessageDialog(null, "No relations to scale.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
		}
		else
		{
			int sf = Integer.parseInt(jLabel8.getText());
			boolean success = true;
			for (int i = 0; i < model1.getSize(); i++) {
				String relation = (String) model1.get(i);
				try {
					Constants.CPrintToConsole("Size Scaling Relation " + relation + " by " + sf, Constants.DEBUG_FIRST_LEVEL_Information);
					String msg;
					if (database.scale(relation, sf, runStats)) {
						msg = "Metadata Size Scaling on realtion " + relation + " is successful.";
					} else {
						msg = "Metadata Size Scaling on realtion " + relation + " has FAILED.";
						success = false;
					}
					Constants.CPrintToConsole(msg, Constants.DEBUG_SECOND_LEVEL_Information);
				} catch (Exception e) {
					Constants.CPrintErrToConsole(e);
					JOptionPane.showMessageDialog(null, "Exception Caught: Size Scaling of Relation failed for " + relation + ".", "CODD - Exception", JOptionPane.ERROR_MESSAGE);
					success = false;
				}
			}
			if(success)
			{
				JOptionPane.showMessageDialog(null, "Metadata Size Scaling of Relations is Successful.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
			} else {
				JOptionPane.showMessageDialog(null, "Metadata Size Scaling of Relations has Failed.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
			}
		}
		try{
			new GetRelationFrame(database).setVisible(true);
			this.dispose();							
		}catch(Exception e){
            Constants.CPrintErrToConsole(e);
            JOptionPane.showMessageDialog(null,e.getMessage(), "CODD - Exception",JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButton1ActionPerformed

	private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
		new ModeSelection(database, selectedRelation).setVisible(true);
		this.dispose();
	}//GEN-LAST:event_jButton4ActionPerformed

	private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
		// Remove the seleceted elements in from model1
		Object[] selection = jList1.getSelectedValues();
		int len = selection.length;
		for (int k = 0; k < len; k++) {
			String selectedrelation = selection[k].toString();
			model1.removeElement(selectedrelation);
		}
	}//GEN-LAST:event_jButton3ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButton1;
	private javax.swing.JButton jButton3;
	private javax.swing.JButton jButton4;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel5;
	private javax.swing.JLabel jLabel7;
	private javax.swing.JLabel jLabel8;
	private javax.swing.JList jList1;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JSeparator jSeparator1;
	// End of variables declaration//GEN-END:variables
}
