/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package iisc.dsl.coddgen.ui;

import java.util.Iterator;
import java.util.Set;

import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import iisc.dsl.codd.Main;
import iisc.dsl.codd.client.MyFilter;
import iisc.dsl.codd.client.gui.BaseJPanel;
import iisc.dsl.codd.client.gui.UIUtils;
import iisc.dsl.codd.db.DBConstants;
import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.db.db2.DB2Database;
import iisc.dsl.codd.db.mssql.MSSQLDatabase;
import iisc.dsl.codd.db.nonstopsql.NonStopSQLDatabase;
import iisc.dsl.codd.db.oracle.OracleDatabase;
import iisc.dsl.codd.db.postgres.PostgresDatabase;
import iisc.dsl.codd.db.sybase.SybaseDatabase;
import iisc.dsl.codd.ds.Constants;
import iisc.dsl.codd.ds.DBSettings;
import iisc.dsl.coddgen.ui.utils.Constants.UserMode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;

/**
 *
 * @author dsladmin
 */
public class ConnectDBFrame extends javax.swing.JFrame {

	private String dbServerName, dbType, dbServerPort, dbName, dbSchema, dbCatalog, dbUserName, dbPassword,
			serverInstance, dbVersion; // input fields
	private String emptyConfig;
	private HashMap<String, String> connectionParameters;
	
	private final JFrame prevFrame;

	/**
	 * Creates new form ConnectDBFrame
	 */
	public ConnectDBFrame(JFrame prevFrame, UserMode userMode) {
		this.prevFrame = prevFrame;
		initComponents();
		getContentPane().setBackground(new java.awt.Color(255, 255, 204));
		setLocationRelativeTo(null);
		emptyConfig = new String("");
		loadConfig();
		UIUtils.disableTextField(tbServerInstance , tbCatalogName, tbVersion);
//		JOptionPane.showMessageDialog(null, Constants.WorkingDirectory, "CODD - Error", JOptionPane.PLAIN_MESSAGE);
	}
	
	public ConnectDBFrame(String dbServerName, String dbType, String dbServerPort, String dbName, String dbCatalog, String dbSchema, String dbUserName, String dbPassword, String serverInstance, String dbVersion) {
		throw new RuntimeException("Not implemented");
	}

	/**
	 * Loads the Configuration ComoboBox with the stored Connection parameters.
	 */
	private void loadConfig() {
		cbPreSavedCons.removeAllItems();
		cbPreSavedCons.addItem(emptyConfig);
		connectionParameters = DBConstants.readStoredConnectionParameters();
		if (connectionParameters != null) {
			Set<String> s = connectionParameters.keySet();
			Iterator<String> i = s.iterator();
			while (i.hasNext()) {
				String key = (String) i.next();
				cbPreSavedCons.addItem(key);
			}
			cbPreSavedCons.setSelectedItem(emptyConfig);
		} else {
			cbPreSavedCons.removeAllItems();
		}
	}

	/**
	 * Sets the form fields with connection parameters.
	 */
	private void setValues() {
		cbEngine.setSelectedItem(dbType);
		tbMachine.setText(dbServerName);
		tbPort.setText(dbServerPort);
		tbDatabase.setText(dbName);
		tbSchema.setText(dbSchema);
		tbCatalogName.setText(dbCatalog);
		tbUsername.setText(dbUserName);
		tbPassword.setText(dbPassword);
		tbServerInstance.setText(serverInstance);
		tbVersion.setText(dbVersion);
	}

	/**
	 * Sets the form fields with connection parameters.
	 */
	private void setValues(String dbServerName, String dbType, String dbServerPort, String dbName, String dbCatalog,
			String dbSchema, String dbUserName, String dbPassword, String serverInstance, String dbVersion) {
		cbEngine.setSelectedItem(dbType);
		tbMachine.setText(dbServerName);
		tbPort.setText(dbServerPort);
		tbDatabase.setText(dbName);
		tbSchema.setText(dbSchema);
		tbCatalogName.setText(dbCatalog);
		tbUsername.setText(dbUserName);
		tbPassword.setText(dbPassword);
		tbServerInstance.setText(serverInstance);
		tbVersion.setText(dbVersion);
	}

	/**
	 * Reads the connection parameters from the input fields and validates the
	 * inputs.
	 * 
	 * @return null, if all inputs are valid. Error Message, if there are any
	 *         validation errors.
	 */
	private String readAndValidateFields() {
		dbServerName = tbMachine.getText();
		dbType = (String) cbEngine.getSelectedItem();
		dbServerPort = tbPort.getText();
		dbName = tbDatabase.getText();
		dbSchema = tbSchema.getText();
		if (dbType == null || dbType.isEmpty()) {
			return "First choose the Database Engine from DropDown.";
		}
		if (dbType.equalsIgnoreCase(DBConstants.NONSTOPSQL)) {
			dbCatalog = tbCatalogName.getText();
			dbVersion = tbVersion.getText();
		} else {
			dbCatalog = "";
			dbVersion = "";
		}
		dbUserName = tbUsername.getText();
		dbPassword = new String(tbPassword.getPassword());
		serverInstance = new String(tbServerInstance.getText());
		String msg = new String();
		boolean error = false;

		if (dbServerName == null || dbServerName.isEmpty()) {
			error = true;
			msg = msg + " Databse Server Machine Name,";
		}
		if (dbServerPort == null || dbServerPort.isEmpty()) {
			error = true;
			msg = msg + " DB Server Port,";
		}
		if ((dbName == null || dbName.isEmpty()) && !dbType.equals(DBConstants.NONSTOPSQL)) {
			error = true;
			msg = msg + " Database Name,";
		}
		if (dbSchema == null || dbSchema.isEmpty()) {
			error = true;
			msg = msg + " Database Schema,";
		}
		if (dbType != null && !dbType.isEmpty() && (dbType.equals(DBConstants.NONSTOPSQL))) {
			if (dbCatalog == null || dbCatalog.isEmpty()) {
				error = true;
				msg = msg + " Database Catalog,";
			}
		}
		if (dbUserName == null || dbUserName.isEmpty()) {
			error = true;
			msg = msg + " Username,";
		}
		if (dbPassword == null || dbPassword.isEmpty()) {
			error = true;
			msg = msg + " Password,";
		}
		if (dbType != null && !dbType.isEmpty()
				&& (dbType.equals(DBConstants.MSSQL) || dbType.equals(DBConstants.NONSTOPSQL))) {
			if (serverInstance == null || serverInstance.isEmpty()) {
				error = true;
				msg = msg + " Server Instance,";
			}
		}
		if (dbType != null && !dbType.isEmpty() && (dbType.equals(DBConstants.NONSTOPSQL))) {
			if (dbVersion == null || dbVersion.isEmpty()) {
				error = true;
				msg = msg + " Version Number,";
			}
		}
		if (error) {
			msg = msg.substring(0, msg.lastIndexOf(","));
			msg = "Entries in the fields " + msg + " are not correct. Please enter the correct values.";
			return msg;
		} else {
			return null;
		}
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	
	// <editor-fold defaultstate="collapsed" desc="Generated
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel5 = new BaseJPanel("img/bg_net.png");
        jPanel4 = new javax.swing.JPanel();
        jLabel7 = new javax.swing.JLabel();
        tbUsername = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        tbPassword = new javax.swing.JPasswordField();
        jPanel3 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        lableCatalog = new javax.swing.JLabel();
        labelVersion = new javax.swing.JLabel();
        tbVersion = new javax.swing.JTextField();
        tbCatalogName = new javax.swing.JTextField();
        tbSchema = new javax.swing.JTextField();
        tbDatabase = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        tbMachine = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        labelServerInstance = new javax.swing.JLabel();
        tbServerInstance = new javax.swing.JTextField();
        tbPort = new javax.swing.JTextField();
        cbEngine = new javax.swing.JComboBox();
        cbPreSavedCons = new javax.swing.JComboBox();
        bDelConfig = new javax.swing.JButton();
        bSaveConfig = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jLabel1 = new javax.swing.JLabel();
        bBack = new javax.swing.JButton();
        bRefresh = new javax.swing.JButton();
        logopanel = new BaseJPanel("img/codd_logo_small.png");
        bConnectServer = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Credentials"));
        jPanel4.setOpaque(false);

        jLabel7.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel7.setText("User Name:");

        tbUsername.setToolTipText("");

        jLabel8.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel8.setText("Password:");

        tbPassword.setToolTipText("");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(tbUsername, javax.swing.GroupLayout.PREFERRED_SIZE, 228, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jLabel8)
                .addGap(18, 18, 18)
                .addComponent(tbPassword, javax.swing.GroupLayout.PREFERRED_SIZE, 233, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jLabel8)
                        .addComponent(tbPassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel7)
                        .addComponent(tbUsername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Schema Details"));
        jPanel3.setOpaque(false);

        jLabel5.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel5.setText("Database:");

        jLabel6.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel6.setText("Schema:");

        lableCatalog.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        lableCatalog.setText("Catalog:");

        labelVersion.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        labelVersion.setText("Version:");

        tbVersion.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N

        tbCatalogName.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N

        tbSchema.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        tbSchema.setToolTipText("Database schema");

        tbDatabase.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        tbDatabase.setToolTipText("Database name");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(lableCatalog)
                    .addComponent(jLabel6)
                    .addComponent(labelVersion, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tbVersion, javax.swing.GroupLayout.DEFAULT_SIZE, 267, Short.MAX_VALUE)
                    .addComponent(tbSchema)
                    .addComponent(tbCatalogName)
                    .addComponent(tbDatabase))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbDatabase, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbCatalogName, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lableCatalog))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbSchema, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addGap(11, 11, 11)
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbVersion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelVersion, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Database Server Details"));
        jPanel1.setOpaque(false);

        jLabel2.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel2.setText("Machine:");

        tbMachine.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        tbMachine.setToolTipText("IP address");

        jLabel3.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel3.setText("Engine:");

        jLabel4.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        jLabel4.setText("Port:");

        labelServerInstance.setFont(new java.awt.Font("Verdana", 0, 14)); // NOI18N
        labelServerInstance.setText("Server Instance:");

        tbServerInstance.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        tbServerInstance.setToolTipText("SQL Server Database Instance");

        tbPort.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        tbPort.setToolTipText("Port number of the chosen DB Engine");

        cbEngine.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "DB2", "ORACLE", "SQL SERVER", "NON STOP SQL", "POSTGRES" }));
        cbEngine.setSelectedIndex(-1);
        cbEngine.setSelectedItem(0);
        cbEngine.setToolTipText("Choose the DB Engine");
        cbEngine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbEngineActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel4)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3))
                        .addGap(68, 68, 68)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(cbEngine, 0, 228, Short.MAX_VALUE)
                            .addComponent(tbMachine)
                            .addComponent(tbPort, javax.swing.GroupLayout.Alignment.LEADING)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(labelServerInstance)
                        .addGap(12, 12, 12)
                        .addComponent(tbServerInstance)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel3)
                    .addComponent(cbEngine, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbMachine, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tbServerInstance, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelServerInstance))
                .addContainerGap(18, Short.MAX_VALUE))
        );

        cbPreSavedCons.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
        cbPreSavedCons.setToolTipText("Load the stored settings");
        cbPreSavedCons.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbPreSavedConsActionPerformed(evt);
            }
        });

        bDelConfig.setText("Delete Config");
        bDelConfig.setToolTipText("Deletes the configuration");
        bDelConfig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bDelConfigActionPerformed(evt);
            }
        });

        bSaveConfig.setText("Save Config");
        bSaveConfig.setToolTipText("Save the connection settings in to a file");
        bSaveConfig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bSaveConfigActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Verdana", 1, 12)); // NOI18N
        jLabel1.setText("Choose From Pre-Saved Connections:");

        bBack.setText("Back");
        bBack.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBackActionPerformed(evt);
            }
        });

        bRefresh.setText("Refresh");
        bRefresh.setToolTipText("Refreshes the connection configurations.");
        bRefresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRefreshActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout logopanelLayout = new javax.swing.GroupLayout(logopanel);
        logopanel.setLayout(logopanelLayout);
        logopanelLayout.setHorizontalGroup(
            logopanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        logopanelLayout.setVerticalGroup(
            logopanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 45, Short.MAX_VALUE)
        );

        bConnectServer.setText("Connect");
        bConnectServer.setToolTipText("Connect to the database");
        bConnectServer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bConnectServerActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(18, 18, 18)
                        .addComponent(cbPreSavedCons, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jSeparator1))
                .addContainerGap())
            .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addComponent(bSaveConfig, javax.swing.GroupLayout.PREFERRED_SIZE, 102, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bRefresh, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bDelConfig, javax.swing.GroupLayout.PREFERRED_SIZE, 112, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(41, 41, 41)
                .addComponent(bBack, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bConnectServer, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(logopanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPanel5Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {bBack, bConnectServer, bDelConfig, bRefresh, bSaveConfig});

        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbPreSavedCons, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 11, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createSequentialGroup()
                        .addGap(5, 5, 5)
                        .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                            .addComponent(bBack, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(bSaveConfig)
                            .addComponent(bRefresh)
                            .addComponent(bDelConfig)
                            .addComponent(bConnectServer, javax.swing.GroupLayout.PREFERRED_SIZE, 39, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(logopanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        jPanel5Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {bBack, bDelConfig, bRefresh, bSaveConfig});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

	private void cbEngineActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_cbEngineActionPerformed
		tbMachine.setText("");
		tbPort.setText("");
		tbDatabase.setText("");
		tbSchema.setText("");
		tbUsername.setText("");
		tbPassword.setText("");
		tbServerInstance.setText("");
		tbVersion.setText("");
		tbCatalogName.setText("");

		if (cbEngine.getSelectedItem().equals("SQL SERVER") || cbEngine.getSelectedItem().equals("NON STOP SQL")) {
			// Enable Server Instance Field.
			UIUtils.enableTextField(tbServerInstance);
			UIUtils.disableTextField(tbVersion, tbCatalogName);

			if (cbEngine.getSelectedItem().equals("NON STOP SQL")) {
				UIUtils.enableTextField(tbVersion, tbCatalogName);
			}

		} else {
			// Disable Server Instance Field.
			UIUtils.disableTextField(tbServerInstance, tbVersion, tbCatalogName);
		}
		if (cbEngine.getSelectedItem().equals("NON STOP SQL")) {
			UIUtils.disableTextField(tbDatabase);
		}
		if (!cbEngine.getSelectedItem().equals("NON STOP SQL")) {
			UIUtils.enableTextField(tbDatabase);
		}
		// Set the port number automatically based on the chosen DB Engine.
		if (cbEngine.getSelectedItem().equals(DBConstants.MSSQL)) {
			tbPort.setText("1433");
		} else if (cbEngine.getSelectedItem().equals(DBConstants.ORACLE)) {
			tbPort.setText("1521");
		} else if (cbEngine.getSelectedItem().equals(DBConstants.DB2)) {
			tbPort.setText("50000");
		} else if (cbEngine.getSelectedItem().equals(DBConstants.SYBASE)) {
			tbPort.setText("5000");
		} else if (cbEngine.getSelectedItem().equals(DBConstants.POSTGRES)) {
			tbPort.setText("5432");
		} else if (cbEngine.getSelectedItem().equals(DBConstants.NONSTOPSQL)) { // Added by - Deepali Nemade
			tbPort.setText("23456");
		} else {
			// Set Empty String if none of the engine is selected.
			tbPort.setText("");
		}
	}// GEN-LAST:event_cbEngineActionPerformed

	private void cbPreSavedConsActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_cbPreSavedConsActionPerformed
		/**
		 * Load the selected Configuration.
		 */
		if (cbPreSavedCons.getSelectedItem() == null) {
			return;
		}
		if (cbPreSavedCons.getSelectedItem().equals(emptyConfig)) {
			dbServerName = emptyConfig;
			dbType = emptyConfig;
			dbServerPort = emptyConfig;
			dbName = emptyConfig;
			dbSchema = emptyConfig;
			dbCatalog = emptyConfig;
			dbUserName = emptyConfig;
			dbPassword = emptyConfig;
			serverInstance = emptyConfig;
			dbVersion = emptyConfig;
			setValues();
			return;
		}
		String params = connectionParameters.get(cbPreSavedCons.getSelectedItem());
		String[] temp = params.split("%%");
		if (temp.length != 7 && temp.length != 8 && temp.length != 10) {
			JOptionPane.showMessageDialog(null, "Error in reading configuration.", "CODD - Error",
					JOptionPane.ERROR_MESSAGE);
		} else {
			dbServerName = temp[0];
			dbType = temp[1];
			dbServerPort = temp[2];
			dbName = temp[3];
			dbSchema = temp[4];
			dbUserName = temp[5];
			dbPassword = temp[6];
			if (dbType.equals(DBConstants.MSSQL)) {
				serverInstance = temp[7];
			} else {
				dbCatalog = emptyConfig;
				serverInstance = emptyConfig;
				dbVersion = emptyConfig;
				if (dbType.equals(DBConstants.NONSTOPSQL)) {
					dbCatalog = temp[7];
					serverInstance = temp[8];
					dbVersion = temp[9];
				} else {
					dbCatalog = emptyConfig;
					serverInstance = emptyConfig;
					dbVersion = emptyConfig;
				}
			}
			setValues();
		}
	}// GEN-LAST:event_cbPreSavedConsActionPerformed

	private void bDelConfigActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bDelConfigActionPerformed
		/**
		 * Delete the chosen file.
		 */
		String configName = (String) cbPreSavedCons.getSelectedItem();
		if (configName != null && !configName.equals(emptyConfig)) {
			removeLineFromConfigFile(configName);
		}
		loadConfig();
	}// GEN-LAST:event_bDelConfigActionPerformed

	private void removeLineFromConfigFile(String lineToRemove) {
		/**
		 * Removes the configuration from the file.
		 */
		Constants.CPrintToConsole("Removing Configuration of " + lineToRemove, Constants.DEBUG_FIRST_LEVEL_Information);
		try {
			File inputFile = new File(Constants.ConfigFileName);
			String tempFileName = "myTempFile";
			File tempFile = new File(tempFileName);

			BufferedReader reader = new BufferedReader(new FileReader(inputFile));
			BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));

			String currentLine;

			while ((currentLine = reader.readLine()) != null) {
				// trim newline when comparing with lineToRemove
				String configName = currentLine.substring(0, currentLine.indexOf("::"));
				if (configName.equals(lineToRemove)) {
					continue;
				}
				writer.write(currentLine + "\n");
			}
			writer.close();
			reader.close();

			BufferedReader br = new BufferedReader(new FileReader(new File(tempFileName)));
			BufferedWriter bw = new BufferedWriter(new FileWriter(new File(Constants.ConfigFileName)));
			String sCurrentLine = "";

			while ((sCurrentLine = br.readLine()) != null) {
				bw.write(sCurrentLine);
				bw.newLine();
			}

			br.close();
			bw.close();

			File org = new File(tempFileName);
			org.delete();
		} catch (Exception e) {
			Constants.CPrintErrToConsole(e);
		}
	}

	private void bSaveConfigActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bSaveConfigActionPerformed
		/**
		 * Save the current Settings in to a configuration file.
		 */
		String retString = readAndValidateFields();
		if (retString == null) {
			// Entries are fine. Go ahead and save.
			try {
				JFileChooser filechooser = new JFileChooser();
				filechooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				filechooser.addChoosableFileFilter(new MyFilter(".cfg"));
				String currDir = Constants.WorkingDirectory;
				filechooser.setCurrentDirectory(new File(currDir));
				int returnvalue = filechooser.showSaveDialog(this);
				if (returnvalue == JFileChooser.APPROVE_OPTION) {
					File selectedFile = filechooser.getSelectedFile();
					String fileName = selectedFile.getName();
					if (!fileName.endsWith(".cfg")) {
						fileName = fileName + ".cfg";
					}
					BufferedWriter writer = new BufferedWriter(new FileWriter(new File(fileName)));
					writer.write("ServerName::" + dbServerName + "\n");
					writer.write("DBType::" + dbType + "\n");
					writer.write("Port::" + dbServerPort + "\n");
					if (!dbType.equals(DBConstants.NONSTOPSQL))
						writer.write("DBName::" + dbName + "\n");
					writer.write("DBSchema::" + dbSchema + "\n");
					writer.write("UserName::" + dbUserName + "\n");
					writer.write("Password::" + dbPassword + "\n");
					if (dbType.equals(DBConstants.MSSQL)) {
						writer.write("ServerInstance::" + serverInstance + "\n");
					}
					if (dbType.equals(DBConstants.NONSTOPSQL)) {
						writer.write("DBCatalog::" + dbCatalog + "\n");
						writer.write("ServerInstance::" + serverInstance + "\n");
						writer.write("VersionNumber::" + dbVersion + "\n");
					}
					writer.close();
					/**
					 * Write into Global Configuration File
					 */
					String fileNameExCfg = fileName.substring(0, fileName.indexOf(".cfg"));
					String lineToRemove = null;
					BufferedReader reader = null;
					try {
						// Check for containment, the same parameters. In that case delete the old file.
						reader = new BufferedReader(new FileReader(new File(Constants.ConfigFileName)));
						String line = reader.readLine();
						while (line != null) {
							String[] temp = line.split("::");
							if (temp[0] != null && temp[0].equals(fileNameExCfg)) {
								lineToRemove = fileNameExCfg;
							}
							line = reader.readLine();
						}
						reader.close();
					} catch (FileNotFoundException e) {
					}
					if (lineToRemove != null) {
						removeLineFromConfigFile(lineToRemove);
					}
					writer = new BufferedWriter(new FileWriter(new File(Constants.ConfigFileName), true)); // true for
																											// append
					String Parameters = dbServerName + "%%" + dbType + "%%" + dbServerPort + "%%" + dbName + "%%"
							+ dbSchema + "%%" + dbUserName + "%%" + dbPassword;
					if (dbType.equals(DBConstants.MSSQL)) {
						Parameters = Parameters + "%%" + serverInstance;
					}
					if (dbType.equals(DBConstants.NONSTOPSQL)) {
						Parameters = Parameters + "%%" + dbCatalog + "%%" + serverInstance + "%%" + dbVersion;
					}
					writer.write(fileNameExCfg + "::" + Parameters + "\n");
					writer.close();
					JOptionPane.showMessageDialog(null,
							"Database Connection Settings are saved successfully in the file " + fileName, "CODD",
							JOptionPane.INFORMATION_MESSAGE);
					loadConfig(); // Loads the configuration File.
				}
			} catch (Exception e) {
				Constants.CPrintErrToConsole(e);
			}
		} else {
			JOptionPane.showMessageDialog(null, retString, "CODD - Error", JOptionPane.ERROR_MESSAGE);
		}
	}// GEN-LAST:event_bSaveConfigActionPerformed

	private void bBackActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bBackActionPerformed
		this.dispose();
		prevFrame.setVisible(true);
	}// GEN-LAST:event_bBackActionPerformed

	private void bRefreshActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bRefreshActionPerformed
		// Refreshes the configuraion from Config Files
		loadConfig();
	}// GEN-LAST:event_bRefreshActionPerformed

	private void bConnectServerActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_bConnectServerActionPerformed
		String retString = readAndValidateFields();
		if (retString == null) {
			try {
				DBSettings settings = new DBSettings(dbServerName, dbServerPort, dbType, dbName, dbSchema, dbUserName,
						dbPassword);
				if (dbType.equals(DBConstants.MSSQL)) {
					settings.setSqlServerInstanceName(serverInstance);
				}
				if (dbType.equals(DBConstants.NONSTOPSQL)) {
					settings.setCatalog(dbCatalog);
					settings.setVersion(dbVersion);
					settings.setSqlServerInstanceName(serverInstance);
				}
				Database database = null;
				switch (dbType) {
				case DBConstants.DB2:
					database = (Database) new DB2Database(settings);
					break;
				case DBConstants.MSSQL:
					database = (Database) new MSSQLDatabase(settings);
					break;
				case DBConstants.ORACLE:
					database = (Database) new OracleDatabase(settings);
					break;
				case DBConstants.POSTGRES:
					database = (Database) new PostgresDatabase(settings);
					break;
				case DBConstants.SYBASE:
					database = (Database) new SybaseDatabase(settings);
					break;
				case DBConstants.NONSTOPSQL:
					database = (Database) new NonStopSQLDatabase(settings);
					break;
				default:
					break;
				}

				/*
				 * Important: The variable "isJdbcDriver" will have the following values: "true"
				 * - If working on databases other than HP NonStopSQLMX, eg. DB2, Oracle etc.
				 * "true" - If working on HP NonStopSQLMX, and using the official JDBC driver.
				 * "false" - If working on HP NonStopSQLMX, but not using the official JDBC
				 * driver.
				 */
				if (Main.isJdbcDriver) {
					if (database == null) {
						JOptionPane.showMessageDialog(null, "Error: Could not get database object.", "CODD - Error",
								JOptionPane.ERROR_MESSAGE);
					} else if (database.connect()) {
						Constants.CPrintToConsole("Connected to database. ", Constants.DEBUG_FIRST_LEVEL_Information);
						if (!database.stopAutoUpdateOfStats()) {
							JOptionPane.showMessageDialog(null,
									"Warning: Could not able to stop auto maintanance of statistics.", "CODD - Warning",
									JOptionPane.INFORMATION_MESSAGE);
							return;
						}
						// if (dbType.equals(DBConstants.DB2)) {
						// new ConfigurationTypeSelection(database).setVisible(true);
						// this.dispose();
						// } else {
						setVisible(false);
						new ClientInputFrame(database, this).setVisible(true);
//						this.dispose();
						// }
					} else {
						JOptionPane.showMessageDialog(null, "Error: Could not able to connect to database.",
								"CODD - Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
				} else {
					// new GetRelationFrame(database).setVisible(true);
					this.dispose();
					Constants.CPrintToConsole("Connected to Database.", Constants.DEBUG_FIRST_LEVEL_Information);
				}
			} catch (Exception e) {
				Constants.CPrintErrToConsole(e);
				JOptionPane.showMessageDialog(null, e.getMessage(), "CODD - Exception", JOptionPane.ERROR_MESSAGE);
			}
		} else {
			JOptionPane.showMessageDialog(null, retString, "CODD - Error", 0);
		}
	}// GEN-LAST:event_bConnectServerActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bBack;
    private javax.swing.JButton bConnectServer;
    private javax.swing.JButton bDelConfig;
    private javax.swing.JButton bRefresh;
    private javax.swing.JButton bSaveConfig;
    private javax.swing.JComboBox cbEngine;
    private javax.swing.JComboBox cbPreSavedCons;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel labelServerInstance;
    private javax.swing.JLabel labelVersion;
    private javax.swing.JLabel lableCatalog;
    private javax.swing.JPanel logopanel;
    private javax.swing.JTextField tbCatalogName;
    private javax.swing.JTextField tbDatabase;
    private javax.swing.JTextField tbMachine;
    private javax.swing.JPasswordField tbPassword;
    private javax.swing.JTextField tbPort;
    private javax.swing.JTextField tbSchema;
    private javax.swing.JTextField tbServerInstance;
    private javax.swing.JTextField tbUsername;
    private javax.swing.JTextField tbVersion;
    // End of variables declaration//GEN-END:variables
}
