package iisc.dsl.coddgen.ui.model;

import java.io.File;
import java.util.List;

import iisc.dsl.codd.db.Database;

/**
 * Represents the info supplied in ClientInputFrame
 * @author rWX450917
 *
 */
public class ClientInputFrameOut {

    public final Database 	database;
    public final List<File> workloadQueryFiles;
    public final boolean    isMetadataFetch;
    public final File       metadataLocation;
    public final boolean    isExecutionPlansFetch;
    public final List<File> executionPlanFiles;
//    public final boolean	doAnonymize;
    public final String		outputLocation;

    public ClientInputFrameOut(Database database, List<File> workloadQueryFiles, File metadataLocation, List<File> executionPlanFiles, String outputLocation) {		//, boolean doAnonymize) {
        this.database = database;
        this.workloadQueryFiles = workloadQueryFiles;
        isMetadataFetch = metadataLocation == null;
        this.metadataLocation = metadataLocation;
        isExecutionPlansFetch = executionPlanFiles == null;
        this.executionPlanFiles = executionPlanFiles;
//        this.doAnonymize = doAnonymize;
        this.outputLocation = outputLocation;
    }

}
