package iisc.dsl.coddgen.ui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;

import in.ac.iisc.cds.dsl.cdgclient.anonymizer.Anonymizer;
import in.ac.iisc.cds.dsl.cdgvendor.constants.PostgresVConfig;
import in.ac.iisc.cds.dsl.cdgvendor.model.Alqp;
import in.ac.iisc.cds.dsl.cdgvendor.model.AlqpInternalNode;
import in.ac.iisc.cds.dsl.cdgvendor.model.AlqpLeafNode;
import in.ac.iisc.cds.dsl.cdgvendor.model.AlqpNode;
import in.ac.iisc.cds.dsl.cdgvendor.model.SchemaInfo;
import in.ac.iisc.cds.dsl.cdgvendor.model.ValueCombination;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewInfo;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewSolution;
import in.ac.iisc.cds.dsl.cdgvendor.model.formal.FormalCondition;
import in.ac.iisc.cds.dsl.cdgvendor.utils.ConditionsEvaluator;
import in.ac.iisc.cds.dsl.cdgvendor.utils.Converter;

@SuppressWarnings("serial")
public class AlqpGraphXComponent extends JPanel {

    private AlqpGraphXComponent(mxGraph graph, long scaleFactor) {

        setOpaque(false);
        setLayout(new BorderLayout());
        mxGraphComponent graphComponent = new mxGraphComponent(graph);
        graphComponent.setEnabled(false);
        graphComponent.setBorder(BorderFactory.createLineBorder(Color.black));
        graphComponent.getViewport().setOpaque(true);
        graphComponent.getViewport().setBackground(Color.WHITE);
        add(graphComponent, BorderLayout.CENTER);
    }

    /**
     * Factory method
     * @param BASICSCHEMA_INFO
     * @param alqp
     * @return
     */
    
    public static AlqpGraphXComponent parse(SchemaInfo BASICSCHEMA_INFO, Alqp alqp, Anonymizer anonymizer,
            Map<String, ViewSolution> uncompressedSummaryByView) {
    	return parse(BASICSCHEMA_INFO, alqp, anonymizer, uncompressedSummaryByView, 1);
    	
    }
    
    public static AlqpGraphXComponent parse(SchemaInfo BASICSCHEMA_INFO, Alqp alqp, Anonymizer anonymizer,
            Map<String, ViewSolution> uncompressedSummaryByView, long scaleFactor) {

    	HashMap<Long, List<Object>> mapCardinalityToEdge = new HashMap<>();
    	
        mxGraph graph = new mxGraph();
        graph.getModel().beginUpdate();
        try {
            graph.setHtmlLabels(true);
            //graph.setSwimlaneNesting(false);
            representAlqpInGraph(graph, BASICSCHEMA_INFO, alqp, anonymizer, uncompressedSummaryByView, scaleFactor, mapCardinalityToEdge);

//            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_STARTARROW, mxConstants.ARROW_OPEN);
            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_STARTARROW, mxConstants.ARROW_BLOCK);
            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_OVAL);
            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_ENDSIZE, 0);
//            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_LEFT);
//            graph.getStylesheet().getDefaultEdgeStyle().put(mxConstants.STYLE_EDGE, mxConstants.EDGESTYLE_SIDETOSIDE);

            graph.getStylesheet().getDefaultVertexStyle().put(mxConstants.STYLE_FILLCOLOR, "#FFFFFF");
            graph.getStylesheet().getDefaultVertexStyle().put(mxConstants.STYLE_STROKECOLOR, "#FFFFFF");
            graph.getStylesheet().getDefaultVertexStyle().put(mxConstants.STYLE_FONTCOLOR, "#774400");
            
            Set<Long> keys = mapCardinalityToEdge.keySet();
            Long maxMinusMin = getMaxMinusMin(keys);
            
            for (Entry<Long, List<Object>> entry : mapCardinalityToEdge.entrySet()) {
            	graph.setCellStyle("strokeWidth="+Long.toString((9 * entry.getKey() / maxMinusMin)+1)+";labelBackgroundColor=#FFFFFF;", entry.getValue().toArray());
			}

            layoutGraph(graph);

        } finally {
            graph.getModel().endUpdate();
        }
        
        AlqpGraphXComponent res = new AlqpGraphXComponent(graph, scaleFactor);
        return res;
    }
    
    private static Long getMaxMinusMin(Set<Long> keys) {
    	Iterator<Long> it = keys.iterator();
    	Long min = it.next();
    	Long max = min;
    	while(it.hasNext()) {
    		Long val = it.next();
    		if(val < min) min = val;
    		if(val > max) max = val;
    	}
    	return max - min;
    }

    private static void representAlqpInGraph(mxGraph graph, SchemaInfo BASICSCHEMA_INFO, Alqp alqp, Anonymizer anonymizer,
            Map<String, ViewSolution> uncompressedSummaryByView, long scaleFactor, HashMap<Long, List<Object>> mapCardinalityToEdge) {
        Object rootVertex = addRelationVertex(graph, "Output");
        representAlqpInGraph(graph, rootVertex, BASICSCHEMA_INFO, alqp.getRoot(), anonymizer, uncompressedSummaryByView, scaleFactor, mapCardinalityToEdge);

    }

    private static void representAlqpInGraph(mxGraph graph, Object parentVertex, SchemaInfo BASICSCHEMA_INFO, AlqpNode alqpNode, Anonymizer anonymizer,
            Map<String, ViewSolution> uncompressedSummaryByView, long scaleFactor, HashMap<Long, List<Object>> mapCardinalityToEdge) {

        if (alqpNode instanceof AlqpLeafNode) {
            AlqpLeafNode alqpLeafNode = (AlqpLeafNode) alqpNode;

            if (alqpLeafNode.getConditionStr() == null || alqpLeafNode.getConditionStr().isEmpty()) {
                String relationName = alqpLeafNode.getRelname();
                if (uncompressedSummaryByView == null) {
                    Object relationVertex = addRelationVertex(graph, relationName.toUpperCase());
                    addEdge(graph, parentVertex, relationVertex, BASICSCHEMA_INFO.getTableInfo(relationName).getRowcount(), -1, mapCardinalityToEdge);
                } else {
                    String viewname = anonymizer.getTablenameAnonymMap().get(relationName);
//                    Object relationVertex = addRelationVertex(graph, viewname);
                    Object relationVertex = addRelationVertex(graph, relationName.toUpperCase());
                    long solutionCardinality = getRelationCardinality(uncompressedSummaryByView.get(viewname));
                    addEdge(graph, parentVertex, relationVertex, BASICSCHEMA_INFO.getTableInfo(relationName).getRowcount() * scaleFactor, solutionCardinality, mapCardinalityToEdge);
                }
            } else {
                Object filterVertex;
                if (uncompressedSummaryByView == null) {
                    filterVertex = addFilterVertex(graph, alqpLeafNode.getConditionStr());
                    addEdge(graph, parentVertex, filterVertex, alqpLeafNode.getOutputCardinality(), -1, mapCardinalityToEdge);
                } else {
                    FormalCondition formalCondition = Converter.getAsFormalCondition(alqpLeafNode.getCondition(), anonymizer);
                    FormalCondition origFormalCondition = formalCondition.getDeepCopy();
                    anonymizer.anonymizeFormalConditionSingle(formalCondition);
                    FormalCondition mappedFormalCondition = anonymizer.distributeShownValuesSingle(formalCondition);

                    String viewname = mappedFormalCondition.getViewname();
                    ViewInfo viewInfo = PostgresVConfig.ANONYMIZED_VIEWINFOs.get(viewname);
                    List<String> sortedColumns = new ArrayList<>(viewInfo.getViewNonkeys());
                    Collections.sort(sortedColumns);

//                    filterVertex = addFilterVertex(graph, mappedFormalCondition.asQueryString());
                    filterVertex = addFilterVertex(graph, origFormalCondition.asQueryString());
                    long solutionCardinality = ConditionsEvaluator.getCardinality(mappedFormalCondition, uncompressedSummaryByView.get(viewname), sortedColumns);
                    addEdge(graph, parentVertex, filterVertex, alqpLeafNode.getOutputCardinality() * scaleFactor, solutionCardinality, mapCardinalityToEdge);
                }

                String relationName = alqpLeafNode.getRelname();
                if (uncompressedSummaryByView == null) {
                    Object relationVertex = addRelationVertex(graph, relationName.toUpperCase());
                    addEdge(graph, filterVertex, relationVertex, BASICSCHEMA_INFO.getTableInfo(relationName).getRowcount(), -1, mapCardinalityToEdge);
                } else {
                    String viewname = anonymizer.getTablenameAnonymMap().get(relationName);
//                    Object relationVertex = addRelationVertex(graph, viewname);
                    Object relationVertex = addRelationVertex(graph, relationName.toUpperCase());
                    long solutionCardinality = getRelationCardinality(uncompressedSummaryByView.get(viewname));
                    addEdge(graph, filterVertex, relationVertex, BASICSCHEMA_INFO.getTableInfo(relationName).getRowcount() * scaleFactor, solutionCardinality, mapCardinalityToEdge);
                }

            }

        } else if (alqpNode instanceof AlqpInternalNode) {

            AlqpInternalNode alqpInternalNode = (AlqpInternalNode) alqpNode;
            AlqpNode lchild = alqpInternalNode.getLeftChild();
            AlqpNode rchild = alqpInternalNode.getRightChild();

            if (rchild == null)
                throw new RuntimeException("Should not be reaching here: " + alqpInternalNode);
            else if (alqpInternalNode.getConditionStr() == null)
                throw new RuntimeException("Should not be reaching here also: " + alqpInternalNode);
            else {
                Object vertex;
                if (uncompressedSummaryByView == null) {
                    vertex = addJoinVertex(graph, alqpInternalNode.getConditionStr());
                    addEdge(graph, parentVertex, vertex, alqpInternalNode.getOutputCardinality(), -1, mapCardinalityToEdge);
                } else {
                    FormalCondition formalCondition = Converter.getAsFormalCondition(alqpInternalNode.getCondition(), anonymizer);
                    anonymizer.anonymizeFormalConditionSingle(formalCondition);
                    FormalCondition mappedFormalCondition = anonymizer.distributeShownValuesSingle(formalCondition);

                    String viewname = mappedFormalCondition.getViewname();
                    ViewInfo viewInfo = PostgresVConfig.ANONYMIZED_VIEWINFOs.get(viewname);
                    List<String> sortedColumns = new ArrayList<>(viewInfo.getViewNonkeys());
                    Collections.sort(sortedColumns);

                    //Beware: Manual String processing
                    String conditionStr = alqpInternalNode.getConditionStr();
                    try {
//                        String viewnameL = anonymizer.getTablenameAnonymMap().get(conditionStr.split("=")[0].split("\\.")[0].substring(1));
//                        String viewnameR = anonymizer.getTablenameAnonymMap().get(conditionStr.split("=")[1].split("\\.")[0].substring(1));
                        String viewnameL = conditionStr.split("=")[0].split("\\.")[0].substring(1);
                        String viewnameR = conditionStr.split("=")[1].split("\\.")[0].substring(1);
                        vertex = addJoinVertex(graph, viewnameL + " joins " + viewnameR);
                    } catch (Exception ex) {
                        vertex = addJoinVertex(graph, conditionStr);
                    }
                    long solutionCardinality = ConditionsEvaluator.getCardinality(mappedFormalCondition, uncompressedSummaryByView.get(viewname), sortedColumns);
                    addEdge(graph, parentVertex, vertex, alqpInternalNode.getOutputCardinality() * scaleFactor, solutionCardinality, mapCardinalityToEdge);
                }

                representAlqpInGraph(graph, vertex, BASICSCHEMA_INFO, lchild, anonymizer, uncompressedSummaryByView, scaleFactor, mapCardinalityToEdge);
                representAlqpInGraph(graph, vertex, BASICSCHEMA_INFO, rchild, anonymizer, uncompressedSummaryByView, scaleFactor, mapCardinalityToEdge);
            }
        } else
            throw new RuntimeException("Unrecognized AlqpNode type " + alqpNode.getClass());
    }

    private static long getRelationCardinality(ViewSolution viewSolution) {
        long relationCardinality = 0;
        for (ValueCombination valueCombination : viewSolution) {
            relationCardinality += valueCombination.getRowcount();
        }
        return relationCardinality;
    }

    private static Object addRelationVertex(mxGraph graph, String relationName) {
        Object vertex = graph.insertVertex(graph.getDefaultParent(), null, getRelationNameAsHtml(relationName), -1, -1, 80, 30);
        graph.updateCellSize(vertex);
        return vertex;
    }

    private static Object addFilterVertex(mxGraph graph, String filterCondStr) {
        filterCondStr = filterCondStr.replaceAll("(.{35})", "$1\n");
        filterCondStr = getSymbolAsHtml("&#963;") + "\n" + escapeAsHtml(filterCondStr);
        return graph.insertVertex(graph.getDefaultParent(), null, filterCondStr, -1, -1, 80, 60);
    }

    private static Object addJoinVertex(mxGraph graph, String joinCondStr) {
        joinCondStr = joinCondStr.replaceAll("(.{35})", "$1\n");
        joinCondStr = getSymbolAsHtml("&#8904;") + "\n" + escapeAsHtml(joinCondStr);
        return graph.insertVertex(graph.getDefaultParent(), null, joinCondStr, -1, -1, 80, 60);
    }

    private static void addEdge(mxGraph graph, Object source, Object target, long requiredCardinality, long solutionCardinality, HashMap<Long, List<Object>> mapCardinalityToEdge) {
        Object edge = graph.insertEdge(graph.getDefaultParent(), null, getCardinalityNumbersAsHtml(requiredCardinality, solutionCardinality), source, target);	// startSize=9;
        
        if(!mapCardinalityToEdge.containsKey(requiredCardinality))
        	mapCardinalityToEdge.put(requiredCardinality, new ArrayList<>());
        mapCardinalityToEdge.get(requiredCardinality).add(edge);
    }

    /**
     * Adapted from http://stackoverflow.com/q/32758018/2202712
     * @param graph
     */
    private static void layoutGraph(mxGraph graph) {
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph);
        layout.setIntraCellSpacing(5 * layout.getIntraCellSpacing());
//        layout.setInterRankCellSpacing(2 * layout.getInterRankCellSpacing());
//        layout.setMoveParent(true);
        layout.setOrientation(SwingConstants.NORTH);
        layout.setDisableEdgeStyle(false);
        layout.execute(graph.getDefaultParent());
    }

    private static String getCardinalityNumbersAsHtml(long requiredCardinality, long solutionCardinality) {
        return solutionCardinality == -1 ? "<strong><span color='green'>" + requiredCardinality + "</span><br /><span color='red'>" + " " + "</span></strong>"
                : "<strong><span color='green'>" + requiredCardinality + "</span><br /><span color='red'>" + solutionCardinality + "</span></strong>";
    }

    private static String getSymbolAsHtml(String symbolHtmlCode) {
        return "<span style='font-size:300%;' color='black'>" + symbolHtmlCode + "</span>";
    }

    private static String getRelationNameAsHtml(String relationName) {
        return "<strong><span style='font-size:150%;' color='black'>" + relationName + "</span></strong>";
    }

    private static String escapeAsHtml(String str) {
        return str.replace("<", "&lt;");
    }
}
