package iisc.dsl.coddgen.ui.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import javax.swing.JTextField;

/**
 * Adapted from http://stackoverflow.com/a/16229082/2202712
 * @author http://stackoverflow.com/users/280783/peter-tseng
 *
 */
@SuppressWarnings("serial")
public class PlaceholderTextField extends JTextField {

    //    public static void main(final String[] args) {
    //        final PlaceholderTextField tf = new PlaceholderTextField("");
    //        tf.setColumns(20);
    //        tf.setPlaceholder("All your base are belong to us!");
    //        final Font f = tf.getFont();
    //        tf.setFont(new Font(f.getName(), f.getStyle(), 30));
    //        JOptionPane.showMessageDialog(null, tf);
    //    }

    private String placeholder;

    public PlaceholderTextField() {}

    //    public PlaceholderTextField(final Document pDoc, final String pText, final int pColumns) {
    //        super(pDoc, pText, pColumns);
    //    }
    //
    //    public PlaceholderTextField(final int pColumns) {
    //        super(pColumns);
    //    }
    //
    //    public PlaceholderTextField(final String pText) {
    //        super(pText);
    //    }

    public PlaceholderTextField(final String placeholder, final int pColumns) {
        super(pColumns);
        this.placeholder = placeholder;
    }

    //    public String getPlaceholder() {
    //        return placeholder;
    //    }

    @Override
    protected void paintComponent(final Graphics pG) {
        super.paintComponent(pG);

        if (placeholder.length() == 0 || getText().length() > 0)
            return;

        final Graphics2D g = (Graphics2D) pG;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(getDisabledTextColor());
        g.drawString(placeholder, getInsets().left, pG.getFontMetrics().getMaxAscent() + getInsets().top);
    }

    //    public void setPlaceholder(final String placeholder) {
    //        this.placeholder = placeholder;
    //    }

}