package in.ac.iisc.cds.dsl.cdgvendor.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public class AlqpInternalNode extends AlqpNode {

    protected AlqpNode leftChild;
    protected AlqpNode rightChild;

    public AlqpNode getLeftChild() {
        return leftChild;
    }

    public void setLeftChild(AlqpNode leftChild) {
        this.leftChild = leftChild;
    }

    public AlqpNode getRightChild() {
        return rightChild;
    }

    public void setRightChild(AlqpNode rightChild) {
        this.rightChild = rightChild;
    }

    public List<AlqpNode> getChildren() {
        List<AlqpNode> children = new ArrayList<>();
        children.add(leftChild);
        children.add(rightChild);
        return children;
    }

    @Override
    public String asString(int tabCount) {
        String prefix = "\n" + StringUtils.repeat("  ", tabCount);
        String str = prefix + super.toString();

        str += leftChild.asString(tabCount + 1);
        if (rightChild != null) {
            str += rightChild.asString(tabCount + 1);
        }
        return str;
    }

    /**
     * Removes extra nodes by collapsing nodes with [ singlechild |  nocondition | samerows ]
     */
    @Override
    public AlqpNode compress() {
        //Descend root
        if (rightChild == null && conditionStr == null && outputCardinality == leftChild.getOutputCardinality())
            return leftChild.compress();
        if (rightChild == null && ("Hash".equals(nodetype) || "Sort".equals(nodetype) || "Aggregate".equals(nodetype)))
            return leftChild.compress();

        leftChild = leftChild.compress();
        if (rightChild != null) {
            rightChild = rightChild.compress();
        }
        return this;
    }

    @Override
    public Condition getCondition() {

        if (rightChild == null)
            //System.out.println("--rarely happens");
            //return leftChild.getCondition();
            throw new RuntimeException("Should not be reaching here");
        ConditionJoin join = new ConditionJoin(leftChild.getCondition(), rightChild.getCondition(), outputCardinality);
        return join;
    }

    /**
     * Creates fresh unbacked list from child lists and returns
     */
    @Override
    public List<Condition> getAllConditions() {

        List<Condition> conditionList = new ArrayList<>();
        conditionList.add(getCondition());
        conditionList.addAll(leftChild.getAllConditions());
        if (rightChild != null) {
            conditionList.addAll(rightChild.getAllConditions());
        }
        return conditionList;
    }

    @Override
    public List<String> getAllRelnames() {
        List<String> tablenames = new ArrayList<>();
        tablenames.addAll(leftChild.getAllRelnames());
        if (rightChild != null) {
            tablenames.addAll(rightChild.getAllRelnames());
        }
        return tablenames;
    }

    @Override
    public List<String> getAllJoinConditionStrs() {
        List<String> joinConditionStrList = new ArrayList<>();
        joinConditionStrList.add(conditionStr);
        joinConditionStrList.addAll(leftChild.getAllJoinConditionStrs());
        if (rightChild != null) {
            joinConditionStrList.addAll(rightChild.getAllJoinConditionStrs());
        }
        return joinConditionStrList;
    }
}
