package in.ac.iisc.cds.dsl.cdgvendor.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public class AlqpLeafNode extends AlqpNode {

    @Override
    public String asString(int tabCount) {
        String prefix = "\n" + StringUtils.repeat("  ", tabCount);
        return prefix + super.toString();
    }

    @Override
    public AlqpNode compress() {
        return this;
    }

    @Override
    public Condition getCondition() {
        return new ConditionBase(relname, alias, conditionStr, outputCardinality);
    }

    @Override
    public List<Condition> getAllConditions() {
        List<Condition> conditionList = new ArrayList<>();
        conditionList.add(getCondition());
        return conditionList;
    }

    @Override
    public List<String> getAllRelnames() {
        List<String> tablenames = new ArrayList<>();
        tablenames.add(relname);
        return tablenames;
    }

    @Override
    public List<String> getAllJoinConditionStrs() {
        return new ArrayList<>();
    }
}
