package in.ac.iisc.cds.dsl.cdgvendor.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import in.ac.iisc.cds.dsl.cdgvendor.constants.Constants;

public class Condition {

    private final long                 outputCardinality;
    protected final List<RelnameAlias> relnames;
    protected final List<String>       predicates;       //TODO: Model as composite predicates instead of List<String> of predicates

    public Condition(long outputCardinality) {
        this.outputCardinality = outputCardinality;
        this.relnames = new ArrayList<>();
        this.predicates = new ArrayList<>();
    }

    @Override
    public String toString() {
        StringBuilder sb;

        sb = new StringBuilder();
        for (String predicate : predicates) {
            sb.append(predicate).append(Constants.AND_OPERATOR);
        }
        String predtsr = StringUtils.removeEnd(sb.toString(), Constants.AND_OPERATOR);

        sb = new StringBuilder();
        for (RelnameAlias relname : relnames) {
            sb.append(relname.toString() + Constants.JOIN_OPERATOR);
        }
        String relstr = StringUtils.removeEnd(sb.toString(), Constants.JOIN_OPERATOR);

        return "|" + Constants.SEL_OPERATOR + "( " + predtsr + " ) (" + relstr + ") | = " + outputCardinality;
    }

    public long getOutputCardinality() {
        return outputCardinality;
    }

    public List<String> getPredicates() {
        return predicates;
    }

    public List<RelnameAlias> getRelnames() {
        return relnames;
    }

}
