package in.ac.iisc.cds.dsl.cdgvendor.model.formal;

import java.io.Serializable;

/**
 * FormalCondition is just another model for Condition but it is more like java classes auto-generated by the grammar.
 * Here viewname is the parent view which is the earliest in revTopo order
 * @author raghav
 *
 */
public abstract class FormalCondition implements Serializable, Comparable<FormalCondition> {
    private static final long serialVersionUID = 7228626574595502175L;

    protected long            outputCardinality;
    protected String          viewname;

    public FormalCondition() {
        outputCardinality = -1;
        viewname = null;
    }

    public long getOutputCardinality() {
        return outputCardinality;
    }

    public void setOutputCardinality(long outputCardinality) {
        this.outputCardinality = outputCardinality;
    }

    public void scaleRowCount(long scaleFactor) {
        outputCardinality *= scaleFactor;
    }

    public String getViewname() {
        if (viewname == null)
            throw new RuntimeException("Trying to get viewname when it is still null");
        return viewname;
    }

    public void setViewname(String viewname) {
        this.viewname = viewname;
    }

    @Override
    public String toString() {
        return "View " + viewname + " " + asString() + " = " + outputCardinality;
    }

    /**
     * Used in toString
     * @return
     */
    public abstract String asString();

    /**
     * Used in generating anonymized and domainmapped queries
     * @return
     */
    public abstract String asQueryString();

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (outputCardinality ^ outputCardinality >>> 32);
        result = prime * result + (viewname == null ? 0 : viewname.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        FormalCondition other = (FormalCondition) obj;
        if (outputCardinality != other.outputCardinality)
            return false;
        if (viewname == null) {
            if (other.viewname != null)
                return false;
        } else if (!viewname.equals(other.viewname))
            return false;
        return true;
    }

    /*
     * Comparing only viewname to cheaply group constraints by viewname
     */
    @Override
    public final int compareTo(FormalCondition arg0) {
        return viewname.compareTo(arg0.viewname);
    }

    public abstract FormalCondition getDeepCopy();
}
