/*
 #
 # COPYRIGHT INFORMATION
 #
 # Copyright (C) 2013 Indian Institute of Science
 # Bangalore 560012, INDIA
 #
 # This program is part of the CODD Metadata Processor
 # software distribution invented at the Database Systems Lab,
 # Indian Institute of Science. The use of the software is governed
 # by the licensing agreement set up between the copyright owner,
 # Indian Institute of Science, and the licensee.
 #
 # This program is distributed WITHOUT ANY WARRANTY;
 # without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 #
 # The public URL of the CODD project is
 # http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
 #
 # For any issues, contact
 # Prof. Jayant R. Haritsa
 # SERC
 # Indian Institute of Science
 # Bangalore 560012, India.
 # 
 
 # Email: haritsa@dsl.serc.iisc.ernet.in
 # 
 #
 */
package iisc.dsl.codd.client;

import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.db.db2.DB2HardwareConfiguration;

import javax.swing.JOptionPane;
import iisc.dsl.codd.client.gui.BaseJPanel;
import iisc.dsl.codd.ds.Constants;
import javax.swing.GroupLayout.Alignment;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.GroupLayout;
import javax.swing.SwingConstants;
import java.awt.Component;

/**
 * ModeSelection Frame allows the user to select any one of the CODD Dataless
 * mode.
 *
 * @author dsladmin
 */
public class ConfigurationTypeSelection extends javax.swing.JFrame {

	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 4120172781293292565L;
	Database database; // Database Object

	/**
	 * Constructor for ConfigurationTypeSelection Frame.
	 *
	 * @param database - Database object
	 * @param relation - Array of Selected Relations
	 */
	public ConfigurationTypeSelection(Database database) {
		this.database = database;
		initComponents();
		setLocationRelativeTo(null);
		setTitle("Configuration Type Selection");
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		buttonGroup1 = new javax.swing.ButtonGroup();
		jPanel1 = new BaseJPanel("img/bg_net.png");
		jPanel2 = new javax.swing.JPanel();
		metadataRadioButton = new javax.swing.JRadioButton();
		hardwareRadioButton = new javax.swing.JRadioButton();
		backButton = new javax.swing.JButton();
		continueButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Select Configuration Type", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Cambria", 0, 14), new java.awt.Color(0, 51, 153))); // NOI18N
		jPanel2.setOpaque(false);

		buttonGroup1.add(metadataRadioButton);
		metadataRadioButton.setText("Metadata Configuration");
		metadataRadioButton.setOpaque(false);

		hardwareRadioButton.setBackground(new java.awt.Color(255, 255, 204));
		buttonGroup1.add(hardwareRadioButton);
		hardwareRadioButton.setText("Hardware Configuration");
		hardwareRadioButton.setOpaque(false);

		javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
		jPanel2Layout.setHorizontalGroup(
				jPanel2Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel2Layout.createSequentialGroup()
						.addGap(24)
						.addComponent(metadataRadioButton, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGap(87)
						.addComponent(hardwareRadioButton, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGap(18))
				);
		jPanel2Layout.setVerticalGroup(
				jPanel2Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel2Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel2Layout.createParallelGroup(Alignment.BASELINE)
								.addComponent(metadataRadioButton, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addComponent(hardwareRadioButton, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
								.addGap(20))
				);
		jPanel2.setLayout(jPanel2Layout);

		backButton.setText("<< Back");
		backButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				backButtonActionPerformed(evt);
			}
		});

		continueButton.setText("Continue >>");
		continueButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				continueButtonActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1Layout.setHorizontalGroup(
				jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
								.addComponent(jPanel2, GroupLayout.PREFERRED_SIZE, 530, GroupLayout.PREFERRED_SIZE)
								.addGroup(jPanel1Layout.createSequentialGroup()
										.addComponent(backButton, GroupLayout.PREFERRED_SIZE, 120, GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(ComponentPlacement.RELATED, 286, Short.MAX_VALUE)
										.addComponent(continueButton)))
										.addContainerGap())
				);
		jPanel1Layout.setVerticalGroup(
				jPanel1Layout.createParallelGroup(Alignment.TRAILING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addGap(29)
						.addComponent(jPanel2, GroupLayout.PREFERRED_SIZE, 66, GroupLayout.PREFERRED_SIZE)
						.addGap(29)
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
								.addComponent(backButton, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
								.addComponent(continueButton))
								.addContainerGap())
				);
		jPanel1Layout.linkSize(SwingConstants.VERTICAL, new Component[] {backButton, continueButton});
		jPanel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {backButton, continueButton});
		jPanel1.setLayout(jPanel1Layout);

		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void continueButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
		/**
		 * Continue button is selected. Read the options and call the
		 * appropriate frames.
		 *
		 * Algorithm to choose the next operation to do.
		 *
		 * Option: 1) MetadataConfigurationType 2) HardwareConfigurationType
		 */
		try{
			if (metadataRadioButton.isSelected()){ 									// MetadataConfigurationType
				new GetRelationFrame(database).setVisible(true);
				this.dispose();
			} else if (hardwareRadioButton.isSelected()){ 							// HardwareConfigurationType
				new DB2HardwareConfiguration(database).setVisible(true);
				this.dispose();
			} else {
				JOptionPane.showMessageDialog(null, "You are required to select one of the two modes to move ahead.", "CODD Error Message", 0);
			}
		}catch(Exception e){
			Constants.CPrintErrToConsole(e);
			JOptionPane.showMessageDialog(null, e.getMessage() , "CODD - Exception", JOptionPane.ERROR_MESSAGE);
		}

	}//GEN-LAST:event_jButton2ActionPerformed

	private void backButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		// Back button selected.
		if(database!=null){
			String dbServerName = database.getSettings().getServerName();
			String dbType = database.getSettings().getDbVendor();
			String dbServerPort = database.getSettings().getServerPort();
			String dbName = database.getSettings().getDbName();
			String dbCatalog = database.getSettings().getCatalog();
			String dbSchema = database.getSettings().getSchema();
			String dbUserName = database.getSettings().getUserName();
			String dbPassword = database.getSettings().getPassword();
			String serverInstance = database.getSettings().getSqlServerInstanceName();
			String dbVersion = database.getSettings().getVersion();
			database.close();        		
			new ConnectDBFrame(dbServerName, dbType, dbServerPort, dbName, dbCatalog, dbSchema, dbUserName, dbPassword, serverInstance, dbVersion).setVisible(true);
		}
	}//GEN-LAST:event_jButton1ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.ButtonGroup buttonGroup1;
	private javax.swing.JButton backButton;
	private javax.swing.JButton continueButton;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JRadioButton metadataRadioButton;
	private javax.swing.JRadioButton hardwareRadioButton;
	// End of variables declaration//GEN-END:variables
}
