/*
 #
 # COPYRIGHT INFORMATION
 #
 # Copyright (C) 2013 Indian Institute of Science
 # Bangalore 560012, INDIA
 #
 # This program is part of the CODD Metadata Processor
 # software distribution invented at the Database Systems Lab,
 # Indian Institute of Science. The use of the software is governed
 # by the licensing agreement set up between the copyright owner,
 # Indian Institute of Science, and the licensee.
 #
 # This program is distributed WITHOUT ANY WARRANTY;
 # without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 #
 # The public URL of the CODD project is
 # http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
 #
 # For any issues, contact
 # Prof. Jayant R. Haritsa
 # SERC
 # Indian Institute of Science
 # Bangalore 560012, India.
 # 
 
 # Email: haritsa@dsl.serc.iisc.ernet.in
 # 
 #
 */
package iisc.dsl.codd.client;

import iisc.dsl.codd.db.Database;
import javax.swing.JOptionPane;
import iisc.dsl.codd.client.gui.BaseJPanel;
import iisc.dsl.codd.client.gui.UIUtils;
import iisc.dsl.codd.db.DBConstants;
import iisc.dsl.codd.ds.Constants;

import javax.swing.GroupLayout.Alignment;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.GroupLayout;
import javax.swing.SwingConstants;
import java.awt.Component;

/**
 * ModeSelection Frame allows the user to select any one of the CODD Dataless
 * mode.
 *
 * @author dsladmin
 */
public class ModeSelection extends javax.swing.JFrame {

	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 8812551084129597989L;
	Database database; // Database Object
	String[] relations; // Selected Relations for Dataless modes
	String type; // Database Vendor type

	/**
	 * Constructor for ModeSelection Frame.
	 *
	 * @param database - Database object
	 * @param relation - Array of Selected Relations
	 */
	public ModeSelection(Database database, String[] relation) {
		this.database = database;
		this.relations = relation;
		type = database.getSettings().getDbVendor();
		initComponents();
		setLocationRelativeTo(null);
		jLabel6.setVisible(false);
		jLabel7.setVisible(false);
		if(database.getSettings().getDbVendor().equals(DBConstants.MSSQL))
		{
			jLabel7.setVisible(true);
			jLabel6.setVisible(true);
			jRadioButton3.setEnabled(false);
			jRadioButton6.setEnabled(false);
		}
		else{
			jLabel6.setVisible(false);
			jLabel7.setVisible(false);
			jRadioButton3.setEnabled(true);
			jRadioButton6.setEnabled(true);
		}
		/*if(database.getSettings().getDbVendor().equals(DBConstants.NONSTOPSQL)){
			jRadioButton2.setEnabled(false);   // Transfer mode not supported for SQLMX
		} */
		setTitle("Dataless Modes");
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		buttonGroup1 = new javax.swing.ButtonGroup();
		jPanel1 = new BaseJPanel("img/bg_net.png");
		jPanel2 = new javax.swing.JPanel();
		jRadioButton3 = new javax.swing.JRadioButton();
		jRadioButton1 = new javax.swing.JRadioButton();
		jRadioButton2 = new javax.swing.JRadioButton();
		jRadioButton6 = new javax.swing.JRadioButton();
		jPanel3 = new javax.swing.JPanel();
		jLabel4 = new javax.swing.JLabel();
		jComboBox2 = new javax.swing.JComboBox();
		jLabel5 = new javax.swing.JLabel();
		jTextField1 = new javax.swing.JTextField();
		jCheckBox2 = new javax.swing.JCheckBox();
		jLabel6 = new javax.swing.JLabel();
		jLabel7 = new javax.swing.JLabel();
		jButton1 = new javax.swing.JButton();
		jButton2 = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Select Mode", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Cambria", 0, 14), new java.awt.Color(0, 51, 153))); // NOI18N
		jPanel2.setOpaque(false);

		buttonGroup1.add(jRadioButton3);
		jRadioButton3.setText("Construct Mode");
		jRadioButton3.setOpaque(false);

		jRadioButton1.setBackground(new java.awt.Color(255, 255, 204));
		buttonGroup1.add(jRadioButton1);
		jRadioButton1.setText("Retain Mode");
		jRadioButton1.setOpaque(false);

		jRadioButton2.setBackground(new java.awt.Color(255, 255, 204));
		buttonGroup1.add(jRadioButton2);
		jRadioButton2.setText("Transfer Mode");
		jRadioButton2.setOpaque(false);

		jRadioButton6.setBackground(new java.awt.Color(255, 255, 204));
		buttonGroup1.add(jRadioButton6);
		jRadioButton6.setText("Metadata Scaling");
		jRadioButton6.setOpaque(false);
		jRadioButton6.addChangeListener(new javax.swing.event.ChangeListener() {
			public void stateChanged(javax.swing.event.ChangeEvent evt) {
				jRadioButton6StateChanged(evt);
			}
		});
		jRadioButton6.addItemListener(new java.awt.event.ItemListener() {
			public void itemStateChanged(java.awt.event.ItemEvent evt) {
				jRadioButton6ItemStateChanged(evt);
			}
		});
		jRadioButton6.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jRadioButton6ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
		jPanel2Layout.setHorizontalGroup(
			jPanel2Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel2Layout.createSequentialGroup()
					.addContainerGap()
					.addComponent(jRadioButton3, GroupLayout.PREFERRED_SIZE, 132, Short.MAX_VALUE)
					.addGap(18)
					.addComponent(jRadioButton2, GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(jRadioButton1, GroupLayout.PREFERRED_SIZE, 109, Short.MAX_VALUE)
					.addGap(23)
					.addComponent(jRadioButton6, GroupLayout.PREFERRED_SIZE, 144, Short.MAX_VALUE)
					.addContainerGap())
		);
		jPanel2Layout.setVerticalGroup(
			jPanel2Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel2Layout.createParallelGroup(Alignment.CENTER)
					.addComponent(jRadioButton3)
					.addComponent(jRadioButton6)
					.addComponent(jRadioButton1)
					.addComponent(jRadioButton2))
		);
		jPanel2.setLayout(jPanel2Layout);

		jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Metadata Scaling Options", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Cambria", 0, 14), new java.awt.Color(0, 51, 153))); // NOI18N
		jPanel3.setOpaque(false);

		jLabel4.setText("Type:");

		jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "Size Scaling", "Time Scaling" }));
		jComboBox2.setEnabled(false);
		jComboBox2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jComboBox2ActionPerformed(evt);
			}
		});

		jLabel5.setText("Scale Factor:");

		jTextField1.setEnabled(false);

		jCheckBox2.setText("Collect Statistics before Scaling");
		jCheckBox2.setToolTipText("Runs Statistics Collection before Scaling");
		jCheckBox2.setEnabled(false);
		jCheckBox2.setOpaque(false);

		javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
		jPanel3Layout.setHorizontalGroup(
			jPanel3Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel3Layout.createSequentialGroup()
					.addComponent(jLabel4)
					.addGap(2)
					.addComponent(jComboBox2, GroupLayout.PREFERRED_SIZE, 131, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(jLabel5)
					.addGap(2)
					.addComponent(jTextField1, GroupLayout.PREFERRED_SIZE, 64, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(jCheckBox2)
					.addContainerGap(38, Short.MAX_VALUE))
		);
		jPanel3Layout.setVerticalGroup(
			jPanel3Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel3Layout.createSequentialGroup()
					.addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
					.addGroup(jPanel3Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(jLabel4)
						.addComponent(jComboBox2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(jLabel5)
						.addComponent(jTextField1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(jCheckBox2)))
		);
		jPanel3.setLayout(jPanel3Layout);

		jLabel6.setFont(new java.awt.Font("Tahoma", 1, 10));
		jLabel6.setForeground(new java.awt.Color(255, 0, 0));
		jLabel6.setText("* Construct Mode and Metadata Scaling options are not supported currently for MS SQL Server.");

		jLabel7.setFont(new java.awt.Font("Tahoma", 1, 10));
		jLabel7.setForeground(new java.awt.Color(255, 0, 0));
		jLabel7.setText("* Only Export to the external Database Engine format is supported currently for MS SQL Server.");

		jButton1.setText("<< Back");
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		jButton2.setText("Continue >>");
		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton2ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1Layout.setHorizontalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addContainerGap()
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
						.addComponent(jLabel6)
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(jButton1, GroupLayout.PREFERRED_SIZE, 120, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, 363, Short.MAX_VALUE)
							.addComponent(jButton2))
						.addComponent(jLabel7)
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.TRAILING, false)
							.addComponent(jPanel2, Alignment.LEADING, 0, 0, Short.MAX_VALUE)
							.addComponent(jPanel3, Alignment.LEADING, GroupLayout.PREFERRED_SIZE, 607, Short.MAX_VALUE)))
					.addContainerGap())
		);
		jPanel1Layout.setVerticalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addContainerGap()
					.addComponent(jPanel2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(jPanel3, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(jLabel6)
					.addGap(3)
					.addComponent(jLabel7, GroupLayout.PREFERRED_SIZE, 13, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.UNRELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(jButton1, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
						.addComponent(jButton2))
					.addContainerGap())
		);
		jPanel1Layout.linkSize(SwingConstants.VERTICAL, new Component[] {jButton1, jButton2});
		jPanel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {jButton1, jButton2});
		jPanel1.setLayout(jPanel1Layout);

		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
		/**
		 * Continue button is selected. Read the options and call the
		 * appropriate frames.
		 *
		 * Algorithm to choose the next operation to do.
		 *
		 * Option: 1) Retain Mode 2) Transfer Mode 2.1) to Native Format 2.2)
		 * export to other db format 3) Construct Mode 3.1) from scratch 3.2)
		 * import from other db format 4) Scaling
		 */
		if (jRadioButton1.isSelected()) // Retain Mode
		{
			new RetainMode(type, relations, database).setVisible(true);
			this.dispose();
		} else if (jRadioButton2.isSelected()) // Transfer Mode
		{
			new TransferMode(type, relations, database).setVisible(true);
			this.dispose();
		} else if (jRadioButton3.isSelected()) // Construct Mode
		{
			new ConstructMode(type, relations, database).setVisible(true);
			this.dispose();
		} else if (jRadioButton6.isSelected()) // Scaling
		{
			String scalingMethod = (String) jComboBox2.getSelectedItem();
			long scale_factor = 1;
			if (scalingMethod.equals("Size Scaling") || scalingMethod.equals("Time Scaling")) {
				String String_scale_factor = jTextField1.getText();
				try {
					scale_factor = Long.parseLong(String_scale_factor);
				} catch (NumberFormatException e) {
					JOptionPane.showMessageDialog(null, "Validation Error - Scaling Factor is not of Integer type.", "CODD - Validation Error", JOptionPane.ERROR_MESSAGE);
					return;
				}
				if (scale_factor <= 1) {
					JOptionPane.showMessageDialog(null, "Validation Error - Scaling Factor must be greather than 1.", "CODD - Validation Error", JOptionPane.ERROR_MESSAGE);
				} else {
					if (scalingMethod.equals("Size Scaling")) {
						boolean runStats = jCheckBox2.isSelected();
						new SizeScaling(relations, scale_factor + "", runStats, database).setVisible(true);
						this.dispose();
					} else if (scalingMethod.equals("Time Scaling")) {                  	
						new TimeScaling(relations, scale_factor + "", database).setVisible(true);
						this.dispose();
					}
				}
			} else {
				JOptionPane.showMessageDialog(null, "One of the scaling method has to be selected.", "CODD Error Message", 0);
			}
		} else {
			JOptionPane.showMessageDialog(null, "You are required to select one of the four modes to move ahead.", "CODD Error Message", 0);
		}

	}//GEN-LAST:event_jButton2ActionPerformed

	private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
		jTextField1.setEnabled(true);
		if (jComboBox2.getSelectedItem().equals("Size Scaling")) {
			jCheckBox2.setEnabled(true);
		} else {
			jCheckBox2.setEnabled(false);
		}
	}//GEN-LAST:event_jComboBox2ActionPerformed

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		// Back button selected.
		try{
			new GetRelationFrame(database).setVisible(true);
			this.dispose();							
		}catch(Exception e){
            Constants.CPrintErrToConsole(e);
            JOptionPane.showMessageDialog(null,e.getMessage(), "CODD - Exception",JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButton1ActionPerformed

	private void jRadioButton6StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jRadioButton6StateChanged
		// TODO add your handling code here:
	}//GEN-LAST:event_jRadioButton6StateChanged

	private void jRadioButton6ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jRadioButton6ItemStateChanged
		boolean nextState = jRadioButton6.isSelected();

		if (nextState) {
			// Scaling is Chosen.On Metadata TPCHScaling option
			jComboBox2.setEnabled(true);  // TPCHScaling type
			UIUtils.enableTextField(jTextField1);
			jCheckBox2.setEnabled(false);  // run statistics
			jCheckBox2.setSelected(false);
		} else {
			jComboBox2.setEnabled(false);  // TPCHScaling type
			UIUtils.disableTextField(jTextField1);
			jCheckBox2.setEnabled(false);  // run statistics
			jCheckBox2.setSelected(false);
		}
	}//GEN-LAST:event_jRadioButton6ItemStateChanged

	private void jRadioButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton6ActionPerformed
		// TODO add your handling code here:
	}//GEN-LAST:event_jRadioButton6ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.ButtonGroup buttonGroup1;
	private javax.swing.JButton jButton1;
	private javax.swing.JButton jButton2;
	private javax.swing.JCheckBox jCheckBox2;
	private javax.swing.JComboBox jComboBox2;
	private javax.swing.JLabel jLabel4;
	private javax.swing.JLabel jLabel5;
	private javax.swing.JLabel jLabel6;
	private javax.swing.JLabel jLabel7;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JPanel jPanel3;
	private javax.swing.JRadioButton jRadioButton1;
	private javax.swing.JRadioButton jRadioButton2;
	private javax.swing.JRadioButton jRadioButton3;
	private javax.swing.JRadioButton jRadioButton6;
	private javax.swing.JTextField jTextField1;
	// End of variables declaration//GEN-END:variables
}
