/*
#
# COPYRIGHT INFORMATION
#
# Copyright (C) 2013 Indian Institute of Science
# Bangalore 560012, INDIA
#
# This program is part of the CODD Metadata Processor
# software distribution invented at the Database Systems Lab,
# Indian Institute of Science. The use of the software is governed
# by the licensing agreement set up between the copyright owner,
# Indian Institute of Science, and the licensee.
#
# This program is distributed WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# The public URL of the CODD project is
# http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
#
# For any issues, contact
# Prof. Jayant R. Haritsa
# SERC
# Indian Institute of Science
# Bangalore 560012, India.
# 

# Email: haritsa@dsl.serc.iisc.ernet.in
# 
#
 */
package iisc.dsl.codd.client;

import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.ds.Constants;
import javax.swing.JOptionPane;
import javax.swing.DefaultListModel;
import java.util.ArrayList;

/**
 * This class implements the Retain mode of CODD Metadata Processor.
 * Based on the selected relations in the GetRelationFrame window, here it lists the
 * selected relations and the dependent relations. It just calls the retain function of database object,
 * which drops the data associated with selected relations and retains the metadata.
 * @author dsladmin
 */
public class RetainMode extends javax.swing.JFrame {
	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 4574803659990994152L;
	String type;  // DB Engine type
	Database database; // Connected Database Object
	/**
	 * Copy of selected relations. As the user might remove few relations from selected relations list,
	 * this copy is used in case of back button action.
	 */
	String [] passedRelation;
	DefaultListModel model1 = new DefaultListModel(); // Selected Relations
	DefaultListModel model2 = new DefaultListModel(); // Dependent Relations

	/**
	 * Constructor for RetainMode. Initializes model1 with the selected input list of relations.
	 * Computes the dependent relations (recursively) for relations and initializes model2.
	 * @param Type - Database Vendor Name
	 * @param relations - Array of selected relation for RetainMode
	 * @param database - Database Object
	 */
	public RetainMode(String Type, String [] relations, Database database) {
		this.type = Type;
		this.passedRelation = relations;
		this.database = database;
		initComponents();
		setLocationRelativeTo(null);
		getContentPane().setBackground(new java.awt.Color(255,255,204));
		jList1.setModel(model1);
		jList2.setModel(model2);

		ArrayList<String> relationsList = new ArrayList();

		for(int i = 0; i < relations.length; i++)
		{
			relationsList.add(relations[i]);
			model1.addElement(relations[i]);
		}
		try
		{
			ArrayList<String> dependentRel = database.getDependentRelations(relationsList);
			for (int i = 0; i < dependentRel.size(); i++) {
				model2.addElement(dependentRel.get(i));
			}
		}
		catch(Exception e)
		{
			Constants.CPrintErrToConsole(e);
		}

		setTitle("RetainMode - " + type);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jPanel1 = new iisc.dsl.codd.client.gui.BaseJPanel("img/bg_net.png");
		jLabel1 = new javax.swing.JLabel();
		jScrollPane1 = new javax.swing.JScrollPane();
		jList1 = new javax.swing.JList();
		jButton3 = new javax.swing.JButton();
		jLabel6 = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		jLabel2 = new javax.swing.JLabel();
		jScrollPane2 = new javax.swing.JScrollPane();
		jList2 = new javax.swing.JList();
		jLabel3 = new javax.swing.JLabel();
		jButton4 = new javax.swing.JButton();
		jButton1 = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		jLabel1.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel1.setText("Following relations have been selected by the user for retaining only metadata :");

		jScrollPane1.setViewportView(jList1);

		jButton3.setText("Remove");
		jButton3.setToolTipText("Removes the selected relations from droping the data.");
		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton3ActionPerformed(evt);
			}
		});

		jLabel6.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel6.setText("(To retain data in any of the above relations  select and press remove)");

		jLabel2.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel2.setText("Following relations data will also be dropped due to their dependency on above relations:");

		jScrollPane2.setViewportView(jList2);

		jLabel3.setFont(new java.awt.Font("Cambria", 0, 14)); // NOI18N
		jLabel3.setForeground(new java.awt.Color(255, 51, 51));
		jLabel3.setText(" *Note that all the data in these tables will be removed.");

		jButton4.setText("<< Back");
		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton4ActionPerformed(evt);
			}
		});

		jButton1.setText("Confirm");
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jButton1ActionPerformed(evt);
			}
		});

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1.setLayout(jPanel1Layout);
		jPanel1Layout.setHorizontalGroup(
				jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
								.addGroup(jPanel1Layout.createSequentialGroup()
										.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
												.addGroup(jPanel1Layout.createSequentialGroup()
														.addComponent(jButton4, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE)
														.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
														.addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE))
														.addComponent(jLabel1)
														.addComponent(jLabel6)
														.addComponent(jLabel3)
														.addGroup(jPanel1Layout.createSequentialGroup()
																.addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 439, javax.swing.GroupLayout.PREFERRED_SIZE)
																.addGap(18, 18, 18)
																.addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 120, javax.swing.GroupLayout.PREFERRED_SIZE))
																.addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 577, javax.swing.GroupLayout.PREFERRED_SIZE)
																.addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 439, javax.swing.GroupLayout.PREFERRED_SIZE))
																.addGap(0, 0, Short.MAX_VALUE)))
																.addContainerGap())
				);
		jPanel1Layout.setVerticalGroup(
				jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
						.addContainerGap()
						.addComponent(jLabel1)
						.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
						.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
								.addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 40, javax.swing.GroupLayout.PREFERRED_SIZE)
								.addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 128, javax.swing.GroupLayout.PREFERRED_SIZE))
								.addGap(11, 11, 11)
								.addComponent(jLabel6)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addComponent(jLabel2)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
								.addComponent(jLabel3)
								.addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
								.addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
										.addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, 40, Short.MAX_VALUE)
										.addComponent(jButton4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
										.addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
				);

		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

		if(model1.getSize() == 0)
		{
			JOptionPane.showMessageDialog(null, "No relations to retain metadata.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
		}
		else
		{
			try {
				String[] dropRelations = new String[model1.getSize()];
				String[] dependentRelations = new String[model2.getSize()];
				for (int i = 0; i < model1.getSize(); i++) {
					dropRelations[i] = (String) model1.get(i);
				}
				for (int i = 0; i < model2.getSize(); i++) {
					dependentRelations[i] = (String) model2.get(i);
				}
				if (database.retain(dropRelations, dependentRelations)) { // Retain the metadata
					JOptionPane.showMessageDialog(null, "Retaining Metadata of Relations is Successful.", "CODD - Message", JOptionPane.INFORMATION_MESSAGE);
				} else {
					JOptionPane.showMessageDialog(null, "Retaining Metadata of Relations has Failed.", "CODD - Erro", JOptionPane.ERROR_MESSAGE);
				}
			} catch (Exception e) {
				Constants.CPrintErrToConsole(e);
				JOptionPane.showMessageDialog(null, "Exception Caught: Retaining Metadata of Database Relations.", "CODD - Exception", JOptionPane.ERROR_MESSAGE);
			}
		}
		try{
			new GetRelationFrame(database).setVisible(true);
			this.dispose();							
		}catch(Exception e){
            Constants.CPrintErrToConsole(e);
            JOptionPane.showMessageDialog(null,e.getMessage(), "CODD - Exception",JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButton1ActionPerformed

	private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
		new ModeSelection(database, passedRelation).setVisible(true);
		this.dispose();
	}//GEN-LAST:event_jButton4ActionPerformed

	private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
		// Remove the seleceted elements in from model1 and recompute dependentRelations
		Object[] selection = jList1.getSelectedValues();
		int len = selection.length;
		for (int k = 0; k < len; k++) {
			String selectedrelation = selection[k].toString();
			model1.removeElement(selectedrelation);
		}
		model2.removeAllElements();
		// Recompute dependentRelations
		ArrayList<String> relationsList = new ArrayList();
		for (int i = 0; i < model1.getSize(); i++) {
			relationsList.add((String)model1.elementAt(i));
		}
		try {
			ArrayList<String> dependentRel = database.getDependentRelations(relationsList);
			for (int i = 0; i < dependentRel.size(); i++) {
				model2.addElement(dependentRel.get(i));
			}
		} catch (Exception e) {
			Constants.CPrintErrToConsole(e);
		}

	}//GEN-LAST:event_jButton3ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButton1;
	private javax.swing.JButton jButton3;
	private javax.swing.JButton jButton4;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JLabel jLabel6;
	private javax.swing.JList jList1;
	private javax.swing.JList jList2;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JScrollPane jScrollPane2;
	private javax.swing.JSeparator jSeparator1;
	// End of variables declaration//GEN-END:variables

}
