/*
#
# COPYRIGHT INFORMATION
#
# Copyright (C) 2013 Indian Institute of Science
# Bangalore 560012, INDIA
#
# This program is part of the CODD Metadata Processor
# software distribution invented at the Database Systems Lab,
# Indian Institute of Science. The use of the software is governed
# by the licensing agreement set up between the copyright owner,
# Indian Institute of Science, and the licensee.
#
# This program is distributed WITHOUT ANY WARRANTY;
# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# The public URL of the CODD project is
# http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
#
# For any issues, contact
# Prof. Jayant R. Haritsa
# SERC
# Indian Institute of Science
# Bangalore 560012, India.
# 

# Email: haritsa@dsl.serc.iisc.ernet.in
# 
#
 */
package iisc.dsl.codd.client;

import iisc.dsl.codd.client.gui.BaseJPanel;
import javax.swing.JProgressBar;

/**
 * Initial Flash Screen.
 * @author dsladmin
 */

public class SplashFrame extends javax.swing.JFrame {

    /**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = -4936210912624268230L;
	//private static final Logger log = LogManager.getLogger(SplashFrame.class);
    private static final int JPROGRESS_MAX = 1;
    private BaseJPanel splash;
    private JProgressBar jpbar;

    /**
     * Constructor for NewJFrame.
     */
    public SplashFrame() {
        initComponents();
        //log.info("Initializing Splash Screen");
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        this.setSize(800, 510);
        splash = new BaseJPanel("img/codd_splash.png");
        jpbar = new JProgressBar(0, JPROGRESS_MAX);
        jpbar.setBorderPainted(false);
        jpbar.setMaximum(JPROGRESS_MAX);
        this.add(splash, 0);
        splash.setBounds(0, 0, 800, 500);
        this.add(jpbar, 1);
        jpbar.setBounds(0, 500, 800, 10);
        splash.addMouseListener(new java.awt.event.MouseAdapter() {
            @Override
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                if (jpbar.getValue() >= JPROGRESS_MAX) {
                    showMainScreen();
                }
            }
        });
        new JPBarAnimationThread(1, jpbar).start();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setBackground(new java.awt.Color(255, 255, 204));
        setBounds(new java.awt.Rectangle(260, 200, 200, 375));
        setFocusTraversalPolicyProvider(true);
        setForeground(new java.awt.Color(204, 255, 204));
        setName("Dataless Frame"); // NOI18N
        setUndecorated(true);
        setResizable(false);
        getContentPane().setLayout(null);

        setSize(new java.awt.Dimension(800, 500));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    final void showMainScreen() {
        new ConnectDBFrame().setVisible(true);
        this.dispose();
    }

    private class JPBarAnimationThread extends Thread {

        private int step;
        private JProgressBar bar;

        public JPBarAnimationThread(int step, JProgressBar bar) {
            this.step = step;
            this.bar = bar;
        }

        @Override
        public void run() {
            super.run(); //To change body of generated methods, choose Tools | Templates.
            while (bar.getValue() < bar.getMaximum()) {
                try {
                    Thread.sleep(500);
                    bar.setValue(bar.getValue() + step);
                } catch (Exception e) {
                	System.out.println("Error occured in progress bar.");
                }
            }
            showMainScreen();
        }
    }
}
