/*
 #
 # COPYRIGHT INFORMATION
 #
 # Copyright (C) 2013 Indian Institute of Science
 # Bangalore 560012, INDIA
 #
 # This program is part of the CODD Metadata Processor
 # software distribution invented at the Database Systems Lab,
 # Indian Institute of Science. The use of the software is governed
 # by the licensing agreement set up between the copyright owner,
 # Indian Institute of Science, and the licensee.
 #
 # This program is distributed WITHOUT ANY WARRANTY;
 # without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 #
 # The public URL of the CODD project is
 # http://dsl.serc.iisc.ernet.in/projects/CODD/index.html
 #
 # For any issues, contact
 # Prof. Jayant R. Haritsa
 # SERC
 # Indian Institute of Science
 # Bangalore 560012, India.
 # 
 
 # Email: haritsa@dsl.serc.iisc.ernet.in
 # 
 #
 */
package iisc.dsl.codd.db.db2;

import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.client.ConfigurationTypeSelection;
import iisc.dsl.codd.client.gui.BaseJPanel;
import javax.swing.GroupLayout.Alignment;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.GroupLayout;
import javax.swing.SwingConstants;
import java.awt.Component;
import java.sql.Connection;

import javax.swing.JScrollPane;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JPanel;
import javax.swing.JDesktopPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import java.awt.BorderLayout;

/**
 * ModeSelection Frame allows the user to select any one of the CODD Dataless
 * mode.
 *
 * @author dsladmin
 */
public class DB2HardwareConfiguration extends javax.swing.JFrame {

	/**
	 * Generated serialVersionUID
	 */
	private static final long serialVersionUID = 4115492120063262520L;
	
	Database database; // Database Object

	/**
	 * Constructor for ConfigurationTypeSelection Frame.
	 *
	 * @param database - Database object
	 * @param relation - Array of Selected Relations
	 */
	public DB2HardwareConfiguration(Database database) {
		this.database = database;
		initComponents();
		setLocationRelativeTo(null);
		setTitle("Configuration Type Selection");
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		jPanel1 = new BaseJPanel("img/bg_net.png");
		backButton = new javax.swing.JButton();
		updateButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setResizable(false);

		backButton.setText("<< Back");
		backButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				backButtonActionPerformed(evt);
			}
		});

		updateButton.setText("Update");
		updateButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				continueButtonActionPerformed(evt);
			}
		});
		
		defaultDegreeLabel = new JLabel("Default Degree (DFT_DEGREE) :");
		avgAppsLabel = new JLabel("Average Number of Active Applications (AVG_APPLS) :");
		sortHeapLabel = new JLabel("Sort Heap Size (SORTHEAP) :");
		cpuSpeedLabel = new JLabel("CPU Speed (CPUSPEED) :");
		stmtHeapLabel = new JLabel("Statement Heap Size (STMTHEAP) :");
		appHeapLabel = new JLabel("Application Heap Size (APPLHEAPSZ) :");

		separatorOne = new JSeparator();		
		separatorTwo = new JSeparator();
		separatorThree = new JSeparator();
		separatorFour = new JSeparator();
		separatorFive = new JSeparator();
		separatorSix = new JSeparator();
		
		defaultDegreeSNM = new SpinnerNumberModel(((DB2Database)database).getDefaultDegree(),1,32767,1);		
		avgAppSNM = new SpinnerNumberModel(((DB2Database)database).getAverageNumOfApps(),1,Integer.MAX_VALUE,1);
		sortHeapSNM = new SpinnerNumberModel(((DB2Database)database).getSortHeapSize(),16,524288,1);
		cpuSpeedSNM = new SpinnerNumberModel(1/((DB2Database)database).getCPUSpeed(),1.0,10000000000.0,1.0);
		stmtHeapSNM = new SpinnerNumberModel(((DB2Database)database).getStatementHeapSize(),128,524288,1);
		appHeapSNM = new SpinnerNumberModel(((DB2Database)database).getApplicationHeapSize(),16,60000,1);

		defaultDegreeSpinner = new JSpinner(defaultDegreeSNM);
		avgAppSpinner = new JSpinner(avgAppSNM);
		sortHeapSpinner = new JSpinner(sortHeapSNM);
		cpuSpeedSpinner = new JSpinner(cpuSpeedSNM);
		stmtHeapSpinner = new JSpinner(stmtHeapSNM);
		appHeapSpinner = new JSpinner(appHeapSNM);

		javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
		jPanel1Layout.setHorizontalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addGap(29)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.LEADING)
						.addComponent(separatorSix, GroupLayout.DEFAULT_SIZE, 576, Short.MAX_VALUE)
						.addGroup(jPanel1Layout.createParallelGroup(Alignment.TRAILING, false)
							.addComponent(separatorFour, Alignment.LEADING)
							.addComponent(separatorTwo, Alignment.LEADING)
							.addComponent(separatorOne, Alignment.LEADING, GroupLayout.DEFAULT_SIZE, 576, Short.MAX_VALUE)
							.addComponent(separatorThree, Alignment.LEADING))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(avgAppsLabel, GroupLayout.PREFERRED_SIZE, 373, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(avgAppSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addGroup(Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
							.addComponent(backButton, GroupLayout.PREFERRED_SIZE, 120, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, 332, Short.MAX_VALUE)
							.addComponent(updateButton))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(stmtHeapLabel, GroupLayout.PREFERRED_SIZE, 246, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(stmtHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(appHeapLabel, GroupLayout.PREFERRED_SIZE, 267, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(appHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addComponent(separatorFive, GroupLayout.DEFAULT_SIZE, 576, Short.MAX_VALUE)
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(defaultDegreeLabel, GroupLayout.PREFERRED_SIZE, 216, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(defaultDegreeSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(sortHeapLabel, GroupLayout.PREFERRED_SIZE, 201, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(sortHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
						.addGroup(jPanel1Layout.createSequentialGroup()
							.addComponent(cpuSpeedLabel, GroupLayout.PREFERRED_SIZE, 172, GroupLayout.PREFERRED_SIZE)
							.addPreferredGap(ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
							.addComponent(cpuSpeedSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
					.addContainerGap())
		);
		jPanel1Layout.setVerticalGroup(
			jPanel1Layout.createParallelGroup(Alignment.LEADING)
				.addGroup(jPanel1Layout.createSequentialGroup()
					.addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(defaultDegreeLabel)
						.addComponent(defaultDegreeSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(separatorOne, GroupLayout.PREFERRED_SIZE, 8, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(avgAppsLabel)
						.addComponent(avgAppSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(separatorTwo, GroupLayout.PREFERRED_SIZE, 9, GroupLayout.PREFERRED_SIZE)
					.addGap(18)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(sortHeapLabel)
						.addComponent(sortHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(separatorThree, GroupLayout.PREFERRED_SIZE, 10, GroupLayout.PREFERRED_SIZE)
					.addGap(18)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(cpuSpeedLabel)
						.addComponent(cpuSpeedSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(separatorFour, GroupLayout.PREFERRED_SIZE, 8, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.TRAILING)
						.addComponent(stmtHeapLabel)
						.addComponent(stmtHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addComponent(separatorFive, GroupLayout.PREFERRED_SIZE, 8, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.TRAILING)
						.addComponent(appHeapLabel)
						.addComponent(appHeapSpinner, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addComponent(separatorSix, GroupLayout.PREFERRED_SIZE, 8, GroupLayout.PREFERRED_SIZE)
					.addGap(24)
					.addGroup(jPanel1Layout.createParallelGroup(Alignment.BASELINE)
						.addComponent(updateButton)
						.addComponent(backButton, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE))
					.addContainerGap())
		);
		jPanel1Layout.linkSize(SwingConstants.VERTICAL, new Component[] {backButton, updateButton});
		jPanel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {backButton, updateButton});
		jPanel1.setLayout(jPanel1Layout);

		getContentPane().add(jPanel1, BorderLayout.NORTH);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void continueButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
		((DB2Database)database).setDefaultDegree((Integer)defaultDegreeSpinner.getValue());
		((DB2Database)database).setAverageNumOfApps((Integer)avgAppSpinner.getValue());
		((DB2Database)database).setSortHeapSize((Integer)sortHeapSpinner.getValue());
		((DB2Database)database).setCPUSpeed(1/(Double)cpuSpeedSpinner.getValue());
		((DB2Database)database).setStatementHeapSize((Integer)stmtHeapSpinner.getValue());
		((DB2Database)database).setApplicationHeapSize((Integer)appHeapSpinner.getValue());
		
		System.out.println("Default Degree: " + defaultDegreeSpinner.getValue());
		System.out.println("Avg App: " + avgAppSpinner.getValue());
		System.out.println("Sort Heap: " + sortHeapSpinner.getValue());
		System.out.println("CPU Speed: " + cpuSpeedSpinner.getValue());
		System.out.println("Stmt Heap: " + stmtHeapSpinner.getValue());
		System.out.println("App Heap: " + appHeapSpinner.getValue());

	
	}//GEN-LAST:event_jButton2ActionPerformed

	private void backButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
		// Back button selected.
		new ConfigurationTypeSelection(database).setVisible(true);
		this.dispose();							
	}//GEN-LAST:event_jButton1ActionPerformed

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton backButton;
	private javax.swing.JButton updateButton;
	private javax.swing.JPanel jPanel1;
	private JLabel defaultDegreeLabel;		
	private JSeparator separatorOne;
	
	private JLabel avgAppsLabel;
	private JLabel sortHeapLabel;
	private JLabel cpuSpeedLabel;
	private JLabel stmtHeapLabel;
	private JLabel appHeapLabel;

	private JSeparator separatorTwo;	
	private JSeparator separatorThree;
	private JSeparator separatorFour;
	private JSeparator separatorFive;
	private JSeparator separatorSix;
	
	private JSpinner defaultDegreeSpinner;		
	private JSpinner avgAppSpinner;
	private JSpinner sortHeapSpinner;
	private JSpinner cpuSpeedSpinner;
	private JSpinner stmtHeapSpinner;
	private JSpinner appHeapSpinner;

	private SpinnerNumberModel defaultDegreeSNM;		
	private SpinnerNumberModel avgAppSNM;
	private SpinnerNumberModel sortHeapSNM;
	private SpinnerNumberModel cpuSpeedSNM;
	private SpinnerNumberModel stmtHeapSNM;
	private SpinnerNumberModel appHeapSNM;

}
