package iisc.dsl.coddgen.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

import iisc.dsl.codd.db.ColumnStatistics;
import iisc.dsl.codd.db.HistogramObject;
import iisc.dsl.codd.ds.Statistics;
import iisc.dsl.coddgen.ui.model.AnonymInputFrameOut;
import iisc.dsl.coddgen.ui.model.CollectingInputFrameOut;
import iisc.dsl.coddgen.ui.utils.AlqpGraphXComponent;
import iisc.dsl.coddgen.ui.utils.Constants;
import iisc.dsl.coddgen.ui.utils.Utils;
import in.ac.iisc.cds.dsl.cdgclient.anonymizer.Anonymizer;
import in.ac.iisc.cds.dsl.cdgclient.anonymizer.SchemaAnonymize;
import in.ac.iisc.cds.dsl.cdgclient.anonymizer.SchemaAnonymizePostgres;
import in.ac.iisc.cds.dsl.cdgclient.constants.PostgresCConfig;
import in.ac.iisc.cds.dsl.cdgclient.constants.PostgresCConfig.Key;
import in.ac.iisc.cds.dsl.cdgclient.preprocess.AlqpToCC;
import in.ac.iisc.cds.dsl.cdgclient.preprocess.AlqpToCCPostgres;
import in.ac.iisc.cds.dsl.cdgclient.preprocess.AlqpToCCPostgresRes;
import in.ac.iisc.cds.dsl.cdgclient.preprocess.DDLGenerator;
import in.ac.iisc.cds.dsl.cdgvendor.model.Alqp;
import in.ac.iisc.cds.dsl.cdgvendor.model.formal.FormalCondition;
import in.ac.iisc.cds.dsl.cdgvendor.utils.DebugHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;

@SuppressWarnings("serial")
public class AnonymInputFrame extends JFrame {

    private static final String           NEWLINE = "\n";

    private final JFrame                  prevFrame;
    private final CollectingInputFrameOut prevFrameOut;

    private Anonymizer                    anonymizer;
    private AlqpToCCPostgresRes           res;

    public AnonymInputFrame(JFrame prevFrame, CollectingInputFrameOut prevFrameOut) {

        this.prevFrame = prevFrame;
        this.prevFrameOut = prevFrameOut;

        Utils.setFrameBig(this, "Visualize Data Generator's Input");

        firstThings();
        generateAnonymizedCCsPostgres();

        initComponents();
    }

    private void initComponents() {
        JPanel origAlqpPanel = Utils.newBorderPanel();
        JPanel origQueryPanel = Utils.newBorderPanel();
        JPanel origConstraintsPanel = Utils.newBorderPanel();

        JPanel anonymQueryPanel = Utils.newBorderPanel();
        JPanel anonymConstraintsPanel = Utils.newBorderPanel();

        String queryNames[] = prevFrameOut.queryNames.toArray(new String[prevFrameOut.queryNames.size()]);

        JList<String> queryJList = new JList<>(queryNames);
        queryJList.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        queryJList.setLayoutOrientation(JList.HORIZONTAL_WRAP);
        queryJList.setVisibleRowCount(4);
        queryJList.setSelectedIndex(0);
        queryJList.addListSelectionListener(new ListSelectionListener() {

            @Override
            public void valueChanged(ListSelectionEvent e) {
            	if(!e.getValueIsAdjusting()) {
	                String selectedQueryName = queryJList.getSelectedValue();
	                int indx = prevFrameOut.queryNames.indexOf(selectedQueryName);
	
	                origAlqpPanel.removeAll();
	                origAlqpPanel.add(Utils.newHeading("Execution Plan"), BorderLayout.NORTH);
	                origAlqpPanel.add(AlqpGraphXComponent.parse(prevFrameOut.BASICSCHEMA_INFO, prevFrameOut.executionPlans.get(indx), null, null),
	                        BorderLayout.CENTER);
	                origAlqpPanel.validate();
	                origAlqpPanel.repaint();
	
	                origQueryPanel.removeAll();
	                origQueryPanel.add(Utils.newHeading("Client Query"), BorderLayout.NORTH);
	                origQueryPanel.add(Utils.newTextArea(prevFrameOut.origQueries.get(indx)), BorderLayout.CENTER);
	                origQueryPanel.validate();
	                origQueryPanel.repaint();
	
	                origConstraintsPanel.removeAll();
	                origConstraintsPanel.add(Utils.newHeading("Cardinality Constraints"), BorderLayout.NORTH);
	                origConstraintsPanel.add(Utils.newTextArea(getAsDisplayStr(res.alqpOrigFormalConditions.get(indx))), BorderLayout.CENTER);
	                origConstraintsPanel.validate();
	                origConstraintsPanel.repaint();
	
	                anonymQueryPanel.removeAll();
	                anonymQueryPanel.add(Utils.newHeading("Anonymized Query"), BorderLayout.NORTH);
	                anonymQueryPanel.add(Utils.newTextArea(res.anonymQueries.get(indx)), BorderLayout.CENTER);
	                anonymQueryPanel.validate();
	                anonymQueryPanel.repaint();
	
	                anonymConstraintsPanel.removeAll();
	                anonymConstraintsPanel.add(Utils.newHeading("Anonymized Cardinality Constraints"), BorderLayout.NORTH);
	                anonymConstraintsPanel.add(Utils.newTextArea(getAsDisplayStr(res.alqpAnonymFormalConditions.get(indx))), BorderLayout.CENTER);
	                anonymConstraintsPanel.validate();
	                anonymConstraintsPanel.repaint();
            	}
            }
        });

        JPanel origPanel = Utils.newGridPanel(1, 2);

        origAlqpPanel.add(Utils.newHeading("Execution Plan"), BorderLayout.NORTH);
        origAlqpPanel.add(AlqpGraphXComponent.parse(prevFrameOut.BASICSCHEMA_INFO, prevFrameOut.executionPlans.get(0), null, null), BorderLayout.CENTER);
//        origAlqpPanel.setBackground(Color.BLACK);
        origPanel.add(origAlqpPanel);

        JPanel origPanelR = Utils.newBoxPanel();
        origQueryPanel.add(Utils.newHeading("Client Query"), BorderLayout.NORTH);
        origQueryPanel.add(Utils.newTextArea(prevFrameOut.origQueries.get(0)), BorderLayout.CENTER);
        origConstraintsPanel.add(Utils.newHeading("Cardinality Constraints"), BorderLayout.NORTH);
        origConstraintsPanel.add(Utils.newTextArea(getAsDisplayStr(res.alqpOrigFormalConditions.get(0))), BorderLayout.CENTER);
        origPanelR.add(origQueryPanel);
        origPanelR.add(origConstraintsPanel);
        origPanel.add(origPanelR);

        JPanel anonymPanel = Utils.newGridPanel(1, 2);
        JPanel jChartPanel = Utils.newBoxPanel();

        List<String> relnames = new ArrayList<>(prevFrameOut.BASICSCHEMA_INFO.getTablenames());
        Collections.sort(relnames);
        JComboBox<String> relCombo = new JComboBox<>(relnames.toArray(new String[prevFrameOut.BASICSCHEMA_INFO.getTablenames().size()]));
        String selectedRelname = relnames.get(0);
        List<String> colnames = new ArrayList<>(prevFrameOut.BASICSCHEMA_INFO.getTableInfo(selectedRelname).columnsNames());
        Collections.sort(colnames);
        JComboBox<String> colCombo = new JComboBox<>(colnames.toArray(new String[colnames.size()]));
        relCombo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedRelname = relCombo.getSelectedItem().toString();
                List<String> colList = new ArrayList<>(prevFrameOut.BASICSCHEMA_INFO.getTableInfo(selectedRelname).columnsNames());
                Collections.sort(colList);

                String[] cols = colList.toArray(new String[colList.size()]);
                colCombo.setModel(new DefaultComboBoxModel<>(cols));
            }
        });

        JRadioButton origHist = new JRadioButton("Client Side Histogram");
        JRadioButton anonymHist = new JRadioButton("Anonymized Histogram");
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(origHist);
        bgroup.add(anonymHist);
        origHist.setSelected(true);

        JPanel radioPanel = Utils.newBoxPanel();
        radioPanel.add(origHist);
        radioPanel.add(anonymHist);

        JButton plotButton = new JButton("Plot Chart");
        plotButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String relname = relCombo.getSelectedItem().toString();
                String colname = colCombo.getSelectedItem().toString();
                boolean isOrig = origHist.isSelected();
                //TODO: Add Anonymized Histogram

                jChartPanel.removeAll();
                jChartPanel.add(new ChartPanel(createHistogram(getDataset(relname, colname))), BorderLayout.CENTER);
                jChartPanel.validate();
                jChartPanel.repaint();
            }
        });

        JPanel northPanel = Utils.newBoxPanel();
        JPanel flowPanel = Utils.newFlowPanel();
        flowPanel.add(Utils.newHeading("Metadata"));
        northPanel.add(flowPanel);

        JPanel subCtrlPanel = Utils.newFlowPanel();
        subCtrlPanel.add(new JLabel("Relation: "));
        subCtrlPanel.add(relCombo);
        subCtrlPanel.add(new JLabel("Column: "));
        subCtrlPanel.add(colCombo);
//        subCtrlPanel.add(radioPanel);
        subCtrlPanel.add(plotButton);
        northPanel.add(subCtrlPanel);

        JPanel metadataPanel = Utils.newBorderPanel();
        metadataPanel.add(northPanel, BorderLayout.NORTH);

        jChartPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jChartPanel.add(new ChartPanel(createHistogram(getDataset(relnames.get(0), colnames.get(0)))), BorderLayout.CENTER);
        metadataPanel.add(jChartPanel, BorderLayout.CENTER);

        anonymPanel.add(metadataPanel);

//        JPanel anonymPanelR = Utils.newBoxPanel();
//        anonymQueryPanel.add(Utils.newHeading("Anonymized Query"), BorderLayout.NORTH);
//        anonymQueryPanel.add(Utils.newTextArea(res.anonymQueries.get(0)), BorderLayout.CENTER);
//        anonymConstraintsPanel.add(Utils.newHeading("Anonymized Cardinality Constraints"), BorderLayout.NORTH);
//        anonymConstraintsPanel.add(Utils.newTextArea(getAsDisplayStr(res.alqpAnonymFormalConditions.get(0))), BorderLayout.CENTER);
//        anonymPanelR.add(anonymQueryPanel);
//        anonymPanelR.add(anonymConstraintsPanel);
//        anonymPanel.add(anonymPanelR);

        JPanel ctrlPanel = Utils.newCtlrsPanel();
        JButton backButton = new JButton("Back");
        backButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickBack();
            }
        });
        ctrlPanel.add(backButton);
//        JButton nextButton = new JButton("Proceed");
        JButton nextButton = new JButton("Go to Vendor Panel");
        nextButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickNext();
            }
        });
        Utils.setEnterButton(this, nextButton);
        ctrlPanel.add(nextButton);

        JPanel bgPanel = Utils.newBgPanel();
        JPanel headingPanel = Utils.newFlowPanel();
        headingPanel.add(Utils.newHeading("Choose a query to visualize"));
        bgPanel.add(headingPanel);
        bgPanel.add(new JScrollPane(queryJList, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER));
        bgPanel.add(new JLabel(" "));
        bgPanel.add(origPanel);
        bgPanel.add(new JLabel(" "));
        bgPanel.add(anonymPanel);
        bgPanel.add(ctrlPanel);

        getContentPane().add(bgPanel);
        setLocationRelativeTo(null);
    }

    private static JFreeChart createHistogram(CategoryDataset dataset) {

        // create the chart...
        final JFreeChart chart = ChartFactory.createBarChart(null, // chart title
                "Buckets", // domain axis label
                "Count", // range axis label
                dataset, // data
                PlotOrientation.VERTICAL, // orientation
                true, // include legend
                true, // tooltips?
                false // URLs?
        );

        // NOW DO SOME OPTIONAL CUSTOMISATION OF THE CHART...

        // set the background color for the chart...
        chart.setBackgroundPaint(Color.white);

        // get a reference to the plot for further customisation...
        final CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);

        // set the range axis to display integers only...
        final NumberAxis rangeAxis = (NumberAxis) plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());

        // disable bar outlines...
        final BarRenderer renderer = (BarRenderer) plot.getRenderer();
        renderer.setDrawBarOutline(true);

        // set up gradient paints for series...
        final GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.lightGray);
        final GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.lightGray);
        final GradientPaint gp2 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.lightGray);
        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        renderer.setSeriesPaint(2, gp2);

        final CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(Math.PI / 6.0));
        // OPTIONAL CUSTOMISATION COMPLETED.

        return chart;

    }

    //TODO: CategoryData not needed
    private CategoryDataset getDataset(String relationName, String columnName) {

        String category1 = "";

        Statistics relationStats = prevFrameOut.relnameStatsMap.get(relationName);
        ColumnStatistics columnsStats = relationStats.getColumnStatistics(columnName);

        DefaultCategoryDataset dataset = new DefaultCategoryDataset();

        if (columnsStats == null || columnsStats.getHistogram() == null)
            return dataset;
        for (int i = 1; i <= columnsStats.getHistogram().size(); i++) {
            HistogramObject hist = columnsStats.getHistogram().get(i);
            dataset.addValue(hist.getValCount(), hist.getColValue(), category1);
        }
        return dataset;
    }

    private void onClickBack() {
        setVisible(false);
        dispose();
        prevFrame.setVisible(true);
    }

//    private void onClickNext() {
//        setVisible(false);
//        dispose();
//        new SolverFrame(this, new AnonymInputFrameOut(prevFrameOut, anonymizer, res)).setVisible(true);
//    }
    
    private void onClickNext() {
//    	JOptionPane.showMessageDialog(this, "Output for vendor saved successfully at "+NEWLINE+prevFrameOut.outputLocation, "Saved successfully", JOptionPane.INFORMATION_MESSAGE);
        setVisible(false);
//        dispose();
        new VendorInputFrame(this, new AnonymInputFrameOut(prevFrameOut, anonymizer, res)).setVisible(true);
//        new SolverFrame(this, new AnonymInputFrameOut(prevFrameOut, anonymizer, res)).setVisible(true);
    }

    private void firstThings() {
//        PostgresVConfig.initDefaultConfig();
        Map<Key, String> overlapConfig = new HashMap<>();
        overlapConfig.put(Key.ANONYMIZEDCCS_TARGETFILE, prevFrameOut.outputLocation+Constants.PathSeparator+"anonymizedcc.info");
        overlapConfig.put(Key.ANONYMIZEDSCHEMA_TARGETFILE, prevFrameOut.outputLocation+Constants.PathSeparator+"anonymizedschema.info");
        overlapConfig.put(Key.ANONYMIZEDQUERIES_TARGETLOCATION, prevFrameOut.outputLocation+Constants.PathSeparator+"anonymizedsqlqueries");
        overlapConfig.put(Key.DDLGENERATED_TARGETFILE, prevFrameOut.outputLocation+Constants.PathSeparator+"schemaddl.sql");
        

//        overlapConfig.put(Key.ANONYMIZEDCCS_INFO,
//                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/anonymizedcc.info");
//        overlapConfig.put(Key.ANONYMIZEDSCHEMA_FILENAME,
//                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/anonymizedschema.info");
//
//        overlapConfig.put(Key.DATABASESUMMARY_LOCATION,
//                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/output/postgres/databasesummary");
//        overlapConfig.put(Key.DATABASESTATICDUMP_LOCATION, "/media/dsladmin/disk1/scratchINUSE");
        
        PostgresCConfig.overlayOnDefaultConfig(overlapConfig);
    }

    private void generateAnonymizedCCsPostgres() {
        DebugHelper.printInfo("-------- Gateway: Generating anonymized CCs for Postgres ------------");

        //Step 1: Load schema
        PostgresCConfig.setBASICSCHEMA_INFO(prevFrameOut.BASICSCHEMA_INFO);

        //Step 2: Anonymize it while creating anonymizer
        SchemaAnonymize san = new SchemaAnonymizePostgres();
        anonymizer = san.anonymizeSchema();

        //Step 3: Generate ddl for anonymized schema. Also contains primary key/foreign key constraints
        DDLGenerator dg = new DDLGenerator();
        dg.generateDDL(anonymizer);

        //Step 4: We already have ALQPs here
        List<Alqp> alqps = prevFrameOut.executionPlans;

        //Step 5: Generate anonymized CCs and queries with domain mapping
        AlqpToCC ac = new AlqpToCCPostgres(anonymizer);
        res = ac.anonymizeAlqpsAndGenerateCCsAndQueries(alqps, prevFrameOut.mappingInfo);

        DebugHelper.printInfo("-------- Gateway: Done generating anonymized CCs for Postgres ------------");
        
//        Saving statistics and maps
        Utils.writeObjectToFile(prevFrameOut.relnameStatsMap, prevFrameOut.outputLocation + Constants.PathSeparator + Constants.STATISTICS_FILENAME);
    	Utils.writeObjectToFile(anonymizer.getTablenameAnonymMap(), prevFrameOut.outputLocation + Constants.PathSeparator + Constants.TABLE_MAP_FILENAME);
    	Utils.writeObjectToFile(anonymizer.getColumnnameAnonymMap(), prevFrameOut.outputLocation + Constants.PathSeparator + Constants.COLUMN_MAP_FILENAME);
    	Utils.writeObjectToFile(anonymizer.getNumber121Mapping(), prevFrameOut.outputLocation + Constants.PathSeparator + Constants.NUMBER_MAP_FILENAME);
    	Utils.writeObjectToFile(anonymizer.getString121Mapping(), prevFrameOut.outputLocation + Constants.PathSeparator + Constants.STRING_MAP_FILENAME);
    	Utils.writeObjectToFile(anonymizer.getDate121Mapping(), prevFrameOut.outputLocation + Constants.PathSeparator + Constants.DATE_MAP_FILENAME);
    	
    	DebugHelper.printInfo(anonymizer.getTablenameAnonymMap().toString());
    	DebugHelper.printInfo(anonymizer.getColumnnameAnonymMap().toString());
    	
    	JOptionPane.showMessageDialog(this, "Input data for vendor saved successfully at "+NEWLINE+prevFrameOut.outputLocation, "Saved successfully", JOptionPane.INFORMATION_MESSAGE);

//        System.err.println(anonymizer.getTablenameAnonymMap());
//        System.err.println(anonymizer.getColumnnameAnonymMap());
    }

    private static String getAsDisplayStr(List<FormalCondition> formalConditions) {
        StringBuilder sb = new StringBuilder();
        for (FormalCondition formalCondition : formalConditions) {
            sb.append(formalCondition.toString()).append(NEWLINE);
        }
        return sb.toString();
    }
}

//Screenshot values
/*

-- start query 70 using TPC-DS template query12.tpl
select *
from
    web_sales
        ,item
        ,date_dim
where
    ws_item_sk = i_item_sk
    and i_category in ('Children', 'Sports', 'Music')
    and ws_sold_date_sk = d_date_sk
    and d_date between '2002-04-01' and '2002-05-01'
;
-- end query 70 using TPC-DS template query12.tpl



 | σ ( ((d_date >= '2002-04-01') AND (d_date <= '2002-05-01')) ∧ (i_category = ANY ('{Children,Sports,Music}')) ) (web_sales ⋈ date_dim ⋈ item) | = 21371
 | σ ( ((d_date >= '2002-04-01') AND (d_date <= '2002-05-01')) ) (web_sales ⋈ date_dim) | = 71480
 | σ (  ) (web_sales) | = 7197566
 | σ ( ((d_date >= '2002-04-01') AND (d_date <= '2002-05-01')) ) (date_dim) | = 31
 | σ ( (i_category = ANY ('{Children,Sports,Music}')) ) (item) | = 30586



select *
from
    t23
        ,t12
        ,t07
where 1=1
    and t23_F_t12 = t12_P
    and ((t12_c002 = 2) or (t12_c002 = 9) or (t12_c002 = 7))
    and t23_F_t07 = t07_P
    and ((t07_c005 >= 20) AND (t07_c005 <= 21))
;


 | σ ( (((t07_c005 >= 20) ∧ (t07_c005 <= 21)) ∧  ((t12_c002 = 2) ∨ (t12_c002 = 9) ∨ (t12_c002 = 7))) (t23 ⋈ t07 ⋈ t12) | = 21371
 | σ ( ((t07_c005 >= 20) ∧ (t07_c005 <= 21)) ) (t23 ⋈ t07) | = 71480
 | σ (  ) (t23) | = 7197566
 | σ ( ((t07_c005 >= 20) ∧ (t07_c005 <= 21)) ) (t07) | = 31
 | σ ( (t12_c002 = 2) ∨ (t12_c002 = 9) ∨ (t12_c002 = 7) ) (t12) | = 30586

*/
