package iisc.dsl.coddgen.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import iisc.dsl.codd.db.Database;
import iisc.dsl.codd.db.postgres.PostgresDatabase;
import iisc.dsl.codd.ds.DBSettings;
import iisc.dsl.coddgen.ui.model.ClientInputFrameOut;
import iisc.dsl.coddgen.ui.utils.PlaceholderTextField;
import iisc.dsl.coddgen.ui.utils.Utils;
import in.ac.iisc.cds.dsl.cdgclient.constants.PostgresCConfig;
import in.ac.iisc.cds.dsl.cdgclient.constants.PostgresCConfig.Key;
import sun.java2d.cmm.ProfileDataVerifier;

@SuppressWarnings("serial")
public class ClientInputFrame extends JFrame {

    private static final String        NEWLINE             = "\n";

    //private final List<String>         relnames;

    private boolean                    wFieldDone;
    private final PlaceholderTextField wField;
    private final JButton              wBrowse;
    
    private final PlaceholderTextField oField;
    private final JButton              oBrowse;

    private final JCheckBox            mFetch;
    private final JTextField           mField;
    private final JButton              mBrowse;

    private final JCheckBox            eFetch;
    private final JTextField           eField;
    private final JButton              eBrowse;
    
//    private final JCheckBox            cbAnonymize;
    
    private final JFrame				prevFrame;

    private static final String        DEFAULT_PLACEFOLDER = "provide folder location...";
    
    Database database;

    public ClientInputFrame(Database database, JFrame prevFrame) {
    	this.database = database;
    	this.prevFrame = prevFrame;
        firstThings();

        //        relnames = new ArrayList<>();
        //        relnames.add("store_sales");
        //        relnames.add("store");

        wField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
        wBrowse = new JButton("Browse");

        mFetch = new JCheckBox("Fetch from Engine");
        mField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
        mBrowse = new JButton("Browse");

        eFetch = new JCheckBox("Fetch from Engine");
        eField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
        eBrowse = new JButton("Browse");
        
//        cbAnonymize = new JCheckBox("Anonimize values");
        
        oField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
        oBrowse = new JButton("Browse");

        Utils.setFrame(this, "Input client database details");
        initComponents();
    }

    //TODO: feed from prev screen
//    private DBSettings getClientDBSettings() {
//        String dbServerName = "127.0.0.1";
//        String dbType = "POSTGRES";
//        String dbServerPort = "5432";
//        String dbName = "tpcds10";
//        String dbSchema = "public";
//        String dbUserName = "dsladmin";
//        String dbPassword = "";
//        String serverInstance = "";
//
//        DBSettings clientDBSettings = new DBSettings(dbServerName, dbServerPort, dbType, dbName, dbSchema, dbUserName, dbPassword);
//        clientDBSettings.setSqlServerInstanceName(serverInstance);
//        return clientDBSettings;
//    }

    private void firstThings() {

        PostgresCConfig.initDefaultConfig();
        Map<Key, String> overlapConfig = new HashMap<>();

        //Conn details
        
        if(!(database instanceof PostgresDatabase))
        	throw new RuntimeException("Not implemented");
        
        DBSettings settings = database.getSettings();
        
        overlapConfig.put(Key.CONN_DRIVERCLASS, "org.postgresql.Driver");
//        overlapConfig.put(Key.CONN_CONNSTRING, "jdbc:postgresql://127.0.0.1:5432/tpcds10");
        overlapConfig.put(Key.CONN_CONNSTRING, "jdbc:postgresql://"+settings.getServerName()+":"+settings.getServerPort()+"/"+settings.getDbName());
        overlapConfig.put(Key.CONN_USERNAME, settings.getUserName());
        overlapConfig.put(Key.CONN_PASSWD, settings.getPassword());
        
        overlapConfig.put(Key.BASICSCHEMA_DBNAME, settings.getDbName());
        overlapConfig.put(Key.BASICSCHEMA_SCHEMANAME, settings.getSchema());

        /*
        //Target files
        overlapConfig.put(Key.BASICSCHEMA_TARGETFILE,
                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgclient/postgres/basicschema/basicschema.info");

        overlapConfig.put(Key.DDLGENERATED_TARGETFILE,
                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/schemaddl.sql");

        overlapConfig.put(Key.ANONYMIZEDSCHEMA_TARGETFILE,
                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/anonymizedschema.info");
        overlapConfig.put(Key.ANONYMIZEDCCS_TARGETFILE,
                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/anonymizedcc.info");
        overlapConfig.put(Key.ANONYMIZEDQUERIES_TARGETLOCATION,
                "/home/dsladmin/CODD/RaghavSood/ws/codd-data-gen/tool-resources-scratch/cdgvendor/input/postgres/anonymizedsqlqueries");
*/
        PostgresCConfig.overlayOnDefaultConfig(overlapConfig);
    }

    private void initComponents() {

        JPanel wPanel = Utils.newFieldSetPanel("Workload Queries");
        wField.setEnabled(!wFieldDone);
        wPanel.add(wField);
        wBrowse.setEnabled(!wFieldDone);
        wBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickWBrowse();
            }
        });
        wPanel.add(wBrowse);

        JPanel ePanel = Utils.newFieldSetBoxLayoutPanel("Exceution Plans of Workload Queries");
        eFetch.setSelected(true);
        eFetch.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                if (eFetch.isSelected()) {
                    eField.setText("");
                    eField.setEnabled(false);
                    eBrowse.setEnabled(false);
                } else {
                    eField.setEnabled(true);
                    eBrowse.setEnabled(true);
                }
            }
        });
        ePanel.add(Utils.leftJustify(eFetch));
        JLabel eLabel = new JLabel("or");
        ePanel.add(Utils.leftJustify(eLabel));
        JPanel eFieldPanel = Utils.newFlowPanel();
        eField.setEnabled(false);
        eFieldPanel.add(eField);
        eBrowse.setEnabled(false);
        eBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickEBrowse();
            }
        });
        eFieldPanel.add(eBrowse);
        ePanel.add(eFieldPanel);

        JPanel mPanel = Utils.newFieldSetBoxLayoutPanel("Metadata Info");
        mFetch.setSelected(true);
        mFetch.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                if (mFetch.isSelected()) {
                    mField.setText("");
                    mField.setEnabled(false);
                    mBrowse.setEnabled(false);
                } else {
                    mField.setEnabled(true);
                    mBrowse.setEnabled(true);
                }
            }
        });
        mPanel.add(Utils.leftJustify(mFetch));
        JLabel mLabel = new JLabel("or");
        mPanel.add(Utils.leftJustify(mLabel));
        JPanel mFieldPanel = Utils.newFlowPanel();
        mField.setEnabled(false);
        mFieldPanel.add(mField);
        mBrowse.setEnabled(false);
        mBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickMBrowse();
            }
        });
        mFieldPanel.add(mBrowse);
        mPanel.add(mFieldPanel);

        JPanel sPanel = Utils.newFieldSetBoxLayoutPanel("Schema Info");
        JCheckBox sFetch = new JCheckBox("Fetch from Engine");
        sFetch.setSelected(true);
        sFetch.setEnabled(false);
        sPanel.add(Utils.leftJustify(sFetch));

        JPanel ctrlPanel = Utils.newCtlrsPanel();
        
        JButton backButton = new JButton("Back");
        backButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickBack();
            }
        });
        ctrlPanel.add(backButton);
        
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickNext();
            }
        });
        Utils.setEnterButton(this, nextButton);
        ctrlPanel.add(nextButton);

//        JPanel enPanel = Utils.newFlowPanel();
//        enPanel.add(cbAnonymize);
//        cbAnonymize.setEnabled(true);
//        cbAnonymize.setEnabled(true);
        
        JPanel oPanel = Utils.newFieldSetPanel("Output Location");
        oField.setEnabled(true);
        oPanel.add(oField);
        oBrowse.setEnabled(true);
        oBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickOBrowse();
            }
        });
        oPanel.add(oBrowse);

        JPanel bgPanel = Utils.newBgPanel();
        bgPanel.add(wPanel);
        bgPanel.add(ePanel);
        bgPanel.add(mPanel);
        bgPanel.add(sPanel);
        bgPanel.add(oPanel);
//        bgPanel.add(enPanel);
        bgPanel.add(ctrlPanel);
        getContentPane().add(bgPanel);
        setLocationRelativeTo(null);

    }

	private void onClickBack() {
		this.dispose();
		prevFrame.setVisible(true);
	}

    private void onClickWBrowse() {

        JFileChooser wChooser = new JFileChooser();
        wChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
        wChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = wChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = wChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String wLocation = selectedLocation.getAbsolutePath();
            wField.setText(wLocation);
        }
    }

    private void onClickEBrowse() {

        JFileChooser eChooser = new JFileChooser();
        eChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
        eChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = eChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = eChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String eLocation = selectedLocation.getAbsolutePath();
            eField.setText(eLocation);

            //Map<String, Alqp> alqps = ClientInputFrameHandler.loadExecutionPlans(eLocation);
            //Constants.CPrintToConsole("Loaded alqps: \n" + alqps, Constants.DEBUG_FIRST_LEVEL_Information);
        }
    }

    private void onClickMBrowse() {
        JFileChooser mChooser = new JFileChooser();
        mChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
        mChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = mChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = mChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String mLocation = selectedLocation.getAbsolutePath();
            mField.setText(mLocation);
        }
    }
    
    private void onClickOBrowse() {
		JFileChooser oChooser = new JFileChooser();
        oChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
        oChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = oChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = oChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String oLocation = selectedLocation.getAbsolutePath();
            oField.setText(oLocation);
        }
	}

    private void onClickNext() {

        //Validating fields
        String wLocation = wField.getText().trim();
        String mLocation = mField.getText().trim();
        String eLocation = eField.getText().trim();
        String oLocation = oField.getText().trim();

        StringBuilder errorMessage = new StringBuilder();
        List<String> workloadQueryFilenames = new ArrayList<>();
        List<String> executionPlanFilenames = new ArrayList<>();

        if (wLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(wLocation)) {
            errorMessage.append("Please provide folder location of workload queries. ").append(NEWLINE);
        } else {
            File file = new File(wLocation);
            if (!file.isDirectory()) {
                errorMessage.append("Provided location of workload queries is not a valid folder").append(NEWLINE);
            } else {
                File[] queryFiles = file.listFiles(new FilenameFilter() {
                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".sql");
                    }
                });
                if (queryFiles.length == 0) {
                    errorMessage.append("Provide location of workload queries contains no .sql files").append(NEWLINE);
                } else {
                    for (File innerFile : queryFiles) {
                        workloadQueryFilenames.add(innerFile.getName().split("\\.")[0]);
                    }
                    Collections.sort(workloadQueryFilenames);
                }
            }
        }

        if (!mFetch.isSelected()) {
            if (mLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(mLocation)) {
                errorMessage.append("Please choose to fetch metadata from engine or provide folder location of CODD exported metadata. ").append(NEWLINE);
            } else {
                try {
                    FileInputStream fis = new FileInputStream(new File(mLocation, "dbType"));	// dbType is name of file in mLocation folder
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    String readType = (String) ois.readObject();
                    ois.close();
                    fis.close();

                    if (!"POSTGRES".equals(readType)) {
                        errorMessage.append("Provided location of CODD exported metadata is not a valid Postgres metadata folder").append(NEWLINE);
                    }

                } catch (Exception ex) {
                    errorMessage.append("Provided location of CODD exported metadata is not a valid metadata folder").append(NEWLINE);
                }
            }
        }

        if (!eFetch.isSelected()) {
            if (eLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(eLocation)) {
                errorMessage.append("Please choose to fetch execution plans from engine or provide folder location of execution plans of workload queries. ")
                        .append(NEWLINE);
            } else {
                File file = new File(eLocation);
                if (!file.isDirectory()) {
                    errorMessage.append("Provided location of execution plans of workload queries is not a valid folder").append(NEWLINE);
                } else {
                    File[] jsonFiles = file.listFiles(new FilenameFilter() {
                        @Override
                        public boolean accept(File dir, String name) {
                            return name.toLowerCase().endsWith(".json");
                        }
                    });

                    if (jsonFiles.length == 0) {
                        errorMessage.append("Provide location of execution plans of workload queries contains no .json files").append(NEWLINE);
                    } else {
                        for (File innerFile : jsonFiles) {
                            executionPlanFilenames.add(innerFile.getName().split("\\.")[0]);
                        }
                        Collections.sort(executionPlanFilenames);

                        if (!executionPlanFilenames.containsAll(workloadQueryFilenames)) {
                            errorMessage
                                    .append("Provide location of execution plans should contain .json files corresponding to each .sql file in workload location")
                                    .append(NEWLINE);
                        }

                    }
                }
            }
        }
        
        if(oLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(oLocation)) {
        	errorMessage.append("Please provide folder location for output files").append(NEWLINE);
        } else {
        	File file = new File(oLocation);
        	if(!file.isDirectory()) {
        		errorMessage.append("Provided location of is not a valid folder").append(NEWLINE);
        	} else if(file.listFiles().length > 0) {
        		errorMessage.append("Please provide location of an empty folder for output").append(NEWLINE);
        	}
        }

        String errorStr = errorMessage.toString();

        if (errorStr.isEmpty()) {

            List<File> workloadQueryFiles = new ArrayList<>();
            for (String workloadQueryFilename : workloadQueryFilenames) {
                workloadQueryFiles.add(new File(wLocation, workloadQueryFilename + ".sql"));
            }

            File metadataLocation = null;
            if (!mFetch.isSelected()) {
                metadataLocation = new File(mLocation);
            }

            List<File> executionPlanFiles = null;
            if (!eFetch.isSelected()) {
                executionPlanFiles = new ArrayList<>();
                for (String workloadQueryFilename : workloadQueryFilenames) {
                    executionPlanFiles.add(new File(eLocation, workloadQueryFilename + ".json"));
                }
            }

            ClientInputFrameOut out = new ClientInputFrameOut(database, workloadQueryFiles, metadataLocation, executionPlanFiles, oLocation);	//, cbAnonymize.isSelected());
            setVisible(false);
            new CollectingInputFrame(this, out).setVisible(true);
        } else {
            Utils.showErrorDialog(this, errorStr, "Input error");
        }

    }

}
