package iisc.dsl.coddgen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import iisc.dsl.coddgen.ui.model.AnonymInputFrameOut;
import iisc.dsl.coddgen.ui.model.CollectingInputFrameOut;
import iisc.dsl.coddgen.ui.model.SolverFrameOut;
import iisc.dsl.coddgen.ui.utils.AlqpGraphXComponent;
import iisc.dsl.coddgen.ui.utils.Utils;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewSolution;
import in.ac.iisc.cds.dsl.cdgvendor.model.formal.FormalCondition;
import in.ac.iisc.cds.dsl.cdgvendor.utils.FileUtils;

@SuppressWarnings("serial")
public class CompareOutputFrame extends JFrame {

	private static final String NEWLINE = "\n";

	private final JFrame prevFrame;
	private final CollectingInputFrameOut inputFrameOut;
	private final AnonymInputFrameOut anonymFrameOut;
	private final Map<String, ViewSolution> uncompressedSummaryByView;
	private final long scaleFactor;
	private final String oLocation;

	public CompareOutputFrame(JFrame prevFrame, SolverFrameOut prevFrameOut, String oLocation) {

		this.prevFrame = prevFrame;
		this.oLocation = oLocation;
		inputFrameOut = prevFrameOut.inputFrameOut;
		anonymFrameOut = prevFrameOut.anonymFrameOut;
		scaleFactor = prevFrameOut.scaleFactor;
		uncompressedSummaryByView = prevFrameOut.uncompressedSummaryByView;

		Utils.setFrameBig(this, "Visualize Data Generator's Output");
		initComponents();
	}

	private void initComponents() {
		JPanel augmentedAlqpPanel = Utils.newBorderPanel();
		JPanel queryPanel = Utils.newBorderPanel(); // lient query panel now

		String queryNames[] = inputFrameOut.queryNames.toArray(new String[inputFrameOut.queryNames.size()]);

		JList<String> queryJList = new JList<>(queryNames);
		queryJList.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
		queryJList.setLayoutOrientation(JList.HORIZONTAL_WRAP);
		queryJList.setVisibleRowCount(4);
		queryJList.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent e) {
				if (!e.getValueIsAdjusting()) {
					String selectedQueryName = queryJList.getSelectedValue();
					int indx = inputFrameOut.queryNames.indexOf(selectedQueryName);

					augmentedAlqpPanel.removeAll();
					augmentedAlqpPanel.add(Utils.newHeading("Execution Plan"), BorderLayout.NORTH);
					augmentedAlqpPanel.add(AlqpGraphXComponent.parse(inputFrameOut.BASICSCHEMA_INFO,
							inputFrameOut.executionPlans.get(indx), anonymFrameOut.anonymizer,
							uncompressedSummaryByView, scaleFactor), BorderLayout.CENTER);
					augmentedAlqpPanel.validate();
					augmentedAlqpPanel.repaint();

					queryPanel.removeAll();
					// anonymQueryPanel.add(Utils.newHeading("Anonymized Query"),
					// BorderLayout.NORTH);
					queryPanel.add(Utils.newHeading("Client Query"), BorderLayout.NORTH);
					// anonymQueryPanel.add(Utils.newTextArea(anonymFrameOut.alqpToCCPostgresRes.anonymQueries.get(indx)),
					// BorderLayout.CENTER);
					queryPanel.add(Utils.newTextArea(anonymFrameOut.inputFrameOut.origQueries.get(indx)),
							BorderLayout.CENTER);
					queryPanel.validate();
					queryPanel.repaint();
				}
			}
		});

		JPanel origPanel = Utils.newGridPanel(1, 2);

		augmentedAlqpPanel.add(Utils.newHeading("Execution Plan"), BorderLayout.NORTH);
		augmentedAlqpPanel.add(AlqpGraphXComponent.parse(inputFrameOut.BASICSCHEMA_INFO,
				inputFrameOut.executionPlans.get(0), anonymFrameOut.anonymizer, uncompressedSummaryByView, scaleFactor),
				BorderLayout.CENTER);
		origPanel.add(augmentedAlqpPanel);

		// anonymQueryPanel.add(Utils.newHeading("Anonymized Query"),
		// BorderLayout.NORTH);
		// anonymQueryPanel.add(Utils.newHeading("Client Query"), BorderLayout.NORTH);
		// anonymQueryPanel.add(Utils.newTextArea(anonymFrameOut.alqpToCCPostgresRes.anonymQueries.get(0)),
		// BorderLayout.CENTER);
		// anonymQueryPanel.add(Utils.newTextArea(anonymFrameOut.inputFrameOut.origQueries.get(0)),
		// BorderLayout.CENTER);
		queryJList.setSelectedIndex(0);
		// origPanel.add(queryPanel);

		JPanel eastPanel = Utils.newGridPanel(2, 1);
		eastPanel.add(queryPanel);

//		JPanel summaryViewPanel = Utils.newGridPanel(2, 1);
		JPanel summaryViewPanel = Utils.newBoxPanel();
		JPanel summaryPanel = Utils.newBorderPanel();
		JPanel summarySelectionPanel = Utils.newBorderPanel();

		Object[] tableNamesTemp = inputFrameOut.BASICSCHEMA_INFO.getTableInfos().keySet().toArray();
		String[] tableNames = Arrays.copyOf(tableNamesTemp, tableNamesTemp.length, String[].class);
		Arrays.sort(tableNames);
		for (int i = 0; i < tableNames.length; ++i)
			tableNames[i] = tableNames[i].toUpperCase();

		JList<String> tableJList = new JList<>(tableNames);
		tableJList.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
		tableJList.setLayoutOrientation(JList.HORIZONTAL_WRAP);
		tableJList.setVisibleRowCount(4);
		tableJList.addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(ListSelectionEvent e) {
				if (!e.getValueIsAdjusting()) {
					String selectedTable = tableJList.getSelectedValue();
					summaryPanel.removeAll();
					summaryPanel.add(Utils.newHeading("Summary"), BorderLayout.NORTH);
					summaryPanel.add(Utils.newTextArea(FileUtils.readFileToString(oLocation, selectedTable)),
							BorderLayout.CENTER);
					summaryPanel.validate();
					summaryPanel.repaint();
				}
			}
		});
		tableJList.setSelectedIndex(0);

		// JComboBox<String> comboBoxTableList = new JComboBox<String>(tableNames);
		// comboBoxTableList.addActionListener(new ActionListener() {
		// @Override
		// public void actionPerformed(ActionEvent event) {
		// JComboBox<String> combo = (JComboBox<String>) event.getSource();
		// String selectedTable = (String) combo.getSelectedItem();
		//
		// summaryPanel.removeAll();
		// summaryPanel.add(Utils.newHeading("Summary of " + selectedTable),
		// BorderLayout.NORTH);
		// summaryPanel.add(Utils.newTextArea(FileUtils.readFileToString(oLocation,
		// selectedTable)), BorderLayout.CENTER);
		// summaryPanel.validate();
		// summaryPanel.repaint();
		// }
		// });
		// comboBoxTableList.setSelectedIndex(0);

		summarySelectionPanel.add(Utils.newHeading("Select table to view its summary"), BorderLayout.NORTH);
		summarySelectionPanel.add(new JScrollPane(tableJList, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);
		summaryViewPanel.add(summarySelectionPanel, BorderLayout.NORTH);
		summaryViewPanel.add(summaryPanel, BorderLayout.CENTER);

//		eastPanel.add(new Label(" "));
		eastPanel.add(summaryViewPanel);
		origPanel.add(eastPanel);

		 String[] columns = new String[] { "Relation", "Generate Static Data", "Velocity (0 GB - 1GB / sec)" };
		Object[][] tableData = new Object[0][3];
		final Class<Object>[] columnClass = new Class[] { Object.class, Boolean.class, JSlider.class };

		DefaultTableModel tableModel = new DefaultTableModel(tableData, columns) {
			@Override
			public boolean isCellEditable(int row, int column) {
				return (column == 1 || column == 2);
			}

			@Override
			public Class<?> getColumnClass(int columnIndex) {
				return columnClass[columnIndex];
			}
		};
		JTable table = new JTable(tableModel);
		table.setRowHeight(20);
		table.getColumn(table.getColumnName(2)).setCellRenderer(new SliderRenderer(JSlider.HORIZONTAL, 0, 20, 10));
		table.getColumn(table.getColumnName(2)).setCellEditor(new SliderEditor(JSlider.HORIZONTAL, 0, 20, 10));

		for (String tabelName : tableNames) {
			Object row[] = new Object[3];
			row[0] = tabelName;
			row[1] = Boolean.FALSE;
			row[2] = 10;
			tableModel.addRow(row);
		}
		JPanel southPanel = Utils.newBorderPanel();
		southPanel.add(Utils.newHeading("Runtime Configuration Settings"), BorderLayout.NORTH);
		southPanel.add(new JScrollPane(table), BorderLayout.CENTER);

		JPanel ctrlPanel = Utils.newCtlrsPanel();
		JButton backButton = new JButton("Back");
		backButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				onClickBack();
			}
		});
		ctrlPanel.add(backButton);
		JButton nextButton = new JButton("Finish");
		nextButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				onClickNext();
			}
		});
		Utils.setEnterButton(this, nextButton);
		ctrlPanel.add(nextButton);

		JPanel bgPanel = Utils.newBgPanel();
		JPanel headingPanel = Utils.newFlowPanel();
		headingPanel.add(Utils.newHeading("Choose a query to visualize the solution"));
		bgPanel.add(headingPanel);
		bgPanel.add(new JScrollPane(queryJList, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
		// bgPanel.add(new JLabel(" "));
		bgPanel.add(origPanel);
		 bgPanel.add(new JLabel(" "));
		// bgPanel.add(summaryViewPanel);
		bgPanel.add(southPanel);
		bgPanel.add(ctrlPanel);

		getContentPane().add(bgPanel);
	}

	private void onClickBack() {
		setVisible(false);
		dispose();
		prevFrame.setVisible(true);
	}

	private void onClickNext() {
		setVisible(false);
		dispose();
	}

	private static String getAsDisplayStr(List<FormalCondition> formalConditions) {
		StringBuilder sb = new StringBuilder();
		for (FormalCondition formalCondition : formalConditions) {
			sb.append(formalCondition.toString()).append(NEWLINE);
		}
		return sb.toString();
	}

	// http://esus.com/making-a-jslider-cell-editor-for-my-jtable/

	class SliderRenderer extends JSlider implements TableCellRenderer {
		public SliderRenderer(int orientation, int min, int max, int value) {
			super(orientation, min, max, value);
		}

		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus,
				int row, int column) {
			if (isSelected) {
				setForeground(table.getSelectionForeground());
				setBackground(table.getSelectionBackground());
			} else {
				setForeground(table.getForeground());
				setBackground(table.getBackground());
			}

			TableColumnModel columnModel = table.getColumnModel();
			TableColumn selectedColumn = columnModel.getColumn(column);
			int columnWidth = selectedColumn.getWidth();
			int columnHeight = table.getRowHeight();
			setSize(new Dimension(columnWidth, columnHeight));

			setValue(((Integer) value).intValue());
			updateUI();
			return this;
		}
	}

	class SliderEditor extends DefaultCellEditor {
		protected JSlider slider;

		public SliderEditor(int orientation, int min, int max, int value) {
			super(new JCheckBox());
			slider = new JSlider(orientation, min, max, value);
			slider.setOpaque(true);
		}

		public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
			if (isSelected) {
				slider.setForeground(table.getSelectionForeground());
				slider.setBackground(table.getSelectionBackground());
			} else {
				slider.setForeground(table.getForeground());
				slider.setBackground(table.getBackground());
			}
			slider.setValue(((Integer) value).intValue());

			return slider;
		}

		public Object getCellEditorValue() {
			return new Integer(slider.getValue());
		}

		public boolean stopCellEditing() {
			return super.stopCellEditing();
		}

		protected void fireEditingStopped() {
			super.fireEditingStopped();
		}
	}
}

// Screenshot values
/*
 * 
 * -- start query 70 using TPC-DS template query12.tpl select * from web_sales
 * ,item ,date_dim where ws_item_sk = i_item_sk and i_category in ('Children',
 * 'Sports', 'Music') and ws_sold_date_sk = d_date_sk and d_date between
 * '2002-04-01' and '2002-05-01' ; -- end query 70 using TPC-DS template
 * query12.tpl
 * 
 * 
 * 
 * | σ ( ((d_date >= '2002-04-01') AND (d_date <= '2002-05-01')) ∧ (i_category =
 * ANY ('{Children,Sports,Music}')) ) (web_sales ⋈ date_dim ⋈ item) | = 21371 |
 * σ ( ((d_date >= '2002-04-01') AND (d_date <= '2002-05-01')) ) (web_sales ⋈
 * date_dim) | = 71480 | σ ( ) (web_sales) | = 7197566 | σ ( ((d_date >=
 * '2002-04-01') AND (d_date <= '2002-05-01')) ) (date_dim) | = 31 | σ (
 * (i_category = ANY ('{Children,Sports,Music}')) ) (item) | = 30586
 * 
 * 
 * 
 * select * from t23 ,t12 ,t07 where 1=1 and t23_F_t12 = t12_P and ((t12_c002 =
 * 2) or (t12_c002 = 9) or (t12_c002 = 7)) and t23_F_t07 = t07_P and ((t07_c005
 * >= 20) AND (t07_c005 <= 21)) ;
 * 
 * 
 * | σ ( (((t07_c005 >= 20) ∧ (t07_c005 <= 21)) ∧ ((t12_c002 = 2) ∨ (t12_c002 =
 * 9) ∨ (t12_c002 = 7))) (t23 ⋈ t07 ⋈ t12) | = 21371 | σ ( ((t07_c005 >= 20) ∧
 * (t07_c005 <= 21)) ) (t23 ⋈ t07) | = 71480 | σ ( ) (t23) | = 7197566 | σ (
 * ((t07_c005 >= 20) ∧ (t07_c005 <= 21)) ) (t07) | = 31 | σ ( (t12_c002 = 2) ∨
 * (t12_c002 = 9) ∨ (t12_c002 = 7) ) (t12) | = 30586
 * 
 */