package iisc.dsl.coddgen.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

import iisc.dsl.coddgen.ui.model.AnonymInputFrameOut;
import iisc.dsl.coddgen.ui.utils.Constants;
import iisc.dsl.coddgen.ui.utils.PlaceholderTextField;
import iisc.dsl.coddgen.ui.utils.Utils;
import in.ac.iisc.cds.dsl.cdgvendor.constants.PostgresVConfig;
import in.ac.iisc.cds.dsl.cdgvendor.constants.PostgresVConfig.Key;

@SuppressWarnings("serial")
public class VendorInputFrame extends JFrame {

    private static final String        NEWLINE             = "\n";

    //private final List<String>         relnames;
    
    private final JTextField           iField;
    private final JButton              iBrowse;

    private final JTextField           oField;
    private final JButton              oBrowse;
    
    JSpinner 							spinner;
    
    private final JFrame	           prevFrame;

    private static final String        DEFAULT_PLACEFOLDER = "provide folder location...";
    
    private final AnonymInputFrameOut 	prevFrameOut;
    
    public VendorInputFrame(JFrame prevFrame) {
    	this(prevFrame, null);
    }

    public VendorInputFrame(JFrame prevFrame, AnonymInputFrameOut prevFrameOut) {
    	this.prevFrame = prevFrame;
    	this.prevFrameOut = prevFrameOut;
//      firstThings();

      //        relnames = new ArrayList<>();
      //        relnames.add("store_sales");
      //        relnames.add("store");
      iField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
      iBrowse = new JButton("Browse");

      oField = new PlaceholderTextField(DEFAULT_PLACEFOLDER, 20);
      oBrowse = new JButton("Browse");

      Utils.setFrame(this, "Input details");
      initComponents();
	}

	private void initComponents() {
    	
        JPanel iPanel = Utils.newFieldSetPanel("Folder containing input files");
        iField.setEnabled(true);
        iPanel.add(iField);
        iBrowse.setEnabled(true);
        iBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickIBrowse();
            }
        });
        iPanel.add(iBrowse);
        
        JPanel oPanel = Utils.newFieldSetPanel("Empty folder for saving Database Summary");
        oField.setEnabled(true);
        oPanel.add(oField);
        oBrowse.setEnabled(true);
        oBrowse.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickOBrowse();
            }
        });
        oPanel.add(oBrowse);
        
        JPanel sPanel = Utils.newFieldSetPanel("Scale Factor");
        SpinnerModel model = new SpinnerNumberModel(Long.valueOf(1), Long.valueOf(1), Long.valueOf(Long.MAX_VALUE), Long.valueOf(1));
        spinner = new JSpinner(model);
        sPanel.add(spinner);

        JPanel ctrlPanel = Utils.newCtlrsPanel();
        JButton nextButton = new JButton("Next");
        JButton backButton = new JButton("Back");

        backButton.setEnabled(true);
        backButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickBack();
            }
        });
        ctrlPanel.add(backButton);
        nextButton.setEnabled(true);
        nextButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                onClickNext();
            }
        });
        Utils.setEnterButton(this, nextButton);
        ctrlPanel.add(nextButton);

        JPanel bgPanel = Utils.newBgPanel();
        bgPanel.add(iPanel);
        bgPanel.add(oPanel);
        bgPanel.add(sPanel);
        bgPanel.add(ctrlPanel);
        getContentPane().add(bgPanel);
        setLocationRelativeTo(null);

    }

	private void onClickIBrowse() {
		JFileChooser iChooser = new JFileChooser();
		iChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
		iChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = iChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = iChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String iLocation = selectedLocation.getAbsolutePath();
            iField.setText(iLocation);
        }
	}
    
    private void onClickOBrowse() {
		JFileChooser oChooser = new JFileChooser();
        oChooser.setCurrentDirectory(Utils.getLastFileChooserLocation());
        oChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int result = oChooser.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
            File selectedLocation = oChooser.getSelectedFile();
            Utils.updateLastFileChooserLocation(selectedLocation);

            String oLocation = selectedLocation.getAbsolutePath();
            oField.setText(oLocation);
        }
	}

	private void onClickBack() {
		this.dispose();
		prevFrame.setVisible(true);
	}

    private void onClickNext() {

        //Validating fields
        String iLocation = iField.getText().trim();
        String oLocation = oField.getText().trim();

        StringBuilder errorMessage = new StringBuilder();

        if (iLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(iLocation)) {
            errorMessage.append("Please provide folder location of input files").append(NEWLINE);
        } else {
            if(new File(iLocation, "anonymizedcc.info").exists() && new File(iLocation, "anonymizedschema.info").exists() && new File(iLocation, "basicschema.info").exists()
            		&& new File(iLocation, Constants.COLUMN_MAP_FILENAME).exists() && new File(iLocation, Constants.DATE_MAP_FILENAME).exists() && new File(iLocation, Constants.NUMBER_MAP_FILENAME).exists() && new File(iLocation, Constants.STATISTICS_FILENAME).exists()
            		&& new File(iLocation, Constants.STRING_MAP_FILENAME).exists() && new File(iLocation, Constants.TABLE_MAP_FILENAME).exists()) {

                PostgresVConfig.initDefaultConfig();
                Map<Key, String> overlapConfig = new HashMap<>();
                
                overlapConfig.put(Key.ANONYMIZEDCCS_INFO, iLocation + Constants.PathSeparator + "anonymizedcc.info");
                overlapConfig.put(Key.ANONYMIZEDSCHEMA_FILENAME, iLocation + Constants.PathSeparator + "anonymizedschema.info");
                overlapConfig.put(Key.DATABASESUMMARY_LOCATION, oLocation);
                PostgresVConfig.overlayOnDefaultConfig(overlapConfig);
            } else  {
            	errorMessage.append("One or more input files are missing from the input folder").append(NEWLINE).append("Selected folder is invalid").append(NEWLINE);
            }
        }
        
        if(oLocation.isEmpty() || DEFAULT_PLACEFOLDER.equals(oLocation)) {
        	errorMessage.append("Please provide folder location for Database Summary").append(NEWLINE);
        } else {
        	File file = new File(oLocation);
        	if(!file.isDirectory()) {
        		errorMessage.append("Provided location of is not a valid folder").append(NEWLINE);
        	} else if(file.listFiles().length > 0) {
        		errorMessage.append("Please provide location of an empty folder for storing Database Summary").append(NEWLINE);
        	}
        }

        String errorStr = errorMessage.toString();

        if (errorStr.isEmpty()) {
            setVisible(false);
            new SolverFrame(this, prevFrameOut, iLocation, oLocation, (long)spinner.getValue()).setVisible(true);
        } else {
            Utils.showErrorDialog(this, errorStr, "Input error");
        }

    }

}
