package iisc.dsl.coddgen.ui.model;

import java.util.List;
import java.util.Map;

import iisc.dsl.codd.ds.Statistics;
import in.ac.iisc.cds.dsl.cdgvendor.model.Alqp;
import in.ac.iisc.cds.dsl.cdgvendor.model.HistogramMappingInfo;
import in.ac.iisc.cds.dsl.cdgvendor.model.SchemaInfo;

/**
 * Represents the info collected in CollectingInputFrame
 * @author rWX450917
 *
 */
public class CollectingInputFrameOut {

    public final SchemaInfo              BASICSCHEMA_INFO;
    public final List<String>            queryNames;
    public final List<Alqp>              executionPlans;
    public final List<String>            origQueries;
    public final HistogramMappingInfo    mappingInfo;
    public final Map<String, Statistics> relnameStatsMap;
    public final String					outputLocation;

    public CollectingInputFrameOut(SchemaInfo BASICSCHEMA_INFO, List<String> queryNames, List<Alqp> executionPlans, List<String> queries,
            HistogramMappingInfo mappingInfo, Map<String, Statistics> relnameStatsMap, String outputLocation) {
        this.BASICSCHEMA_INFO = BASICSCHEMA_INFO;
        this.queryNames = queryNames;
        this.executionPlans = executionPlans;
        origQueries = queries;
        this.mappingInfo = mappingInfo;
        this.relnameStatsMap = relnameStatsMap;
        this.outputLocation = outputLocation;
    }

}
