package iisc.dsl.coddgen.ui.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

import iisc.dsl.codd.client.gui.BaseJPanel;

public class Utils {

    private static final String NEWLINE = "\n";

    public static final Insets  INSETS;
    static {
        INSETS = new Insets(10, 10, 10, 10);
    }

    public static void setFrame(JFrame frame, String title) {
        setFrame(frame, title, 600, 430);
    }

    public static void setFrameHuge(JFrame frame, String title) {
        setFrame(frame, title, 1800, 1200);
    }

    public static void setFrameBig(JFrame frame, String title) {
        setFrame(frame, title, 1200, 800);
    }

    public static void setFrameMedium(JFrame frame, String title) {
        setFrame(frame, title, 800, 500);
    }

    private static void setFrame(JFrame frame, String title, int width, int height) {
        frame.setTitle(title);
        frame.setResizable(false);
        frame.setSize(width, height);
        Utils.centreWindow(frame);
        frame.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
    }

    private static void centreWindow(Window frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int) ((dimension.getWidth() - frame.getWidth()) / 2);
        int y = (int) ((dimension.getHeight() - frame.getHeight()) / 2);
        frame.setLocation(x, y);
    }

    /**
     * Makes given JButton target of hitting enter key
     * @param button
     */
    public static void setEnterButton(JFrame frame, JButton button) {
        JRootPane rootPane = SwingUtilities.getRootPane(frame);
        rootPane.setDefaultButton(button);
    }

    private static final String FILECHOOSER_LAST_LOCATION_KEY = "FILECHOOSER_LAST_LOCATION_KEY";
    static {
        Preferences.userRoot().put(FILECHOOSER_LAST_LOCATION_KEY, System.getProperty("user.home"));
    }

    public static void updateLastFileChooserLocation(File location) {
        Preferences.userRoot().put(FILECHOOSER_LAST_LOCATION_KEY, location.getAbsolutePath());
    }

    public static File getLastFileChooserLocation() {
        return new File(Preferences.userRoot().get(FILECHOOSER_LAST_LOCATION_KEY, System.getProperty("user.home")));
    }

    public static JPanel newFieldSetPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(null, title, javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION, new Font("Cambria", 0, 14), new java.awt.Color(0, 51, 153)));
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(FlowLayout.LEADING));
        return panel;
    }

    public static JPanel newFieldSetBoxLayoutPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(null, title, javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
                javax.swing.border.TitledBorder.DEFAULT_POSITION, new Font("Cambria", 0, 14), new java.awt.Color(0, 51, 153)));
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        return panel;
    }

    /**
     * Adapted from http://stackoverflow.com/a/9213219/2202712
     * @param component
     * @return
     */
    public static Component leftJustify(JComponent component) {
        Box b = Box.createHorizontalBox();
        b.add(component);
        b.add(Box.createHorizontalGlue());
        // (Note that you could throw a lot more components and struts and glue in here.)
        return b;
    }

    public static JPanel newBorderPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        return panel;
    }

    public static JPanel newFlowPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(FlowLayout.LEADING));
        return panel;
    }

    public static JPanel newBoxPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        return panel;
    }

    public static JPanel newGridPanel(int rows, int cols) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridLayout(rows, cols));
        return panel;
    }

    public static JComponent newTextArea(String text) {
        JTextArea area = new JTextArea(text);
        area.setEditable(false);
        area.setBorder(BorderFactory.createLineBorder(Color.black));
        return new JScrollPane(area);
    }

    public static JPanel newBgPanel() {
        JPanel bgPanel = new BaseJPanel("img/bg_net.png");
        bgPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        bgPanel.setLayout(new BoxLayout(bgPanel, BoxLayout.Y_AXIS));
        return bgPanel;
    }

    public static JPanel newCtlrsPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(FlowLayout.TRAILING));
        return panel;
    }

    /**
     * @param parent
     * @param message
     * @param title
     * @cite http://stackoverflow.com/a/14127091/2202712
     * @return
     */
    public static void showProcessingDialog(JDialog dialog, Component parent, String message, String title) {
        message = message.replaceAll("(.{100})", "$1-" + NEWLINE);

        final JOptionPane optionPane = new JOptionPane(message, JOptionPane.INFORMATION_MESSAGE, JOptionPane.DEFAULT_OPTION, null, new Object[] {}, null);
        dialog.setTitle(title);
        dialog.setModal(true);
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public static void showInfoDialog(Component parent, String message, String title) {
        message = message.replaceAll("(.{100})", "$1-" + NEWLINE);
        JOptionPane.showMessageDialog(parent, message, title, JOptionPane.INFORMATION_MESSAGE);
    }

    public static void showErrorDialog(Component parent, String message, String title) {
        message = message.replaceAll("(.{100})", "$1-" + NEWLINE);
        JOptionPane.showMessageDialog(parent, message, title, JOptionPane.ERROR_MESSAGE);
    }

    public static JLabel newHeading(String str) {
        JLabel label = new JLabel(str);
        label.setForeground(Color.MAGENTA);
        label.setFont(new Font("Cambria", 0, 18));
        return label;
    }

    public static JPanel newSuccessBanner(String str) {
        JPanel panel = newBorderPanel();
        panel.setBackground(Color.green);
        JTextPane text = new JTextPane();
        text.setText(str);
        text.setForeground(Color.MAGENTA);
        text.setOpaque(false);
        text.setFont(new Font("Cambria", 0, 14));
        text.setEditable(false);
        panel.add(text);
        return panel;
    }

    /** Returns an ImageIcon, or null if the path was invalid. */
    public static ImageIcon createImageIcon(String path, String description) {
        //TODO: Use resource instead
        //java.net.URL imgURL = Utils.class.getResource(path);
        //if (imgURL != null)
        return new ImageIcon(path, description);
        //else {
        //    //TODO: Use console output
        //    System.err.println("Couldn't find file: " + path);
        //    return null;
        //}
    }
    
    public static void writeObjectToFile(Object obj, String file) {
    	try(FileOutputStream fs = new FileOutputStream(file)) {
			try(ObjectOutputStream os = new ObjectOutputStream(fs)) {
				os.writeObject(obj);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
    
    public static Object readObjectFromFile(String file) {
    	Object obj = null;
    	try(FileInputStream fs = new FileInputStream(file)) {
			try(ObjectInputStream os = new ObjectInputStream(fs)) {
				obj = os.readObject();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
    	return obj;
    }
}
