package in.ac.iisc.cds.dsl.cdgvendor.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;

import in.ac.iisc.cds.dsl.cdgvendor.model.SolverViewStats;
import in.ac.iisc.cds.dsl.cdgvendor.model.ValueCombination;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewInfo;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewSolution;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewSolutionInMemory;
import in.ac.iisc.cds.dsl.cdgvendor.model.ViewSolutionWithSolverStats;
import in.ac.iisc.cds.dsl.cdgvendor.model.formal.FormalCondition;
import in.ac.iisc.cds.dsl.cdgvendor.reducer.Bucket;
import in.ac.iisc.cds.dsl.cdgvendor.reducer.BucketStructure;
import in.ac.iisc.cds.dsl.cdgvendor.reducer.Partition;
import in.ac.iisc.cds.dsl.cdgvendor.reducer.Reducer;
import in.ac.iisc.cds.dsl.cdgvendor.reducer.Region;
import in.ac.iisc.cds.dsl.cdgvendor.utils.CliqueComparator;
import in.ac.iisc.cds.dsl.cdgvendor.utils.DebugHelper;
import in.ac.iisc.cds.dsl.cdgvendor.utils.StopWatch;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;

public class DoubleReductionBasedViewSolver extends AbstractCliqueFinder {

    private final SolverViewStats solverStats;

    public DoubleReductionBasedViewSolver(String viewname, ViewInfo viewInfo, List<boolean[]> allTrueBS, List<Set<String>> arasuCliques,
            Map<String, IntList> bucketFloorsByColumns) {
        super(viewname, viewInfo, allTrueBS, arasuCliques, bucketFloorsByColumns);
        solverStats = new SolverViewStats();
        solverStats.relRowCount = viewInfo.getRowcount();
    }

    @Override
    public ViewSolutionWithSolverStats solveView(List<FormalCondition> conditions, List<Region> conditionRegions, FormalCondition consistencyConstraints[]) {

        StopWatch formulationPlusSolvingSW = new StopWatch("LP-SolvingPlusPostSolving-" + viewname);
        beginLPFormulation();
        List<LinkedList<VariableValuePair>> cliqueIdxToVarValuesList = formulateAndSolve(conditions, conditionRegions, consistencyConstraints);
        finishSolving();
        ViewSolution viewSolution = mergeCliqueSolutions(cliqueIdxToVarValuesList);
        finishPostSolving();
        solverStats.millisToSolve = formulationPlusSolvingSW.getTimeAndDispose();
        return new ViewSolutionWithSolverStats(viewSolution, solverStats);
    }

    private List<LinkedList<VariableValuePair>> formulateAndSolve(List<FormalCondition> conditions, List<Region> conditionRegions, FormalCondition consistencyConstraints[]) {

    	StopWatch onlyReductionSW = new StopWatch("LP-OnlyReduction" + viewname);
    	
        //STEP 1: For each clique find set of applicable conditions and call variable reduction
        List<LongList> cliqueIdxtoConditionBValuesList = new ArrayList<>(cliqueCount);
        List<Partition> cliqueIdxtoPList = new ArrayList<>(cliqueCount);
        List<List<IntList>> cliqueIdxtoPSimplifiedList = new ArrayList<>(cliqueCount);
        
        List<HashMap<Integer, Integer>> mappedIndexOfConsistencyConstraint = new ArrayList<>();

        for (int i = 0; i < cliqueCount; i++) {

            LongList bvalues = new LongArrayList();
            Set<String> clique = arasuCliques.get(i);
            List<Region> cRegions = new ArrayList<>();
            for (int j = 0; j < conditions.size(); j++) {
                Set<String> appearingCols = new HashSet<>();
                getApppearingCols(appearingCols, conditions.get(j));

                if (clique.containsAll(appearingCols)) {
                    cRegions.add(conditionRegions.get(j));
                    bvalues.add(conditions.get(j).getOutputCardinality());
                }
            }

            //Adding extra cRegion for all 1's condition
            Region allOnesCRegion = new Region();
            BucketStructure subConditionBS = new BucketStructure();
            for (int j = 0; j < allTrueBS.size(); j++) {
                Bucket bucket = new Bucket();
                for (int k = 0; k < allTrueBS.get(j).length; k++) {
                    if (allTrueBS.get(j)[k]) {		// TODO : Is this check needed?
                        bucket.add(k);
                    }
                }
                subConditionBS.add(bucket);
            }
            allOnesCRegion.add(subConditionBS);
            cRegions.add(allOnesCRegion);
            bvalues.add(relationCardinality);
            cliqueIdxtoConditionBValuesList.add(bvalues);
            
///////////////// Start dk
            HashMap<Integer, Integer> indexKeeper = new HashMap<>();
            int tempIndex = 0;
            for (int j = 0; j < consistencyConstraints.length; j++) {
				FormalCondition condition = consistencyConstraints[j];
            	Set<String> appearingCols = new HashSet<>();
                getApppearingCols(appearingCols, condition);

                if (clique.containsAll(appearingCols)) {
                	indexKeeper.put(j, tempIndex++);
                    cRegions.add(conditionRegions.get(conditions.size() + j));
                }
			}
            mappedIndexOfConsistencyConstraint.add(indexKeeper);
///////////////// End dk
            
            Reducer reducer = new Reducer(allTrueBS, cRegions);
            //Map<IntList, Region> P = reducer.getMinPartition();

            //Using varIds instead of old variable regions
            List<Region> oldVarList = new ArrayList<>();	// List of regions corresponding to below labels
            List<IntList> conditionIdxsList = new ArrayList<>();	// List of labels
            reducer.getVarsAndConditionsSimplified(oldVarList, conditionIdxsList);

            Partition cliqueP = new Partition(new ArrayList<>(oldVarList));
            cliqueIdxtoPList.add(cliqueP);

            cliqueIdxtoPSimplifiedList.add(conditionIdxsList);
        }
        onlyReductionSW.displayTimeAndDispose();

        /* Not required now
        List<CliqueIntersectionInfo> cliqueIntersectionInfos = new ArrayList<>();	// Further divide regions for consistency
        for (int i = 0; i < cliqueCount; i++) {
            for (int j = i + 1; j < cliqueCount; j++) {
                IntList intersectingColIndices = getIntersectionColIndices(arasuCliques.get(i), arasuCliques.get(j));
                if (intersectingColIndices.isEmpty()) {
                    continue;
                }
                CliqueIntersectionInfo cliqueIntersectionInfo =
                        replaceWithFreshVariablesToEnsureConsistency(cliqueIdxtoPList, cliqueIdxtoPSimplifiedList, i, j, intersectingColIndices);
                cliqueIntersectionInfos.add(cliqueIntersectionInfo);
            }
        }
        /**/
        

        long varcountDR = 0;
        for (int i = 0; i < cliqueCount; i++) {
            varcountDR += cliqueIdxtoPList.get(i).getAll().size();
        }
        DebugHelper.printInfo("Number of variables after double reduction " + varcountDR);

        
        
/////////////// Start dk
        /* Compare partitions
        CliqueComparator cliqueComparator = new CliqueComparator(viewname);
        cliqueComparator.comparePartitions(cliqueIdxtoPList);
        /**/
///////////////// End dk
        
        StopWatch onlyFormationSW = new StopWatch("LP-OnlyFormation" + viewname);
        
        Map<String, String> contextmap = new HashMap<>();
        contextmap.put("model", "true");
        contextmap.put("unsat_core", "true");
        Context ctx = new Context(contextmap);

        Solver solver = ctx.mkSolver();

        List<List<List<IntExpr>>> allSolverConstraints = new ArrayList<>();
        for (int i = 0; i < cliqueCount; i++) {					// Create lp variables for cardinality constraints
            LongList bvalues = cliqueIdxtoConditionBValuesList.get(i);
            Partition partition = cliqueIdxtoPList.get(i);		// Partition is a list of regions corresponding to below labels
            List<IntList> conditionIdxsList = cliqueIdxtoPSimplifiedList.get(i);	// Getting label list for this clique

            HashMap<Integer, Integer> indexKeeper = mappedIndexOfConsistencyConstraint.get(i);
            List<List<IntExpr>> solverConstraints = new ArrayList<>(bvalues.size() + indexKeeper.size());
            for (int j = 0; j < bvalues.size() + indexKeeper.size(); j++) {
                solverConstraints.add(new ArrayList<>());
            }
            for (int j = 0; j < partition.size(); j++) {
                String varname = "var" + i + "_" + j;
                solverStats.solverVarCount++;

                //Adding non-negativity constraints
                solver.add(ctx.mkGe(ctx.mkIntConst(varname), ctx.mkInt(0)));

                for (IntIterator iter = conditionIdxsList.get(j).iterator(); iter.hasNext();) {
                    int k = iter.nextInt();
                    solverConstraints.get(k).add(ctx.mkIntConst(varname));
                }
            }
            //Adding normal constraints
            for (int j = 0; j < bvalues.size(); j++) {
                long outputCardinality = bvalues.getLong(j);
                List<IntExpr> addList = solverConstraints.get(j);
                solver.add(ctx.mkEq(ctx.mkAdd(addList.toArray(new ArithExpr[addList.size()])), ctx.mkInt(outputCardinality)));
                solverStats.solverConstraintCount++;
            }
            
///////////////// Start dk
            List<List<IntExpr>> solverConstraintsToExport = new ArrayList<>(indexKeeper.size());
            for(int j = bvalues.size(); j < solverConstraints.size(); j++) {
            	solverConstraintsToExport.add(solverConstraints.get(j));
            }
            solverConstraintsToExport.add(solverConstraints.get(bvalues.size() - 1));
            allSolverConstraints.add(solverConstraintsToExport);
///////////////// End dk
        }
        
///////////////// Start dk
        int countConsistencyConstraint = 0;
        
        if(consistencyConstraints.length != 0) {
	        for (int c1index = 0; c1index < cliqueCount; c1index++) {
				HashMap<Integer, Integer> c1indexKeeper = mappedIndexOfConsistencyConstraint.get(c1index);
				if(c1indexKeeper.isEmpty())
					continue;
				List<List<IntExpr>> c1solverConstraints = allSolverConstraints.get(c1index);
				for (int c2index = c1index + 1; c2index < cliqueCount; c2index++) {
					HashMap<Integer, Integer> c2indexKeeper = mappedIndexOfConsistencyConstraint.get(c2index);
					if(c2indexKeeper.isEmpty())
						continue;
					List<List<IntExpr>> c2solverConstraints = allSolverConstraints.get(c2index);
					HashSet<Integer> applicableConsistencyConstraints = new HashSet<>();
					Set<Integer> temp = new HashSet<>(c1indexKeeper.keySet());
					temp.retainAll(c2indexKeeper.keySet());
					if(temp.isEmpty())
						continue;
					for (Integer ccIndex : temp) {
						applicableConsistencyConstraints.add(ccIndex);
					}
//					System.err.println("First " + applicableConsistencyConstraints);
					List<List<IntExpr>> c1ApplicableSolverConstraints = new ArrayList<>();
					List<List<IntExpr>> c2ApplicableSolverConstraints = new ArrayList<>();
					for (Integer originalConsistencyConstraintIndex : applicableConsistencyConstraints) {
						c1ApplicableSolverConstraints.add(c1solverConstraints.get(c1indexKeeper.get(originalConsistencyConstraintIndex)));
						c2ApplicableSolverConstraints.add(c2solverConstraints.get(c2indexKeeper.get(originalConsistencyConstraintIndex)));
					}
					
					c1ApplicableSolverConstraints.add(c1solverConstraints.get(c1solverConstraints.size() - 1));
					c2ApplicableSolverConstraints.add(c2solverConstraints.get(c2solverConstraints.size() - 1));

					HashMap<IntList, List<List<IntExpr>>> conditionListToSetOfVarList = new HashMap<>();
					getVarToConditionList(c1ApplicableSolverConstraints, conditionListToSetOfVarList);
					getVarToConditionList(c2ApplicableSolverConstraints, conditionListToSetOfVarList);
					
					for (List<List<IntExpr>> list : conditionListToSetOfVarList.values()) {
						List<IntExpr> set1 = list.get(0);
						List<IntExpr> set2 = list.get(1);
						ArithExpr set1expr = ctx.mkAdd(set1.toArray(new ArithExpr[set1.size()]));
						ArithExpr set2expr = ctx.mkAdd(set2.toArray(new ArithExpr[set2.size()]));
						solver.add(ctx.mkEq(set1expr, set2expr));
		                countConsistencyConstraint++;
					}
		        }
	        }
        }
///////////////// End dk

        /* Not required now
        for (CliqueIntersectionInfo cliqueIntersectionInfo : cliqueIntersectionInfos) {		// Create lp variables for consistency constraints

            int i = cliqueIntersectionInfo.i;
            int j = cliqueIntersectionInfo.j;
            IntList intersectingColIndices = cliqueIntersectionInfo.intersectingColIndices;

            Partition partitionI = cliqueIdxtoPList.get(i);
            Partition partitionJ = cliqueIdxtoPList.get(j);

            //Recomputing SplitRegions for every pair of intersecting cliques
            //as the SplitRegions might have become more granular due to
            //some other pair of intersecting cliques having its intersectingColIndices
            //overlapping with this pair's intersectingColIndices
            List<Region> splitRegions = getSplitRegions(partitionI, partitionJ, intersectingColIndices);

            for (Region splitRegion : splitRegions) {
                List<IntExpr> consistencyLHS = new ArrayList<>();
                for (int k = 0; k < partitionI.size(); k++) {
                    Region iVar = partitionI.at(k);

                    Region truncRegion = getTruncatedRegion(iVar, intersectingColIndices);
                    Region truncOverlap = truncRegion.intersection(splitRegion);
                    if (!truncOverlap.isEmpty()) {
                        String varname = "var" + i + "_" + k;
                        consistencyLHS.add(ctx.mkIntConst(varname));
                    }
                }

                List<IntExpr> consistencyRHS = new ArrayList<>();
                for (int k = 0; k < partitionJ.size(); k++) {
                    Region jVar = partitionJ.at(k);

                    Region truncRegion = getTruncatedRegion(jVar, intersectingColIndices);
                    Region truncOverlap = truncRegion.intersection(splitRegion);
                    if (!truncOverlap.isEmpty()) {
                        String varname = "var" + j + "_" + k;
                        consistencyRHS.add(ctx.mkIntConst(varname));
                    }
                }

                //Adding consistency constraints
                solver.add(ctx.mkEq(ctx.mkAdd(consistencyLHS.toArray(new ArithExpr[consistencyLHS.size()])),
                        ctx.mkAdd(consistencyRHS.toArray(new ArithExpr[consistencyRHS.size()]))));
                solverStats.solverConstraintCount++;
            }
        }
        /**/

        DebugHelper.printInfo("countConsistencyConstraint for " + viewname + " = " + countConsistencyConstraint);
        onlyFormationSW.displayTimeAndDispose();
        
//        System.err.println(solver.toString());

        StopWatch onlySolvingSW = new StopWatch("LP-OnlySolving" + viewname);
        
        Status solverStatus = solver.check();
        DebugHelper.printInfo("Solver Status: " + solverStatus);

        if (!Status.SATISFIABLE.equals(solverStatus)) {
        	ctx.close();
            throw new RuntimeException("solverStatus is not SATISFIABLE");
        }

        Model model = solver.getModel();

        List<LinkedList<VariableValuePair>> cliqueIdxToVarValuesList = new ArrayList<>(cliqueCount);
        for (int i = 0; i < cliqueCount; i++) {

            IntList colIndxs = arasuCliquesAsColIndxs.get(i);
            Partition partition = cliqueIdxtoPList.get(i);
            LinkedList<VariableValuePair> varValuePairs = new LinkedList<>();
            for (int j = 0; j < partition.size(); j++) {
                String varname = "var" + i + "_" + j;
                long rowcount = Long.parseLong(model.evaluate(ctx.mkIntConst(varname), true).toString());
                if (rowcount != 0) {
                    Region variable = getTruncatedRegion(partition.at(j), colIndxs);
                    VariableValuePair varValuePair = new VariableValuePair(variable, rowcount);
                    varValuePairs.add(varValuePair);
                }
            }
            cliqueIdxToVarValuesList.add(varValuePairs);
        }
        
        onlySolvingSW.displayTimeAndDispose();
        
        ctx.close();
        return cliqueIdxToVarValuesList;
    }

	/*private Set<Set<String>> getProjectedSetOfCommonAttribs(Set<Set<String>> setOfCommonAttribs, Set<String> clique) {
    	Set<Set<String>> projectedSetOfCommonAttribs = new HashSet<>();
    	for (Set<String> commonAttribs : setOfCommonAttribs) {
    		HashSet<String> temp = new HashSet<>(commonAttribs);
    		temp.removeAll(clique);
    		if(temp.isEmpty()) {
    			projectedSetOfCommonAttribs.add(commonAttribs);
    		}
    	}
		return projectedSetOfCommonAttribs;
	}*/

	private ViewSolution mergeCliqueSolutions(List<LinkedList<VariableValuePair>> cliqueIdxToVarValuesList) {

        IntList mergedColIndxs = new IntArrayList();
        List<ValueCombination> mergedValueCombinations = new ArrayList<>();

        mergedColIndxs.addAll(arasuCliquesAsColIndxs.get(0));
        //Instantiating variables of first clique
        for (VariableValuePair varValuePair : cliqueIdxToVarValuesList.get(0)) {
            IntList columnValues = getFloorInstantiation(varValuePair.variable);
            ValueCombination valueCombination = new ValueCombination(columnValues, varValuePair.rowcount);
            mergedValueCombinations.add(valueCombination);
        }

        for (int i = 1; i < cliqueCount; i++) {
            mergeWithAlignment(mergedColIndxs, mergedValueCombinations, arasuCliquesAsColIndxs.get(i), cliqueIdxToVarValuesList.get(i));
        }

        for (ListIterator<ValueCombination> iter = mergedValueCombinations.listIterator(); iter.hasNext();) {
            ValueCombination valueCombination = iter.next();
            valueCombination = getReverseMappedValueCombination(valueCombination);
            valueCombination = getExpandedValueCombination(valueCombination);
            iter.set(valueCombination);
        }

        ViewSolutionInMemory viewSolutionInMemory = new ViewSolutionInMemory(mergedValueCombinations.size());
        for (ValueCombination mergedValueCombination : mergedValueCombinations) {
            viewSolutionInMemory.addValueCombination(mergedValueCombination);
        }
        return viewSolutionInMemory;
    }

    private IntList getFloorInstantiation(Region variable) {
        //choose BS with min bucket floors
        BucketStructure leadingBS = variable.getLeadingBS();
        IntList columnValues = new IntArrayList(leadingBS.getAll().size());
        for (Bucket b : leadingBS.getAll()) {
            columnValues.add(b.min());
        }
        return columnValues;
    }

    /**
     * lhs has instantiated ValueCombinations. Each lhs ValueCombination is extended by widthwise appending instantiated tuples from appropriate BucketStructure of compatible rhs variable(s).
     *     lhsColIndxs and lhsValueCombinations get side effects.
     *     rhsColIndxs gets NO side effects.
     *     rhsVarValuePairs gets exhausted and becomes empty.
     * TODO: Could have been some smart alignment which prevents extra tuples to be added to primary view
     * @param lhsColIndxs
     * @param lhsValueCombinations
     * @param rhsColIndxs
     * @param sourceValueCombinations
     */
    private void mergeWithAlignment(IntList lhsColIndxs, List<ValueCombination> lhsValueCombinations, IntList rhsColIndxs,
            LinkedList<VariableValuePair> rhsVarValuePairs) {

        IntList tempColIndxs = new IntArrayList(rhsColIndxs);
        tempColIndxs.removeAll(lhsColIndxs);
        IntList sharedColIndxs = new IntArrayList(rhsColIndxs);
        sharedColIndxs.removeAll(tempColIndxs);

        IntList posInLHS = new IntArrayList(sharedColIndxs.size());
        IntList posInRHS = new IntArrayList(sharedColIndxs.size());
        for (IntIterator iter = sharedColIndxs.iterator(); iter.hasNext();) {
            int sharedColIndx = iter.nextInt();
            posInLHS.add(lhsColIndxs.indexOf(sharedColIndx));
            posInRHS.add(rhsColIndxs.indexOf(sharedColIndx));
        }

        IntList mergedColIndxsList = new IntArrayList(lhsColIndxs);
        mergedColIndxsList.addAll(rhsColIndxs);
        mergedColIndxsList = new IntArrayList(new IntOpenHashSet(mergedColIndxsList));
        Collections.sort(mergedColIndxsList);

        boolean[] fromLHS = new boolean[mergedColIndxsList.size()];
        int[] correspOriginalIndx = new int[mergedColIndxsList.size()];

        for (int i = 0; i < mergedColIndxsList.size(); i++) {
            fromLHS[i] = lhsColIndxs.contains(mergedColIndxsList.get(i));
            if (fromLHS[i]) {
                correspOriginalIndx[i] = lhsColIndxs.indexOf(mergedColIndxsList.get(i));
            } else {
                correspOriginalIndx[i] = rhsColIndxs.indexOf(mergedColIndxsList.get(i));
            }
        }

        List<ValueCombination> mergedValueCombinations = new ArrayList<>();
        for (ValueCombination lhsValueCombination : lhsValueCombinations) {
            IntList lhsColValues = lhsValueCombination.getColValues();
            long lhsRowcount = lhsValueCombination.getRowcount();

            for (ListIterator<VariableValuePair> rhsIter = rhsVarValuePairs.listIterator(); rhsIter.hasNext();) {
                VariableValuePair rhsVarValuePair = rhsIter.next();
                Region rhsVariable = rhsVarValuePair.variable;
                long rhsRowcount = rhsVarValuePair.rowcount;

                BucketStructure rhsCompatibleBS = getCompatibleBS(posInLHS, lhsColValues, posInRHS, rhsVariable);
                if (rhsCompatibleBS != null) {
                    IntList mergedColValues = new IntArrayList(mergedColIndxsList.size());
                    for (int j = 0; j < mergedColIndxsList.size(); j++) {
                        if (fromLHS[j]) {
                            mergedColValues.add(lhsColValues.getInt(correspOriginalIndx[j]));
                        } else {
                            mergedColValues.add(rhsCompatibleBS.at(correspOriginalIndx[j]).at(0));
                        }
                    }

                    if (lhsRowcount <= rhsRowcount) {
                        ValueCombination mergedValueCombination = new ValueCombination(mergedColValues, lhsRowcount);
                        mergedValueCombinations.add(mergedValueCombination);
                        lhsValueCombination.reduceRowcount(lhsRowcount);
                        rhsVarValuePair.rowcount -= lhsRowcount;
                        if (rhsVarValuePair.rowcount == 0) {
                            rhsIter.remove();
                        }
                        break;
                    } else {
                        ValueCombination mergedValueCombination = new ValueCombination(mergedColValues, rhsRowcount);
                        mergedValueCombinations.add(mergedValueCombination);
                        lhsValueCombination.reduceRowcount(rhsRowcount);
                        lhsRowcount = lhsValueCombination.getRowcount();
                        rhsVarValuePair.rowcount = 0;
                        rhsIter.remove();
                    }
                }
            }
        }

        //if (DebugHelper.sanityChecksNeeded()) {
        for (ValueCombination lhsValueCombination : lhsValueCombinations) {
            if (lhsValueCombination.getRowcount() != 0)
                throw new RuntimeException("Found while merge ValueCombination " + lhsValueCombination + " in LHS with unmet rowcount");
        }
        if (!rhsVarValuePairs.isEmpty())
            throw new RuntimeException("Found while merge RHS variables not getting exhausted");

        //Updating targetColIndxs
        lhsColIndxs.clear();
        lhsColIndxs.addAll(mergedColIndxsList);

        //Updating targetValueCombinations
        lhsValueCombinations.clear();
        lhsValueCombinations.addAll(mergedValueCombinations);
    }

    private static BucketStructure getCompatibleBS(IntList posInLHS, IntList lhsColValues, IntList posInRHS, Region var) {
        for (BucketStructure bs : var.getAll()) {
            if (isCompatible(posInLHS, lhsColValues, posInRHS, bs))
                return bs;
        }
        return null;
    }

    private static boolean isCompatible(IntList posInLHS, IntList lhsColValues, IntList posInRHS, BucketStructure bs) {
        for (IntIterator iterLHS = posInLHS.iterator(), iterRHS = posInRHS.iterator(); iterLHS.hasNext();) {
            int posL = iterLHS.nextInt();
            int posR = iterRHS.nextInt();

            if (!bs.at(posR).contains(lhsColValues.getInt(posL)))
                return false;
        }
        return true;
    }

    /* Not required now
    private IntList getIntersectionColIndices(Set<String> cliqueI, Set<String> cliqueJ) {
        Set<String> temp = new HashSet<>(cliqueI);
        temp.removeAll(cliqueJ);
        Set<String> intersectingCols = new HashSet<>(cliqueI);
        intersectingCols.removeAll(temp);
        IntList intersectingColIndices = getSortedIndxs(intersectingCols);
        return intersectingColIndices;
    }
//    */

    /**
     * cliqueIndextoPList stores current partition (set of variables) of every clique.
     * This method takes two (intersecting) cliques i and j as input and replaces
     *     cliqueIndextoPList[i] with a newer partition (a fresh set of variables)
     *     cliqueIndextoPList[j] with a newer partition (a fresh set of variables)
     * such that these newer variables of the two cliques can be used to frame consistency conditions later.
     *
     * @param cliqueIdxtoPList
     * @param cliqueIdxtoPSimplifiedList
     * @param i
     * @param j
     * @param intersectingColIndices
     * @return
     */
    /* Not required now
    private CliqueIntersectionInfo replaceWithFreshVariablesToEnsureConsistency(List<Partition> cliqueIdxtoPList,
            List<List<IntList>> cliqueIdxtoPSimplifiedList, int i, int j, IntList intersectingColIndices) {
        Partition partitionI = cliqueIdxtoPList.get(i);
        Partition partitionJ = cliqueIdxtoPList.get(j);

        List<Region> splitRegions = getSplitRegions(partitionI, partitionJ, intersectingColIndices);

        IntList parentOldVarIdsI = new IntArrayList();
        Partition freshPartitionI = getFreshVariables(parentOldVarIdsI, partitionI, splitRegions, intersectingColIndices);
        cliqueIdxtoPList.set(i, freshPartitionI);
        List<IntList> sourceListI = cliqueIdxtoPSimplifiedList.get(i);
        List<IntList> freshListI = new ArrayList<>(freshPartitionI.size());
        for (int a = 0; a < freshPartitionI.size(); a++) {
            freshListI.add(sourceListI.get(parentOldVarIdsI.getInt(a)));
        }
        cliqueIdxtoPSimplifiedList.set(i, freshListI);

        IntArrayList parentOldVarIdsJ = new IntArrayList();
        Partition freshPartitionJ = getFreshVariables(parentOldVarIdsJ, partitionJ, splitRegions, intersectingColIndices);
        cliqueIdxtoPList.set(j, freshPartitionJ);
        List<IntList> sourceListJ = cliqueIdxtoPSimplifiedList.get(j);
        List<IntList> freshListJ = new ArrayList<>(freshPartitionJ.size());
        for (int a = 0; a < freshPartitionJ.size(); a++) {
            freshListJ.add(sourceListJ.get(parentOldVarIdsJ.getInt(a)));
        }
        cliqueIdxtoPSimplifiedList.set(j, freshListJ);

        CliqueIntersectionInfo cliqueIntersectionInfo = new CliqueIntersectionInfo(i, j, intersectingColIndices);
        //cliqueIntersectionInfo.splitRegions = splitRegions;
        return cliqueIntersectionInfo;
    }
//    */

    /* Not required now
    private List<Region> getSplitRegions(Partition partitionI, Partition partitionJ, IntList intersectingColIndices) {
        List<Region> bothRegions = new ArrayList<>();
        bothRegions.addAll(partitionI.getAll());
        bothRegions.addAll(partitionJ.getAll());

        List<boolean[]> truncAllTrueBS = getTruncatedAllTrueBS(intersectingColIndices);
        List<Region> truncRegions = getTruncatedRegions(bothRegions, intersectingColIndices);

        Reducer reducer = new Reducer(truncAllTrueBS, truncRegions);
        Map<IntList, Region> P = reducer.getMinPartition();
        List<Region> splitRegions = new ArrayList<>(P.values());
        return splitRegions;
    }
//    */

    /**
     * Returns a Partition with freshVariables and also populated parentOldVarIds of same length storing which oldVarId it came from
     * @param parentOldVarIds
     * @param oldPartition
     * @param splitRegions
     * @param intersectingColIndices
     * @return
     */
    /* Not required now
    private Partition getFreshVariables(IntList parentOldVarIds, Partition oldPartition, List<Region> splitRegions, IntList intersectingColIndices) {

        List<Region> freshRegions = new ArrayList<>();
        List<Region> oldRegions = oldPartition.getAll();

        IntList oldRegionIds = new IntArrayList(oldRegions.size());
        for (int i = 0; i < oldRegions.size(); i++) {
            oldRegionIds.add(i);
        }

        for (Region splitRegion : splitRegions) {
            List<Region> tempOldRegions = new ArrayList<>();
            IntList tempOldRegionIds = new IntArrayList();

            for (int i = 0; i < oldRegions.size(); i++) {
                Region oldRegion = oldRegions.get(i);
                Integer oldRegionId = oldRegionIds.get(i);

                Region freshRegion = new Region(); //stores list of untruncated bs which come from intersection of oldRegion and splitRegion
                Region remainRegion = new Region(); //stores list of untruncated bs which come from oldRegion minus splitRegion
                for (BucketStructure oldBS : oldRegion.getAll()) { //need to do bs by bs so that untruncing is possible
                    Region oldSingleBSRegion = new Region();
                    oldSingleBSRegion.add(oldBS);
                    Region truncOldSingleBSRegion = getTruncatedRegion(oldSingleBSRegion, intersectingColIndices);
                    Region truncOverlap = truncOldSingleBSRegion.intersection(splitRegion);
                    if (truncOverlap.isEmpty()) {
                        remainRegion.add(oldBS);
                    } else {
                        Region untruncOverlap = getUntruncatedRegion(truncOverlap, oldSingleBSRegion, intersectingColIndices);
                        freshRegion.addAll(untruncOverlap.getAll());

                        Region remainTruncRegion = truncOldSingleBSRegion.minus(truncOverlap);
                        if (!remainTruncRegion.isEmpty()) {
                            Region remainUntruncRegion = getUntruncatedRegion(remainTruncRegion, oldSingleBSRegion, intersectingColIndices);
                            remainRegion.addAll(remainUntruncRegion.getAll());
                        }
                    }
                }
                if (!freshRegion.isEmpty()) {
                    freshRegions.add(freshRegion);
                    parentOldVarIds.add(oldRegionId);
                }
                if (!remainRegion.isEmpty()) {
                    tempOldRegions.add(remainRegion);
                    tempOldRegionIds.add(oldRegionId);
                }

            }
            oldRegions = tempOldRegions;
            oldRegionIds = tempOldRegionIds;
        }

        if (!oldRegions.isEmpty() || !oldRegionIds.isEmpty())
            throw new RuntimeException("Expected oldRegions to be empty here. oldRegions " + oldRegions.size() + " and oldRegionIds " + oldRegionIds.size());

        Partition freshVariables = new Partition(freshRegions);
        return freshVariables;
    }
//    */

    /* Not required now
    private List<boolean[]> getTruncatedAllTrueBS(IntList intersectingColIndices) {
        List<boolean[]> truncatedAllTrueBS = new ArrayList<>();
        for (int i = 0; i < allTrueBS.size(); i++) {
            if (intersectingColIndices.contains(i)) {
                truncatedAllTrueBS.add(allTrueBS.get(i));
            }
        }
        return truncatedAllTrueBS;
    }
//    */

    /* Not required now
    private List<Region> getTruncatedRegions(List<Region> regions, IntList intersectingColIndices) {
        List<Region> truncatedRegions = new ArrayList<>(regions.size());
        for (Region region : regions) {
            Region truncatedRegion = getTruncatedRegion(region, intersectingColIndices);
            truncatedRegions.add(truncatedRegion);
        }
        return truncatedRegions;
    }
//    */

    private Region getTruncatedRegion(Region region, IntList intersectingColIndices) {
        Region truncatedRegion = new Region();
        for (BucketStructure bs : region.getAll()) {
            BucketStructure truncatedBS = new BucketStructure();
            List<Bucket> buckets = bs.getAll();
            for (int i = 0; i < buckets.size(); i++) {
                if (intersectingColIndices.contains(i)) {
                    truncatedBS.add(buckets.get(i));
                }
            }
            truncatedRegion.add(truncatedBS);
        }
        return truncatedRegion;
    }

    /* Not required now
    private Region getUntruncatedRegion(Region truncatedRegion, Region donorRegion, IntList intersectingColIndices) {

        if (donorRegion.getAll().size() != 1)
            throw new RuntimeException("Can only untruncate Regions with single BucketStructure in donor but found " + donorRegion.getAll().size());

        BucketStructure donorBS = donorRegion.getAll().get(0);
        Region untruncatedRegion = new Region();
        for (BucketStructure truncatedBS : truncatedRegion.getAll()) {

            BucketStructure untruncatedBS = new BucketStructure();
            int k = -1;
            for (int i = 0; i < donorBS.size(); i++) {
                if (intersectingColIndices.contains(i)) {
                    untruncatedBS.add(truncatedBS.at(++k));
                } else {
                    untruncatedBS.add(donorBS.at(i));
                }
            }
            untruncatedRegion.add(untruncatedBS);
        }
        return untruncatedRegion;
    }
//    */
    
    private void getVarToConditionList(List<List<IntExpr>> applicableSolverConstraints, HashMap<IntList, List<List<IntExpr>>> conditionListToSetOfVarList) {
    	HashMap<IntExpr, IntList> varToConditionList = new HashMap<>();
		for (int i = 0; i < applicableSolverConstraints.size(); i++) {
			for (IntExpr intExpr : applicableSolverConstraints.get(i)) {
				if(!varToConditionList.containsKey(intExpr))
					varToConditionList.put(intExpr, new IntArrayList());
				varToConditionList.get(intExpr).add(i);
			}
		}
		HashMap<IntList, List<IntExpr>> conditionListToVarList = new HashMap<>();
        for (Entry<IntExpr, IntList> entry : varToConditionList.entrySet()) {
        	IntExpr var = entry.getKey();
        	IntList conditionsList = entry.getValue();
			if(!conditionListToVarList.containsKey(conditionsList)) {
				conditionListToVarList.put(conditionsList, new ArrayList<>());
			}
			conditionListToVarList.get(conditionsList).add(var);
		}
        
        for (Entry<IntList, List<IntExpr>> entry : conditionListToVarList.entrySet()) {
			if(!conditionListToSetOfVarList.containsKey(entry.getKey())) {
				conditionListToSetOfVarList.put(entry.getKey(), new ArrayList<>());
			}
			conditionListToSetOfVarList.get(entry.getKey()).add(entry.getValue());
		}
    }
}

/* Not required now
class CliqueIntersectionInfo {
    final int     i;
    final int     j;
    final IntList intersectingColIndices;
    //List<Region> splitRegions;

    public CliqueIntersectionInfo(int i, int j, IntList intersectingColIndices) {
        this.i = i;
        this.j = j;
        this.intersectingColIndices = intersectingColIndices;
    }
}
//*/

class VariableValuePair {
    final Region variable;
    long         rowcount;

    public VariableValuePair(Region variable, long rowcount) {
        this.variable = variable;
        this.rowcount = rowcount;
    }
}