/***********************************************************************
    Copyright (C) 2003 Database Systems Lab, SERC, IISc, Bangalore.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#ifndef DATA_H_
#define DATA_H_

#include <fstream.h>
#include <string>
using namespace std;
#include "svector.h"

typedef svector<int> Itemset;
const int BUFSIZE = 8192 * sizeof(int);

class Data
{
    ifstream db; //the actual database file
    char buf[BUFSIZE];
    streampos start; //start of 1st tuple

public:

    Data(char *filename)
    {
    	db.open(filename);

	if (! db)
	{
	    cerr << "Couldn't open database file: " << filename << endl;
	    exit(1);
	}

//	db.setbuf(buf, BUFSIZE);
	start = db.tellg();
    }

    void rewind() { db.clear(); db.seekg(start); } //goto first tuple
    friend Data& operator>>(Data& d, Itemset& i);
    	//operator gets the next tuple and puts it into itemset i

    operator bool() { return (db.good()); }
    	//returns true if the input stream is good(), i.e. there is
    	//input to be seen. See sections 7.3.2 and 10.3.2 of
    	//Stroustrup 2nd edition.
        //Should have been a const function. But good() is not
    	//implemented as a const function.. so
};

inline Data& operator>>(Data& d, Itemset& i)
{
    static string line;

    getline(d.db, line);

    if (! d)
	return d;

    vector<int> iset;
    for (int cur = 0; cur < line.size(); )
    {
	int item=0, pos=0, c;
	c = line[cur];
	while ((c >= '0') && (c <= '9'))
	{
	    item *=10;
	    item += c - int('0');
	    cur++;
	    c = line[cur];
	    pos++;
	}

	if(pos)
	    iset.push_back(item);

	while (cur < line.size() && ((c < '0') || (c > '9')))
	    c = line[++cur];
    }

    // sort list of items (this is not necessary for the workshop test datasets)
    // sort(iset.begin(),iset.end());

    // put items in Itemset structure
    i.swap(iset);

    return d;
}

#endif
