#ifndef _DEFINES_H_
#define _DEFINES_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Globally needed definitions and method interfaces.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
#include <iostream>
#include <string>
using namespace std;
struct SfxNode;
struct SfxInternalNode;

#if defined(__arch64__ ) && defined(_LONGLONG)
typedef unsigned int SFXULONG;
#endif

#if defined(i386) || defined(linux)
typedef unsigned long SFXULONG;
typedef unsigned short ushort;
typedef unsigned char uchar;
#endif

#define DISASTER 1

void err_msg (char* msg, int level);


void initstats ();
void printstats (SFXULONG i=0);


enum PHASE {
  NONE,
  SEARCH,
  CONSTRUCT,
  BOTH};

enum POLICY {
  LRU,
  TOPQ
};

enum STORAGE {
  RAM,
  DISK
};

#ifndef SMALL_PAGE

// SINGLE DISKPAGE SIZE (in bytes)

#define DISKPAGESIZE 4*1024
// MAXIMUM NUMBER OF BLOCKS THAT WE CAN HAVE IN A SINGLE FILE OF 2GB
#define MAXBLOCKS ((SFXULONG)(2 * 1024 * 1024 * 1024)/ (SFXULONG)(4 * 1024) - 1)


#else /* SMALL_PAGE */

#define DISKPAGESIZE 40
// MAXIMUM NUMBER OF BLOCKS THAT WE CAN HAVE IN A SINGLE FILE OF 2GB
#define MAXBLOCKS (SFXULONG)(2 * 1024 * 1024 * 1024)/ (SFXULONG)(40)

#endif /* SMALL_PAGE */

#ifdef TRACE
#define DBG_TRACE(x)\
cerr << x;
#else
#define DBG_TRACE(x)
#endif 

#ifdef SM_TRACE
#define DBG_SM_TRACE(x)\
cerr << x;
#else
#define DBG_SM_TRACE(x)
#endif 

#ifdef SM_TRACE1
#define DBG_SM_TRACE1(x)\
cerr << x;
#else
#define DBG_SM_TRACE1(x)
#endif 

#ifdef RULETRACE
#define RULE_TRACE(x)\
cerr << x;
#else
#define RULE_TRACE(x)
#endif

#ifdef DEBUG
#define ASSERT(x)\
assert(x);
#else
#define ASSERT(x)
#endif


#ifdef FILESTATS
extern SFXULONG read_internal_count;
extern SFXULONG write_internal_count;
extern SFXULONG unpin_internal_count;

extern SFXULONG read_leaf_count;
extern SFXULONG write_leaf_count;
extern SFXULONG unpin_leaf_count;
#endif 

#ifdef SMSTATS
extern SFXULONG buffer_leaf_hits;
extern SFXULONG buffer_leaf_requests;
extern SFXULONG buffer_internal_hits;
extern SFXULONG buffer_internal_requests;
#endif

#ifdef STATS
extern SFXULONG suffixlinks;
extern SFXULONG edgestaken;
extern SFXULONG skipcountpasses;
extern SFXULONG suffixlinkstaken;
#endif

extern string sfxfilesuffix[4];

extern long curindex;
extern long curjndex;

#endif 
