#ifndef _S_PAGEREC_H_
#define _S_PAGEREC_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    In memory wrapper for every Page (used within Storage Manager)

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/
///////////////////////////////////////////////////
/// Structure for use within any buffer management
/// to hold the in-memory pages, and some statistics
/// pertaining to them.
/// Obv. used in s_man.h
///////////////////////////////////////////////////

struct pagerec_t {

  long ref_count;
  page_t* page_ptr;
  bool beingwritten;
  bool dirtyflag;

  SFXULONG key;

  /**
   * Needed if we want to chain these records
   * anytime - like in LRU or Queue etc.
   **/
  pagerec_t *next;
  pagerec_t *prev;

  pagerec_t (page_t* ptr,
	     SFXULONG mykey,
	     bool writeflag = false,
	     bool dirty = false):page_ptr(ptr),
				 ref_count(0),
				 beingwritten(writeflag),
				 dirtyflag(dirty),
				 key(mykey),
				 next(NULL),
				 prev(NULL) {

    ASSERT (page_ptr);
  }
};

#endif
