#ifndef SFXNODE_H_
#define SFXNODE_H_

/***********************************************************************
 AUTHOR: Srikanta Bedathur
 DESCRIPTION:
    Definitions for suffix tree nodes - for both linked-list and 
    array-based representation of nodes.

    Copyright (C) 2004 Database Systems Lab, Supercomputer Education and
    Research Centre, Indian Institute of Science, Bangalore, INDIA.
                     http://dsl.serc.iisc.ernet.in

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***********************************************************************/

#include "defines.h"
#include "alphabet.h"

#include <sstream>
using namespace std;
struct SfxNode;
struct SfxInternalNode;


//Contains the "real data" of each node, this is the thing that goes
//into the disk, as well as wrapped by the Ref object.

struct SfxNode {
protected:
#ifdef LINKEDLIST
  //Handling maximum 128 children
  uchar ch: 7;
  uchar nextparentflag: 1;
#else /*ARRAY*/
  uchar ch;
#endif

  SFXULONG length;
  SFXULONG begins;

#ifdef LINKEDLIST
  SFXULONG  next; //pointer to the sibling or the parent (based on parentflag)
#else
  SFXULONG  parent; //pointer to the parent
#endif

public:
  SfxNode();
  
public:
#ifndef LINKEDLIST
  void setParent (const SFXULONG _parent);
#endif
  SFXULONG  getParent() const;

#ifdef LINKEDLIST
  void setNext (SFXULONG _next);
  SFXULONG getNext () const;
#endif

public:
   void setch (unsigned char c);
   void setlength (SFXULONG _length);
   void setbegin (SFXULONG _begins);

   unsigned char getch () const;
   SFXULONG getlength () const;
   SFXULONG  getbegin () const;

#ifdef LINKEDLIST
  void setNextParentFlag (bool flag);
  bool getNextParentFlag () const;
#endif

public:
  void print (const char *sequence, const int level, bool printnl = true) const;
};



struct SfxInternalNode : public SfxNode {
protected:
#ifdef LINKEDLIST
  SFXULONG child; //the head of the children list
#else
  SFXULONG child[ALPHABETSIZE]; // size determined from Alphabet
#endif
  SFXULONG suffixLink; //points to the suffix link
  
public:
  SfxInternalNode ();
  //  SfxInternalNode (uchar* vect);
  
  void vect (uchar* copyto) const;

#ifdef LINKEDLIST
  void addChild (SFXULONG _cpointer, SFXULONG _myself);
#else
  void addChild (SFXULONG _cpointer, unsigned char c);
#endif
  SFXULONG removeChild(unsigned char _c);

  SFXULONG locateChild(unsigned char _c) const;
#ifdef LINKEDLIST
  SFXULONG getChild () const;
#else
  SFXULONG locateChildIdx (unsigned char idx) const; // for traversing all the children.
#endif
  void setSuffixLink (SFXULONG _sfx);
  SFXULONG getSuffixLink () const; 
  
  friend class Ref;
public:
  void print (const char* sequence, const int level = 0) const;
};

#define OFFSET(x)\
for(int OFFSETINDEX=0; OFFSETINDEX < x; OFFSETINDEX++,cout <<".");

#endif 
